/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J1\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020\u0003H\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BlockRealMatrix;", "", "rows", "", "columns", "(II)V", "rawData", "", "", "([[D)V", "BLOCK_SIZE", "blockColumns", "blockRows", "blocks", "[[D", "blockHeight", "blockRow", "blockWidth", "blockColumn", "create", "", "blockData", "copyArray", "", "(II[[DZ)V", "createBlocksLayout", "(II)[[D", "getColumnDimension", "getEntry", "", "row", "column", "getRowDimension", "multiply", "m", "toBlocksLayout", "([[D)[[D", "transpose", "plot-base-portable"})
public final class BlockRealMatrix {
    private final int BLOCK_SIZE;
    private int rows;
    private int columns;
    private int blockRows;
    private int blockColumns;
    private double[][] blocks;

    /*
     * WARNING - void declaration
     */
    public final void create(int rows, int columns, @NotNull double[][] blockData, boolean copyArray) {
        Intrinsics.checkNotNullParameter((Object)blockData, (String)"blockData");
        this.rows = rows;
        this.columns = columns;
        this.blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        ArrayList<double[]> blocksCopyList = new ArrayList<double[]>();
        if (!copyArray) {
            this.blocks = blockData;
        }
        int index = 0;
        int n = 0;
        int n2 = this.blockRows;
        while (n < n2) {
            void iBlock;
            int iHeight = this.blockHeight((int)iBlock);
            int jBlock = 0;
            while (jBlock < this.blockColumns) {
                boolean bl;
                Object object;
                if (blockData[index].length != iHeight * this.blockWidth(jBlock)) {
                    object = "";
                    bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                if (copyArray) {
                    object = blockData[index];
                    bl = false;
                    double[] dArray = Arrays.copyOf((double[])object, ((Object)object).length);
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"java.util.Arrays.copyOf(this, size)");
                    blocksCopyList.add(dArray);
                }
                ++jBlock;
                ++index;
            }
            ++iBlock;
        }
        if (copyArray) {
            Collection $this$toTypedArray$iv = blocksCopyList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
            if (TArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.blocks = (double[][])TArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double[][] createBlocksLayout(int rows, int columns) {
        int blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        ArrayList<double[]> blocksList = new ArrayList<double[]>();
        int blockIndex = 0;
        int n = 0;
        int n2 = blockRows;
        while (n < n2) {
            void iBlock;
            void pStart = iBlock * this.BLOCK_SIZE;
            void var11_13 = pStart + this.BLOCK_SIZE;
            int n3 = 0;
            int pEnd = Math.min((int)var11_13, rows);
            int iHeight = pEnd - pStart;
            n3 = 0;
            int n4 = blockColumns;
            while (n3 < n4) {
                void jBlock;
                void qStart = jBlock * this.BLOCK_SIZE;
                void var16_18 = qStart + this.BLOCK_SIZE;
                boolean bl = false;
                int qEnd = Math.min((int)var16_18, columns);
                int jWidth = qEnd - qStart;
                blocksList.add(new double[iHeight * jWidth]);
                ++blockIndex;
                ++jBlock;
            }
            ++iBlock;
        }
        Collection $this$toTypedArray$iv = blocksList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (double[][])TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BlockRealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BlockRealMatrix out = new BlockRealMatrix(nCols, nRows);
        int blockIndex = 0;
        int n = 0;
        int n2 = this.blockColumns;
        while (n < n2) {
            void iBlock;
            int n3 = 0;
            int n4 = this.blockRows;
            while (n3 < n4) {
                void jBlock;
                if (out.blocks == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                }
                double[] outBlock = out.blocks[blockIndex];
                if (this.blocks == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                }
                double[] tBlock = this.blocks[jBlock * this.blockColumns + iBlock];
                void pStart = iBlock * this.BLOCK_SIZE;
                void var13_13 = pStart + this.BLOCK_SIZE;
                int n5 = this.columns;
                int n6 = 0;
                int pEnd = Math.min((int)var13_13, n5);
                void qStart = jBlock * this.BLOCK_SIZE;
                n6 = qStart + this.BLOCK_SIZE;
                int n7 = this.rows;
                int n8 = 0;
                int qEnd = Math.min(n6, n7);
                int k = 0;
                n7 = pStart;
                n8 = pEnd;
                while (n7 < n8) {
                    void p;
                    int lInc = pEnd - pStart;
                    void l = p - pStart;
                    void var20_20 = qStart;
                    int n9 = qEnd;
                    while (var20_20 < n9) {
                        void q;
                        outBlock[k] = tBlock[l];
                        ++k;
                        l += lInc;
                        ++q;
                    }
                    ++p;
                }
                ++blockIndex;
                ++jBlock;
            }
            ++iBlock;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BlockRealMatrix multiply(@NotNull BlockRealMatrix m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (this.getColumnDimension() != m.getRowDimension()) {
            String string = "Matrix multiply dimension mismatch: " + this.getColumnDimension() + " x " + m.getRowDimension();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BlockRealMatrix out = new BlockRealMatrix(this.rows, m.columns);
        int blockIndex = 0;
        int n = 0;
        int n2 = out.blockRows;
        while (n < n2) {
            void iBlock;
            void pStart = iBlock * this.BLOCK_SIZE;
            int n3 = pStart + this.BLOCK_SIZE;
            int n4 = this.rows;
            boolean bl = false;
            int pEnd = Math.min(n3, n4);
            n3 = 0;
            n4 = out.blockColumns;
            while (n3 < n4) {
                void jBlock;
                int jWidth = out.blockWidth((int)jBlock);
                int jWidth2 = jWidth + jWidth;
                int jWidth3 = jWidth2 + jWidth;
                int jWidth4 = jWidth3 + jWidth;
                if (out.blocks == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                }
                double[] outBlock = out.blocks[blockIndex];
                int n5 = 0;
                int n6 = this.blockColumns;
                while (n5 < n6) {
                    void kBlock;
                    int kWidth = this.blockWidth((int)kBlock);
                    if (this.blocks == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                    }
                    double[] tBlock = this.blocks[iBlock * this.blockColumns + kBlock];
                    if (m.blocks == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                    }
                    double[] mBlock = m.blocks[kBlock * m.blockColumns + jBlock];
                    int k = 0;
                    void var21_23 = pStart;
                    int n7 = pEnd;
                    while (var21_23 < n7) {
                        void p;
                        void lStart = (p - pStart) * kWidth;
                        void lEnd = lStart + kWidth;
                        int n8 = 0;
                        int n9 = jWidth;
                        while (n8 < n9) {
                            void nStart;
                            double sum = 0.0;
                            void l = lStart;
                            void n10 = nStart;
                            while (l < lEnd - 3) {
                                sum += tBlock[l] * mBlock[n10] + tBlock[l + true] * mBlock[n10 + jWidth] + tBlock[l + 2] * mBlock[n10 + jWidth2] + tBlock[l + 3] * mBlock[n10 + jWidth3];
                                l += 4;
                                n10 += jWidth4;
                            }
                            while (l < lEnd) {
                                sum += tBlock[l++] * mBlock[n10];
                                n10 += jWidth;
                            }
                            int n11 = k++;
                            outBlock[n11] = outBlock[n11] + sum;
                            ++nStart;
                        }
                        ++p;
                    }
                    ++kBlock;
                }
                ++blockIndex;
                ++jBlock;
            }
            ++iBlock;
        }
        return out;
    }

    public final double getEntry(int row, int column) {
        if (row < 0 || row > this.getRowDimension()) {
            String string = "row out of range: " + row;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (column < 0 || column > this.getColumnDimension()) {
            String string = "column out of range: " + column;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int iBlock = row / this.BLOCK_SIZE;
        int jBlock = column / this.BLOCK_SIZE;
        int k = (row - iBlock * this.BLOCK_SIZE) * this.blockWidth(jBlock) + (column - jBlock * this.BLOCK_SIZE);
        if (this.blocks == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
        }
        return this.blocks[iBlock * this.blockColumns + jBlock][k];
    }

    private final int getRowDimension() {
        return this.rows;
    }

    private final int getColumnDimension() {
        return this.columns;
    }

    private final int blockWidth(int blockColumn) {
        return blockColumn == this.blockColumns - 1 ? this.columns - blockColumn * this.BLOCK_SIZE : this.BLOCK_SIZE;
    }

    private final int blockHeight(int blockRow) {
        return blockRow == this.blockRows - 1 ? this.rows - blockRow * this.BLOCK_SIZE : this.BLOCK_SIZE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[][] toBlocksLayout(@NotNull double[][] rawData) {
        int length;
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        int rows = ((Object[])rawData).length;
        int columns = rawData[0].length;
        int blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int n = 0;
        int n2 = rawData.length;
        while (n < n2) {
            void i;
            length = rawData[i].length;
            if (length != columns) {
                String string = "Wrong dimension: " + columns + ", " + length;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ++i;
        }
        ArrayList<double[]> blocksList = new ArrayList<double[]>();
        int blockIndex = 0;
        length = 0;
        int n3 = blockRows;
        while (length < n3) {
            void iBlock;
            void pStart = iBlock * this.BLOCK_SIZE;
            void var12_17 = pStart + this.BLOCK_SIZE;
            int n4 = 0;
            int pEnd = Math.min((int)var12_17, rows);
            int iHeight = pEnd - pStart;
            n4 = 0;
            int n5 = blockColumns;
            while (n4 < n5) {
                void jBlock;
                void qStart = jBlock * this.BLOCK_SIZE;
                void var17_22 = qStart + this.BLOCK_SIZE;
                boolean bl = false;
                int qEnd = Math.min((int)var17_22, columns);
                int jWidth = qEnd - qStart;
                double[] block = new double[iHeight * jWidth];
                blocksList.add(block);
                int index = 0;
                void var20_26 = pStart;
                int n6 = pEnd;
                while (var20_26 < n6) {
                    void p;
                    ArraysKt.copyInto((double[])rawData[p], (double[])block, (int)index, (int)qStart, (int)qEnd);
                    index += jWidth;
                    ++p;
                }
                ++blockIndex;
                ++jBlock;
            }
            ++iBlock;
        }
        Collection $this$toTypedArray$iv = blocksList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (double[][])TArray;
    }

    public BlockRealMatrix(int rows, int columns) {
        this.BLOCK_SIZE = 52;
        this.rows = rows;
        this.columns = columns;
        this.blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blocks = this.createBlocksLayout(rows, columns);
    }

    public BlockRealMatrix(@NotNull double[][] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        this.BLOCK_SIZE = 52;
        this.create(((Object[])rawData).length, rawData[0].length, this.toBlocksLayout(rawData), false);
    }
}

