/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.SmoothStat$WhenMappings;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.LinearRegression;
import jetbrains.datalore.plot.base.stat.regression.LocalPolynomialRegression;
import jetbrains.datalore.plot.base.stat.regression.PolynomialRegression;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.util.SamplingUtil;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 C2\u00020\u0001:\u0002CDB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J;\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2!\u0010.\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0004\u0012\u0002040/H\u0016J1\u00105\u001a\u00020*2\u0006\u0010+\u001a\u00020*2!\u0010.\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0004\u0012\u0002040/J:\u00106\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000409072\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004092\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000409H\u0002J\u0012\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030=09H\u0016J\u0014\u0010>\u001a\u0002082\n\u0010?\u001a\u0006\u0012\u0002\b\u00030=H\u0016J\u0014\u0010@\u001a\u00020\u00102\n\u0010?\u001a\u0006\u0012\u0002\b\u00030=H\u0016J\u000e\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u000eR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\b\u00a8\u0006E"}, d2={"Ljetbrains/datalore/plot/base/stat/SmoothStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "()V", "confidenceLevel", "", "getConfidenceLevel", "()D", "setConfidenceLevel", "(D)V", "deg", "", "getDeg", "()I", "setDeg", "(I)V", "isDisplayConfidenceInterval", "", "()Z", "setDisplayConfidenceInterval", "(Z)V", "loessCriticalSize", "getLoessCriticalSize", "setLoessCriticalSize", "seed", "", "getSeed", "()J", "setSeed", "(J)V", "smootherPointCount", "getSmootherPointCount", "setSmootherPointCount", "smoothingMethod", "Ljetbrains/datalore/plot/base/stat/SmoothStat$Method;", "getSmoothingMethod", "()Ljetbrains/datalore/plot/base/stat/SmoothStat$Method;", "setSmoothingMethod", "(Ljetbrains/datalore/plot/base/stat/SmoothStat$Method;)V", "span", "getSpan", "setSpan", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "applySampling", "applySmoothing", "", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "valuesX", "valuesY", "consumes", "Ljetbrains/datalore/plot/base/Aes;", "getDefaultMapping", "aes", "hasDefaultMapping", "needSampling", "rowCount", "Companion", "Method", "plot-base-portable"})
public final class SmoothStat
extends BaseStat {
    private int smootherPointCount = 80;
    @NotNull
    private Method smoothingMethod = DEF_SMOOTHING_METHOD;
    private double confidenceLevel = 0.95;
    private boolean isDisplayConfidenceInterval = true;
    private double span = 0.5;
    private int deg = 1;
    private int loessCriticalSize = 1000;
    private long seed = 37L;
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    private static final int DEF_EVAL_POINT_COUNT = 80;
    private static final Method DEF_SMOOTHING_METHOD;
    private static final double DEF_CONFIDENCE_LEVEL = 0.95;
    private static final boolean DEF_DISPLAY_CONFIDENCE_INTERVAL = true;
    private static final double DEF_SPAN = 0.5;
    private static final int DEF_DEG = 1;
    private static final int DEF_LOESS_CRITICAL_SIZE = 1000;
    private static final long DEF_SAMPLING_SEED = 37L;
    public static final Companion Companion;

    public final int getSmootherPointCount() {
        return this.smootherPointCount;
    }

    public final void setSmootherPointCount(int n) {
        this.smootherPointCount = n;
    }

    @NotNull
    public final Method getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public final void setSmoothingMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"<set-?>");
        this.smoothingMethod = method;
    }

    public final double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public final void setConfidenceLevel(double d) {
        this.confidenceLevel = d;
    }

    public final boolean isDisplayConfidenceInterval() {
        return this.isDisplayConfidenceInterval;
    }

    public final void setDisplayConfidenceInterval(boolean bl) {
        this.isDisplayConfidenceInterval = bl;
    }

    public final double getSpan() {
        return this.span;
    }

    public final void setSpan(double d) {
        this.span = d;
    }

    public final int getDeg() {
        return this.deg;
    }

    public final void setDeg(int n) {
        this.deg = n;
    }

    public final int getLoessCriticalSize() {
        return this.loessCriticalSize;
    }

    public final void setLoessCriticalSize(int n) {
        this.loessCriticalSize = n;
    }

    public final long getSeed() {
        return this.seed;
    }

    public final void setSeed(long l) {
        this.seed = l;
    }

    @Override
    public boolean hasDefaultMapping(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return super.hasDefaultMapping(aes) || Intrinsics.areEqual(aes, Aes.Companion.getYMIN()) && this.isDisplayConfidenceInterval || Intrinsics.areEqual(aes, Aes.Companion.getYMAX()) && this.isDisplayConfidenceInterval;
    }

    @Override
    @NotNull
    public DataFrame.Variable getDefaultMapping(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        if (Intrinsics.areEqual(aes, Aes.Companion.getYMIN())) {
            return Stats.INSTANCE.getY_MIN();
        }
        return Intrinsics.areEqual(aes, Aes.Companion.getYMAX()) ? Stats.INSTANCE.getY_MAX() : super.getDefaultMapping(aes);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf(Aes.Companion.getY());
    }

    public final boolean needSampling(int rowCount) {
        if (this.smoothingMethod != Method.LOESS) {
            return false;
        }
        return rowCount > this.loessCriticalSize;
    }

    @NotNull
    public final DataFrame applySampling(@NotNull DataFrame data, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        String msg = "LOESS drew a random sample with max_n=" + this.loessCriticalSize + ", seed=" + this.seed;
        messageConsumer.invoke((Object)msg);
        return SamplingUtil.INSTANCE.sampleWithoutReplacement(this.loessCriticalSize, RandomKt.Random((long)this.seed), data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        List<Double> valuesY;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!this.hasRequiredValues(data, Aes.Companion.getY())) {
            return this.withEmptyStatValues();
        }
        DataFrame data2 = data;
        if (this.needSampling(data2.rowCount())) {
            data2 = this.applySampling(data2, messageConsumer);
        }
        if ((valuesY = data2.getNumeric(TransformVar.INSTANCE.getY())).size() < 3) {
            return this.withEmptyStatValues();
        }
        List valuesX = null;
        if (data2.has(TransformVar.INSTANCE.getX())) {
            valuesX = data2.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            valuesX = new ArrayList();
            int n = 0;
            int n2 = ((Collection)valuesY).size();
            while (n < n2) {
                void i;
                ((ArrayList)valuesX).add((double)i);
                ++i;
            }
        }
        if (SeriesUtil.INSTANCE.range(valuesX) == null) {
            return this.withEmptyStatValues();
        }
        List<Double> statX = null;
        List<Double> statY = null;
        List<Double> statMinY = null;
        List<Double> statMaxY = null;
        List<Double> statSE = null;
        Map<DataFrame.Variable, List<Double>> statValues = this.applySmoothing(valuesX, valuesY);
        List<Double> list2 = statValues.get(Stats.INSTANCE.getX());
        Intrinsics.checkNotNull(list2);
        statX = list2;
        List<Double> list3 = statValues.get(Stats.INSTANCE.getY());
        Intrinsics.checkNotNull(list3);
        statY = list3;
        List<Double> list4 = statValues.get(Stats.INSTANCE.getY_MIN());
        Intrinsics.checkNotNull(list4);
        statMinY = list4;
        List<Double> list5 = statValues.get(Stats.INSTANCE.getY_MAX());
        Intrinsics.checkNotNull(list5);
        statMaxY = list5;
        List<Double> list6 = statValues.get(Stats.INSTANCE.getSE());
        Intrinsics.checkNotNull(list6);
        statSE = list6;
        DataFrame.Builder statData = new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), statX).putNumeric(Stats.INSTANCE.getY(), statY);
        if (this.isDisplayConfidenceInterval) {
            statData.putNumeric(Stats.INSTANCE.getY_MIN(), statMinY).putNumeric(Stats.INSTANCE.getY_MAX(), statMaxY).putNumeric(Stats.INSTANCE.getSE(), statSE);
        }
        return statData.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> applySmoothing(List<Double> valuesX, List<Double> valuesY) {
        RegressionEvaluator regressionEvaluator;
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statY = new ArrayList<Double>();
        ArrayList<Double> statMinY = new ArrayList<Double>();
        ArrayList<Double> statMaxY = new ArrayList<Double>();
        ArrayList<Double> statSE = new ArrayList<Double>();
        HashMap result = new HashMap();
        ((Map)result).put(Stats.INSTANCE.getX(), statX);
        ((Map)result).put(Stats.INSTANCE.getY(), statY);
        ((Map)result).put(Stats.INSTANCE.getY_MIN(), statMinY);
        ((Map)result).put(Stats.INSTANCE.getY_MAX(), statMaxY);
        ((Map)result).put(Stats.INSTANCE.getSE(), statSE);
        switch (SmoothStat$WhenMappings.$EnumSwitchMapping$0[this.smoothingMethod.ordinal()]) {
            case 1: {
                Preconditions.INSTANCE.checkArgument(this.deg >= 1, "Degree of polynomial regression must be at least 1");
                if (this.deg == 1) {
                    regressionEvaluator = new LinearRegression(valuesX, valuesY, this.confidenceLevel);
                    break;
                }
                if (!PolynomialRegression.Companion.canBeComputed(valuesX, valuesY, this.deg)) {
                    return result;
                }
                regressionEvaluator = new PolynomialRegression(valuesX, valuesY, this.confidenceLevel, this.deg);
                break;
            }
            case 2: {
                regressionEvaluator = new LocalPolynomialRegression(valuesX, valuesY, this.confidenceLevel, this.span);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported smoother method: " + (Object)((Object)this.smoothingMethod) + " (only 'lm' and 'loess' methods are currently available)");
            }
        }
        RegressionEvaluator regression = regressionEvaluator;
        ClosedRange<Double> closedRange = SeriesUtil.INSTANCE.range((Iterable<Double>)valuesX);
        if (closedRange == null) {
            return result;
        }
        ClosedRange<Double> rangeX = closedRange;
        double startX = ((Number)rangeX.getLowerEnd()).doubleValue();
        double spanX = ((Number)rangeX.getUpperEnd()).doubleValue() - startX;
        double stepX = spanX / (double)(this.smootherPointCount - 1);
        int n = 0;
        int n2 = this.smootherPointCount;
        while (n < n2) {
            void i;
            double x2 = startX + (double)i * stepX;
            EvalResult eval = regression.evalX(RangesKt.coerceIn((double)x2, (double)((Number)rangeX.getLowerEnd()).doubleValue(), (double)((Number)rangeX.getUpperEnd()).doubleValue()));
            statX.add(x2);
            statY.add(eval.getY());
            statMinY.add(eval.getYmin());
            statMaxY.add(eval.getYmax());
            statSE.add(eval.getSe());
            ++i;
        }
        return result;
    }

    public SmoothStat() {
        super(DEF_MAPPING);
    }

    static {
        Companion = new Companion(null);
        DEF_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY())});
        DEF_SMOOTHING_METHOD = Method.LM;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/stat/SmoothStat$Method;", "", "(Ljava/lang/String;I)V", "LM", "GLM", "GAM", "LOESS", "RLM", "plot-base-portable"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LM;
        public static final /* enum */ Method GLM;
        public static final /* enum */ Method GAM;
        public static final /* enum */ Method LOESS;
        public static final /* enum */ Method RLM;
        private static final /* synthetic */ Method[] $VALUES;

        static {
            Method[] methodArray = new Method[5];
            Method[] methodArray2 = methodArray;
            methodArray[0] = LM = new Method();
            methodArray[1] = GLM = new Method();
            methodArray[2] = GAM = new Method();
            methodArray[3] = LOESS = new Method();
            methodArray[4] = RLM = new Method();
            $VALUES = methodArray;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String string) {
            return Enum.valueOf(Method.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/stat/SmoothStat$Companion;", "", "()V", "DEF_CONFIDENCE_LEVEL", "", "DEF_DEG", "", "DEF_DISPLAY_CONFIDENCE_INTERVAL", "", "DEF_EVAL_POINT_COUNT", "DEF_LOESS_CRITICAL_SIZE", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_SAMPLING_SEED", "", "DEF_SMOOTHING_METHOD", "Ljetbrains/datalore/plot/base/stat/SmoothStat$Method;", "DEF_SPAN", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

