/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.stat.FiveNumberSummary;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00042\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\f\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/stat/BoxplotStatUtil;", "", "()V", "buildStat", "", "xs", "", "", "ys", "whiskerIQRRatio", "group", "collector", "", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "plot-base-portable"})
public final class BoxplotStatUtil {
    public static final BoxplotStatUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final int buildStat(@NotNull List<Double> xs, @NotNull List<Double> ys, double whiskerIQRRatio, int group2, @NotNull Map<DataFrame.Variable, List<Double>> collector2) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Intrinsics.checkNotNullParameter(collector2, (String)"collector");
        if (collector2.isEmpty()) {
            collector2.put(Stats.INSTANCE.getX(), new ArrayList());
            collector2.put(Stats.INSTANCE.getY(), new ArrayList());
            collector2.put(Stats.INSTANCE.getMIDDLE(), new ArrayList());
            collector2.put(Stats.INSTANCE.getLOWER(), new ArrayList());
            collector2.put(Stats.INSTANCE.getUPPER(), new ArrayList());
            collector2.put(Stats.INSTANCE.getY_MIN(), new ArrayList());
            collector2.put(Stats.INSTANCE.getY_MAX(), new ArrayList());
            collector2.put(Stats.INSTANCE.getWIDTH(), new ArrayList());
            collector2.put(Stats.INSTANCE.getGROUP(), new ArrayList());
        }
        Map binnedData = new HashMap();
        Iterator<Double> ys_ = ys.iterator();
        for (Double x2 : xs) {
            Double y2 = ys_.next();
            if (!SeriesUtil.INSTANCE.isFinite(x2) || !SeriesUtil.INSTANCE.isFinite(y2)) continue;
            Map map2 = binnedData;
            boolean bl = false;
            if (!map2.containsKey(x2)) {
                Double d = x2;
                Intrinsics.checkNotNull((Object)d);
                binnedData.put(d, new ArrayList());
            }
            map2 = binnedData;
            bl = false;
            Object v = map2.get(x2);
            Intrinsics.checkNotNull(v);
            List list2 = (List)v;
            Double d = y2;
            Intrinsics.checkNotNull((Object)d);
            list2.add(d);
        }
        if (binnedData.isEmpty()) {
            return 0;
        }
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statY = new ArrayList<Double>();
        ArrayList<Double> statMiddle = new ArrayList<Double>();
        ArrayList<Double> statLower = new ArrayList<Double>();
        ArrayList<Double> statUpper = new ArrayList<Double>();
        ArrayList<Double> statMin = new ArrayList<Double>();
        ArrayList<Double> statMax = new ArrayList<Double>();
        ArrayList<Double> statGroup = new ArrayList<Double>();
        ArrayList<Double> statCount = new ArrayList<Double>();
        int maxCount = 0;
        Iterator iterator2 = binnedData.keySet().iterator();
        while (iterator2.hasNext()) {
            ClosedRange<Double> range2;
            double x3 = ((Number)iterator2.next()).doubleValue();
            Object v = binnedData.get(x3);
            Intrinsics.checkNotNull(v);
            List bin = (List)v;
            FiveNumberSummary summary = new FiveNumberSummary(bin);
            double middle = summary.getMedian();
            double lowerHinge = summary.getFirstQuartile();
            double upperHinge = summary.getThirdQuartile();
            double IQR = upperHinge - lowerHinge;
            double lowerFence = lowerHinge - IQR * whiskerIQRRatio;
            double upperFence = upperHinge + IQR * whiskerIQRRatio;
            double lowerWhisker = lowerFence;
            double upperWhisker = upperFence;
            if (SeriesUtil.INSTANCE.isFinite(lowerFence) && SeriesUtil.INSTANCE.isFinite(upperFence) && (range2 = SeriesUtil.INSTANCE.range(Iterables.INSTANCE.filter(bin, (Function1)new Function1<Double, Boolean>(lowerFence, upperFence){
                final /* synthetic */ double $lowerFence;
                final /* synthetic */ double $upperFence;

                public final boolean invoke(double y2) {
                    return y2 >= this.$lowerFence && y2 <= this.$upperFence;
                }
                {
                    this.$lowerFence = d;
                    this.$upperFence = d2;
                    super(1);
                }
            }))) != null) {
                lowerWhisker = ((Number)range2.getLowerEnd()).doubleValue();
                upperWhisker = ((Number)range2.getUpperEnd()).doubleValue();
            }
            Iterable outliers2 = Iterables.INSTANCE.filter(bin, (Function1)new Function1<Double, Boolean>(lowerFence, upperFence){
                final /* synthetic */ double $lowerFence;
                final /* synthetic */ double $upperFence;

                public final boolean invoke(double y2) {
                    return y2 < this.$lowerFence || y2 > this.$upperFence;
                }
                {
                    this.$lowerFence = d;
                    this.$upperFence = d2;
                    super(1);
                }
            });
            int outlierCount = 0;
            Iterator iterator3 = outliers2.iterator();
            while (iterator3.hasNext()) {
                double y3 = ((Number)iterator3.next()).doubleValue();
                ++outlierCount;
                statX.add(x3);
                statY.add(y3);
                statMiddle.add(Double.NaN);
                statLower.add(Double.NaN);
                statUpper.add(Double.NaN);
                statMin.add(Double.NaN);
                statMax.add(Double.NaN);
            }
            statX.add(x3);
            statY.add(Double.NaN);
            statMiddle.add(middle);
            statLower.add(lowerHinge);
            statUpper.add(upperHinge);
            statMin.add(lowerWhisker);
            statMax.add(upperWhisker);
            int count2 = bin.size();
            int n = 0;
            maxCount = Math.max(maxCount, count2);
            n = 0;
            int n2 = outlierCount + 1;
            while (n < n2) {
                void i;
                statCount.add(Double.valueOf(count2));
                statGroup.add(Double.valueOf(group2));
                ++i;
            }
        }
        List<Double> list3 = collector2.get(Stats.INSTANCE.getX());
        Intrinsics.checkNotNull(list3);
        list3.addAll((Collection<Double>)statX);
        List<Double> list4 = collector2.get(Stats.INSTANCE.getY());
        Intrinsics.checkNotNull(list4);
        list4.addAll((Collection<Double>)statY);
        List<Double> list5 = collector2.get(Stats.INSTANCE.getMIDDLE());
        Intrinsics.checkNotNull(list5);
        list5.addAll((Collection<Double>)statMiddle);
        List<Double> list6 = collector2.get(Stats.INSTANCE.getLOWER());
        Intrinsics.checkNotNull(list6);
        list6.addAll((Collection<Double>)statLower);
        List<Double> list7 = collector2.get(Stats.INSTANCE.getUPPER());
        Intrinsics.checkNotNull(list7);
        list7.addAll((Collection<Double>)statUpper);
        List<Double> list8 = collector2.get(Stats.INSTANCE.getY_MIN());
        Intrinsics.checkNotNull(list8);
        list8.addAll((Collection<Double>)statMin);
        List<Double> list9 = collector2.get(Stats.INSTANCE.getY_MAX());
        Intrinsics.checkNotNull(list9);
        list9.addAll((Collection<Double>)statMax);
        List<Double> list10 = collector2.get(Stats.INSTANCE.getWIDTH());
        Intrinsics.checkNotNull(list10);
        list10.addAll((Collection<Double>)statCount);
        List<Double> list11 = collector2.get(Stats.INSTANCE.getGROUP());
        Intrinsics.checkNotNull(list11);
        list11.addAll((Collection<Double>)statGroup);
        return maxCount;
    }

    private BoxplotStatUtil() {
    }

    static {
        BoxplotStatUtil boxplotStatUtil;
        INSTANCE = boxplotStatUtil = new BoxplotStatUtil();
    }
}

