/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.transform;

import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import jetbrains.datalore.plot.base.scale.transform.IdentityTransform;
import jetbrains.datalore.plot.base.scale.transform.Log10Transform;
import jetbrains.datalore.plot.base.scale.transform.ReverseTransform;
import jetbrains.datalore.plot.base.scale.transform.SqrtTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Transforms;", "", "()V", "IDENTITY", "Ljetbrains/datalore/plot/base/Transform;", "getIDENTITY", "()Ljetbrains/datalore/plot/base/Transform;", "LOG10", "getLOG10", "REVERSE", "getREVERSE", "SQRT", "getSQRT", "identityWithBreaksGen", "breaksGenerator", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "plot-base-portable"})
public final class Transforms {
    @NotNull
    private static final Transform IDENTITY;
    @NotNull
    private static final Transform LOG10;
    @NotNull
    private static final Transform REVERSE;
    @NotNull
    private static final Transform SQRT;
    public static final Transforms INSTANCE;

    @NotNull
    public final Transform getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final Transform getLOG10() {
        return LOG10;
    }

    @NotNull
    public final Transform getREVERSE() {
        return REVERSE;
    }

    @NotNull
    public final Transform getSQRT() {
        return SQRT;
    }

    @NotNull
    public final Transform identityWithBreaksGen(@NotNull BreaksGenerator breaksGenerator) {
        Intrinsics.checkNotNullParameter((Object)breaksGenerator, (String)"breaksGenerator");
        return new IdentityTransform(breaksGenerator);
    }

    private Transforms() {
    }

    static {
        Transforms transforms;
        INSTANCE = transforms = new Transforms();
        IDENTITY = new IdentityTransform(null, 1, null);
        LOG10 = new Log10Transform();
        REVERSE = new ReverseTransform();
        SQRT = new SqrtTransform();
    }
}

