/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.plot.base.scale.breaks.BreaksHelperBase;
import jetbrains.datalore.plot.base.scale.breaks.LinearBreaksHelper;
import jetbrains.datalore.plot.base.scale.breaks.QuantitativeTickFormatterFactory;
import jetbrains.datalore.plot.common.time.TimeUtil;
import jetbrains.datalore.plot.common.time.interval.NiceTimeInterval;
import jetbrains.datalore.plot.common.time.interval.TimeInterval;
import jetbrains.datalore.plot.common.time.interval.YearInterval;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/DateTimeBreaksHelper;", "Ljetbrains/datalore/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "count", "", "(DDI)V", "minInterval", "Ljetbrains/datalore/plot/common/time/interval/TimeInterval;", "(DDILjetbrains/datalore/plot/common/time/interval/TimeInterval;)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "labelFormatter", "Lkotlin/Function1;", "", "", "getLabelFormatter", "()Lkotlin/jvm/functions/Function1;", "plot-base-portable"})
public final class DateTimeBreaksHelper
extends BreaksHelperBase {
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> labelFormatter;

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @Override
    @NotNull
    public Function1<Object, String> getLabelFormatter() {
        return this.labelFormatter;
    }

    public DateTimeBreaksHelper(double rangeStart, double rangeEnd, int count2, @Nullable TimeInterval minInterval) {
        super(rangeStart, rangeEnd, count2);
        double step = this.getTargetStep();
        if (step < (double)1000) {
            this.labelFormatter = QuantitativeTickFormatterFactory.Companion.forTimeScale(minInterval).getFormatter(step);
            this.breaks = new LinearBreaksHelper(rangeStart, rangeEnd, count2).getBreaks();
        } else {
            double start = this.getNormalStart();
            double end = this.getNormalEnd();
            List ticks = null;
            if (minInterval != null) {
                ticks = CollectionsKt.toMutableList((Collection)minInterval.range(start, end));
            }
            if (ticks != null && ticks.size() <= count2) {
                TimeInterval timeInterval = minInterval;
                Intrinsics.checkNotNull((Object)timeInterval);
                this.labelFormatter = timeInterval.getTickFormatter();
            } else if (step > 3.1536E10) {
                int startYear;
                this.labelFormatter = YearInterval.Companion.getTICK_FORMATTER();
                ticks = new ArrayList();
                DateTime startDateTime = TimeUtil.INSTANCE.asDateTimeUTC(start);
                if (startDateTime.isAfter(TimeUtil.INSTANCE.yearStart(startYear = startDateTime.getYear()))) {
                    ++startYear;
                }
                int endYear = TimeUtil.INSTANCE.asDateTimeUTC(end).getYear();
                LinearBreaksHelper helper = new LinearBreaksHelper(startYear, endYear, count2);
                Iterator<Double> iterator2 = helper.getBreaks().iterator();
                while (iterator2.hasNext()) {
                    double tickYear = ((Number)iterator2.next()).doubleValue();
                    boolean bl = false;
                    DateTime tickDate = TimeUtil.INSTANCE.yearStart((int)Math.rint(tickYear));
                    ticks.add(Double.valueOf(TimeUtil.INSTANCE.asInstantUTC(tickDate)));
                }
            } else {
                TimeInterval interval = NiceTimeInterval.INSTANCE.forMillis(step);
                this.labelFormatter = interval.getTickFormatter();
                ticks = CollectionsKt.toMutableList((Collection)interval.range(start, end));
            }
            if (this.isReversed()) {
                CollectionsKt.reverse((List)ticks);
            }
            this.breaks = ticks;
        }
    }

    public DateTimeBreaksHelper(double rangeStart, double rangeEnd, int count2) {
        this(rangeStart, rangeEnd, count2, null);
    }
}

