/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.render.svg;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.registration.CompositeRegistration;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.plot.base.render.svg.SvgUID;
import jetbrains.datalore.vis.svg.SvgClipPathElement;
import jetbrains.datalore.vis.svg.SvgDefsElement;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgGraphicsElement;
import jetbrains.datalore.vis.svg.SvgIRI;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import jetbrains.datalore.vis.svg.SvgTransform;
import jetbrains.datalore.vis.svg.SvgTransformBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0019H$J\b\u0010!\u001a\u00020\u0019H\u0002J\u0006\u0010\"\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0010J\u0016\u0010'\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014J\b\u0010+\u001a\u00020\u0019H\u0004J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\u0004\b\u0000\u0010.H\u0004J\u0010\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201H\u0004J\u000e\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0014J\u000e\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0010J\u000e\u00106\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00000\bj\b\u0012\u0004\u0012\u00020\u0000`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00068"}, d2={"Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "", "()V", "childComponents", "", "getChildComponents", "()Ljava/util/List;", "myChildComponents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myCompositeRegistration", "Ljetbrains/datalore/base/registration/CompositeRegistration;", "myIsBuilding", "", "myIsBuilt", "myOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myRootGroup", "Ljetbrains/datalore/vis/svg/SvgGElement;", "myRotationAngle", "", "rootGroup", "getRootGroup", "()Ljetbrains/datalore/vis/svg/SvgGElement;", "add", "", "child", "node", "Ljetbrains/datalore/vis/svg/SvgNode;", "addClassName", "className", "", "buildComponent", "buildComponentIntern", "clear", "clipBounds", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "ensureBuilt", "moveTo", "p", "x", "y", "needRebuild", "rebuildHandler", "Ljetbrains/datalore/base/observable/event/EventHandler;", "EventT", "reg", "r", "Ljetbrains/datalore/base/registration/Registration;", "rotate", "angle", "toAbsoluteCoordinates", "location", "toRelativeCoordinates", "Companion", "plot-base-portable"})
public abstract class SvgComponent {
    private boolean myIsBuilt;
    private boolean myIsBuilding;
    private final SvgGElement myRootGroup = new SvgGElement();
    private final ArrayList<SvgComponent> myChildComponents = new ArrayList();
    private DoubleVector myOrigin = DoubleVector.Companion.getZERO();
    private double myRotationAngle;
    private CompositeRegistration myCompositeRegistration = new CompositeRegistration(new Registration[0]);
    @NotNull
    public static final String CLIP_PATH_ID_PREFIX = "";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final List<SvgComponent> getChildComponents() {
        Preconditions.INSTANCE.checkState(this.myIsBuilt, "Plot has not yet built");
        return new ArrayList(this.myChildComponents);
    }

    @NotNull
    public final SvgGElement getRootGroup() {
        this.ensureBuilt();
        return this.myRootGroup;
    }

    public final void ensureBuilt() {
        if (!this.myIsBuilt && !this.myIsBuilding) {
            this.buildComponentIntern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildComponentIntern() {
        try {
            this.myIsBuilding = true;
            this.buildComponent();
        }
        finally {
            this.myIsBuilding = false;
            this.myIsBuilt = true;
        }
    }

    protected abstract void buildComponent();

    @NotNull
    protected final <EventT> EventHandler<EventT> rebuildHandler() {
        return new EventHandler<EventT>(this){
            final /* synthetic */ SvgComponent this$0;

            public void onEvent(EventT event) {
                this.this$0.needRebuild();
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    protected final void needRebuild() {
        if (this.myIsBuilt) {
            this.clear();
            this.buildComponentIntern();
        }
    }

    protected final void reg(@NotNull Registration r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.myCompositeRegistration.add(r);
    }

    public final void clear() {
        this.myIsBuilt = false;
        for (SvgComponent child : this.myChildComponents) {
            child.clear();
        }
        this.myChildComponents.clear();
        this.myRootGroup.children().clear();
        this.myCompositeRegistration.remove();
        this.myCompositeRegistration = new CompositeRegistration(new Registration[0]);
    }

    public final void add(@NotNull SvgComponent child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this.myChildComponents.add(child);
        this.add(child.getRootGroup());
    }

    public final void add(@NotNull SvgNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.myRootGroup.children().add(node);
    }

    public final void moveTo(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.myOrigin = p;
        this.myRootGroup.transform().set(Companion.buildTransform(this.myOrigin, this.myRotationAngle));
    }

    public final void moveTo(double x2, double y2) {
        this.moveTo(new DoubleVector(x2, y2));
    }

    public final void rotate(double angle) {
        this.myRotationAngle = angle;
        this.myRootGroup.transform().set(Companion.buildTransform(this.myOrigin, this.myRotationAngle));
    }

    @NotNull
    public final DoubleVector toRelativeCoordinates(@NotNull DoubleVector location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.getRootGroup().pointToTransformedCoordinates(location);
    }

    @NotNull
    public final DoubleVector toAbsoluteCoordinates(@NotNull DoubleVector location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.getRootGroup().pointToAbsoluteCoordinates(location);
    }

    /*
     * WARNING - void declaration
     */
    public final void clipBounds(@NotNull DoubleRectangle rect2) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        SvgClipPathElement svgClipPathElement = new SvgClipPathElement();
        boolean bl = false;
        boolean bl2 = false;
        SvgClipPathElement $this$apply2 = svgClipPathElement;
        boolean bl3 = false;
        $this$apply2.id().set(SvgUID.INSTANCE.get(CLIP_PATH_ID_PREFIX));
        SvgRectElement svgRectElement = new SvgRectElement();
        boolean bl4 = false;
        boolean bl5 = false;
        SvgRectElement svgRectElement2 = svgRectElement;
        ObservableList<SvgNode> observableList = $this$apply2.children();
        boolean bl6 = false;
        $this$apply.x().set(rect2.getLeft());
        $this$apply.y().set(rect2.getTop());
        $this$apply.width().set(rect2.getWidth());
        $this$apply.height().set(rect2.getHeight());
        Unit unit = Unit.INSTANCE;
        observableList.add(svgRectElement);
        SvgClipPathElement clipPathElement = svgClipPathElement;
        SvgDefsElement svgDefsElement = new SvgDefsElement();
        bl2 = false;
        boolean bl7 = false;
        SvgDefsElement $this$apply3 = svgDefsElement;
        boolean bl8 = false;
        $this$apply3.children().add(clipPathElement);
        SvgDefsElement defs = svgDefsElement;
        this.add(defs);
        Property<SvgIRI> property2 = this.getRootGroup().clipPath();
        Object ValueT = clipPathElement.id().get();
        Intrinsics.checkNotNull(ValueT);
        property2.set(new SvgIRI((String)ValueT));
        this.getRootGroup().setAttribute(SvgGraphicsElement.Companion.getCLIP_BOUNDS_JFX(), rect2);
    }

    public final void addClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.myRootGroup.addClass(className);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/render/svg/SvgComponent$Companion;", "", "()V", "CLIP_PATH_ID_PREFIX", "", "buildTransform", "Ljetbrains/datalore/vis/svg/SvgTransform;", "origin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "rotationAngle", "", "plot-base-portable"})
    public static final class Companion {
        @NotNull
        public final SvgTransform buildTransform(@NotNull DoubleVector origin, double rotationAngle) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            SvgTransformBuilder transformBuilder = new SvgTransformBuilder();
            if (Intrinsics.areEqual((Object)origin, (Object)DoubleVector.Companion.getZERO()) ^ true) {
                transformBuilder.translate(origin.getX(), origin.getY());
            }
            if (rotationAngle != 0.0) {
                transformBuilder.rotate(rotationAngle);
            }
            return transformBuilder.build();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

