/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.render.point;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.render.point.NamedShape;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.PointShapeSvg$WhenMappings;
import jetbrains.datalore.plot.base.render.point.TinyPointShape;
import jetbrains.datalore.plot.base.render.point.symbol.Glyph;
import jetbrains.datalore.plot.base.render.point.symbol.Glyphs;
import jetbrains.datalore.vis.svg.slim.SvgSlimElements;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import jetbrains.datalore.vis.svg.slim.SvgSlimShape;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/render/point/PointShapeSvg;", "", "()V", "create", "Ljetbrains/datalore/vis/svg/slim/SvgSlimObject;", "shape", "Ljetbrains/datalore/plot/base/render/point/PointShape;", "location", "Ljetbrains/datalore/base/geometry/DoubleVector;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "fatten", "", "createNamedShape", "Ljetbrains/datalore/plot/base/render/point/NamedShape;", "createSlimGlyph", "Ljetbrains/datalore/plot/base/render/point/symbol/Glyph;", "size", "createTinyDotShape", "plot-base-portable"})
public final class PointShapeSvg {
    public static final PointShapeSvg INSTANCE;

    @NotNull
    public final SvgSlimObject create(@NotNull PointShape shape, @NotNull DoubleVector location, @NotNull DataPointAesthetics p, double fatten) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (Intrinsics.areEqual((Object)shape, (Object)TinyPointShape.INSTANCE)) {
            return this.createTinyDotShape(location, p);
        }
        if (shape instanceof NamedShape) {
            return this.createNamedShape((NamedShape)shape, location, p, fatten);
        }
        throw (Throwable)new IllegalArgumentException("Unsupported point shape code " + shape.getCode() + ' ' + Reflection.getOrCreateKotlinClass(shape.getClass()).getSimpleName());
    }

    public static /* synthetic */ SvgSlimObject create$default(PointShapeSvg pointShapeSvg, PointShape pointShape, DoubleVector doubleVector, DataPointAesthetics dataPointAesthetics, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        return pointShapeSvg.create(pointShape, doubleVector, dataPointAesthetics, d);
    }

    private final SvgSlimObject createTinyDotShape(DoubleVector location, DataPointAesthetics p) {
        SvgSlimShape r = SvgSlimElements.INSTANCE.rect(location.getX() - 0.5, location.getY() - 0.5, 1.0, 1.0);
        Color color = p.color();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        double alpha = AestheticsUtil.INSTANCE.alpha(color2, p);
        r.setFill(color2, alpha);
        r.setStrokeWidth(0.0);
        return r;
    }

    private final SvgSlimObject createNamedShape(NamedShape shape, DoubleVector location, DataPointAesthetics p, double fatten) {
        Glyph glyph = this.createSlimGlyph(shape, location, shape.size(p) * fatten);
        AestheticsUtil.INSTANCE.decorate(glyph, shape.isFilled(), shape.isSolid(), p, shape.strokeWidth(p));
        return glyph;
    }

    private final Glyph createSlimGlyph(NamedShape shape, DoubleVector location, double size2) {
        switch (PointShapeSvg$WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return Glyphs.INSTANCE.square(location, size2);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Glyphs.INSTANCE.circle(location, size2);
            }
            case 9: 
            case 10: 
            case 11: {
                return Glyphs.INSTANCE.triangleUp(location, size2);
            }
            case 12: 
            case 13: {
                return Glyphs.INSTANCE.triangleDown(location, size2);
            }
            case 14: 
            case 15: 
            case 16: {
                return Glyphs.INSTANCE.diamond(location, size2);
            }
            case 17: {
                return Glyphs.INSTANCE.stickPlus(location, size2);
            }
            case 18: {
                return Glyphs.INSTANCE.stickCross(location, size2);
            }
            case 19: {
                return Glyphs.INSTANCE.stickSquareCross(location, size2);
            }
            case 20: {
                return Glyphs.INSTANCE.stickStar(location, size2);
            }
            case 21: {
                return Glyphs.INSTANCE.stickDiamondPlus(location, size2);
            }
            case 22: {
                return Glyphs.INSTANCE.stickCirclePlus(location, size2);
            }
            case 23: {
                return Glyphs.INSTANCE.stickTriangleUpDown(location, size2);
            }
            case 24: {
                return Glyphs.INSTANCE.stickSquarePlus(location, size2);
            }
            case 25: {
                return Glyphs.INSTANCE.stickCircleCross(location, size2);
            }
            case 26: {
                return Glyphs.INSTANCE.stickSquareTriangleUp(location, size2);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private PointShapeSvg() {
    }

    static {
        PointShapeSvg pointShapeSvg;
        INSTANCE = pointShapeSvg = new PointShapeSvg();
    }
}

