/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/geom/util/HintColorUtil;", "", "()V", "fromColor", "Ljetbrains/datalore/base/values/Color;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "fromColorValue", "color", "alpha", "", "fromFill", "plot-base-portable"})
public final class HintColorUtil {
    public static final HintColorUtil INSTANCE;

    @NotNull
    public final Color fromColor(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Color color = p.color();
        Intrinsics.checkNotNull((Object)color);
        Double d = p.alpha();
        Intrinsics.checkNotNull((Object)d);
        return this.fromColorValue(color, d);
    }

    @NotNull
    public final Color fromFill(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Color color = p.fill();
        Intrinsics.checkNotNull((Object)color);
        Double d = p.alpha();
        Intrinsics.checkNotNull((Object)d);
        return this.fromColorValue(color, d);
    }

    @NotNull
    public final Color fromColorValue(@NotNull Color color, double alpha) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int intAlpha = (int)((double)255 * alpha);
        return Colors.INSTANCE.solid(color) ? color.changeAlpha(intAlpha) : color;
    }

    private HintColorUtil() {
    }

    static {
        HintColorUtil hintColorUtil;
        INSTANCE = hintColorUtil = new HintColorUtil();
    }
}

