/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.Iterator;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.FilledSquareLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.vis.svg.SvgImageElementEx;
import jetbrains.datalore.vis.svg.SvgUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/geom/RasterGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public final class RasterGeom
extends GeomBase {
    public static final boolean HANDLES_GROUPS = false;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new FilledSquareLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterator<DataPointAesthetics> iter = GeomUtil.INSTANCE.with_X_Y(aesthetics.dataPoints()).iterator();
        if (!iter.hasNext()) {
            return;
        }
        DataPointAesthetics randomP = iter.next();
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        DoubleRectangle boundsXY = GeomBase.Companion.aesBoundingBox(aesthetics);
        double stepX = ctx2.getResolution(Aes.Companion.getX());
        double stepY = ctx2.getResolution(Aes.Companion.getY());
        Preconditions.INSTANCE.checkArgument(stepX > 1.0E-50, "x-step is too small: " + stepX);
        Preconditions.INSTANCE.checkArgument(stepY > 1.0E-50, "y-step is too small: " + stepY);
        double d = boundsXY.getDimension().getX() / stepX;
        boolean bl = false;
        double width2 = Math.rint(d) + 1.0;
        double d2 = boundsXY.getDimension().getY() / stepY;
        boolean bl2 = false;
        double height = Math.rint(d2) + 1.0;
        if (width2 * height > (double)5000000) {
            DoubleVector center = boundsXY.getCenter();
            String[] lines = new String[]{"Raster image size", "" + '[' + width2 + " X " + height + ']', "exceeds capability", "of", "your imaging device"};
            double fontSize = 12.0;
            double lineHeight = fontSize + (double)4;
            double y2 = center.getY() + lineHeight * (double)lines.length / 2.0;
            for (String line2 : lines) {
                TextLabel label = new TextLabel(line2);
                label.textColor().set(Color.Companion.getDARK_MAGENTA());
                label.textOpacity().set(0.5);
                label.setFontSize(fontSize);
                label.setFontWeight("bold");
                label.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                label.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                DoubleVector loc = helper.toClient(center.getX(), y2, randomP);
                label.moveTo(loc);
                root.add(label.getRootGroup());
                y2 -= lineHeight;
            }
            return;
        }
        boolean lines = false;
        int cols = (int)Math.rint(width2);
        boolean fontSize = false;
        int rows = (int)Math.rint(height);
        DoubleVector halfStep = new DoubleVector(stepX * 0.5, stepY * 0.5);
        DoubleVector corner0 = helper.toClient(boundsXY.getOrigin().subtract(halfStep), randomP);
        DoubleVector corner2 = helper.toClient(boundsXY.getOrigin().add(boundsXY.getDimension()).add(halfStep), randomP);
        boolean invertedX = corner2.getX() < corner0.getX();
        boolean invertedY = corner2.getY() < corner0.getY();
        double x0 = boundsXY.getOrigin().getX();
        double y0 = boundsXY.getOrigin().getY();
        int[] argbValues = new int[cols * rows];
        for (DataPointAesthetics p : GeomUtil.INSTANCE.with_X_Y(aesthetics.dataPoints())) {
            Double x2 = p.x();
            Double y3 = p.y();
            Double alpha = p.alpha();
            Color color = p.fill();
            Double d3 = x2;
            Intrinsics.checkNotNull((Object)d3);
            double d4 = (d3 - x0) / stepX;
            boolean bl3 = false;
            int col = (int)Math.rint(d4);
            Double d5 = y3;
            Intrinsics.checkNotNull((Object)d5);
            double d6 = (d5 - y0) / stepY;
            boolean bl4 = false;
            int row = (int)Math.rint(d6);
            if (invertedX) {
                col = cols - (col + 1);
            }
            if (invertedY) {
                row = rows - (row + 1);
            }
            Color color2 = color;
            Intrinsics.checkNotNull((Object)color2);
            Double d7 = alpha;
            Intrinsics.checkNotNull((Object)d7);
            argbValues[row * cols + col] = SvgUtils.INSTANCE.toARGB(color2, d7);
        }
        SvgImageElementEx.Bitmap bitmap = new SvgImageElementEx.Bitmap(cols, rows, argbValues);
        double d8 = corner0.getX();
        double d9 = corner2.getX();
        boolean bl5 = false;
        double d10 = Math.min(d8, d9);
        d8 = corner0.getY();
        d9 = corner2.getY();
        bl5 = false;
        double d11 = Math.min(d8, d9);
        d8 = corner0.getX() - corner2.getX();
        boolean bl6 = false;
        double d12 = Math.abs(d8);
        d8 = corner0.getY() - corner2.getY();
        bl6 = false;
        SvgImageElementEx svgImageElement = new SvgImageElementEx(d10, d11, d12, Math.abs(d8), bitmap);
        root.add(svgImageElement);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/geom/RasterGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

