/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.legend.HLineLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgLineElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/geom/HLineGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public final class HLineGeom
extends GeomBase {
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_KEY_ELEMENT_FACTORY;
    public static final Companion Companion;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_KEY_ELEMENT_FACTORY;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper helper = geomHelper.createSvgElementHelper();
        DoubleRectangle viewPort = GeomBase.Companion.aesViewPort(aesthetics);
        ArrayList<SvgLineElement> lines = new ArrayList<SvgLineElement>();
        for (DataPointAesthetics p : aesthetics.dataPoints()) {
            Double intercept = p.interceptY();
            if (!SeriesUtil.INSTANCE.isFinite(intercept)) continue;
            ClosedRange<Double> closedRange = viewPort.yRange();
            Double d = intercept;
            Intrinsics.checkNotNull((Object)d);
            if (!closedRange.contains((Double)((Comparable)d))) continue;
            DoubleVector start = new DoubleVector(viewPort.getLeft(), intercept);
            DoubleVector end = new DoubleVector(viewPort.getRight(), intercept);
            SvgLineElement line2 = helper.createLine(start, end, p);
            lines.add(line2);
            double h = AesScaling.INSTANCE.strokeWidth(p);
            DoubleVector origin = new DoubleVector(0.0, intercept - h / (double)2 - 2.0);
            DoubleVector dimensions = new DoubleVector(end.getX(), h + 4.0);
            DoubleRectangle rect2 = new DoubleRectangle(origin, dimensions);
            ctx2.getTargetCollector().addRectangle(p.index(), geomHelper.toClient(rect2, p), GeomTargetCollector.TooltipParams.Companion.params().setColor(HintColorUtil.INSTANCE.fromColor(p)), TipLayoutHint.Kind.CURSOR_TOOLTIP);
        }
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgLineElement it = (SvgLineElement)element$iv;
            boolean bl = false;
            root.add(it);
        }
    }

    static {
        Companion = new Companion(null);
        LEGEND_KEY_ELEMENT_FACTORY = new HLineLegendKeyElementFactory();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/HLineGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_KEY_ELEMENT_FACTORY", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLEGEND_KEY_ELEMENT_FACTORY", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "plot-base-portable"})
    public static final class Companion {
        @NotNull
        public final LegendKeyElementFactory getLEGEND_KEY_ELEMENT_FACTORY() {
            return LEGEND_KEY_ELEMENT_FACTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

