/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.geom.BoxplotGeom;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.PointGeom;
import jetbrains.datalore.plot.base.geom.util.BarTooltipHelper;
import jetbrains.datalore.plot.base.geom.util.CrossBarHelper;
import jetbrains.datalore.plot.base.geom.util.DataPointAestheticsDelegate;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.MappedAesthetics;
import jetbrains.datalore.plot.base.interact.NullGeomTargetCollector;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.vis.svg.SvgLineElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J0\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J0\u0010/\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Ljetbrains/datalore/plot/base/geom/BoxplotGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "outlierColor", "Ljetbrains/datalore/base/values/Color;", "getOutlierColor", "()Ljetbrains/datalore/base/values/Color;", "setOutlierColor", "(Ljetbrains/datalore/base/values/Color;)V", "outlierFill", "getOutlierFill", "setOutlierFill", "outlierShape", "Ljetbrains/datalore/plot/base/render/point/PointShape;", "getOutlierShape", "()Ljetbrains/datalore/plot/base/render/point/PointShape;", "setOutlierShape", "(Ljetbrains/datalore/plot/base/render/point/PointShape;)V", "outlierSize", "getOutlierSize", "()Ljava/lang/Double;", "setOutlierSize", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "buildLines", "buildOutliers", "getOutliersAesthetics", "toOutlierDataPointAesthetics", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "p", "Companion", "plot-base-portable"})
public final class BoxplotGeom
extends GeomBase {
    private double fattenMidline = 1.0;
    @Nullable
    private Color outlierColor;
    @Nullable
    private Color outlierFill;
    @Nullable
    private PointShape outlierShape;
    @Nullable
    private Double outlierSize;
    public static final boolean HANDLES_GROUPS = false;
    private static final LegendKeyElementFactory LEGEND_FACTORY;
    private static final double OUTLIER_DEF_SIZE;
    public static final Companion Companion;

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    @Nullable
    public final Color getOutlierColor() {
        return this.outlierColor;
    }

    public final void setOutlierColor(@Nullable Color color) {
        this.outlierColor = color;
    }

    @Nullable
    public final Color getOutlierFill() {
        return this.outlierFill;
    }

    public final void setOutlierFill(@Nullable Color color) {
        this.outlierFill = color;
    }

    @Nullable
    public final PointShape getOutlierShape() {
        return this.outlierShape;
    }

    public final void setOutlierShape(@Nullable PointShape pointShape) {
        this.outlierShape = pointShape;
    }

    @Nullable
    public final Double getOutlierSize() {
        return this.outlierSize;
    }

    public final void setOutlierSize(@Nullable Double d) {
        this.outlierSize = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        CrossBarHelper.INSTANCE.buildBoxes(root, aesthetics, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BoxplotGeom.Companion.rectangleByDataPoint(ctx2));
        this.buildLines(root, aesthetics, pos, coord, ctx2);
        this.buildOutliers(root, aesthetics, pos, coord, ctx2);
        BarTooltipHelper.INSTANCE.collectRectangleTargets(CollectionsKt.listOf((Object[])new Aes[]{Aes.Companion.getYMAX(), Aes.Companion.getUPPER(), Aes.Companion.getMIDDLE(), Aes.Companion.getLOWER(), Aes.Companion.getYMIN()}), aesthetics, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BoxplotGeom.Companion.rectangleByDataPoint(ctx2), (Function1<? super DataPointAesthetics, Color>)((Function1)buildIntern.1.INSTANCE));
    }

    private final void buildLines(SvgRoot root, Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        CrossBarHelper.INSTANCE.buildMidlines(root, aesthetics, pos, coord, ctx2, this.fattenMidline);
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper elementHelper = helper.createSvgElementHelper();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX())) {
            double fence;
            double hinge;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double x2 = d;
            ArrayList<SvgLineElement> lines = new ArrayList<SvgLineElement>();
            if (p.defined(Aes.Companion.getLOWER()) && p.defined(Aes.Companion.getYMIN())) {
                Double d2 = p.lower();
                Intrinsics.checkNotNull((Object)d2);
                hinge = d2;
                Double d3 = p.ymin();
                Intrinsics.checkNotNull((Object)d3);
                fence = d3;
                lines.add(elementHelper.createLine(new DoubleVector(x2, hinge), new DoubleVector(x2, fence), p));
            }
            if (!p.defined(Aes.Companion.getUPPER()) || !p.defined(Aes.Companion.getYMAX())) continue;
            Double d4 = p.upper();
            Intrinsics.checkNotNull((Object)d4);
            hinge = d4;
            Double d5 = p.ymax();
            Intrinsics.checkNotNull((Object)d5);
            fence = d5;
            lines.add(elementHelper.createLine(new DoubleVector(x2, hinge), new DoubleVector(x2, fence), p));
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgLineElement it = (SvgLineElement)element$iv;
                boolean bl = false;
                root.add(it);
            }
        }
    }

    private final void buildOutliers(SvgRoot root, Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        Aesthetics outlierAesthetics = this.getOutliersAesthetics(aesthetics);
        new PointGeom().buildIntern(root, outlierAesthetics, pos, coord, ctx2.withTargetCollector(new NullGeomTargetCollector()));
    }

    private final Aesthetics getOutliersAesthetics(Aesthetics aesthetics) {
        return new MappedAesthetics(aesthetics, (Function1<? super DataPointAesthetics, ? extends DataPointAesthetics>)((Function1)new Function1<DataPointAesthetics, DataPointAesthetics>(this){
            final /* synthetic */ BoxplotGeom this$0;

            @NotNull
            public final DataPointAesthetics invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return BoxplotGeom.access$toOutlierDataPointAesthetics(this.this$0, p);
            }
            {
                this.this$0 = boxplotGeom;
                super(1);
            }
        }));
    }

    private final DataPointAesthetics toOutlierDataPointAesthetics(DataPointAesthetics p) {
        if (!p.defined(Aes.Companion.getY())) {
            return p;
        }
        return new DataPointAestheticsDelegate(this, p, p){
            final /* synthetic */ BoxplotGeom this$0;
            final /* synthetic */ DataPointAesthetics $p;

            @Nullable
            public <T> T get(@NotNull Aes<T> aes) {
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                return this.getIntern(aes);
            }

            @Nullable
            public Color color() {
                return this.getIntern(Aes.Companion.getCOLOR());
            }

            @Nullable
            public Color fill() {
                return this.getIntern(Aes.Companion.getFILL());
            }

            @Nullable
            public PointShape shape() {
                return this.getIntern(Aes.Companion.getSHAPE());
            }

            @Nullable
            public Double size() {
                return this.getIntern(Aes.Companion.getSIZE());
            }

            private final <T> T getIntern(Aes<T> aes) {
                Object object;
                Aes<T> aes2 = aes;
                if (Intrinsics.areEqual(aes2, Aes.Companion.getCOLOR())) {
                    object = this.this$0.getOutlierColor();
                    if (object == null) {
                        object = super.color();
                    }
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getFILL())) {
                    object = this.this$0.getOutlierFill();
                    if (object == null) {
                        object = super.fill();
                    }
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getSHAPE())) {
                    object = this.this$0.getOutlierShape();
                    if (object == null) {
                        object = super.shape();
                    }
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getSIZE())) {
                    Double d = this.this$0.getOutlierSize();
                    object = d != null ? d : BoxplotGeom.access$getOUTLIER_DEF_SIZE$cp();
                } else {
                    object = super.get(aes);
                }
                Color value = object;
                return (T)value;
            }
            {
                this.this$0 = this$0;
                this.$p = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    static {
        Companion = new Companion(null);
        LEGEND_FACTORY = CrossBarHelper.INSTANCE.legendFactory(true);
        OUTLIER_DEF_SIZE = ((Number)AestheticsDefaults.Companion.point().defaultValue(Aes.Companion.getSIZE())).doubleValue();
    }

    public static final /* synthetic */ DataPointAesthetics access$toOutlierDataPointAesthetics(BoxplotGeom $this, DataPointAesthetics p) {
        return $this.toOutlierDataPointAesthetics(p);
    }

    public static final /* synthetic */ double access$getOUTLIER_DEF_SIZE$cp() {
        return OUTLIER_DEF_SIZE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/geom/BoxplotGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "OUTLIER_DEF_SIZE", "", "rectangleByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-base-portable"})
    public static final class Companion {
        private final Function1<DataPointAesthetics, DoubleRectangle> rectangleByDataPoint(GeomContext ctx2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2){
                final /* synthetic */ GeomContext $ctx;

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                    DoubleRectangle doubleRectangle;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (p.defined(Aes.Companion.getX()) && p.defined(Aes.Companion.getLOWER()) && p.defined(Aes.Companion.getUPPER()) && p.defined(Aes.Companion.getWIDTH())) {
                        Double d = p.x();
                        Intrinsics.checkNotNull((Object)d);
                        double x2 = d;
                        Double d2 = p.lower();
                        Intrinsics.checkNotNull((Object)d2);
                        double lower = d2;
                        Double d3 = p.upper();
                        Intrinsics.checkNotNull((Object)d3);
                        double upper = d3;
                        double width2 = GeomUtil.INSTANCE.widthPx(p, this.$ctx, 2.0);
                        DoubleVector origin = new DoubleVector(x2 - width2 / (double)2, lower);
                        DoubleVector dimensions = new DoubleVector(width2, upper - lower);
                        doubleRectangle = new DoubleRectangle(origin, dimensions);
                    } else {
                        doubleRectangle = null;
                    }
                    return doubleRectangle;
                }
                {
                    this.$ctx = geomContext;
                    super(1);
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

