/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.ReadableProperty;
import jetbrains.datalore.base.observable.property.ValueProperty;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.builder.Plot;
import jetbrains.datalore.plot.builder.PlotContainerPortable;
import jetbrains.datalore.plot.builder.assemble.PlotAssembler;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.plot.config.PlotConfigClientSideUtil;
import jetbrains.datalore.plot.config.PlotConfigUtil;
import jetbrains.datalore.plot.server.config.PlotConfigServerSide;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import jetbrains.datalore.vis.svgToString.SvgToString;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J$\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ&\u0010\f\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002JL\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f\u0012\u0004\u0012\u00020\u00140\u0013J;\u0010\u0015\u001a\u00020\u00162\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b\u0017J.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0014H\u0002\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon;", "", "()V", "buildGGBunchFromProcessedSpecs", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "bunchSpec", "", "", "buildPlotsFromProcessedSpecs", "plotSpec", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "buildSinglePlotFromProcessedSpecs", "Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "buildSvgImagesFromRawSpecs", "", "svgToString", "Ljetbrains/datalore/vis/svgToString/SvgToString;", "computationMessagesHandler", "Lkotlin/Function1;", "", "createPlotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "createPlotAssembler$plot_config_portable", "processRawSpecs", "frontendOnly", "", "throwTestingErrors", "PlotBuildInfo", "PlotsBuildResult", "plot-config-portable"})
public final class MonolithicCommon {
    public static final MonolithicCommon INSTANCE;

    @NotNull
    public final List<String> buildSvgImagesFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize, @NotNull SvgToString svgToString, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Object object;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Object list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)svgToString, (String)"svgToString");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        Map<String, Object> plotSpec2 = this.processRawSpecs(plotSpec, false);
        PlotsBuildResult buildResult = this.buildPlotsFromProcessedSpecs(plotSpec2, plotSize);
        if (buildResult.isError()) {
            PlotsBuildResult plotsBuildResult = buildResult;
            if (plotsBuildResult == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Error");
            }
            String errorMessage = ((PlotsBuildResult.Error)plotsBuildResult).getError();
            throw (Throwable)new RuntimeException(errorMessage);
        }
        PlotsBuildResult plotsBuildResult = buildResult;
        if (plotsBuildResult == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Success");
        }
        PlotsBuildResult.Success success2 = (PlotsBuildResult.Success)plotsBuildResult;
        Iterable $this$flatMap$iv = success2.getBuildInfos();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PlotBuildInfo)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((PlotBuildInfo)it).getComputationMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List computationMessages = (List)destination$iv$iv;
        $this$flatMap$iv = computationMessages;
        $i$f$flatMap = false;
        if (!$this$flatMap$iv.isEmpty()) {
            computationMessagesHandler.invoke((Object)computationMessages);
        }
        Iterable $this$map$iv = success2.getBuildInfos();
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (PlotBuildInfo)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            PlotAssembler assembler2 = ((PlotBuildInfo)it).getPlotAssembler();
            Plot plot2 = assembler2.createPlot();
            PlotContainerPortable plotContainer = new PlotContainerPortable(plot2, ((PlotBuildInfo)it).getSize());
            plotContainer.ensureContentBuilt();
            object = plotContainer.getSvg();
            collection2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SvgSvgElement)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            object = svgToString.render((SvgSvgElement)it);
            collection2.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PlotsBuildResult buildPlotsFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize) {
        PlotsBuildResult plotsBuildResult;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        this.throwTestingErrors();
        PlotConfig.Companion.assertPlotSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            String errorMessage = PlotConfig.Companion.getErrorMessage(plotSpec);
            return new PlotsBuildResult.Error(errorMessage);
        }
        if (PlotConfig.Companion.isPlotSpec(plotSpec)) {
            plotsBuildResult = new PlotsBuildResult.Success(CollectionsKt.listOf((Object)this.buildSinglePlotFromProcessedSpecs(plotSpec, plotSize)));
        } else if (PlotConfig.Companion.isGGBunchSpec(plotSpec)) {
            plotsBuildResult = this.buildGGBunchFromProcessedSpecs(plotSpec);
        } else {
            throw (Throwable)new RuntimeException("Unexpected plot spec kind: " + PlotConfig.Companion.specKind(plotSpec));
        }
        return plotsBuildResult;
    }

    private final PlotsBuildResult buildGGBunchFromProcessedSpecs(Map<String, Object> bunchSpec) {
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            return new PlotsBuildResult.Error("No plots in the bunch");
        }
        ArrayList<PlotBuildInfo> buildInfos = new ArrayList<PlotBuildInfo>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            Map<String, Object> map2 = bunchItem.getFeatureSpec();
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            }
            Map plotSpec = TypeIntrinsics.asMutableMap(map2);
            PlotBuildInfo buildInfo = this.buildSinglePlotFromProcessedSpecs(plotSpec, PlotSizeHelper.INSTANCE.bunchItemSize$plot_config_portable(bunchItem));
            buildInfo = new PlotBuildInfo(buildInfo.getPlotAssembler(), buildInfo.getProcessedPlotSpec(), new DoubleVector(bunchItem.getX(), bunchItem.getY()), buildInfo.getSize(), buildInfo.getComputationMessages());
            buildInfos.add(buildInfo);
        }
        return new PlotsBuildResult.Success((List<PlotBuildInfo>)buildInfos);
    }

    private final PlotBuildInfo buildSinglePlotFromProcessedSpecs(Map<String, Object> plotSpec, DoubleVector plotSize) {
        ArrayList computationMessages = new ArrayList();
        PlotAssembler assembler2 = this.createPlotAssembler$plot_config_portable(plotSpec, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(computationMessages){
            final /* synthetic */ ArrayList $computationMessages;

            public final void invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$computationMessages.addAll((Collection)it);
            }
            {
                this.$computationMessages = arrayList;
                super(1);
            }
        }));
        ValueProperty<DoubleVector> preferredSize = new ValueProperty<DoubleVector>(PlotSizeHelper.INSTANCE.singlePlotSize(plotSpec, plotSize, assembler2.getFacets(), assembler2.getContainsLiveMap()));
        return new PlotBuildInfo(assembler2, plotSpec, DoubleVector.Companion.getZERO(), (ReadableProperty<DoubleVector>)preferredSize, computationMessages);
    }

    @NotNull
    public final PlotAssembler createPlotAssembler$plot_config_portable(@NotNull Map<String, Object> plotSpec, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        List<String> computationMessages = PlotConfigUtil.INSTANCE.findComputationMessages(plotSpec);
        Collection collection2 = computationMessages;
        boolean bl = false;
        if (!collection2.isEmpty()) {
            computationMessagesHandler.invoke(computationMessages);
        }
        return PlotConfigClientSideUtil.INSTANCE.createPlotAssembler(plotSpec);
    }

    private final void throwTestingErrors() {
    }

    @NotNull
    public final Map<String, Object> processRawSpecs(@NotNull Map<String, Object> plotSpec, boolean frontendOnly) {
        Map<String, Object> plotSpec2;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        PlotConfig.Companion.assertPlotSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            return plotSpec;
        }
        Map<String, Object> map2 = plotSpec2 = frontendOnly ? plotSpec : PlotConfigServerSide.Companion.processTransform(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec2)) {
            return plotSpec2;
        }
        return PlotConfigClientSide.Companion.processTransform(plotSpec2);
    }

    private MonolithicCommon() {
    }

    static {
        MonolithicCommon monolithicCommon;
        INSTANCE = monolithicCommon = new MonolithicCommon();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "", "()V", "isError", "", "()Z", "Error", "Success", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Error;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Success;", "plot-config-portable"})
    public static abstract class PlotsBuildResult {
        private final boolean isError = this instanceof Error;

        public final boolean isError() {
            return this.isError;
        }

        private PlotsBuildResult() {
        }

        public /* synthetic */ PlotsBuildResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Error;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "plot-config-portable"})
        public static final class Error
        extends PlotsBuildResult {
            @NotNull
            private final String error;

            @NotNull
            public final String getError() {
                return this.error;
            }

            public Error(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Success;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "buildInfos", "", "Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "(Ljava/util/List;)V", "getBuildInfos", "()Ljava/util/List;", "plot-config-portable"})
        public static final class Success
        extends PlotsBuildResult {
            @NotNull
            private final List<PlotBuildInfo> buildInfos;

            @NotNull
            public final List<PlotBuildInfo> getBuildInfos() {
                return this.buildInfos;
            }

            public Success(@NotNull List<PlotBuildInfo> buildInfos) {
                Intrinsics.checkNotNullParameter(buildInfos, (String)"buildInfos");
                super(null);
                this.buildInfos = buildInfos;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "", "plotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "processedPlotSpec", "", "", "origin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "size", "Ljetbrains/datalore/base/observable/property/ReadableProperty;", "computationMessages", "", "(Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/observable/property/ReadableProperty;Ljava/util/List;)V", "getComputationMessages", "()Ljava/util/List;", "getOrigin", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getPlotAssembler", "()Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "getProcessedPlotSpec", "()Ljava/util/Map;", "getSize", "()Ljetbrains/datalore/base/observable/property/ReadableProperty;", "bounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "plot-config-portable"})
    public static final class PlotBuildInfo {
        @NotNull
        private final PlotAssembler plotAssembler;
        @NotNull
        private final Map<String, Object> processedPlotSpec;
        @NotNull
        private final DoubleVector origin;
        @NotNull
        private final ReadableProperty<DoubleVector> size;
        @NotNull
        private final List<String> computationMessages;

        @NotNull
        public final DoubleRectangle bounds() {
            return new DoubleRectangle(this.origin, (DoubleVector)this.size.get());
        }

        @NotNull
        public final PlotAssembler getPlotAssembler() {
            return this.plotAssembler;
        }

        @NotNull
        public final Map<String, Object> getProcessedPlotSpec() {
            return this.processedPlotSpec;
        }

        @NotNull
        public final DoubleVector getOrigin() {
            return this.origin;
        }

        @NotNull
        public final ReadableProperty<DoubleVector> getSize() {
            return this.size;
        }

        @NotNull
        public final List<String> getComputationMessages() {
            return this.computationMessages;
        }

        public PlotBuildInfo(@NotNull PlotAssembler plotAssembler, @NotNull Map<String, Object> processedPlotSpec, @NotNull DoubleVector origin, @NotNull ReadableProperty<DoubleVector> size2, @NotNull List<String> computationMessages) {
            Intrinsics.checkNotNullParameter((Object)plotAssembler, (String)"plotAssembler");
            Intrinsics.checkNotNullParameter(processedPlotSpec, (String)"processedPlotSpec");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter(size2, (String)"size");
            Intrinsics.checkNotNullParameter(computationMessages, (String)"computationMessages");
            this.plotAssembler = plotAssembler;
            this.processedPlotSpec = processedPlotSpec;
            this.origin = origin;
            this.size = size2;
            this.computationMessages = computationMessages;
        }
    }
}

