/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator$calculateBoundingRange$1;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator$calculateBoundingRange$2;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculatorKt;
import jetbrains.datalore.base.spatial.LongitudeSegment;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0015B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJH\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u001c\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\u001c\u0010\u000f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bJB\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator;", "TypeT", "", "myMapRect", "Ljetbrains/datalore/base/typedGeometry/Rect;", "myLoopX", "", "myLoopY", "(Ljetbrains/datalore/base/typedGeometry/Rect;ZZ)V", "calculateBoundingBox", "xSegments", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "Ljetbrains/datalore/base/spatial/Segment;", "ySegments", "calculateBoundingRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "segments", "mapRange", "loop", "Companion", "base-portable"})
public final class GeoBoundingBoxCalculator<TypeT> {
    private final Rect<TypeT> myMapRect;
    private final boolean myLoopX;
    private final boolean myLoopY;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Rect<TypeT> calculateBoundingBox(@NotNull Sequence<Pair<Double, Double>> xSegments, @NotNull Sequence<Pair<Double, Double>> ySegments) {
        Intrinsics.checkNotNullParameter(xSegments, (String)"xSegments");
        Intrinsics.checkNotNullParameter(ySegments, (String)"ySegments");
        ClosedRange<Double> xRange = this.calculateBoundingRange(xSegments, FunctionsKt.xRange(this.myMapRect), this.myLoopX);
        ClosedRange<Double> yRange = this.calculateBoundingRange(ySegments, FunctionsKt.yRange(this.myMapRect), this.myLoopY);
        return new Rect(((Number)xRange.getLowerEnd()).doubleValue(), ((Number)yRange.getLowerEnd()).doubleValue(), GeoBoundingBoxCalculator.Companion.length(xRange), GeoBoundingBoxCalculator.Companion.length(yRange));
    }

    private final ClosedRange<Double> calculateBoundingRange(Sequence<Pair<Double, Double>> segments, ClosedRange<Double> mapRange, boolean loop) {
        ClosedRange<Double> closedRange;
        if (loop) {
            closedRange = Companion.calculateLoopLimitRange$base_portable(segments, mapRange);
        } else {
            Double d = SequencesKt.min((Sequence)SequencesKt.map(segments, (Function1)((Function1)GeoBoundingBoxCalculator$calculateBoundingRange$1.INSTANCE)));
            Intrinsics.checkNotNull((Object)d);
            Comparable comparable = d;
            Double d2 = SequencesKt.max((Sequence)SequencesKt.map(segments, (Function1)((Function1)GeoBoundingBoxCalculator$calculateBoundingRange$2.INSTANCE)));
            Intrinsics.checkNotNull((Object)d2);
            closedRange = new ClosedRange<Double>((Double)comparable, (Double)((Comparable)d2));
        }
        return closedRange;
    }

    public GeoBoundingBoxCalculator(@NotNull Rect<TypeT> myMapRect, boolean myLoopX, boolean myLoopY) {
        Intrinsics.checkNotNullParameter(myMapRect, (String)"myMapRect");
        this.myMapRect = myMapRect;
        this.myLoopX = myLoopX;
        this.myLoopY = myLoopY;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u001c\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bj\u0002`\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0012\u0010\u0012\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator$Companion;", "", "()V", "calculateLoopLimitRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "segments", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Ljetbrains/datalore/base/spatial/Segment;", "mapRange", "calculateLoopLimitRange$base_portable", "findMaxGapBetweenRanges", "ranges", "width", "invertRange", "range", "normalizeCenter", "length", "base-portable"})
    public static final class Companion {
        @NotNull
        public final ClosedRange<Double> calculateLoopLimitRange$base_portable(@NotNull Sequence<Pair<Double, Double>> segments, @NotNull ClosedRange<Double> mapRange) {
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            Intrinsics.checkNotNullParameter(mapRange, (String)"mapRange");
            Object object = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map(segments, (Function1)((Function1)new Function1<Pair<? extends Double, ? extends Double>, List<? extends ClosedRange<Double>>>(mapRange){
                final /* synthetic */ ClosedRange $mapRange;

                @NotNull
                public final List<ClosedRange<Double>> invoke(@NotNull Pair<Double, Double> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return LongitudeSegment.Companion.splitSegment(GeoBoundingBoxCalculatorKt.getStart(it), GeoBoundingBoxCalculatorKt.getEnd(it), ((Number)this.$mapRange.getLowerEnd()).doubleValue(), ((Number)this.$mapRange.getUpperEnd()).doubleValue());
                }
                {
                    this.$mapRange = closedRange;
                    super(1);
                }
            })));
            boolean bl = false;
            boolean bl2 = false;
            Sequence $this$run = object;
            boolean bl3 = false;
            object = Companion.findMaxGapBetweenRanges((Sequence<? extends ClosedRange<Double>>)$this$run, Companion.length(mapRange));
            bl = false;
            bl2 = false;
            $this$run = object;
            boolean bl4 = false;
            object = Companion.invertRange((ClosedRange<Double>)$this$run, Companion.length(mapRange));
            bl = false;
            bl2 = false;
            $this$run = object;
            boolean bl5 = false;
            return Companion.normalizeCenter((ClosedRange<Double>)$this$run, mapRange);
        }

        private final ClosedRange<Double> normalizeCenter(ClosedRange<Double> range2, ClosedRange<Double> mapRange) {
            return mapRange.contains((Double)((Comparable)Double.valueOf((((Number)range2.getUpperEnd()).doubleValue() + ((Number)range2.getLowerEnd()).doubleValue()) / (double)2))) ? range2 : new ClosedRange<Comparable>(Double.valueOf(((Number)range2.getLowerEnd()).doubleValue() - this.length(mapRange)), Double.valueOf(((Number)range2.getUpperEnd()).doubleValue() - this.length(mapRange)));
        }

        private final ClosedRange<Double> findMaxGapBetweenRanges(Sequence<? extends ClosedRange<Double>> ranges, double width2) {
            Object v0;
            Sequence sortedRanges;
            Sequence<? extends ClosedRange<Double>> $this$sortedBy$iv = ranges;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Sequence $this$maxBy$iv = sortedRanges = SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    T receiver = a;
                    boolean bl2 = false;
                    T t = ((ClosedRange)receiver).getLowerEnd();
                    receiver = b;
                    T t2 = t;
                    bl2 = false;
                    T t3 = ((ClosedRange)receiver).getLowerEnd();
                    return ComparisonsKt.compareValues(t2, t3);
                }
            });
            boolean $i$f$maxBy = false;
            Sequence $this$maxByOrNull$iv$iv = $this$maxBy$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv$iv22 = $this$maxByOrNull$iv$iv.iterator();
            if (!iterator$iv$iv22.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv$iv = iterator$iv$iv22.next();
                if (!iterator$iv$iv22.hasNext()) {
                    v0 = maxElem$iv$iv;
                } else {
                    Object receiver = maxElem$iv$iv;
                    boolean bl2 = false;
                    Object maxValue$iv$iv = ((ClosedRange)receiver).getUpperEnd();
                    do {
                        Object e$iv$iv;
                        Object receiver2 = e$iv$iv = iterator$iv$iv22.next();
                        $i$a$-unknown-Object = false;
                        Object v$iv$iv = ((ClosedRange)receiver2).getUpperEnd();
                        if (maxValue$iv$iv.compareTo(v$iv$iv) >= 0) continue;
                        maxElem$iv$iv = e$iv$iv;
                        maxValue$iv$iv = v$iv$iv;
                    } while (iterator$iv$iv22.hasNext());
                    v0 = maxElem$iv$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            double prevUpper = ((Number)((ClosedRange)v0).getUpperEnd()).doubleValue();
            double nextLower = ((Number)((ClosedRange)SequencesKt.first((Sequence)sortedRanges)).getLowerEnd()).doubleValue();
            double iterator$iv$iv22 = width2 + nextLower;
            boolean maxValue$iv$iv = false;
            double gapRight = Math.max(iterator$iv$iv22, prevUpper);
            ClosedRange<Comparable> maxGapRange = new ClosedRange<Comparable>(Double.valueOf(prevUpper), Double.valueOf(gapRight));
            Iterator it = sortedRanges.iterator();
            prevUpper = ((Number)((ClosedRange)it.next()).getUpperEnd()).doubleValue();
            while (it.hasNext()) {
                ClosedRange range2 = (ClosedRange)it.next();
                nextLower = ((Number)range2.getLowerEnd()).doubleValue();
                if (nextLower > prevUpper && nextLower - prevUpper > this.length(maxGapRange)) {
                    maxGapRange = new ClosedRange<Comparable>(Double.valueOf(prevUpper), Double.valueOf(nextLower));
                }
                double d = ((Number)range2.getUpperEnd()).doubleValue();
                boolean bl3 = false;
                prevUpper = Math.max(prevUpper, d);
            }
            return maxGapRange;
        }

        private final ClosedRange<Double> invertRange(ClosedRange<Double> range2, double width2) {
            invertRange.1 $fun$safeRange$1 = invertRange.1.INSTANCE;
            return this.length(range2) > width2 ? new ClosedRange<Double>(range2.getLowerEnd(), range2.getLowerEnd()) : (((Number)range2.getUpperEnd()).doubleValue() > width2 ? $fun$safeRange$1.invoke(((Number)range2.getUpperEnd()).doubleValue() - width2, ((Number)range2.getLowerEnd()).doubleValue()) : $fun$safeRange$1.invoke(((Number)range2.getUpperEnd()).doubleValue(), width2 + ((Number)range2.getLowerEnd()).doubleValue()));
        }

        private final double length(ClosedRange<Double> $this$length) {
            return ((Number)$this$length.getUpperEnd()).doubleValue() - ((Number)$this$length.getLowerEnd()).doubleValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

