/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.numberFormat;

import jetbrains.datalore.base.numberFormat.NumberFormat;
import jetbrains.datalore.base.numberFormat.NumberFormatKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 !2\u00020\u0001:\u0005!\"#$%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat;", "", "spec", "", "(Ljava/lang/String;)V", "Ljetbrains/datalore/base/numberFormat/NumberFormat$Spec;", "(Ljetbrains/datalore/base/numberFormat/NumberFormat$Spec;)V", "apply", "num", "", "applyGroup", "Ljetbrains/datalore/base/numberFormat/NumberFormat$Output;", "output", "computeBody", "res", "numberInfo", "Ljetbrains/datalore/base/numberFormat/NumberFormat$NumberInfo;", "computePadding", "computePrefix", "computeSign", "computeSuffix", "getAlignedString", "handleNonNumbers", "roundToPrecision", "precision", "", "toExponential", "toFixedFormat", "Ljetbrains/datalore/base/numberFormat/NumberFormat$FormattedNumber;", "toPrecisionFormat", "toSiFormat", "toSimpleFormat", "trimFraction", "Companion", "FormattedNumber", "NumberInfo", "Output", "Spec", "base-portable"})
public final class NumberFormat {
    private final Spec spec;
    private static final String CURRENCY = "$";
    private static final String PERCENT = "%";
    private static final String COMMA = ",";
    private static final String FRACTION_DELIMITER = ".";
    private static final int FRACTION_DELIMITER_LENGTH = 1;
    private static final int GROUP_SIZE = 3;
    private static final String[] SI_SUFFIXES;
    private static final Regex NUMBER_REGEX;
    public static final Companion Companion;

    @NotNull
    public final String apply(@NotNull Number num) {
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        String nonNumberString = this.handleNonNumbers(num);
        if (nonNumberString != null) {
            return nonNumberString;
        }
        NumberInfo numberInfo = NumberInfo.Companion.createNumberInfo$base_portable(num);
        Output output = new Output(null, null, null, null, null, 31, null);
        output = this.computeBody(output, numberInfo);
        output = this.trimFraction(output);
        output = this.computeSign(output, numberInfo);
        output = this.computePrefix(output);
        output = this.computeSuffix(output);
        if (this.spec.getComma() && !this.spec.getZero()) {
            output = this.applyGroup(output);
        }
        output = this.computePadding(output);
        if (this.spec.getComma() && this.spec.getZero()) {
            output = this.applyGroup(output);
        }
        return this.getAlignedString(output);
    }

    private final String handleNonNumbers(Number num) {
        double number;
        double d = number = num.doubleValue();
        boolean bl = false;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        d = num.doubleValue();
        return d == Double.NEGATIVE_INFINITY ? "-Infinity" : (d == Double.POSITIVE_INFINITY ? "+Infinity" : null);
    }

    private final String getAlignedString(Output output) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        Output $this$with = output;
        boolean bl3 = false;
        switch (this.spec.getAlign()) {
            case "<": {
                string = $this$with.getSign() + $this$with.getPrefix() + $this$with.getBody() + $this$with.getSuffix() + $this$with.getPadding();
                break;
            }
            case "=": {
                string = $this$with.getSign() + $this$with.getPrefix() + $this$with.getPadding() + $this$with.getBody() + $this$with.getSuffix();
                break;
            }
            case "^": {
                int stop = $this$with.getPadding().length() / 2;
                string = StringsKt.slice((String)$this$with.getPadding(), (IntRange)RangesKt.until((int)0, (int)stop)) + $this$with.getSign() + $this$with.getPrefix() + $this$with.getBody() + $this$with.getSuffix() + StringsKt.slice((String)$this$with.getPadding(), (IntRange)RangesKt.until((int)stop, (int)output.getPadding().length()));
                break;
            }
            default: {
                string = $this$with.getPadding() + $this$with.getSign() + $this$with.getPrefix() + $this$with.getBody() + $this$with.getSuffix();
            }
        }
        return string;
    }

    private final Output applyGroup(Output output) {
        boolean bl;
        String string = output.getPadding();
        boolean bl2 = false;
        boolean bl3 = false;
        String it22 = string;
        boolean bl4 = false;
        String string2 = this.spec.getZero() ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        String zeroPadding = string2;
        FormattedNumber body = output.getBody();
        String fullIntStr = zeroPadding + body.getIntegerPart();
        double it22 = (double)fullIntStr.length() / (double)3;
        int n = 0;
        int commas = (int)(Math.ceil(it22) - 1.0);
        int width2 = RangesKt.coerceAtLeast((int)(this.spec.getWidth() - body.getFractionalLength() - body.getExponentialPart().length()), (int)(body.getIntegerPart().length() + commas));
        fullIntStr = NumberFormat.Companion.group(fullIntStr);
        if (fullIntStr.length() > width2) {
            String string3 = fullIntStr;
            n = fullIntStr.length() - width2;
            bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            fullIntStr = string5;
            if (StringsKt.startsWith$default((CharSequence)fullIntStr, (char)',', (boolean)false, (int)2, null)) {
                fullIntStr = '0' + fullIntStr;
            }
        }
        String string6 = "";
        n = 0;
        bl = false;
        String string7 = string6;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        FormattedNumber formattedNumber = FormattedNumber.copy$default(body, fullIntStr, null, null, 6, null);
        Output output2 = output;
        boolean bl5 = false;
        boolean bl6 = this.spec.getZero();
        String string11 = bl6 ? string6 : null;
        if (string11 == null) {
            string11 = output.getPadding();
        }
        return Output.copy$default(output2, formattedNumber, string10, string9, string8, string11, 14, null);
    }

    private final Output computeBody(Output res, NumberInfo numberInfo) {
        FormattedNumber formattedNumber;
        switch (this.spec.getType()) {
            case "%": {
                formattedNumber = this.toFixedFormat(NumberInfo.Companion.createNumberInfo$base_portable(numberInfo.getNumber() * (double)100), this.spec.getPrecision());
                break;
            }
            case "c": {
                formattedNumber = new FormattedNumber(String.valueOf(numberInfo.getNumber()), null, null, 6, null);
                break;
            }
            case "d": {
                formattedNumber = this.toSimpleFormat(numberInfo, 0);
                break;
            }
            case "e": {
                formattedNumber = this.toSimpleFormat(this.toExponential(numberInfo, this.spec.getPrecision()), this.spec.getPrecision());
                break;
            }
            case "f": {
                formattedNumber = this.toFixedFormat(numberInfo, this.spec.getPrecision());
                break;
            }
            case "g": {
                formattedNumber = this.toPrecisionFormat(numberInfo, this.spec.getPrecision());
                break;
            }
            case "b": {
                long l = MathKt.roundToLong((double)numberInfo.getNumber());
                int n = 2;
                boolean bl = false;
                String string = Long.toString(l, CharsKt.checkRadix((int)n));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
                formattedNumber = new FormattedNumber(string, null, null, 6, null);
                break;
            }
            case "o": {
                long l = MathKt.roundToLong((double)numberInfo.getNumber());
                int n = 8;
                boolean bl = false;
                String string = Long.toString(l, CharsKt.checkRadix((int)n));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
                formattedNumber = new FormattedNumber(string, null, null, 6, null);
                break;
            }
            case "X": {
                long l = MathKt.roundToLong((double)numberInfo.getNumber());
                int n = 16;
                boolean bl = false;
                String string = Long.toString(l, CharsKt.checkRadix((int)n));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
                String string2 = string;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                formattedNumber = new FormattedNumber(string4, null, null, 6, null);
                break;
            }
            case "x": {
                long l = MathKt.roundToLong((double)numberInfo.getNumber());
                int n = 16;
                boolean bl = false;
                String string = Long.toString(l, CharsKt.checkRadix((int)n));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
                formattedNumber = new FormattedNumber(string, null, null, 6, null);
                break;
            }
            case "s": {
                formattedNumber = this.toSiFormat(numberInfo, this.spec.getPrecision());
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Wrong type: " + this.spec.getType());
            }
        }
        FormattedNumber formattedNumber2 = formattedNumber;
        return Output.copy$default(res, formattedNumber2, null, null, null, null, 30, null);
    }

    private final NumberInfo toExponential(NumberInfo numberInfo, int precision) {
        double num = numberInfo.getNumber();
        if (num == 0.0) {
            return NumberInfo.copy$default(numberInfo, 0.0, false, 0L, 0L, 0, 15, null);
        }
        int e = numberInfo.getIntegerPart() == 0L ? -(numberInfo.getFractionLeadingZeros() + 1) : numberInfo.getIntegerLength() - 1;
        double d = 10.0;
        boolean bl = false;
        double n = num / Math.pow(d, e);
        NumberInfo newInfo = NumberInfo.Companion.createNumberInfo$base_portable(n);
        if (precision > -1) {
            newInfo = this.roundToPrecision(newInfo, precision);
        }
        if (newInfo.getIntegerLength() > 1) {
            ++e;
            newInfo = NumberInfo.Companion.createNumberInfo$base_portable(n / (double)10);
        }
        return NumberInfo.copy$default(newInfo, 0.0, false, 0L, 0L, e, 15, null);
    }

    static /* synthetic */ NumberInfo toExponential$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toExponential(numberInfo, n);
    }

    private final FormattedNumber toPrecisionFormat(NumberInfo numberInfo, int precision) {
        if (numberInfo.getIntegerPart() == 0L) {
            if (numberInfo.getFractionalPart() == 0L) {
                return this.toFixedFormat(numberInfo, precision - 1);
            }
            return this.toFixedFormat(numberInfo, precision + numberInfo.getFractionLeadingZeros());
        }
        if (numberInfo.getIntegerLength() > precision) {
            return this.toSimpleFormat(this.toExponential(numberInfo, precision - 1), precision - 1);
        }
        return this.toFixedFormat(numberInfo, precision - numberInfo.getIntegerLength());
    }

    static /* synthetic */ FormattedNumber toPrecisionFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toPrecisionFormat(numberInfo, n);
    }

    private final FormattedNumber toFixedFormat(NumberInfo numberInfo, int precision) {
        int completePrecision;
        if (precision <= 0) {
            return new FormattedNumber(String.valueOf(MathKt.roundToLong((double)numberInfo.getNumber())), null, null, 6, null);
        }
        NumberInfo newNumberInfo = this.roundToPrecision(numberInfo, precision);
        int n = completePrecision = numberInfo.getIntegerLength() < newNumberInfo.getIntegerLength() ? precision - 1 : precision;
        if (newNumberInfo.getFractionalPart() == 0L) {
            return new FormattedNumber(String.valueOf(newNumberInfo.getIntegerPart()), StringsKt.repeat((CharSequence)"0", (int)completePrecision), null, 4, null);
        }
        String fractionString = StringsKt.padEnd((String)newNumberInfo.getFractionString(), (int)completePrecision, (char)'0');
        return new FormattedNumber(String.valueOf(newNumberInfo.getIntegerPart()), fractionString, null, 4, null);
    }

    static /* synthetic */ FormattedNumber toFixedFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return numberFormat.toFixedFormat(numberInfo, n);
    }

    private final FormattedNumber toSimpleFormat(NumberInfo numberInfo, int precision) {
        String string;
        if (numberInfo.getExponent() != null) {
            String expSign = MathKt.getSign((int)numberInfo.getExponent()) >= 0 ? "+" : "";
            string = 'e' + expSign + numberInfo.getExponent();
        } else {
            string = "";
        }
        String exponentString = string;
        NumberInfo expNumberInfo = NumberInfo.Companion.createNumberInfo$base_portable((double)numberInfo.getIntegerPart() + (double)numberInfo.getFractionalPart() / (double)NumberInfo.Companion.getMAX_DECIMAL_VALUE$base_portable());
        if (precision > -1) {
            FormattedNumber formattedNumber = this.toFixedFormat(expNumberInfo, precision);
            return FormattedNumber.copy$default(formattedNumber, null, null, exponentString, 3, null);
        }
        String integerString = String.valueOf(expNumberInfo.getIntegerPart());
        String fractionString = expNumberInfo.getFractionalPart() == 0L ? "" : expNumberInfo.getFractionString();
        return new FormattedNumber(integerString, fractionString, exponentString);
    }

    static /* synthetic */ FormattedNumber toSimpleFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toSimpleFormat(numberInfo, n);
    }

    private final FormattedNumber toSiFormat(NumberInfo numberInfo, int precision) {
        NumberInfo expNumberInfo = numberInfo.getExponent() == null ? this.toExponential(numberInfo, precision - 1) : numberInfo;
        Integer n = expNumberInfo.getExponent();
        int exponent = n != null ? n : 0;
        double d = (double)exponent / 3.0;
        boolean bl = false;
        int suffixExp = (int)RangesKt.coerceAtMost((double)RangesKt.coerceAtLeast((double)Math.floor(d), (double)-8.0), (double)8.0) * 3;
        double d2 = 10.0;
        int n2 = -suffixExp;
        boolean bl2 = false;
        NumberInfo newNumberInfo = NumberInfo.Companion.createNumberInfo$base_portable(numberInfo.getNumber() * Math.pow(d2, n2));
        int suffixIndex = 8 + suffixExp / 3;
        String exponentString = SI_SUFFIXES[suffixIndex];
        FormattedNumber formattedNumber = this.toFixedFormat(newNumberInfo, precision - newNumberInfo.getIntegerLength());
        return FormattedNumber.copy$default(formattedNumber, null, null, exponentString, 3, null);
    }

    static /* synthetic */ FormattedNumber toSiFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toSiFormat(numberInfo, n);
    }

    private final NumberInfo roundToPrecision(NumberInfo numberInfo, int precision) {
        Integer n = numberInfo.getExponent();
        int exp = n != null ? n : 0;
        int totalPrecision = precision + exp;
        long fractionalPart = 0L;
        long integerPart = 0L;
        if (totalPrecision < 0) {
            long l;
            fractionalPart = 0L;
            int n2 = totalPrecision;
            boolean bl = false;
            int intShift = Math.abs(n2);
            if (numberInfo.getIntegerLength() <= intShift) {
                l = 0L;
            } else {
                double d = 10.0;
                boolean bl2 = false;
                long l2 = numberInfo.getIntegerPart() / (long)Math.pow(d, intShift);
                d = 10.0;
                bl2 = false;
                l = l2 * (long)Math.pow(d, intShift);
            }
            integerPart = l;
        } else {
            double d = 10.0;
            boolean bl = false;
            long precisionExp = NumberInfo.Companion.getMAX_DECIMAL_VALUE$base_portable() / (long)Math.pow(d, totalPrecision);
            fractionalPart = MathKt.roundToLong((double)((double)numberInfo.getFractionalPart() / (double)precisionExp)) * precisionExp;
            integerPart = numberInfo.getIntegerPart();
            if (fractionalPart == NumberInfo.Companion.getMAX_DECIMAL_VALUE$base_portable()) {
                fractionalPart = 0L;
                ++integerPart;
            }
        }
        double num = (double)integerPart + (double)fractionalPart / (double)NumberInfo.Companion.getMAX_DECIMAL_VALUE$base_portable();
        Integer n3 = null;
        long l = integerPart;
        long l3 = fractionalPart;
        return NumberInfo.copy$default(numberInfo, num, false, l, l3, n3, 18, null);
    }

    static /* synthetic */ NumberInfo roundToPrecision$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return numberFormat.roundToPrecision(numberInfo, n);
    }

    private final Output trimFraction(Output output) {
        block3: {
            block2: {
                if (!this.spec.getTrim()) break block2;
                CharSequence charSequence = output.getBody().getFractionalPart();
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return output;
        }
        String trimmedFraction = StringsKt.trimEnd((String)output.getBody().getFractionalPart(), (char[])new char[]{'0'});
        return Output.copy$default(output, FormattedNumber.copy$default(output.getBody(), null, trimmedFraction, null, 5, null), null, null, null, null, 30, null);
    }

    private final Output computeSign(Output output, NumberInfo numberInfo) {
        boolean isNegative;
        boolean bl;
        block1: {
            FormattedNumber formattedNumber = output.getBody();
            boolean bl2 = false;
            boolean bl3 = false;
            FormattedNumber $this$run = formattedNumber;
            boolean bl4 = false;
            Sequence $this$all$iv = SequencesKt.plus((Sequence)StringsKt.asSequence((CharSequence)$this$run.getIntegerPart()), (Sequence)StringsKt.asSequence((CharSequence)$this$run.getFractionalPart()));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                char it = ((Character)element$iv).charValue();
                boolean bl5 = false;
                if (it == '0') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        boolean isBodyZero = bl;
        boolean bl6 = isNegative = numberInfo.getNegative() && !isBodyZero;
        String signStr = isNegative ? "-" : (Intrinsics.areEqual((Object)this.spec.getSign(), (Object)"-") ^ true ? this.spec.getSign() : "");
        return Output.copy$default(output, null, signStr, null, null, null, 29, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Output computePrefix(Output output) {
        block7: {
            var3_2 = this.spec.getSymbol();
            switch (var3_2.hashCode()) {
                case 35: {
                    if (!var3_2.equals("#")) ** break;
                    break;
                }
                case 36: {
                    if (!var3_2.equals("$")) ** break;
                    v0 = "$";
                    break block7;
                }
            }
            if (StringsKt.indexOf$default((CharSequence)"boxX", (String)this.spec.getType(), (int)0, (boolean)false, (int)6, null) > -1) {
                v1 = new StringBuilder().append('0');
                var4_3 = this.spec.getType();
                var5_4 = false;
                v2 = var4_3;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v3 = v2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"(this as java.lang.String).toLowerCase()");
                v0 = v1.append(v3).toString();
            } else {
                v0 = "";
            }
            break block7;
            v0 = "";
        }
        prefix = v0;
        return Output.copy$default(output, null, null, prefix, null, null, 27, null);
    }

    private final Output computeSuffix(Output res) {
        String string = PERCENT;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        String string3 = null;
        String string4 = null;
        FormattedNumber formattedNumber = null;
        Output output = res;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual((Object)this.spec.getType(), (Object)PERCENT);
        string = bl4 ? string : null;
        bl = false;
        String string5 = string;
        if (string5 == null) {
            string5 = "";
        }
        return Output.copy$default(output, formattedNumber, string4, string3, string5, null, 23, null);
    }

    private final Output computePadding(Output output) {
        int length = output.getSign().length() + output.getPrefix().length() + output.getBody().getFullLength() + output.getSuffix().length();
        String padding = length < this.spec.getWidth() ? StringsKt.repeat((CharSequence)this.spec.getFill(), (int)(this.spec.getWidth() - length)) : "";
        return Output.copy$default(output, null, null, null, null, padding, 15, null);
    }

    public NumberFormat(@NotNull Spec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
    }

    public NumberFormat(@NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this(Companion.create(spec));
    }

    static {
        Companion = new Companion(null);
        SI_SUFFIXES = new String[]{"y", "z", "a", "f", "p", "n", "\u00b5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"};
        String string = "^(?:([^{}])?([<>=^]))?([+ -])?([#$])?(0)?(\\d+)?(,)?(?:\\.(\\d+))?([%bcdefgosXx])?$";
        boolean bl = false;
        NUMBER_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\"\b\u0086\b\u0018\u00002\u00020\u0001Bc\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003Jm\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\bH\u00c6\u0001J\u0013\u0010(\u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\nH\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006,"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat$Spec;", "", "fill", "", "align", "sign", "symbol", "zero", "", "width", "", "comma", "precision", "type", "trim", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZIZILjava/lang/String;Z)V", "getAlign", "()Ljava/lang/String;", "getComma", "()Z", "getFill", "getPrecision", "()I", "getSign", "getSymbol", "getTrim", "getType", "getWidth", "getZero", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "base-portable"})
    public static final class Spec {
        @NotNull
        private final String fill;
        @NotNull
        private final String align;
        @NotNull
        private final String sign;
        @NotNull
        private final String symbol;
        private final boolean zero;
        private final int width;
        private final boolean comma;
        private final int precision;
        @NotNull
        private final String type;
        private final boolean trim;

        @NotNull
        public final String getFill() {
            return this.fill;
        }

        @NotNull
        public final String getAlign() {
            return this.align;
        }

        @NotNull
        public final String getSign() {
            return this.sign;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        public final boolean getZero() {
            return this.zero;
        }

        public final int getWidth() {
            return this.width;
        }

        public final boolean getComma() {
            return this.comma;
        }

        public final int getPrecision() {
            return this.precision;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean getTrim() {
            return this.trim;
        }

        public Spec(@NotNull String fill2, @NotNull String align, @NotNull String sign, @NotNull String symbol, boolean zero, int width2, boolean comma, int precision, @NotNull String type, boolean trim) {
            Intrinsics.checkNotNullParameter((Object)fill2, (String)"fill");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.fill = fill2;
            this.align = align;
            this.sign = sign;
            this.symbol = symbol;
            this.zero = zero;
            this.width = width2;
            this.comma = comma;
            this.precision = precision;
            this.type = type;
            this.trim = trim;
        }

        public /* synthetic */ Spec(String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5, boolean bl3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                string = " ";
            }
            if ((n3 & 2) != 0) {
                string2 = ">";
            }
            if ((n3 & 4) != 0) {
                string3 = "-";
            }
            if ((n3 & 0x20) != 0) {
                n = -1;
            }
            if ((n3 & 0x80) != 0) {
                n2 = 6;
            }
            if ((n3 & 0x100) != 0) {
                string5 = "";
            }
            if ((n3 & 0x200) != 0) {
                bl3 = false;
            }
            this(string, string2, string3, string4, bl, n, bl2, n2, string5, bl3);
        }

        @NotNull
        public final String component1() {
            return this.fill;
        }

        @NotNull
        public final String component2() {
            return this.align;
        }

        @NotNull
        public final String component3() {
            return this.sign;
        }

        @NotNull
        public final String component4() {
            return this.symbol;
        }

        public final boolean component5() {
            return this.zero;
        }

        public final int component6() {
            return this.width;
        }

        public final boolean component7() {
            return this.comma;
        }

        public final int component8() {
            return this.precision;
        }

        @NotNull
        public final String component9() {
            return this.type;
        }

        public final boolean component10() {
            return this.trim;
        }

        @NotNull
        public final Spec copy(@NotNull String fill2, @NotNull String align, @NotNull String sign, @NotNull String symbol, boolean zero, int width2, boolean comma, int precision, @NotNull String type, boolean trim) {
            Intrinsics.checkNotNullParameter((Object)fill2, (String)"fill");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Spec(fill2, align, sign, symbol, zero, width2, comma, precision, type, trim);
        }

        public static /* synthetic */ Spec copy$default(Spec spec, String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5, boolean bl3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = spec.fill;
            }
            if ((n3 & 2) != 0) {
                string2 = spec.align;
            }
            if ((n3 & 4) != 0) {
                string3 = spec.sign;
            }
            if ((n3 & 8) != 0) {
                string4 = spec.symbol;
            }
            if ((n3 & 0x10) != 0) {
                bl = spec.zero;
            }
            if ((n3 & 0x20) != 0) {
                n = spec.width;
            }
            if ((n3 & 0x40) != 0) {
                bl2 = spec.comma;
            }
            if ((n3 & 0x80) != 0) {
                n2 = spec.precision;
            }
            if ((n3 & 0x100) != 0) {
                string5 = spec.type;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = spec.trim;
            }
            return spec.copy(string, string2, string3, string4, bl, n, bl2, n2, string5, bl3);
        }

        @NotNull
        public String toString() {
            return "Spec(fill=" + this.fill + ", align=" + this.align + ", sign=" + this.sign + ", symbol=" + this.symbol + ", zero=" + this.zero + ", width=" + this.width + ", comma=" + this.comma + ", precision=" + this.precision + ", type=" + this.type + ", trim=" + this.trim + ")";
        }

        public int hashCode() {
            String string = this.fill;
            String string2 = this.align;
            String string3 = this.sign;
            String string4 = this.symbol;
            int n = ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31;
            int n2 = this.zero ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = ((n + n2) * 31 + this.width) * 31;
            int n4 = this.comma ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            String string5 = this.type;
            int n5 = (((n3 + n4) * 31 + this.precision) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31;
            int n6 = this.trim ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            return n5 + n6;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Spec)) break block3;
                    Spec spec = (Spec)object;
                    if (!Intrinsics.areEqual((Object)this.fill, (Object)spec.fill) || !Intrinsics.areEqual((Object)this.align, (Object)spec.align) || !Intrinsics.areEqual((Object)this.sign, (Object)spec.sign) || !Intrinsics.areEqual((Object)this.symbol, (Object)spec.symbol) || this.zero != spec.zero || this.width != spec.width || this.comma != spec.comma || this.precision != spec.precision || !Intrinsics.areEqual((Object)this.type, (Object)spec.type) || this.trim != spec.trim) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0018\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJB\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\bH\u00d6\u0001J\t\u0010+\u001a\u00020\u0015H\u00d6\u0001R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat$NumberInfo;", "", "number", "", "integerPart", "", "fractionalPart", "exponent", "", "(Ljava/lang/Number;JJLjava/lang/Integer;)V", "", "negative", "", "(DZJJLjava/lang/Integer;)V", "getExponent", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "fractionLeadingZeros", "getFractionLeadingZeros", "()I", "fractionString", "", "getFractionString", "()Ljava/lang/String;", "getFractionalPart", "()J", "integerLength", "getIntegerLength", "getIntegerPart", "getNegative", "()Z", "getNumber", "()D", "component1", "component2", "component3", "component4", "component5", "copy", "(DZJJLjava/lang/Integer;)Ljetbrains/datalore/base/numberFormat/NumberFormat$NumberInfo;", "equals", "other", "hashCode", "toString", "Companion", "base-portable"})
    public static final class NumberInfo {
        private final int fractionLeadingZeros;
        private final int integerLength;
        @NotNull
        private final String fractionString;
        private final double number;
        private final boolean negative;
        private final long integerPart;
        private final long fractionalPart;
        @Nullable
        private final Integer exponent;
        private static final int MAX_DECIMALS = 18;
        private static final long MAX_DECIMAL_VALUE;
        public static final Companion Companion;

        public final int getFractionLeadingZeros() {
            return this.fractionLeadingZeros;
        }

        public final int getIntegerLength() {
            return this.integerLength;
        }

        @NotNull
        public final String getFractionString() {
            return this.fractionString;
        }

        public final double getNumber() {
            return this.number;
        }

        public final boolean getNegative() {
            return this.negative;
        }

        public final long getIntegerPart() {
            return this.integerPart;
        }

        public final long getFractionalPart() {
            return this.fractionalPart;
        }

        @Nullable
        public final Integer getExponent() {
            return this.exponent;
        }

        public NumberInfo(double number, boolean negative, long integerPart, long fractionalPart, @Nullable Integer exponent) {
            this.number = number;
            this.negative = negative;
            this.integerPart = integerPart;
            this.fractionalPart = fractionalPart;
            this.exponent = exponent;
            this.fractionLeadingZeros = 18 - NumberFormatKt.length(this.fractionalPart);
            this.integerLength = NumberFormatKt.length(this.integerPart);
            this.fractionString = StringsKt.repeat((CharSequence)"0", (int)this.fractionLeadingZeros) + StringsKt.trimEnd((String)String.valueOf(this.fractionalPart), (char[])new char[]{'0'});
        }

        public /* synthetic */ NumberInfo(double d, boolean bl, long l, long l2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                d = 0.0;
            }
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                l = 0L;
            }
            if ((n2 & 8) != 0) {
                l2 = 0L;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            this(d, bl, l, l2, n);
        }

        public NumberInfo() {
            this(0.0, false, 0L, 0L, null, 31, null);
        }

        public NumberInfo(@NotNull Number number, long integerPart, long fractionalPart, @Nullable Integer exponent) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            double d = number.doubleValue();
            boolean bl = false;
            this(Math.abs(d), number.doubleValue() < 0.0, integerPart, fractionalPart, exponent);
        }

        public /* synthetic */ NumberInfo(Number number, long l, long l2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                l = 0L;
            }
            if ((n2 & 4) != 0) {
                l2 = 0L;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            this(number, l, l2, n);
        }

        static {
            Companion = new Companion(null);
            double d = 10.0;
            int n = 18;
            boolean bl = false;
            MAX_DECIMAL_VALUE = (long)Math.pow(d, n);
        }

        public final double component1() {
            return this.number;
        }

        public final boolean component2() {
            return this.negative;
        }

        public final long component3() {
            return this.integerPart;
        }

        public final long component4() {
            return this.fractionalPart;
        }

        @Nullable
        public final Integer component5() {
            return this.exponent;
        }

        @NotNull
        public final NumberInfo copy(double number, boolean negative, long integerPart, long fractionalPart, @Nullable Integer exponent) {
            return new NumberInfo(number, negative, integerPart, fractionalPart, exponent);
        }

        public static /* synthetic */ NumberInfo copy$default(NumberInfo numberInfo, double d, boolean bl, long l, long l2, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = numberInfo.number;
            }
            if ((n2 & 2) != 0) {
                bl = numberInfo.negative;
            }
            if ((n2 & 4) != 0) {
                l = numberInfo.integerPart;
            }
            if ((n2 & 8) != 0) {
                l2 = numberInfo.fractionalPart;
            }
            if ((n2 & 0x10) != 0) {
                n = numberInfo.exponent;
            }
            return numberInfo.copy(d, bl, l, l2, n);
        }

        @NotNull
        public String toString() {
            return "NumberInfo(number=" + this.number + ", negative=" + this.negative + ", integerPart=" + this.integerPart + ", fractionalPart=" + this.fractionalPart + ", exponent=" + this.exponent + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.number);
            int n = (int)(l ^ l >>> 32) * 31;
            int n2 = this.negative ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            long l2 = this.integerPart;
            long l3 = this.fractionalPart;
            Integer n3 = this.exponent;
            return (((n + n2) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (n3 != null ? ((Object)n3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NumberInfo)) break block3;
                    NumberInfo numberInfo = (NumberInfo)object;
                    if (Double.compare(this.number, numberInfo.number) != 0 || this.negative != numberInfo.negative || this.integerPart != numberInfo.integerPart || this.fractionalPart != numberInfo.fractionalPart || !Intrinsics.areEqual((Object)this.exponent, (Object)numberInfo.exponent)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat$NumberInfo$Companion;", "", "()V", "MAX_DECIMALS", "", "MAX_DECIMAL_VALUE", "", "getMAX_DECIMAL_VALUE$base_portable", "()J", "createNumberInfo", "Ljetbrains/datalore/base/numberFormat/NumberFormat$NumberInfo;", "num", "", "createNumberInfo$base_portable", "base-portable"})
        public static final class Companion {
            public final long getMAX_DECIMAL_VALUE$base_portable() {
                return MAX_DECIMAL_VALUE;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NumberInfo createNumberInfo$base_portable(@NotNull Number num) {
                void $this$run;
                void fracStr;
                void intStr;
                int exponent;
                Intrinsics.checkNotNullParameter((Object)num, (String)"num");
                Function2 encodeFraction2 = createNumberInfo.encodeFraction.1.INSTANCE;
                String string = "^(\\d+)\\.?(\\d+)?e?([+-]?\\d+)?$";
                boolean bl = false;
                Regex regex = new Regex(string);
                double d = num.doubleValue();
                boolean bl2 = false;
                String string2 = String.valueOf(Math.abs(d));
                bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string4, (int)0, (int)2, null);
                if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                    string2 = "Wrong number: " + num;
                    bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                MatchResult matchResult2 = matchResult;
                string2 = matchResult2;
                bl = false;
                String string5 = (String)string2.getMatch().getGroupValues().get(1);
                string2 = matchResult2;
                bl = false;
                String string6 = (String)string2.getMatch().getGroupValues().get(2);
                string2 = matchResult2;
                bl = false;
                String exponentString = (String)string2.getMatch().getGroupValues().get(3);
                Integer n = StringsKt.toIntOrNull((String)exponentString);
                int n2 = exponent = n != null ? n : 0;
                bl = false;
                if (Math.abs(n2) > 18) {
                    void var7_7 = intStr;
                    bl = false;
                    return new NumberInfo(num, Long.parseLong((String)var7_7), 0L, exponent);
                }
                n2 = exponent < 18 ? 1 : 0;
                bl = false;
                bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (n2 == 0) {
                    boolean bl4 = false;
                    String string7 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string7.toString());
                }
                if (exponent < 0) {
                    n2 = exponent;
                    bl = false;
                    return new NumberInfo(num, 0L, ((Number)encodeFraction2.invoke((Object)((String)intStr + (String)fracStr), (Object)(Math.abs(n2) + fracStr.length()))).longValue(), null, 10, null);
                }
                n2 = exponent >= 0 && exponent <= 18 ? 1 : 0;
                bl = false;
                bl2 = false;
                bl2 = false;
                bl3 = false;
                if (n2 == 0) {
                    boolean bl5 = false;
                    String string8 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string8.toString());
                }
                if (exponent >= fracStr.length()) {
                    String string9 = (String)intStr + (String)fracStr + StringsKt.repeat((CharSequence)"0", (int)(exponent - fracStr.length()));
                    bl = false;
                    return new NumberInfo(num, Long.parseLong(string9), 0L, null, 12, null);
                }
                n2 = exponent >= 0 && exponent < fracStr.length() ? 1 : 0;
                bl = false;
                bl2 = false;
                bl2 = false;
                bl3 = false;
                if (n2 == 0) {
                    boolean bl6 = false;
                    String string10 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string10.toString());
                }
                String string11 = (String)intStr + StringsKt.substring((String)fracStr, (IntRange)RangesKt.until((int)0, (int)exponent));
                bl = false;
                long l = Long.parseLong(string11);
                string11 = fracStr;
                bl = false;
                String string12 = string11;
                if (string12 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string13 = string12.substring(exponent);
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
                string11 = string13;
                bl = false;
                bl2 = false;
                String string14 = string11;
                long l2 = l;
                Number number = num;
                boolean bl7 = false;
                long l3 = ((Number)encodeFraction2.invoke((Object)$this$run, (Object)$this$run.length())).longValue();
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n3 = 8;
                Integer n4 = null;
                long l4 = l3;
                long l5 = l2;
                Number number2 = number;
                return new NumberInfo(number2, l5, l4, n4, n3, defaultConstructorMarker);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat$Output;", "", "body", "Ljetbrains/datalore/base/numberFormat/NumberFormat$FormattedNumber;", "sign", "", "prefix", "suffix", "padding", "(Ljetbrains/datalore/base/numberFormat/NumberFormat$FormattedNumber;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljetbrains/datalore/base/numberFormat/NumberFormat$FormattedNumber;", "getPadding", "()Ljava/lang/String;", "getPrefix", "getSign", "getSuffix", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "base-portable"})
    public static final class Output {
        @NotNull
        private final FormattedNumber body;
        @NotNull
        private final String sign;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;
        @NotNull
        private final String padding;

        @NotNull
        public final FormattedNumber getBody() {
            return this.body;
        }

        @NotNull
        public final String getSign() {
            return this.sign;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public final String getPadding() {
            return this.padding;
        }

        public Output(@NotNull FormattedNumber body, @NotNull String sign, @NotNull String prefix, @NotNull String suffix, @NotNull String padding) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            this.body = body;
            this.sign = sign;
            this.prefix = prefix;
            this.suffix = suffix;
            this.padding = padding;
        }

        public /* synthetic */ Output(FormattedNumber formattedNumber, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                formattedNumber = new FormattedNumber(null, null, null, 7, null);
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                string3 = "";
            }
            if ((n & 0x10) != 0) {
                string4 = "";
            }
            this(formattedNumber, string, string2, string3, string4);
        }

        public Output() {
            this(null, null, null, null, null, 31, null);
        }

        @NotNull
        public final FormattedNumber component1() {
            return this.body;
        }

        @NotNull
        public final String component2() {
            return this.sign;
        }

        @NotNull
        public final String component3() {
            return this.prefix;
        }

        @NotNull
        public final String component4() {
            return this.suffix;
        }

        @NotNull
        public final String component5() {
            return this.padding;
        }

        @NotNull
        public final Output copy(@NotNull FormattedNumber body, @NotNull String sign, @NotNull String prefix, @NotNull String suffix, @NotNull String padding) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            return new Output(body, sign, prefix, suffix, padding);
        }

        public static /* synthetic */ Output copy$default(Output output, FormattedNumber formattedNumber, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                formattedNumber = output.body;
            }
            if ((n & 2) != 0) {
                string = output.sign;
            }
            if ((n & 4) != 0) {
                string2 = output.prefix;
            }
            if ((n & 8) != 0) {
                string3 = output.suffix;
            }
            if ((n & 0x10) != 0) {
                string4 = output.padding;
            }
            return output.copy(formattedNumber, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Output(body=" + this.body + ", sign=" + this.sign + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", padding=" + this.padding + ")";
        }

        public int hashCode() {
            FormattedNumber formattedNumber = this.body;
            String string = this.sign;
            String string2 = this.prefix;
            String string3 = this.suffix;
            String string4 = this.padding;
            return ((((formattedNumber != null ? ((Object)formattedNumber).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Output)) break block3;
                    Output output = (Output)object;
                    if (!Intrinsics.areEqual((Object)this.body, (Object)output.body) || !Intrinsics.areEqual((Object)this.sign, (Object)output.sign) || !Intrinsics.areEqual((Object)this.prefix, (Object)output.prefix) || !Intrinsics.areEqual((Object)this.suffix, (Object)output.suffix) || !Intrinsics.areEqual((Object)this.padding, (Object)output.padding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat$FormattedNumber;", "", "integerPart", "", "fractionalPart", "exponentialPart", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExponentialPart", "()Ljava/lang/String;", "fractionalLength", "", "getFractionalLength", "()I", "getFractionalPart", "fullLength", "getFullLength", "getIntegerPart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "base-portable"})
    public static final class FormattedNumber {
        private final int fractionalLength;
        private final int fullLength;
        @NotNull
        private final String integerPart;
        @NotNull
        private final String fractionalPart;
        @NotNull
        private final String exponentialPart;

        public final int getFractionalLength() {
            return this.fractionalLength;
        }

        public final int getFullLength() {
            return this.fullLength;
        }

        @NotNull
        public String toString() {
            String string = NumberFormat.FRACTION_DELIMITER;
            boolean bl = false;
            boolean bl2 = false;
            String string2 = string;
            StringBuilder stringBuilder = new StringBuilder().append(this.integerPart);
            boolean bl3 = false;
            CharSequence charSequence = this.fractionalPart;
            boolean bl4 = false;
            boolean bl5 = charSequence.length() > 0;
            String string3 = bl5 ? string : null;
            if (string3 == null) {
                string3 = "";
            }
            return stringBuilder.append(string3).append(this.fractionalPart).append(this.exponentialPart).toString();
        }

        @NotNull
        public final String getIntegerPart() {
            return this.integerPart;
        }

        @NotNull
        public final String getFractionalPart() {
            return this.fractionalPart;
        }

        @NotNull
        public final String getExponentialPart() {
            return this.exponentialPart;
        }

        public FormattedNumber(@NotNull String integerPart, @NotNull String fractionalPart, @NotNull String exponentialPart) {
            Intrinsics.checkNotNullParameter((Object)integerPart, (String)"integerPart");
            Intrinsics.checkNotNullParameter((Object)fractionalPart, (String)"fractionalPart");
            Intrinsics.checkNotNullParameter((Object)exponentialPart, (String)"exponentialPart");
            this.integerPart = integerPart;
            this.fractionalPart = fractionalPart;
            this.exponentialPart = exponentialPart;
            Integer n = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = ((Number)n).intValue();
            FormattedNumber formattedNumber = this;
            boolean bl3 = false;
            CharSequence charSequence = this.fractionalPart;
            boolean bl4 = false;
            boolean bl5 = charSequence.length() == 0;
            Integer n3 = bl5 ? n : null;
            formattedNumber.fractionalLength = n3 != null ? n3 : 1 + this.fractionalPart.length();
            this.fullLength = this.integerPart.length() + this.fractionalLength + this.exponentialPart.length();
        }

        public /* synthetic */ FormattedNumber(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            this(string, string2, string3);
        }

        public FormattedNumber() {
            this(null, null, null, 7, null);
        }

        @NotNull
        public final String component1() {
            return this.integerPart;
        }

        @NotNull
        public final String component2() {
            return this.fractionalPart;
        }

        @NotNull
        public final String component3() {
            return this.exponentialPart;
        }

        @NotNull
        public final FormattedNumber copy(@NotNull String integerPart, @NotNull String fractionalPart, @NotNull String exponentialPart) {
            Intrinsics.checkNotNullParameter((Object)integerPart, (String)"integerPart");
            Intrinsics.checkNotNullParameter((Object)fractionalPart, (String)"fractionalPart");
            Intrinsics.checkNotNullParameter((Object)exponentialPart, (String)"exponentialPart");
            return new FormattedNumber(integerPart, fractionalPart, exponentialPart);
        }

        public static /* synthetic */ FormattedNumber copy$default(FormattedNumber formattedNumber, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = formattedNumber.integerPart;
            }
            if ((n & 2) != 0) {
                string2 = formattedNumber.fractionalPart;
            }
            if ((n & 4) != 0) {
                string3 = formattedNumber.exponentialPart;
            }
            return formattedNumber.copy(string, string2, string3);
        }

        public int hashCode() {
            String string = this.integerPart;
            String string2 = this.fractionalPart;
            String string3 = this.exponentialPart;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FormattedNumber)) break block3;
                    FormattedNumber formattedNumber = (FormattedNumber)object;
                    if (!Intrinsics.areEqual((Object)this.integerPart, (Object)formattedNumber.integerPart) || !Intrinsics.areEqual((Object)this.fractionalPart, (Object)formattedNumber.fractionalPart) || !Intrinsics.areEqual((Object)this.exponentialPart, (Object)formattedNumber.exponentialPart)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/base/numberFormat/NumberFormat$Companion;", "", "()V", "COMMA", "", "CURRENCY", "FRACTION_DELIMITER", "FRACTION_DELIMITER_LENGTH", "", "GROUP_SIZE", "NUMBER_REGEX", "Lkotlin/text/Regex;", "PERCENT", "SI_SUFFIXES", "", "[Ljava/lang/String;", "create", "Ljetbrains/datalore/base/numberFormat/NumberFormat$Spec;", "spec", "group", "str", "isValidPattern", "", "parse", "base-portable"})
    public static final class Companion {
        @NotNull
        public final Spec create(@NotNull String spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            return this.create(this.parse(spec));
        }

        @NotNull
        public final Spec create(@NotNull Spec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            int precision = spec.getPrecision();
            String type = spec.getType();
            boolean trim = false;
            if (Intrinsics.areEqual((Object)type, (Object)"")) {
                if (precision == -1) {
                    precision = 12;
                }
                type = "g";
            }
            if (Intrinsics.areEqual((Object)type, (Object)"g")) {
                trim = true;
            }
            boolean zero = spec.getZero();
            String fill2 = spec.getFill();
            String align = spec.getAlign();
            if (zero || Intrinsics.areEqual((Object)fill2, (Object)"0") && Intrinsics.areEqual((Object)align, (Object)"=")) {
                zero = true;
                fill2 = "0";
                align = "=";
            }
            boolean bl = trim;
            String string = align;
            String string2 = fill2;
            boolean bl2 = false;
            int n = 0;
            boolean bl3 = zero;
            String string3 = null;
            String string4 = null;
            int n2 = precision;
            String string5 = type;
            return Spec.copy$default(spec, string2, string, string4, string3, bl3, n, bl2, n2, string5, bl, 108, null);
        }

        public final boolean isValidPattern(@NotNull String spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            return NUMBER_REGEX.matches((CharSequence)spec);
        }

        private final Spec parse(String spec) {
            Object object;
            Object object2;
            Object object3;
            MatchResult matchResult = Regex.find$default((Regex)NUMBER_REGEX, (CharSequence)spec, (int)0, (int)2, null);
            if (matchResult == null) {
                throw (Throwable)new IllegalArgumentException("Wrong pattern format");
            }
            MatchResult matchResult2 = matchResult;
            Object object4 = matchResult2.getGroups().get(1);
            if (object4 == null || (object4 = object4.getValue()) == null) {
                object4 = " ";
            }
            if ((object3 = matchResult2.getGroups().get(2)) == null || (object3 = object3.getValue()) == null) {
                object3 = ">";
            }
            if ((object2 = matchResult2.getGroups().get(3)) == null || (object2 = object2.getValue()) == null) {
                object2 = "-";
            }
            if ((object = matchResult2.getGroups().get(4)) == null || (object = object.getValue()) == null) {
                object = "";
            }
            boolean bl = matchResult2.getGroups().get(5) != null;
            Object object5 = matchResult2.getGroups().get(6);
            if (object5 == null || (object5 = object5.getValue()) == null) {
                object5 = "-1";
            }
            Object object6 = object5;
            boolean bl2 = false;
            int n = Integer.parseInt((String)object6);
            boolean bl3 = matchResult2.getGroups().get(7) != null;
            Object object7 = matchResult2.getGroups().get(8);
            if (object7 == null || (object7 = object7.getValue()) == null) {
                object7 = "6";
            }
            object6 = object7;
            bl2 = false;
            int n2 = Integer.parseInt((String)object6);
            Object object8 = matchResult2.getGroups().get(9);
            if (object8 == null || (object8 = object8.getValue()) == null) {
                object8 = "";
            }
            return new Spec((String)object4, (String)object3, (String)object2, (String)object, bl, n, bl3, n2, (String)object8, false, 512, null);
        }

        private final String group(String str) {
            String string = str;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)StringsKt.asSequence((CharSequence)((Object)StringsKt.reversed((CharSequence)string2)).toString()), (int)3), (Function1)group.1.INSTANCE), (CharSequence)NumberFormat.COMMA, null, null, (int)0, null, null, (int)62, null);
            bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.reversed((CharSequence)string3)).toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

