/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.dateFormat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.dateFormat.DateLocale;
import jetbrains.datalore.base.dateFormat.Format$Companion$WhenMappings;
import jetbrains.datalore.base.dateFormat.Pattern;
import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.base.datetime.Time;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/base/dateFormat/Format;", "", "spec", "", "(Ljava/lang/String;)V", "", "Ljetbrains/datalore/base/dateFormat/Format$SpecPart;", "(Ljava/util/List;)V", "apply", "date", "Ljetbrains/datalore/base/datetime/Date;", "dateTime", "Ljetbrains/datalore/base/datetime/DateTime;", "time", "Ljetbrains/datalore/base/datetime/Time;", "Companion", "PatternSpecPart", "SpecPart", "base-portable"})
public final class Format {
    private final List<SpecPart> spec;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String apply(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return CollectionsKt.joinToString$default((Iterable)this.spec, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SpecPart, CharSequence>(dateTime){
            final /* synthetic */ DateTime $dateTime;

            @NotNull
            public final CharSequence invoke(@NotNull SpecPart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.exec(this.$dateTime);
            }
            {
                this.$dateTime = dateTime;
                super(1);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String apply(@NotNull Date date) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$filter$iv = this.spec;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpecPart it = (SpecPart)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof PatternSpecPart && ((PatternSpecPart)it).getPattern().getKind() == Pattern.Companion.Kind.DATE ? true : !(it instanceof PatternSpecPart))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SpecPart, CharSequence>(date){
            final /* synthetic */ Date $date;

            @NotNull
            public final CharSequence invoke(@NotNull SpecPart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.exec(new DateTime(this.$date, null, 2, null));
            }
            {
                this.$date = date;
                super(1);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String apply(@NotNull Time time2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
        Iterable $this$filter$iv = this.spec;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpecPart it = (SpecPart)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof PatternSpecPart && ((PatternSpecPart)it).getPattern().getKind() == Pattern.Companion.Kind.TIME ? true : !(it instanceof PatternSpecPart))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SpecPart, CharSequence>(time2){
            final /* synthetic */ Time $time;

            @NotNull
            public final CharSequence invoke(@NotNull SpecPart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.exec(new DateTime(Date.Companion.getEPOCH(), this.$time));
            }
            {
                this.$time = time2;
                super(1);
            }
        }), (int)30, null);
    }

    public Format(@NotNull List<? extends SpecPart> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        this.spec = spec;
    }

    public Format(@NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this(Companion.parse(spec));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/base/dateFormat/Format$SpecPart;", "", "str", "", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "exec", "dateTime", "Ljetbrains/datalore/base/datetime/DateTime;", "base-portable"})
    public static class SpecPart {
        @NotNull
        private final String str;

        @NotNull
        public String exec(@NotNull DateTime dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            return this.str;
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        public SpecPart(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.str = str;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/base/dateFormat/Format$PatternSpecPart;", "Ljetbrains/datalore/base/dateFormat/Format$SpecPart;", "str", "", "(Ljava/lang/String;)V", "pattern", "Ljetbrains/datalore/base/dateFormat/Pattern;", "getPattern", "()Ljetbrains/datalore/base/dateFormat/Pattern;", "exec", "dateTime", "Ljetbrains/datalore/base/datetime/DateTime;", "base-portable"})
    public static final class PatternSpecPart
    extends SpecPart {
        @NotNull
        private final Pattern pattern;

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public String exec(@NotNull DateTime dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            return Companion.getValueForPattern(this.pattern, dateTime);
        }

        public PatternSpecPart(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            super(str);
            Pattern pattern2 = Pattern.Companion.patternByString(str);
            if (pattern2 == null) {
                throw (Throwable)new IllegalArgumentException("Wrong pattern: " + str);
            }
            this.pattern = pattern2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0004H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/base/dateFormat/Format$Companion;", "", "()V", "getHours12", "", "dateTime", "Ljetbrains/datalore/base/datetime/DateTime;", "getHours24", "getMeridian", "", "getValueForPattern", "type", "Ljetbrains/datalore/base/dateFormat/Pattern;", "getWeekDayNumber", "leadZero", "value", "length", "parse", "", "Ljetbrains/datalore/base/dateFormat/Format$SpecPart;", "str", "base-portable"})
    public static final class Companion {
        @NotNull
        public final List<SpecPart> parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            boolean bl = false;
            List result = new ArrayList();
            Sequence resultSequence = Regex.findAll$default((Regex)Pattern.Companion.getPATTERN_REGEX(), (CharSequence)str, (int)0, (int)2, null);
            int lastIndex = 0;
            Sequence $this$forEach$iv = resultSequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult it = (MatchResult)element$iv;
                boolean bl2 = false;
                String value = it.getValue();
                IntRange range2 = it.getRange();
                int startIndex = range2.getFirst();
                int endIndex = range2.getLast();
                if (startIndex > 0) {
                    SpecPart spec = new SpecPart(StringsKt.substring((String)str, (IntRange)RangesKt.until((int)lastIndex, (int)startIndex)));
                    result.add(spec);
                }
                result.add(new PatternSpecPart(value));
                lastIndex = endIndex + 1;
            }
            if (lastIndex < str.length()) {
                String string = str;
                int n = lastIndex;
                boolean bl3 = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                result.add(new SpecPart(string2));
            }
            return result;
        }

        private final String getValueForPattern(Pattern type, DateTime dateTime) {
            String string;
            switch (Format$Companion$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    string = jetbrains.datalore.base.dateFormat.Format$Companion.leadZero$default(this, dateTime.getSeconds(), 0, 2, null);
                    break;
                }
                case 2: {
                    string = jetbrains.datalore.base.dateFormat.Format$Companion.leadZero$default(this, dateTime.getMinutes(), 0, 2, null);
                    break;
                }
                case 3: {
                    string = String.valueOf(this.getHours12(dateTime));
                    break;
                }
                case 4: {
                    string = jetbrains.datalore.base.dateFormat.Format$Companion.leadZero$default(this, this.getHours12(dateTime), 0, 2, null);
                    break;
                }
                case 5: {
                    string = jetbrains.datalore.base.dateFormat.Format$Companion.leadZero$default(this, this.getHours24(dateTime), 0, 2, null);
                    break;
                }
                case 6: {
                    string = this.getMeridian(dateTime);
                    break;
                }
                case 7: {
                    String string2 = this.getMeridian(dateTime);
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toUpperCase();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                    break;
                }
                case 8: {
                    string = this.getWeekDayNumber(dateTime);
                    break;
                }
                case 9: {
                    string = DateLocale.INSTANCE.getWeekDayAbbr().get((Object)dateTime.getWeekDay());
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 10: {
                    string = DateLocale.INSTANCE.getWeekDayFull().get((Object)dateTime.getWeekDay());
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 11: {
                    string = String.valueOf(dateTime.getDay());
                    break;
                }
                case 12: {
                    string = jetbrains.datalore.base.dateFormat.Format$Companion.leadZero$default(this, dateTime.getDay(), 0, 2, null);
                    break;
                }
                case 13: {
                    string = this.leadZero(dateTime.getDate().daysFromYearStart(), 3);
                    break;
                }
                case 14: {
                    Month month = dateTime.getMonth();
                    string = jetbrains.datalore.base.dateFormat.Format$Companion.leadZero$default(this, (month != null ? month.ordinal() : 0) + 1, 0, 2, null);
                    break;
                }
                case 15: {
                    Map<Month, String> map2 = DateLocale.INSTANCE.getMonthAbbr();
                    Month month = dateTime.getMonth();
                    boolean bl = false;
                    string = map2.get(month);
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 16: {
                    Map<Month, String> map3 = DateLocale.INSTANCE.getMonthFull();
                    Month month = dateTime.getMonth();
                    boolean bl = false;
                    string = map3.get(month);
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 17: {
                    String string5 = String.valueOf(dateTime.getYear());
                    int n = 2;
                    boolean bl = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    break;
                }
                case 18: {
                    string = String.valueOf(dateTime.getYear());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private final String leadZero(int value, int length) {
            return StringsKt.padStart((String)String.valueOf(value), (int)length, (char)'0');
        }

        static /* synthetic */ String leadZero$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 2;
            }
            return companion.leadZero(n, n2);
        }

        private final int getHours12(DateTime dateTime) {
            int hours = dateTime.getHours();
            return hours == 0 ? 12 : (hours <= 12 ? hours : hours - 12);
        }

        private final int getHours24(DateTime dateTime) {
            int n;
            switch (dateTime.getHours()) {
                case 0: {
                    n = 24;
                    break;
                }
                default: {
                    n = dateTime.getHours();
                }
            }
            return n;
        }

        private final String getMeridian(DateTime dateTime) {
            int hours = dateTime.getHours();
            return hours == 24 ? "am" : (hours <= 12 ? "am" : "pm");
        }

        private final String getWeekDayNumber(DateTime dateTime) {
            int num = dateTime.getWeekDay().ordinal() + 1;
            if (num == 7) {
                num = 0;
            }
            return String.valueOf(num);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

