/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.AbstractSerialFormat;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.CoreKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ElementValueDecoder;
import kotlinx.serialization.ElementValueEncoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.context.SerialContext;
import kotlinx.serialization.context.SerialModule;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.json.JSON$JsonInput$WhenMappings;
import kotlinx.serialization.json.JSON$JsonOutput$WhenMappings;
import kotlinx.serialization.json.JSONKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonInvalidValueInStrictModeException;
import kotlinx.serialization.json.JsonParsingException;
import kotlinx.serialization.json.JsonTreeParser;
import kotlinx.serialization.json.JsonUnknownKeyException;
import kotlinx.serialization.json.Mode;
import kotlinx.serialization.json.Parser;
import kotlinx.serialization.json.StringOpsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0004\u001e\u001f !BA\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ)\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001b2\u0006\u0010\u001c\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u000fR\u0014\u0010\b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lkotlinx/serialization/json/JSON;", "Lkotlinx/serialization/AbstractSerialFormat;", "Lkotlinx/serialization/StringFormat;", "unquoted", "", "indented", "indent", "", "strictMode", "updateMode", "Lkotlinx/serialization/UpdateMode;", "encodeDefaults", "(ZZLjava/lang/String;ZLkotlinx/serialization/UpdateMode;Z)V", "getEncodeDefaults", "()Z", "indented$1", "getStrictMode$kotlinx_serialization_runtime", "unquoted$1", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "parse", "T", "serializer", "Lkotlinx/serialization/DeserializationStrategy;", "string", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "stringify", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "Companion", "Composer", "JsonInput", "JsonOutput", "kotlinx-serialization-runtime"})
public final class JSON
extends AbstractSerialFormat
implements StringFormat {
    private final boolean unquoted$1;
    private final boolean indented$1;
    private final String indent;
    private final boolean strictMode;
    @NotNull
    private final UpdateMode updateMode;
    private final boolean encodeDefaults;
    @NotNull
    private static final JSON plain;
    @NotNull
    private static final JSON unquoted;
    @NotNull
    private static final JSON indented;
    @NotNull
    private static final JSON nonstrict;
    public static final Companion Companion;

    @Override
    @NotNull
    public <T> String stringify(@NotNull SerializationStrategy<? super T> serializer, T obj) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        StringBuilder sb = new StringBuilder();
        JsonOutput output2 = new JsonOutput(Mode.OBJ, new Composer(sb), new JsonOutput[Mode.values().length]);
        CoreKt.encode(output2, serializer, obj);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public <T> T parse(@NotNull DeserializationStrategy<T> serializer, @NotNull String string) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Parser parser = new Parser(string);
        JsonInput input = new JsonInput(Mode.OBJ, parser);
        T result = CoreKt.decode(input, serializer);
        boolean bl2 = bl = parser.getTc() == 12;
        if (!bl) {
            String string2 = "Shall parse complete string";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return result;
    }

    public final boolean getStrictMode$kotlinx_serialization_runtime() {
        return this.strictMode;
    }

    @NotNull
    public final UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public final boolean getEncodeDefaults() {
        return this.encodeDefaults;
    }

    public JSON(boolean unquoted, boolean indented, @NotNull String indent, boolean strictMode, @NotNull UpdateMode updateMode, boolean encodeDefaults) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)updateMode), (String)"updateMode");
        this.unquoted$1 = unquoted;
        this.indented$1 = indented;
        this.indent = indent;
        this.strictMode = strictMode;
        this.updateMode = updateMode;
        this.encodeDefaults = encodeDefaults;
    }

    public /* synthetic */ JSON(boolean bl, boolean bl2, String string, boolean bl3, UpdateMode updateMode, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            string = "    ";
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            updateMode = UpdateMode.OVERWRITE;
        }
        if ((n & 0x20) != 0) {
            bl4 = true;
        }
        this(bl, bl2, string, bl3, updateMode, bl4);
    }

    public JSON() {
        this(false, false, null, false, null, false, 63, null);
    }

    static {
        Companion = new Companion(null);
        plain = new JSON(false, false, null, false, null, false, 63, null);
        unquoted = new JSON(true, false, null, false, null, false, 62, null);
        indented = new JSON(false, true, null, false, null, false, 61, null);
        nonstrict = new JSON(false, false, null, false, null, false, 55, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0000R\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0011\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00120\b\"\u0006\u0012\u0002\b\u00030\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001fH\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u00101\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u000204R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0000R\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lkotlinx/serialization/json/JSON$JsonOutput;", "Lkotlinx/serialization/ElementValueEncoder;", "mode", "Lkotlinx/serialization/json/Mode;", "w", "Lkotlinx/serialization/json/JSON$Composer;", "Lkotlinx/serialization/json/JSON;", "modeReuseCache", "", "(Lkotlinx/serialization/json/JSON;Lkotlinx/serialization/json/Mode;Lkotlinx/serialization/json/JSON$Composer;[Lkotlinx/serialization/json/JSON$JsonOutput;)V", "forceQuoting", "", "[Lkotlinx/serialization/json/JSON$JsonOutput;", "beginStructure", "Lkotlinx/serialization/CompositeEncoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeEncoder;", "encodeBoolean", "", "value", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "ordinal", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "", "encodeValue", "", "endStructure", "shouldEncodeElementDefault", "writeTree", "tree", "Lkotlinx/serialization/json/JsonElement;", "kotlinx-serialization-runtime"})
    public final class JsonOutput
    extends ElementValueEncoder {
        private boolean forceQuoting;
        private final Mode mode;
        private final Composer w;
        private final JsonOutput[] modeReuseCache;

        public final void writeTree(@NotNull JsonElement tree) {
            Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
            this.w.getSb$kotlinx_serialization_runtime().append(tree.toString());
        }

        @Override
        public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            return JSON.this.getEncodeDefaults();
        }

        @Override
        @NotNull
        public CompositeEncoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Mode newMode = JSONKt.access$switchMode(desc, typeParams);
            if (newMode.getBegin() != '\u0000') {
                this.w.print(newMode.getBegin());
                this.w.indent();
            }
            if (this.mode == newMode) {
                return this;
            }
            JsonOutput cached = this.modeReuseCache[newMode.ordinal()];
            if (cached != null) {
                return cached;
            }
            return new JsonOutput(newMode, this.w, this.modeReuseCache);
        }

        @Override
        public void endStructure(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.mode.getEnd() != '\u0000') {
                this.w.unIndent();
                this.w.nextItem();
                this.w.print(this.mode.getEnd());
            }
        }

        @Override
        public boolean encodeElement(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            switch (JSON$JsonOutput$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                case 1: {
                    if (!this.w.getWritingFirst()) {
                        this.w.print(',');
                    }
                    this.w.nextItem();
                    break;
                }
                case 2: {
                    if (!this.w.getWritingFirst()) {
                        if (index % 2 == 0) {
                            this.w.print(',');
                        } else {
                            this.w.print(':');
                        }
                    }
                    this.w.nextItem();
                    break;
                }
                case 3: {
                    throw (Throwable)new IllegalStateException("Entry is deprecated");
                }
                case 4: {
                    if (index == 0) {
                        this.forceQuoting = true;
                    }
                    if (index != 1) break;
                    this.w.print(this.mode == Mode.ENTRY ? (char)':' : ',');
                    this.w.space();
                    this.forceQuoting = false;
                    break;
                }
                default: {
                    if (!this.w.getWritingFirst()) {
                        this.w.print(',');
                    }
                    this.w.nextItem();
                    this.encodeString(desc.getElementName(index));
                    this.w.print(':');
                    this.w.space();
                }
            }
            return true;
        }

        @Override
        public void encodeNull() {
            this.w.print("null");
        }

        @Override
        public void encodeBoolean(boolean value) {
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeByte(byte value) {
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeShort(short value) {
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeInt(int value) {
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeLong(long value) {
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeFloat(float value) {
            float f;
            float f2;
            if (JSON.this.getStrictMode$kotlinx_serialization_runtime() && !(!Float.isInfinite(f2 = (f = value)) && !Float.isNaN(f2 = f))) {
                throw (Throwable)new JsonInvalidValueInStrictModeException(value);
            }
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeDouble(double value) {
            double d;
            double d2;
            if (JSON.this.getStrictMode$kotlinx_serialization_runtime() && !(!Double.isInfinite(d2 = (d = value)) && !Double.isNaN(d2 = d))) {
                throw (Throwable)new JsonInvalidValueInStrictModeException(value);
            }
            if (this.forceQuoting) {
                this.encodeString(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void encodeChar(char value) {
            this.encodeString(String.valueOf(value));
        }

        @Override
        public void encodeString(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (JSON.this.unquoted$1 && !JSONKt.access$mustBeQuoted(value)) {
                this.w.print(value);
            } else {
                this.w.printQuoted(value);
            }
        }

        @Override
        public void encodeEnum(@NotNull EnumDescriptor enumDescription, int ordinal) {
            Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
            this.encodeString(enumDescription.getElementName(ordinal));
        }

        @Override
        public void encodeValue(@NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (JSON.this.getStrictMode$kotlinx_serialization_runtime()) {
                super.encodeValue(value);
            } else {
                this.encodeString(value.toString());
            }
        }

        public JsonOutput(@NotNull Mode mode, @NotNull Composer w, JsonOutput[] modeReuseCache) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
            Intrinsics.checkParameterIsNotNull((Object)modeReuseCache, (String)"modeReuseCache");
            this.mode = mode;
            this.w = w;
            this.modeReuseCache = modeReuseCache;
            this.setContext(JSON.this.getContext());
            int i = this.mode.ordinal();
            if (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this) {
                this.modeReuseCache[i] = this;
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\u0010\f\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0018J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0019J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001aJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001bJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001cJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lkotlinx/serialization/json/JSON$Composer;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lkotlinx/serialization/json/JSON;Ljava/lang/StringBuilder;)V", "level", "", "getSb$kotlinx_serialization_runtime", "()Ljava/lang/StringBuilder;", "<set-?>", "", "writingFirst", "getWritingFirst", "()Z", "setWritingFirst", "(Z)V", "indent", "", "nextItem", "print", "kotlin.jvm.PlatformType", "v", "", "", "", "", "", "", "", "printQuoted", "value", "space", "unIndent", "kotlinx-serialization-runtime"})
    public final class Composer {
        private int level;
        private boolean writingFirst;
        @NotNull
        private final StringBuilder sb;

        public final boolean getWritingFirst() {
            return this.writingFirst;
        }

        private final void setWritingFirst(boolean bl) {
            this.writingFirst = bl;
        }

        public final void indent() {
            this.writingFirst = true;
            int n = this.level;
            this.level = n + 1;
        }

        public final void unIndent() {
            int n = this.level;
            this.level = n + -1;
        }

        public final void nextItem() {
            this.writingFirst = false;
            if (JSON.this.indented$1) {
                this.print("\n");
                int n = this.level;
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    this.print(JSON.this.indent);
                }
            }
        }

        public final void space() {
            if (JSON.this.indented$1) {
                this.print(' ');
            }
        }

        public final StringBuilder print(char v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(@NotNull String v) {
            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
            return this.sb.append(v);
        }

        public final StringBuilder print(float v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(double v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(byte v) {
            return this.sb.append((Object)v);
        }

        public final StringBuilder print(short v) {
            return this.sb.append((Object)v);
        }

        public final StringBuilder print(int v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(long v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(boolean v) {
            return this.sb.append(v);
        }

        public final void printQuoted(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            StringOpsKt.printQuoted(this.sb, value);
        }

        @NotNull
        public final StringBuilder getSb$kotlinx_serialization_runtime() {
            return this.sb;
        }

        public Composer(StringBuilder sb) {
            Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
            this.sb = sb;
            this.writingFirst = true;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\"\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u00100\u001a\u000201R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00062"}, d2={"Lkotlinx/serialization/json/JSON$JsonInput;", "Lkotlinx/serialization/ElementValueDecoder;", "mode", "Lkotlinx/serialization/json/Mode;", "p", "Lkotlinx/serialization/json/Parser;", "(Lkotlinx/serialization/json/JSON;Lkotlinx/serialization/json/Mode;Lkotlinx/serialization/json/Parser;)V", "curIndex", "", "entryIndex", "updateMode", "Lkotlinx/serialization/UpdateMode;", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "beginStructure", "Lkotlinx/serialization/CompositeDecoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeDecoder;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "", "endStructure", "", "readAsTree", "Lkotlinx/serialization/json/JsonElement;", "kotlinx-serialization-runtime"})
    public final class JsonInput
    extends ElementValueDecoder {
        private int curIndex;
        private int entryIndex;
        private final Mode mode;
        private final Parser p;

        @NotNull
        public final JsonElement readAsTree() {
            return new JsonTreeParser(this.p).read();
        }

        @Override
        @NotNull
        public UpdateMode getUpdateMode() {
            return JSON.this.getUpdateMode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Mode newMode = JSONKt.access$switchMode(desc, typeParams);
            if (newMode.getBegin() != '\u0000') {
                void this_$iv;
                Parser parser = this.p;
                byte expected$iv = newMode.getBeginTc();
                if (this_$iv.getTc() != expected$iv) {
                    void pos$iv$iv;
                    int n = this_$iv.getTokenPos();
                    String msg$iv$iv = "Expected '" + newMode.getBegin() + ", kind: " + desc.getKind() + '\'';
                    throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
                }
                this.p.nextToken();
            }
            switch (JSON$JsonInput$WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    compositeDecoder = new JsonInput(newMode, this.p);
                    break;
                }
                default: {
                    compositeDecoder = this.mode == newMode ? this : new JsonInput(newMode, this.p);
                }
            }
            return compositeDecoder;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endStructure(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.mode.getEnd() != '\u0000') {
                void this_$iv;
                Parser parser = this.p;
                byte expected$iv = this.mode.getEndTc();
                if (this_$iv.getTc() != expected$iv) {
                    void pos$iv$iv;
                    int n = this_$iv.getTokenPos();
                    String msg$iv$iv = "Expected '" + this.mode.getEnd() + '\'';
                    throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
                }
                this.p.nextToken();
            }
        }

        @Override
        public boolean decodeNotNullMark() {
            return this.p.getTc() != 10;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Void decodeNull() {
            void this_$iv;
            Parser parser = this.p;
            byte expected$iv = 10;
            if (this_$iv.getTc() != expected$iv) {
                void pos$iv$iv;
                int n = this_$iv.getTokenPos();
                String msg$iv$iv = "Expected 'null' literal";
                throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
            }
            this.p.nextToken();
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            while (true) {
                void this_$iv;
                if (this.p.getTc() == 4) {
                    this.p.nextToken();
                }
                switch (JSON$JsonInput$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
                    case 1: {
                        int n;
                        if (!this.p.getCanBeginValue()) {
                            n = -1;
                        } else {
                            JsonInput jsonInput = this;
                            n = ++jsonInput.curIndex;
                        }
                        return n;
                    }
                    case 2: {
                        int n;
                        if (this.curIndex % 2 == 0 && this.p.getTc() == 5) {
                            this.p.nextToken();
                        }
                        if (!this.p.getCanBeginValue()) {
                            n = -1;
                        } else {
                            JsonInput jsonInput = this;
                            n = ++jsonInput.curIndex;
                        }
                        return n;
                    }
                    case 3: {
                        int n;
                        int n2 = this.entryIndex;
                        this.entryIndex = n2 + 1;
                        switch (n2) {
                            case 0: {
                                n = 0;
                                break;
                            }
                            case 1: {
                                n = 1;
                                break;
                            }
                            default: {
                                this.entryIndex = 0;
                                n = -1;
                            }
                        }
                        return n;
                    }
                    case 4: {
                        int n;
                        int n3 = this.entryIndex;
                        this.entryIndex = n3 + 1;
                        switch (n3) {
                            case 0: {
                                n = 0;
                                break;
                            }
                            case 1: {
                                void this_$iv2;
                                Parser parser = this.p;
                                byte expected$iv = 5;
                                if (this_$iv2.getTc() != expected$iv) {
                                    void pos$iv$iv;
                                    int n4 = this_$iv2.getTokenPos();
                                    String msg$iv$iv = "Expected ':'";
                                    throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
                                }
                                this.p.nextToken();
                                n = 1;
                                break;
                            }
                            default: {
                                this.entryIndex = 0;
                                n = -1;
                            }
                        }
                        return n;
                    }
                }
                if (!this.p.getCanBeginValue()) {
                    return -1;
                }
                String key = this.p.takeStr();
                Parser expected$iv = this.p;
                byte expected$iv2 = 5;
                if (this_$iv.getTc() != expected$iv2) {
                    void pos$iv$iv;
                    int $i$a$1$requireTc = this_$iv.getTokenPos();
                    String msg$iv$iv = "Expected ':'";
                    throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
                }
                this.p.nextToken();
                int ind = desc.getElementIndex(key);
                if (ind != -3) {
                    return ind;
                }
                if (JSON.this.getStrictMode$kotlinx_serialization_runtime()) {
                    throw (Throwable)new JsonUnknownKeyException(key);
                }
                this.p.skipElement();
            }
        }

        @Override
        public boolean decodeBoolean() {
            boolean bl;
            String string;
            String $receiver = string = this.p.takeStr();
            if (JSON.this.getStrictMode$kotlinx_serialization_runtime()) {
                bl = StringOpsKt.toBooleanStrict($receiver);
            } else {
                String string2 = $receiver;
                bl = Boolean.parseBoolean(string2);
            }
            return bl;
        }

        @Override
        public byte decodeByte() {
            String string = this.p.takeStr();
            return Byte.parseByte(string);
        }

        @Override
        public short decodeShort() {
            String string = this.p.takeStr();
            return Short.parseShort(string);
        }

        @Override
        public int decodeInt() {
            String string = this.p.takeStr();
            return Integer.parseInt(string);
        }

        @Override
        public long decodeLong() {
            String string = this.p.takeStr();
            return Long.parseLong(string);
        }

        @Override
        public float decodeFloat() {
            String string = this.p.takeStr();
            return Float.parseFloat(string);
        }

        @Override
        public double decodeDouble() {
            String string = this.p.takeStr();
            return Double.parseDouble(string);
        }

        @Override
        public char decodeChar() {
            return StringsKt.single((CharSequence)this.p.takeStr());
        }

        @Override
        @NotNull
        public String decodeString() {
            return this.p.takeStr();
        }

        @Override
        public int decodeEnum(@NotNull EnumDescriptor enumDescription) {
            Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
            return enumDescription.getElementIndex(this.p.takeStr());
        }

        public JsonInput(@NotNull Mode mode, Parser p) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
            this.mode = mode;
            this.p = p;
            this.curIndex = -1;
            this.setContext(JSON.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001d2\u0006\u0010\u001e\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/JSON$Companion;", "Lkotlinx/serialization/StringFormat;", "()V", "context", "Lkotlinx/serialization/context/SerialContext;", "getContext", "()Lkotlinx/serialization/context/SerialContext;", "indented", "Lkotlinx/serialization/json/JSON;", "getIndented", "()Lkotlinx/serialization/json/JSON;", "nonstrict", "getNonstrict", "plain", "getPlain", "unquoted", "getUnquoted", "install", "", "module", "Lkotlinx/serialization/context/SerialModule;", "parse", "T", "serializer", "Lkotlinx/serialization/DeserializationStrategy;", "string", "", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "stringify", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "kotlinx-serialization-runtime"})
    public static final class Companion
    implements StringFormat {
        @NotNull
        public final JSON getPlain() {
            return plain;
        }

        @NotNull
        public final JSON getUnquoted() {
            return unquoted;
        }

        @NotNull
        public final JSON getIndented() {
            return indented;
        }

        @NotNull
        public final JSON getNonstrict() {
            return nonstrict;
        }

        @Override
        public void install(@NotNull SerialModule module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.getPlain().install(module);
        }

        @Override
        @NotNull
        public SerialContext getContext() {
            return Companion.getPlain().getContext();
        }

        @Override
        @NotNull
        public <T> String stringify(@NotNull SerializationStrategy<? super T> serializer, T obj) {
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            return this.getPlain().stringify(serializer, obj);
        }

        @Override
        public <T> T parse(@NotNull DeserializationStrategy<T> serializer, @NotNull String string) {
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            return this.getPlain().parse(serializer, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

