/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003:\u0001\u0017B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkotlinx/serialization/internal/NullableSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "element", "(Lkotlinx/serialization/KSerializer;)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "input", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/lang/Object;", "patch", "old", "(Lkotlinx/serialization/Decoder;Ljava/lang/Object;)Ljava/lang/Object;", "serialize", "", "output", "Lkotlinx/serialization/Encoder;", "obj", "(Lkotlinx/serialization/Encoder;Ljava/lang/Object;)V", "SerialDescriptorForNullable", "kotlinx-serialization-runtime"})
public final class NullableSerializer<T>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final KSerializer<T> element;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder output2, @Nullable T obj) {
        Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
        if (obj != null) {
            output2.encodeNotNullMark();
            this.element.serialize(output2, obj);
        } else {
            output2.encodeNull();
        }
    }

    @Override
    @Nullable
    public T deserialize(@NotNull Decoder input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return (T)(input.decodeNotNullMark() ? this.element.deserialize(input) : input.decodeNull());
    }

    @Override
    @Nullable
    public T patch(@NotNull Decoder input, @Nullable T old) {
        T t;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (old == null) {
            t = this.deserialize(input);
        } else if (input.decodeNotNullMark()) {
            t = this.element.patch(input, old);
        } else {
            Void void_;
            Void it = void_ = input.decodeNull();
            t = old;
        }
        return t;
    }

    public NullableSerializer(@NotNull KSerializer<T> element) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        this.element = element;
        this.descriptor = new SerialDescriptorForNullable(this.element.getDescriptor());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0005H\u0096\u0001J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0096\u0001J\b\u0010 \u001a\u00020\u0005H\u0016J\u0011\u0010!\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0005H\u0096\u0001R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lkotlinx/serialization/internal/NullableSerializer$SerialDescriptorForNullable;", "Lkotlinx/serialization/SerialDescriptor;", "original", "(Lkotlinx/serialization/SerialDescriptor;)V", "elementsCount", "", "getElementsCount", "()I", "isNullable", "", "()Z", "kind", "Lkotlinx/serialization/SerialKind;", "getKind", "()Lkotlinx/serialization/SerialKind;", "name", "", "getName", "()Ljava/lang/String;", "getOriginal", "()Lkotlinx/serialization/SerialDescriptor;", "equals", "other", "", "getElementAnnotations", "", "", "index", "getElementDescriptor", "getElementIndex", "getElementName", "getEntityAnnotations", "hashCode", "isElementOptional", "kotlinx-serialization-runtime"})
    private static final class SerialDescriptorForNullable
    implements SerialDescriptor {
        @NotNull
        private final SerialDescriptor original;

        @Override
        public boolean isNullable() {
            return true;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerialDescriptorForNullable)) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.original, (Object)((SerialDescriptorForNullable)other).original) ^ true);
        }

        public int hashCode() {
            return this.original.hashCode() * 31;
        }

        @NotNull
        public final SerialDescriptor getOriginal() {
            return this.original;
        }

        public SerialDescriptorForNullable(@NotNull SerialDescriptor original) {
            Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
            this.original = original;
        }

        @Override
        public int getElementsCount() {
            return this.original.getElementsCount();
        }

        @Override
        @NotNull
        public SerialKind getKind() {
            return this.original.getKind();
        }

        @Override
        @NotNull
        public String getName() {
            return this.original.getName();
        }

        @Override
        @NotNull
        public List<Annotation> getElementAnnotations(int index) {
            return this.original.getElementAnnotations(index);
        }

        @Override
        @NotNull
        public SerialDescriptor getElementDescriptor(int index) {
            return this.original.getElementDescriptor(index);
        }

        @Override
        public int getElementIndex(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.original.getElementIndex(name);
        }

        @Override
        @NotNull
        public String getElementName(int index) {
            return this.original.getElementName(index);
        }

        @Override
        @NotNull
        public List<Annotation> getEntityAnnotations() {
            return this.original.getEntityAnnotations();
        }

        @Override
        public boolean isElementOptional(int index) {
            return this.original.isElementOptional(index);
        }
    }
}

