/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.AbstractSerialFormat;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.CoreKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ImplicitReflectionSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.NamedValueDecoder;
import kotlinx.serialization.NamedValueEncoder;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StructureKind;
import kotlinx.serialization.context.ContextKt;
import kotlinx.serialization.context.SerialContext;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementTypeMismatchException;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\b\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0002H\u0004\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087\b\u00a2\u0006\u0002\u0010\bJ'\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\t\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000b\u00a2\u0006\u0002\u0010\fJ'\u0010\r\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00042\u0006\u0010\t\u001a\u0002H\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000f\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper;", "Lkotlinx/serialization/AbstractSerialFormat;", "()V", "readTree", "T", "", "tree", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Object;", "obj", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonElement;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "writeTree", "saver", "Lkotlinx/serialization/SerializationStrategy;", "(Ljava/lang/Object;Lkotlinx/serialization/SerializationStrategy;)Lkotlinx/serialization/json/JsonElement;", "AbstractJsonTreeInput", "AbstractJsonTreeOutput", "JsonTreeInput", "JsonTreeListInput", "JsonTreeListOutput", "JsonTreeMapInput", "JsonTreeMapOutput", "JsonTreeOutput", "kotlinx-serialization-runtime"})
public final class JsonTreeMapper
extends AbstractSerialFormat {
    @ImplicitReflectionSerializer
    private final <T> T readTree(JsonElement tree) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.readTree(tree, ContextKt.getOrDefault(serialContext, Reflection.getOrCreateKotlinClass(Object.class)));
    }

    public final <T> T readTree(@NotNull JsonElement obj, @NotNull DeserializationStrategy<T> loader) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        if (!(obj instanceof JsonObject)) {
            throw (Throwable)new SerializationException("Can't deserialize primitive on root level", null, 2, null);
        }
        return CoreKt.decode(new JsonTreeInput((JsonObject)obj), loader);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> JsonElement writeTree(T obj, @NotNull SerializationStrategy<? super T> saver) {
        void result;
        Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        JsonTreeOutput output2 = new JsonTreeOutput((Function1<? super JsonElement, Unit>)((Function1)new Function1<JsonElement, Unit>((Ref.ObjectRef)result){
            final /* synthetic */ Ref.ObjectRef $result;

            public final void invoke(@NotNull JsonElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$result.element = it;
            }
            {
                this.$result = objectRef;
                super(1);
            }
        }));
        CoreKt.encode(output2, saver, obj);
        Object object = result.element;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
        }
        return (JsonElement)object;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J1\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\"\u0006\u0012\u0002\b\u00030\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020#H\u0016J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\u0004H&J\u0018\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0004H&R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00064"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/NamedValueEncoder;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "getNodeConsumer", "()Lkotlin/jvm/functions/Function1;", "beginStructure", "Lkotlinx/serialization/CompositeEncoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeEncoder;", "composeName", "", "parentName", "childName", "encodeTaggedBoolean", "tag", "value", "", "encodeTaggedByte", "", "encodeTaggedChar", "", "encodeTaggedDouble", "", "encodeTaggedEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "ordinal", "", "encodeTaggedFloat", "", "encodeTaggedInt", "encodeTaggedLong", "", "encodeTaggedNull", "encodeTaggedShort", "", "encodeTaggedString", "encodeTaggedValue", "", "endEncode", "getCurrent", "putElement", "key", "element", "kotlinx-serialization-runtime"})
    private abstract class AbstractJsonTreeOutput
    extends NamedValueEncoder {
        @NotNull
        private final Function1<JsonElement, Unit> nodeConsumer;

        @Override
        @NotNull
        public String composeName(@NotNull String parentName, @NotNull String childName) {
            Intrinsics.checkParameterIsNotNull((Object)parentName, (String)"parentName");
            Intrinsics.checkParameterIsNotNull((Object)childName, (String)"childName");
            return childName;
        }

        public abstract void putElement(@NotNull String var1, @NotNull JsonElement var2);

        @NotNull
        public abstract JsonElement getCurrent();

        @Override
        public void encodeTaggedNull(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, JsonNull.INSTANCE);
        }

        @Override
        public void encodeTaggedInt(@NotNull String tag, int value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedByte(@NotNull String tag, byte value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedShort(@NotNull String tag, short value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedLong(@NotNull String tag, long value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedFloat(@NotNull String tag, float value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(Float.valueOf(value)));
        }

        @Override
        public void encodeTaggedDouble(@NotNull String tag, double value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedBoolean(@NotNull String tag, boolean value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedChar(@NotNull String tag, char value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(String.valueOf(value)));
        }

        @Override
        public void encodeTaggedString(@NotNull String tag, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void encodeTaggedEnum(@NotNull String tag, @NotNull EnumDescriptor enumDescription, int ordinal) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
            this.putElement(tag, new JsonLiteral(enumDescription.getElementName(ordinal)));
        }

        @Override
        public void encodeTaggedValue(@NotNull String tag, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.putElement(tag, new JsonLiteral(value.toString()));
        }

        @Override
        @NotNull
        public CompositeEncoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Function1 consumer2 = this.getCurrentTagOrNull() == null ? this.nodeConsumer : (Function1)new Function1<JsonElement, Unit>(this){
                final /* synthetic */ AbstractJsonTreeOutput this$0;

                public final void invoke(@NotNull JsonElement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    this.this$0.putElement(AbstractJsonTreeOutput.access$getCurrentTag$p(this.this$0), node);
                }
                {
                    this.this$0 = abstractJsonTreeOutput;
                    super(1);
                }
            };
            SerialKind serialKind = desc.getKind();
            return Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) ? (CompositeEncoder)new JsonTreeListOutput((Function1<? super JsonElement, Unit>)consumer2) : (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? (CompositeEncoder)new JsonTreeMapOutput((Function1<? super JsonElement, Unit>)consumer2) : (CompositeEncoder)new JsonTreeOutput((Function1<? super JsonElement, Unit>)consumer2));
        }

        @Override
        public void endEncode(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            this.nodeConsumer.invoke((Object)this.getCurrent());
        }

        @NotNull
        public final Function1<JsonElement, Unit> getNodeConsumer() {
            return this.nodeConsumer;
        }

        public AbstractJsonTreeOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(null, 1, null);
            this.nodeConsumer = nodeConsumer;
            this.setContext(JsonTreeMapper.this.getContext());
        }

        @NotNull
        public static final /* synthetic */ String access$getCurrentTag$p(AbstractJsonTreeOutput $this) {
            return (String)$this.getCurrentTag();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "map", "", "", "getCurrent", "putElement", "key", "element", "kotlinx-serialization-runtime"})
    private class JsonTreeOutput
    extends AbstractJsonTreeOutput {
        private final Map<String, JsonElement> map;

        @Override
        public void putElement(@NotNull String key, @NotNull JsonElement element) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Map<String, JsonElement> map = this.map;
            JsonElement jsonElement = element;
            map.put(key, jsonElement);
        }

        @Override
        @NotNull
        public JsonElement getCurrent() {
            return new JsonObject(this.map);
        }

        public JsonTreeOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(nodeConsumer);
            JsonTreeOutput jsonTreeOutput = this;
            HashMap hashMap = new HashMap();
            jsonTreeOutput.map = hashMap;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeMapOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "mapBuilder", "", "", "tag", "getCurrent", "putElement", "key", "element", "shouldWriteElement", "", "desc", "Lkotlinx/serialization/SerialDescriptor;", "index", "", "kotlinx-serialization-runtime"})
    private final class JsonTreeMapOutput
    extends JsonTreeOutput {
        private final Map<String, JsonElement> mapBuilder;
        private String tag;

        @Override
        public void putElement(@NotNull String key, @NotNull JsonElement element) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Object object = key;
            int idx = Integer.parseInt((String)object);
            if (idx % 2 == 0) {
                boolean bl = element instanceof JsonLiteral;
                if (!bl) {
                    String string = "Expected tag to be JsonLiteral";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.tag = ((JsonLiteral)element).getContent();
            } else {
                object = this.mapBuilder;
                String string = this.tag;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tag");
                }
                String string2 = string;
                JsonElement jsonElement = element;
                object.put(string2, jsonElement);
            }
        }

        @Override
        @NotNull
        public JsonElement getCurrent() {
            return new JsonObject(this.mapBuilder);
        }

        @Override
        public boolean shouldWriteElement(@NotNull SerialDescriptor desc, @NotNull String tag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return true;
        }

        public JsonTreeMapOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(nodeConsumer);
            JsonTreeMapOutput jsonTreeMapOutput = this;
            HashMap hashMap = new HashMap();
            jsonTreeMapOutput.mapBuilder = hashMap;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeListOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "array", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getCurrent", "putElement", "key", "", "element", "shouldWriteElement", "", "desc", "Lkotlinx/serialization/SerialDescriptor;", "tag", "index", "", "kotlinx-serialization-runtime"})
    private final class JsonTreeListOutput
    extends AbstractJsonTreeOutput {
        private final ArrayList<JsonElement> array;

        @Override
        public boolean shouldWriteElement(@NotNull SerialDescriptor desc, @NotNull String tag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return true;
        }

        @Override
        public void putElement(@NotNull String key, @NotNull JsonElement element) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            String string = key;
            int idx = Integer.parseInt(string);
            this.array.add(idx, element);
        }

        @Override
        @NotNull
        public JsonElement getCurrent() {
            return new JsonArray((List<? extends JsonElement>)this.array);
        }

        public JsonTreeListOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(nodeConsumer);
            JsonTreeListOutput jsonTreeListOutput = this;
            ArrayList arrayList = new ArrayList();
            jsonTreeListOutput.array = arrayList;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u001a\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\r0\f\"\u0006\u0012\u0002\b\u00030\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u000f\u001a\u0002H\u0010\"\n\b\u0000\u0010\u0010\u0018\u0001*\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0013H$J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u0013H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00063"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/NamedValueDecoder;", "obj", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonElement;)V", "getObj", "()Lkotlinx/serialization/json/JsonElement;", "beginStructure", "Lkotlinx/serialization/CompositeDecoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeDecoder;", "checkCast", "T", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonElement;", "composeName", "", "parentName", "childName", "currentElement", "tag", "decodeTaggedBoolean", "", "decodeTaggedByte", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "", "decodeTaggedNotNullMark", "decodeTaggedNull", "", "decodeTaggedShort", "", "decodeTaggedString", "decodeTaggedUnit", "", "getValue", "Lkotlinx/serialization/json/JsonPrimitive;", "kotlinx-serialization-runtime"})
    private abstract class AbstractJsonTreeInput
    extends NamedValueDecoder {
        @NotNull
        private final JsonElement obj;

        @Override
        @NotNull
        public String composeName(@NotNull String parentName, @NotNull String childName) {
            Intrinsics.checkParameterIsNotNull((Object)parentName, (String)"parentName");
            Intrinsics.checkParameterIsNotNull((Object)childName, (String)"childName");
            return childName;
        }

        private final <T extends JsonElement> T checkCast(JsonElement obj) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            boolean bl = obj instanceof JsonElement;
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder().append("Expected ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(JsonElement.class)).append(" but found ").append(Reflection.getOrCreateKotlinClass(obj.getClass())).toString();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)obj;
        }

        @Override
        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
            AbstractJsonTreeInput this_$iv;
            CompositeDecoder compositeDecoder;
            Object object;
            Object it;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Object object2 = (String)this.getCurrentTagOrNull();
            if (object2 == null || (object2 = this.currentElement((String)(it = (object = object2)))) == null) {
                object2 = this.getObj();
            }
            Object curObj = object2;
            object = desc.getKind();
            if (Intrinsics.areEqual((Object)object, (Object)StructureKind.LIST.INSTANCE)) {
                JsonArray jsonArray;
                it = this;
                JsonTreeMapper jsonTreeMapper = JsonTreeMapper.this;
                boolean bl = curObj instanceof JsonArray;
                if (!bl) {
                    String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonArray.class) + " but found " + Reflection.getOrCreateKotlinClass(curObj.getClass());
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object object3 = curObj;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonArray");
                }
                JsonArray jsonArray2 = jsonArray = (JsonArray)object3;
                JsonTreeMapper jsonTreeMapper2 = jsonTreeMapper;
                compositeDecoder = jsonTreeMapper2.new JsonTreeListInput(jsonArray2);
            } else if (Intrinsics.areEqual((Object)object, (Object)StructureKind.MAP.INSTANCE)) {
                JsonObject jsonObject;
                this_$iv = this;
                JsonTreeMapper jsonTreeMapper = JsonTreeMapper.this;
                boolean bl = curObj instanceof JsonObject;
                if (!bl) {
                    String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " but found " + Reflection.getOrCreateKotlinClass(curObj.getClass());
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object object4 = curObj;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                }
                JsonObject jsonObject2 = jsonObject = (JsonObject)object4;
                JsonTreeMapper jsonTreeMapper3 = jsonTreeMapper;
                compositeDecoder = jsonTreeMapper3.new JsonTreeMapInput(jsonObject2);
            } else {
                JsonObject jsonObject;
                this_$iv = this;
                JsonTreeMapper jsonTreeMapper = JsonTreeMapper.this;
                boolean bl = curObj instanceof JsonObject;
                if (!bl) {
                    String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " but found " + Reflection.getOrCreateKotlinClass(curObj.getClass());
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object object5 = curObj;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                }
                JsonObject jsonObject3 = jsonObject = (JsonObject)object5;
                JsonTreeMapper jsonTreeMapper4 = jsonTreeMapper;
                compositeDecoder = jsonTreeMapper4.new JsonTreeInput(jsonObject3);
            }
            return compositeDecoder;
        }

        @NotNull
        protected JsonPrimitive getValue(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            JsonElement currentElement = this.currentElement(tag);
            JsonElement jsonElement = currentElement;
            if (!(jsonElement instanceof JsonPrimitive)) {
                jsonElement = null;
            }
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive == null) {
                throw (Throwable)new JsonElementTypeMismatchException(currentElement + " at " + tag, "JsonPrimitive");
            }
            return jsonPrimitive;
        }

        @NotNull
        protected abstract JsonElement currentElement(@NotNull String var1);

        @Override
        public char decodeTaggedChar(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            JsonPrimitive o = this.getValue(tag);
            if (o.getContent().length() != 1) {
                throw (Throwable)new SerializationException(o + " can't be represented as Char", null, 2, null);
            }
            return o.getContent().charAt(0);
        }

        @Override
        public int decodeTaggedEnum(@NotNull String tag, @NotNull EnumDescriptor enumDescription) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
            return enumDescription.getElementIndex(this.getValue(tag).getContent());
        }

        @Override
        @Nullable
        public Void decodeTaggedNull(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return null;
        }

        @Override
        public boolean decodeTaggedNotNullMark(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.currentElement(tag) != JsonNull.INSTANCE;
        }

        @Override
        public void decodeTaggedUnit(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        }

        @Override
        public boolean decodeTaggedBoolean(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getBoolean();
        }

        @Override
        public byte decodeTaggedByte(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return (byte)this.getValue(tag).getInt();
        }

        @Override
        public short decodeTaggedShort(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return (short)this.getValue(tag).getInt();
        }

        @Override
        public int decodeTaggedInt(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getInt();
        }

        @Override
        public long decodeTaggedLong(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getLong();
        }

        @Override
        public float decodeTaggedFloat(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getFloat();
        }

        @Override
        public double decodeTaggedDouble(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getDouble();
        }

        @Override
        @NotNull
        public String decodeTaggedString(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getContent();
        }

        @NotNull
        public JsonElement getObj() {
            return this.obj;
        }

        public AbstractJsonTreeInput(JsonElement obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(null, 1, null);
            this.obj = obj;
            this.setContext(JsonTreeMapper.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonObject;)V", "getObj", "()Lkotlinx/serialization/json/JsonObject;", "pos", "", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "", "decodeElementIndex", "desc", "Lkotlinx/serialization/SerialDescriptor;", "kotlinx-serialization-runtime"})
    private class JsonTreeInput
    extends AbstractJsonTreeInput {
        private int pos;
        @NotNull
        private final JsonObject obj;

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            while (this.pos < desc.getElementsCount()) {
                int n = this.pos;
                this.pos = n + 1;
                String name = this.getTag(desc, n);
                Map map = this.getObj();
                Map map2 = map;
                if (!map2.containsKey(name)) continue;
                return this.pos - 1;
            }
            return -1;
        }

        @Override
        @NotNull
        protected JsonElement currentElement(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return (JsonElement)MapsKt.getValue((Map)this.getObj(), (Object)tag);
        }

        @Override
        @NotNull
        public JsonObject getObj() {
            return this.obj;
        }

        public JsonTreeInput(JsonObject obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(obj);
            this.obj = obj;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeMapInput;", "Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonObject;)V", "keys", "", "", "getObj", "()Lkotlinx/serialization/json/JsonObject;", "pos", "", "size", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "decodeElementIndex", "desc", "Lkotlinx/serialization/SerialDescriptor;", "elementName", "index", "kotlinx-serialization-runtime"})
    private final class JsonTreeMapInput
    extends JsonTreeInput {
        private final List<String> keys;
        private final int size;
        private int pos;
        @NotNull
        private final JsonObject obj;

        @Override
        @NotNull
        public String elementName(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            int i = index / 2;
            return this.keys.get(i);
        }

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.pos < this.size - 1) {
                int n = this.pos;
                this.pos = n + 1;
                return this.pos;
            }
            return -1;
        }

        @Override
        @NotNull
        protected JsonElement currentElement(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.pos % 2 == 0 ? (JsonElement)new JsonLiteral(tag) : (JsonElement)this.getObj().get((Object)tag);
        }

        @Override
        @NotNull
        public JsonObject getObj() {
            return this.obj;
        }

        public JsonTreeMapInput(JsonObject obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(obj);
            this.obj = obj;
            this.keys = CollectionsKt.toList((Iterable)this.getObj().keySet());
            this.size = this.keys.size() * 2;
            this.pos = -1;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeListInput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonArray;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonArray;)V", "getObj", "()Lkotlinx/serialization/json/JsonArray;", "pos", "", "size", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "", "decodeElementIndex", "desc", "Lkotlinx/serialization/SerialDescriptor;", "elementName", "index", "kotlinx-serialization-runtime"})
    private final class JsonTreeListInput
    extends AbstractJsonTreeInput {
        private final int size;
        private int pos;
        @NotNull
        private final JsonArray obj;

        @Override
        @NotNull
        protected JsonElement currentElement(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            String string = tag;
            JsonArray jsonArray = this.getObj();
            int n = Integer.parseInt(string);
            return jsonArray.get(n);
        }

        @Override
        @NotNull
        public String elementName(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            return String.valueOf(index);
        }

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.pos < this.size - 1) {
                int n = this.pos;
                this.pos = n + 1;
                return this.pos;
            }
            return -1;
        }

        @Override
        @NotNull
        public JsonArray getObj() {
            return this.obj;
        }

        public JsonTreeListInput(JsonArray obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(obj);
            this.obj = obj;
            this.size = this.getObj().getContent().size();
            this.pos = -1;
        }
    }
}

