/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlinx.serialization.KInput;
import kotlinx.serialization.KOutput;
import kotlinx.serialization.KSerialClassDesc;
import kotlinx.serialization.KSerialLoader;
import kotlinx.serialization.KSerialSaver;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.NamedValueInput;
import kotlinx.serialization.NamedValueOutput;
import kotlinx.serialization.ScopeKt;
import kotlinx.serialization.SerialContext;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonTreeMapper$AbstractJsonTreeInput$WhenMappings;
import kotlinx.serialization.json.JsonTreeMapper$AbstractJsonTreeOutput$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\n\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u000bJ'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000e\u00a2\u0006\u0002\u0010\u000fJ'\u0010\u0010\u001a\u00020\n\"\u0004\b\u0000\u0010\b2\u0006\u0010\f\u001a\u0002H\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\u00a2\u0006\u0002\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper;", "", "context", "Lkotlinx/serialization/SerialContext;", "(Lkotlinx/serialization/SerialContext;)V", "getContext", "()Lkotlinx/serialization/SerialContext;", "readTree", "T", "tree", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Object;", "obj", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/json/JsonElement;Lkotlinx/serialization/KSerialLoader;)Ljava/lang/Object;", "writeTree", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Ljava/lang/Object;Lkotlinx/serialization/KSerialSaver;)Lkotlinx/serialization/json/JsonElement;", "AbstractJsonTreeInput", "AbstractJsonTreeOutput", "JsonTreeEntryOutput", "JsonTreeInput", "JsonTreeListInput", "JsonTreeListOutput", "JsonTreeMapEntryInput", "JsonTreeMapInput", "JsonTreeMapOutput", "JsonTreeOutput", "kotlinx-serialization-runtime"})
public final class JsonTreeMapper {
    @Nullable
    private final SerialContext context;

    private final <T> T readTree(JsonElement tree) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.readTree(tree, ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)));
    }

    public final <T> T readTree(@NotNull JsonElement obj, @NotNull KSerialLoader<T> loader) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        if (!(obj instanceof JsonObject)) {
            throw (Throwable)new SerializationException("Can't deserialize primitive on root level");
        }
        return new JsonTreeInput((JsonObject)obj).read(loader);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> JsonElement writeTree(T obj, @NotNull KSerialSaver<? super T> saver) {
        void result;
        Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        JsonTreeOutput output2 = new JsonTreeOutput((Function1<? super JsonElement, Unit>)((Function1)new Function1<JsonElement, Unit>((Ref.ObjectRef)result){
            final /* synthetic */ Ref.ObjectRef $result;

            public final void invoke(@NotNull JsonElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$result.element = it;
            }
            {
                this.$result = objectRef;
                super(1);
            }
        }));
        output2.write(saver, obj);
        Object object = result.element;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
        }
        return (JsonElement)object;
    }

    @Nullable
    public final SerialContext getContext() {
        return this.context;
    }

    public JsonTreeMapper(@Nullable SerialContext context) {
        this.context = context;
    }

    public /* synthetic */ JsonTreeMapper(SerialContext serialContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serialContext = null;
        }
        this(serialContext);
    }

    public JsonTreeMapper() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0004H&J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004H&J1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u001a\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\"\u0006\u0012\u0002\b\u00030\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020#H\u0016J;\u0010$\u001a\u00020\u0005\"\u000e\b\u0000\u0010%*\b\u0012\u0004\u0012\u0002H%0&2\u0006\u0010\u001b\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H%0(2\u0006\u0010\u001c\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0018\u00101\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0018\u00104\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u000205H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00066"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/NamedValueOutput;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "getNodeConsumer", "()Lkotlin/jvm/functions/Function1;", "composeName", "", "parentName", "childName", "getCurrent", "putElement", "key", "element", "writeBegin", "Lkotlinx/serialization/KOutput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KOutput;", "writeFinished", "writeTaggedBoolean", "tag", "value", "", "writeTaggedByte", "", "writeTaggedChar", "", "writeTaggedDouble", "", "writeTaggedEnum", "E", "", "enumClass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/lang/Enum;)V", "writeTaggedFloat", "", "writeTaggedInt", "", "writeTaggedLong", "", "writeTaggedNull", "writeTaggedShort", "", "writeTaggedString", "writeTaggedValue", "", "kotlinx-serialization-runtime"})
    private abstract class AbstractJsonTreeOutput
    extends NamedValueOutput {
        @NotNull
        private final Function1<JsonElement, Unit> nodeConsumer;

        @Override
        @NotNull
        public String composeName(@NotNull String parentName, @NotNull String childName) {
            Intrinsics.checkParameterIsNotNull((Object)parentName, (String)"parentName");
            Intrinsics.checkParameterIsNotNull((Object)childName, (String)"childName");
            return childName;
        }

        public abstract void putElement(@NotNull String var1, @NotNull JsonElement var2);

        @NotNull
        public abstract JsonElement getCurrent();

        @Override
        public void writeTaggedNull(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, JsonNull.INSTANCE);
        }

        @Override
        public void writeTaggedInt(@NotNull String tag, int value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void writeTaggedByte(@NotNull String tag, byte value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void writeTaggedShort(@NotNull String tag, short value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void writeTaggedLong(@NotNull String tag, long value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void writeTaggedFloat(@NotNull String tag, float value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(Float.valueOf(value)));
        }

        @Override
        public void writeTaggedDouble(@NotNull String tag, double value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void writeTaggedBoolean(@NotNull String tag, boolean value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public void writeTaggedChar(@NotNull String tag, char value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.putElement(tag, new JsonLiteral(String.valueOf(value)));
        }

        @Override
        public void writeTaggedString(@NotNull String tag, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.putElement(tag, new JsonLiteral(value));
        }

        @Override
        public <E extends Enum<E>> void writeTaggedEnum(@NotNull String tag, @NotNull KClass<E> enumClass, @NotNull E value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            this.putElement(tag, new JsonLiteral(value.toString()));
        }

        @Override
        public void writeTaggedValue(@NotNull String tag, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.putElement(tag, new JsonLiteral(value.toString()));
        }

        @Override
        @NotNull
        public KOutput writeBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            KOutput kOutput;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Function1 consumer2 = this.getCurrentTagOrNull() == null ? this.nodeConsumer : (Function1)new Function1<JsonElement, Unit>(this){
                final /* synthetic */ AbstractJsonTreeOutput this$0;

                public final void invoke(@NotNull JsonElement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    this.this$0.putElement(AbstractJsonTreeOutput.access$getCurrentTag$p(this.this$0), node);
                }
                {
                    this.this$0 = abstractJsonTreeOutput;
                    super(1);
                }
            };
            switch (JsonTreeMapper$AbstractJsonTreeOutput$WhenMappings.$EnumSwitchMapping$0[desc.getKind().ordinal()]) {
                case 1: 
                case 2: {
                    kOutput = new JsonTreeListOutput((Function1<? super JsonElement, Unit>)consumer2);
                    break;
                }
                case 3: {
                    kOutput = new JsonTreeMapOutput((Function1<? super JsonElement, Unit>)consumer2);
                    break;
                }
                case 4: {
                    kOutput = new JsonTreeEntryOutput((Function2<? super String, ? super JsonElement, Unit>)((Function2)new Function2<String, JsonElement, Unit>(this){

                        public final void invoke(@NotNull String p1, @NotNull JsonElement p2) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            ((AbstractJsonTreeOutput)this.receiver).putElement(p1, p2);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(AbstractJsonTreeOutput.class);
                        }

                        public final String getName() {
                            return "putElement";
                        }

                        public final String getSignature() {
                            return "putElement(Ljava/lang/String;Lkotlinx/serialization/json/JsonElement;)V";
                        }
                    }));
                    break;
                }
                default: {
                    kOutput = new JsonTreeOutput((Function1<? super JsonElement, Unit>)consumer2);
                }
            }
            return kOutput;
        }

        @Override
        public void writeFinished(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            this.nodeConsumer.invoke((Object)this.getCurrent());
        }

        @NotNull
        public final Function1<JsonElement, Unit> getNodeConsumer() {
            return this.nodeConsumer;
        }

        public AbstractJsonTreeOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(null, 1, null);
            this.nodeConsumer = nodeConsumer;
            this.setContext(JsonTreeMapper.this.getContext());
        }

        @NotNull
        public static final /* synthetic */ String access$getCurrentTag$p(AbstractJsonTreeOutput $this) {
            return (String)$this.getCurrentTag();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "map", "", "", "getCurrent", "putElement", "key", "element", "kotlinx-serialization-runtime"})
    private class JsonTreeOutput
    extends AbstractJsonTreeOutput {
        private final Map<String, JsonElement> map;

        @Override
        public void putElement(@NotNull String key, @NotNull JsonElement element) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Map<String, JsonElement> map = this.map;
            JsonElement jsonElement = element;
            map.put(key, jsonElement);
        }

        @Override
        @NotNull
        public JsonElement getCurrent() {
            return new JsonObject(this.map);
        }

        public JsonTreeOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(nodeConsumer);
            JsonTreeOutput jsonTreeOutput = this;
            HashMap hashMap = new HashMap();
            jsonTreeOutput.map = hashMap;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeMapOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "shouldWriteElement", "", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "tag", "", "index", "", "kotlinx-serialization-runtime"})
    private final class JsonTreeMapOutput
    extends JsonTreeOutput {
        @Override
        public boolean shouldWriteElement(@NotNull KSerialClassDesc desc, @NotNull String tag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return index != 0;
        }

        public JsonTreeMapOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(nodeConsumer);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeListOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function1;)V", "array", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getCurrent", "putElement", "key", "", "element", "shouldWriteElement", "", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "tag", "index", "", "kotlinx-serialization-runtime"})
    private final class JsonTreeListOutput
    extends AbstractJsonTreeOutput {
        private final ArrayList<JsonElement> array;

        @Override
        public boolean shouldWriteElement(@NotNull KSerialClassDesc desc, @NotNull String tag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return index != 0;
        }

        @Override
        public void putElement(@NotNull String key, @NotNull JsonElement element) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            String string = key;
            int idx = Integer.parseInt(string) - 1;
            this.array.add(idx, element);
        }

        @Override
        @NotNull
        public JsonElement getCurrent() {
            return new JsonArray((List<? extends JsonElement>)this.array);
        }

        public JsonTreeListOutput(Function1<? super JsonElement, Unit> nodeConsumer) {
            Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
            super(nodeConsumer);
            JsonTreeListOutput jsonTreeListOutput = this;
            ArrayList arrayList = new ArrayList();
            jsonTreeListOutput.array = arrayList;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeEntryOutput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeOutput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "entryConsumer", "Lkotlin/Function2;", "", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlin/jvm/functions/Function2;)V", "elem", "getEntryConsumer", "()Lkotlin/jvm/functions/Function2;", "tag", "getCurrent", "putElement", "key", "element", "writeFinished", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "kotlinx-serialization-runtime"})
    private final class JsonTreeEntryOutput
    extends AbstractJsonTreeOutput {
        private JsonElement elem;
        private String tag;
        @NotNull
        private final Function2<String, JsonElement, Unit> entryConsumer;

        @Override
        public void putElement(@NotNull String key, @NotNull JsonElement element) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (Intrinsics.areEqual((Object)key, (Object)"key") ^ true) {
                this.elem = element;
            } else {
                boolean bl = element instanceof JsonLiteral;
                if (!bl) {
                    String string = "Expected tag to be JsonLiteral";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.tag = ((JsonLiteral)element).getContent();
            }
        }

        @Override
        @NotNull
        public JsonElement getCurrent() {
            JsonElement jsonElement = this.elem;
            if (jsonElement == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"elem");
            }
            return jsonElement;
        }

        @Override
        public void writeFinished(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            String string = this.tag;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tag");
            }
            JsonElement jsonElement = this.elem;
            if (jsonElement == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"elem");
            }
            this.entryConsumer.invoke((Object)string, (Object)jsonElement);
        }

        @NotNull
        public final Function2<String, JsonElement, Unit> getEntryConsumer() {
            return this.entryConsumer;
        }

        public JsonTreeEntryOutput(Function2<? super String, ? super JsonElement, Unit> entryConsumer) {
            Intrinsics.checkParameterIsNotNull(entryConsumer, (String)"entryConsumer");
            super((Function1<? super JsonElement, Unit>)((Function1)1.INSTANCE));
            this.entryConsumer = entryConsumer;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH$J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J1\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u001a\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017\"\u0006\u0012\u0002\b\u00030\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J3\u0010\"\u001a\u0002H#\"\u000e\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0$2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00066"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/NamedValueInput;", "obj", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonElement;)V", "getObj", "()Lkotlinx/serialization/json/JsonElement;", "checkCast", "T", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonElement;", "composeName", "", "parentName", "childName", "currentElement", "tag", "getValue", "Lkotlinx/serialization/json/JsonPrimitive;", "readBegin", "Lkotlinx/serialization/KInput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KInput;", "readTaggedBoolean", "", "readTaggedByte", "", "readTaggedChar", "", "readTaggedDouble", "", "readTaggedEnum", "E", "", "enumClass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Enum;", "readTaggedFloat", "", "readTaggedInt", "", "readTaggedLong", "", "readTaggedNotNullMark", "readTaggedNull", "", "readTaggedShort", "", "readTaggedString", "readTaggedUnit", "", "kotlinx-serialization-runtime"})
    private abstract class AbstractJsonTreeInput
    extends NamedValueInput {
        @NotNull
        private final JsonElement obj;

        @Override
        @NotNull
        public String composeName(@NotNull String parentName, @NotNull String childName) {
            Intrinsics.checkParameterIsNotNull((Object)parentName, (String)"parentName");
            Intrinsics.checkParameterIsNotNull((Object)childName, (String)"childName");
            return childName;
        }

        private final <T extends JsonElement> T checkCast(JsonElement obj) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            boolean bl = obj instanceof JsonElement;
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder().append("Expected ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(JsonElement.class)).append(" but found ").append(Reflection.getOrCreateKotlinClass(obj.getClass())).toString();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)obj;
        }

        @Override
        @NotNull
        public KInput readBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            KInput kInput;
            Object object;
            String it;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Object object2 = (String)this.getCurrentTagOrNull();
            if (object2 == null || (object2 = this.currentElement(it = (object = object2))) == null) {
                object2 = this.getObj();
            }
            Object curObj = object2;
            switch (JsonTreeMapper$AbstractJsonTreeInput$WhenMappings.$EnumSwitchMapping$0[desc.getKind().ordinal()]) {
                case 1: 
                case 2: {
                    JsonTreeListInput jsonTreeListInput;
                    object = this;
                    JsonTreeMapper jsonTreeMapper = JsonTreeMapper.this;
                    JsonTreeListInput jsonTreeListInput2 = jsonTreeListInput;
                    JsonTreeListInput jsonTreeListInput3 = jsonTreeListInput;
                    boolean bl = curObj instanceof JsonArray;
                    if (!bl) {
                        String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonArray.class) + " but found " + Reflection.getOrCreateKotlinClass(curObj.getClass());
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Object object3 = curObj;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonArray");
                    }
                    JsonArray jsonArray = (JsonArray)object3;
                    jsonTreeListInput2(jsonArray);
                    kInput = jsonTreeListInput3;
                    break;
                }
                case 3: {
                    JsonTreeMapInput jsonTreeMapInput;
                    AbstractJsonTreeInput this_$iv = this;
                    JsonTreeMapper jsonTreeMapper = JsonTreeMapper.this;
                    JsonTreeMapInput jsonTreeMapInput2 = jsonTreeMapInput;
                    JsonTreeMapInput jsonTreeMapInput3 = jsonTreeMapInput;
                    boolean bl = curObj instanceof JsonObject;
                    if (!bl) {
                        String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " but found " + Reflection.getOrCreateKotlinClass(curObj.getClass());
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Object object4 = curObj;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    }
                    JsonObject jsonObject = (JsonObject)object4;
                    jsonTreeMapInput2(jsonObject);
                    kInput = jsonTreeMapInput3;
                    break;
                }
                case 4: {
                    kInput = new JsonTreeMapEntryInput((JsonElement)curObj, (String)this.getCurrentTag());
                    break;
                }
                default: {
                    JsonTreeInput jsonTreeInput;
                    AbstractJsonTreeInput this_$iv = this;
                    JsonTreeMapper jsonTreeMapper = JsonTreeMapper.this;
                    JsonTreeInput jsonTreeInput2 = jsonTreeInput;
                    JsonTreeInput jsonTreeInput3 = jsonTreeInput;
                    boolean bl = curObj instanceof JsonObject;
                    if (!bl) {
                        String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " but found " + Reflection.getOrCreateKotlinClass(curObj.getClass());
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Object object5 = curObj;
                    if (object5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    }
                    JsonObject jsonObject = (JsonObject)object5;
                    jsonTreeInput2(jsonObject);
                    kInput = jsonTreeInput3;
                }
            }
            return kInput;
        }

        @NotNull
        protected JsonPrimitive getValue(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            JsonElement currentElement = this.currentElement(tag);
            JsonElement jsonElement = currentElement;
            if (!(jsonElement instanceof JsonPrimitive)) {
                jsonElement = null;
            }
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive == null) {
                throw (Throwable)new SerializationException("Expected from " + tag + " to be primitive but found " + currentElement);
            }
            return jsonPrimitive;
        }

        @NotNull
        protected abstract JsonElement currentElement(@NotNull String var1);

        @Override
        public char readTaggedChar(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            JsonPrimitive o = this.getValue(tag);
            if (o.getContent().length() != 1) {
                throw (Throwable)new SerializationException(o + " can't be represented as Char");
            }
            return o.getContent().charAt(0);
        }

        @Override
        @NotNull
        public <E extends Enum<E>> E readTaggedEnum(@NotNull String tag, @NotNull KClass<E> enumClass) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            return SerializationKt.enumFromName(enumClass, this.getValue(tag).getContent());
        }

        @Override
        @Nullable
        public Void readTaggedNull(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return null;
        }

        @Override
        public boolean readTaggedNotNullMark(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.currentElement(tag) != JsonNull.INSTANCE;
        }

        @Override
        public void readTaggedUnit(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        }

        @Override
        public boolean readTaggedBoolean(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getBoolean();
        }

        @Override
        public byte readTaggedByte(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return (byte)this.getValue(tag).getInt();
        }

        @Override
        public short readTaggedShort(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return (short)this.getValue(tag).getInt();
        }

        @Override
        public int readTaggedInt(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getInt();
        }

        @Override
        public long readTaggedLong(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getLong();
        }

        @Override
        public float readTaggedFloat(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getFloat();
        }

        @Override
        public double readTaggedDouble(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getDouble();
        }

        @Override
        @NotNull
        public String readTaggedString(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return this.getValue(tag).getContent();
        }

        @NotNull
        public JsonElement getObj() {
            return this.obj;
        }

        public AbstractJsonTreeInput(JsonElement obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(null, 1, null);
            this.obj = obj;
            this.setContext(JsonTreeMapper.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonObject;)V", "getObj", "()Lkotlinx/serialization/json/JsonObject;", "pos", "", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "", "readElement", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "kotlinx-serialization-runtime"})
    private class JsonTreeInput
    extends AbstractJsonTreeInput {
        private int pos;
        @NotNull
        private final JsonObject obj;

        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            while (this.pos < desc.getAssociatedFieldsCount()) {
                int n = this.pos;
                this.pos = n + 1;
                String name = this.getTag(desc, n);
                Map map = this.getObj();
                Map map2 = map;
                if (!map2.containsKey(name)) continue;
                return this.pos - 1;
            }
            return -1;
        }

        @Override
        @NotNull
        protected JsonElement currentElement(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return (JsonElement)MapsKt.getValue((Map)this.getObj(), (Object)tag);
        }

        @Override
        @NotNull
        public JsonObject getObj() {
            return this.obj;
        }

        public JsonTreeInput(JsonObject obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(obj);
            this.obj = obj;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeMapEntryInput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonElement;", "cTag", "", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonElement;Ljava/lang/String;)V", "getCTag", "()Ljava/lang/String;", "getObj", "()Lkotlinx/serialization/json/JsonElement;", "currentElement", "tag", "kotlinx-serialization-runtime"})
    private final class JsonTreeMapEntryInput
    extends AbstractJsonTreeInput {
        @NotNull
        private final JsonElement obj;
        @NotNull
        private final String cTag;

        @Override
        @NotNull
        protected JsonElement currentElement(@NotNull String tag) {
            JsonElement jsonElement;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            if (Intrinsics.areEqual((Object)tag, (Object)"key")) {
                jsonElement = new JsonLiteral(this.cTag);
            } else {
                boolean bl = Intrinsics.areEqual((Object)tag, (Object)"value");
                if (!bl) {
                    String string = "Found unexpected tag: " + tag;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                jsonElement = this.getObj();
            }
            return jsonElement;
        }

        @Override
        @NotNull
        public JsonElement getObj() {
            return this.obj;
        }

        @NotNull
        public final String getCTag() {
            return this.cTag;
        }

        public JsonTreeMapEntryInput(@NotNull JsonElement obj, String cTag) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)cTag, (String)"cTag");
            super(obj);
            this.obj = obj;
            this.cTag = cTag;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeMapInput;", "Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonObject;)V", "keys", "", "", "getObj", "()Lkotlinx/serialization/json/JsonObject;", "pos", "", "size", "elementName", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "index", "readElement", "kotlinx-serialization-runtime"})
    private final class JsonTreeMapInput
    extends JsonTreeInput {
        private final List<String> keys;
        private final int size;
        private int pos;
        @NotNull
        private final JsonObject obj;

        @Override
        @NotNull
        public String elementName(@NotNull KSerialClassDesc desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            int i = index - 1;
            return this.keys.get(i);
        }

        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.pos < this.size) {
                int n = this.pos;
                this.pos = n + 1;
                return this.pos;
            }
            return -1;
        }

        @Override
        @NotNull
        public JsonObject getObj() {
            return this.obj;
        }

        public JsonTreeMapInput(JsonObject obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(obj);
            this.obj = obj;
            this.keys = CollectionsKt.toList((Iterable)this.getObj().keySet());
            this.size = this.keys.size();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/json/JsonTreeMapper$JsonTreeListInput;", "Lkotlinx/serialization/json/JsonTreeMapper$AbstractJsonTreeInput;", "Lkotlinx/serialization/json/JsonTreeMapper;", "obj", "Lkotlinx/serialization/json/JsonArray;", "(Lkotlinx/serialization/json/JsonTreeMapper;Lkotlinx/serialization/json/JsonArray;)V", "getObj", "()Lkotlinx/serialization/json/JsonArray;", "pos", "", "size", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "", "elementName", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "index", "readElement", "kotlinx-serialization-runtime"})
    private final class JsonTreeListInput
    extends AbstractJsonTreeInput {
        private final int size;
        private int pos;
        @NotNull
        private final JsonArray obj;

        @Override
        @NotNull
        protected JsonElement currentElement(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            String string = tag;
            JsonArray jsonArray = this.getObj();
            int n = Integer.parseInt(string);
            return jsonArray.get(n);
        }

        @Override
        @NotNull
        public String elementName(@NotNull KSerialClassDesc desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            return String.valueOf(index - 1);
        }

        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.pos < this.size) {
                int n = this.pos;
                this.pos = n + 1;
                return this.pos;
            }
            return -1;
        }

        @Override
        @NotNull
        public JsonArray getObj() {
            return this.obj;
        }

        public JsonTreeListInput(JsonArray obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super(obj);
            this.obj = obj;
            this.size = this.getObj().getContent().size();
        }
    }
}

