/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.serialization.ElementValueInput;
import kotlinx.serialization.ElementValueOutput;
import kotlinx.serialization.KInput;
import kotlinx.serialization.KOutput;
import kotlinx.serialization.KSerialClassDesc;
import kotlinx.serialization.KSerialLoader;
import kotlinx.serialization.KSerialSaver;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.ScopeKt;
import kotlinx.serialization.SerialContext;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.json.JSON$JsonInput$WhenMappings;
import kotlinx.serialization.json.JSON$JsonOutput$WhenMappings;
import kotlinx.serialization.json.JSONKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonTreeParser;
import kotlinx.serialization.json.Mode;
import kotlinx.serialization.json.Parser;
import kotlinx.serialization.json.StringOpsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00040123BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c2\u0003J\u000e\u0010\u0019\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\"\u0010\"\u001a\u0002H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u00012\u0006\u0010$\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010%J'\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0'2\u0006\u0010$\u001a\u00020\u0006\u00a2\u0006\u0002\u0010(J\"\u0010)\u001a\u00020\u0006\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u00012\u0006\u0010*\u001a\u0002H#H\u0086\b\u00a2\u0006\u0002\u0010+J'\u0010)\u001a\u00020\u0006\"\u0004\b\u0000\u0010#2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H#0-2\u0006\u0010*\u001a\u0002H#\u00a2\u0006\u0002\u0010.J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u000fR\u0016\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\b\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Lkotlinx/serialization/json/JSON;", "", "unquoted", "", "indented", "indent", "", "nonstrict", "updateMode", "Lkotlinx/serialization/UpdateMode;", "context", "Lkotlinx/serialization/SerialContext;", "(ZZLjava/lang/String;ZLkotlinx/serialization/UpdateMode;Lkotlinx/serialization/SerialContext;)V", "getContext", "()Lkotlinx/serialization/SerialContext;", "indented$1", "getNonstrict$kotlinx_serialization_runtime", "()Z", "nonstrict$1", "unquoted$1", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "component1", "component2", "component3", "component4", "component4$kotlinx_serialization_runtime", "component5", "component6", "copy", "equals", "other", "hashCode", "", "parse", "T", "str", "(Ljava/lang/String;)Ljava/lang/Object;", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/KSerialLoader;Ljava/lang/String;)Ljava/lang/Object;", "stringify", "obj", "(Ljava/lang/Object;)Ljava/lang/String;", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Lkotlinx/serialization/KSerialSaver;Ljava/lang/Object;)Ljava/lang/String;", "toString", "Companion", "Composer", "JsonInput", "JsonOutput", "kotlinx-serialization-runtime"})
public final class JSON {
    private final boolean unquoted$1;
    private final boolean indented$1;
    private final String indent;
    private final boolean nonstrict$1;
    @NotNull
    private final UpdateMode updateMode;
    @Nullable
    private final SerialContext context;
    @NotNull
    private static final JSON plain;
    @NotNull
    private static final JSON unquoted;
    @NotNull
    private static final JSON indented;
    @NotNull
    private static final JSON nonstrict;
    public static final Companion Companion;

    @NotNull
    public final <T> String stringify(@NotNull KSerialSaver<? super T> saver, T obj) {
        Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
        StringBuilder sb = new StringBuilder();
        JsonOutput output2 = new JsonOutput(Mode.OBJ, new Composer(sb), new JsonOutput[Mode.values().length]);
        output2.write(saver, obj);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final <T> String stringify(T obj) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.stringify(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), obj);
    }

    public final <T> T parse(@NotNull KSerialLoader<T> loader, @NotNull String str) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Parser parser = new Parser(str);
        JsonInput input = new JsonInput(Mode.OBJ, parser);
        T result = input.read(loader);
        boolean bl2 = bl = parser.getTc() == 12;
        if (!bl) {
            String string = "Shall parse complete string";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return result;
    }

    private final <T> T parse(String str) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.parse(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), str);
    }

    public final boolean getNonstrict$kotlinx_serialization_runtime() {
        return this.nonstrict$1;
    }

    @NotNull
    public final UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    @Nullable
    public final SerialContext getContext() {
        return this.context;
    }

    public JSON(boolean unquoted, boolean indented, @NotNull String indent, boolean nonstrict, @NotNull UpdateMode updateMode, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)updateMode), (String)"updateMode");
        this.unquoted$1 = unquoted;
        this.indented$1 = indented;
        this.indent = indent;
        this.nonstrict$1 = nonstrict;
        this.updateMode = updateMode;
        this.context = context;
    }

    public /* synthetic */ JSON(boolean bl, boolean bl2, String string, boolean bl3, UpdateMode updateMode, SerialContext serialContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            string = "    ";
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            updateMode = UpdateMode.OVERWRITE;
        }
        if ((n & 0x20) != 0) {
            serialContext = null;
        }
        this(bl, bl2, string, bl3, updateMode, serialContext);
    }

    public JSON() {
        this(false, false, null, false, null, null, 63, null);
    }

    static {
        Companion = new Companion(null);
        plain = new JSON(false, false, null, false, null, null, 63, null);
        unquoted = new JSON(true, false, null, false, null, null, 62, null);
        indented = new JSON(false, true, null, false, null, null, 61, null);
        nonstrict = new JSON(false, false, null, true, null, null, 55, null);
    }

    private final boolean component1() {
        return this.unquoted$1;
    }

    private final boolean component2() {
        return this.indented$1;
    }

    private final String component3() {
        return this.indent;
    }

    public final boolean component4$kotlinx_serialization_runtime() {
        return this.nonstrict$1;
    }

    @NotNull
    public final UpdateMode component5() {
        return this.updateMode;
    }

    @Nullable
    public final SerialContext component6() {
        return this.context;
    }

    @NotNull
    public final JSON copy(boolean unquoted, boolean indented, @NotNull String indent, boolean nonstrict, @NotNull UpdateMode updateMode, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)updateMode), (String)"updateMode");
        return new JSON(unquoted, indented, indent, nonstrict, updateMode, context);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ JSON copy$default(JSON jSON, boolean bl, boolean bl2, String string, boolean bl3, UpdateMode updateMode, SerialContext serialContext, int n, Object object) {
        if ((n & 1) != 0) {
            bl = jSON.unquoted$1;
        }
        if ((n & 2) != 0) {
            bl2 = jSON.indented$1;
        }
        if ((n & 4) != 0) {
            string = jSON.indent;
        }
        if ((n & 8) != 0) {
            bl3 = jSON.nonstrict$1;
        }
        if ((n & 0x10) != 0) {
            updateMode = jSON.updateMode;
        }
        if ((n & 0x20) != 0) {
            serialContext = jSON.context;
        }
        return jSON.copy(bl, bl2, string, bl3, updateMode, serialContext);
    }

    @NotNull
    public String toString() {
        return "JSON(unquoted=" + this.unquoted$1 + ", indented=" + this.indented$1 + ", indent=" + this.indent + ", nonstrict=" + this.nonstrict$1 + ", updateMode=" + (Object)((Object)this.updateMode) + ", context=" + this.context + ")";
    }

    public int hashCode() {
        int n = this.unquoted$1 ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int n2 = n * 31;
        int n3 = this.indented$1 ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        String string = this.indent;
        int n4 = ((n2 + n3) * 31 + (string != null ? string.hashCode() : 0)) * 31;
        int n5 = this.nonstrict$1 ? 1 : 0;
        if (n5 != 0) {
            n5 = 1;
        }
        UpdateMode updateMode = this.updateMode;
        SerialContext serialContext = this.context;
        return ((n4 + n5) * 31 + (updateMode != null ? ((Object)((Object)updateMode)).hashCode() : 0)) * 31 + (serialContext != null ? serialContext.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JSON)) break block3;
                JSON jSON = (JSON)object;
                if (!(this.unquoted$1 == jSON.unquoted$1) || !(this.indented$1 == jSON.indented$1) || !Intrinsics.areEqual((Object)this.indent, (Object)jSON.indent) || !(this.nonstrict$1 == jSON.nonstrict$1) || !Intrinsics.areEqual((Object)((Object)this.updateMode), (Object)((Object)jSON.updateMode)) || !Intrinsics.areEqual((Object)this.context, (Object)jSON.context)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0000R\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0011\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00120\b\"\u0006\u0012\u0002\b\u00030\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020,H\u0016J\u000e\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0000R\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lkotlinx/serialization/json/JSON$JsonOutput;", "Lkotlinx/serialization/ElementValueOutput;", "mode", "Lkotlinx/serialization/json/Mode;", "w", "Lkotlinx/serialization/json/JSON$Composer;", "Lkotlinx/serialization/json/JSON;", "modeReuseCache", "", "(Lkotlinx/serialization/json/JSON;Lkotlinx/serialization/json/Mode;Lkotlinx/serialization/json/JSON$Composer;[Lkotlinx/serialization/json/JSON$JsonOutput;)V", "forceStr", "", "[Lkotlinx/serialization/json/JSON$JsonOutput;", "writeBegin", "Lkotlinx/serialization/KOutput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KOutput;", "writeBooleanValue", "", "value", "writeByteValue", "", "writeCharValue", "", "writeDoubleValue", "", "writeElement", "index", "", "writeEnd", "writeFloatValue", "", "writeIntValue", "writeLongValue", "", "writeNonSerializableValue", "", "writeNullValue", "writeShortValue", "", "writeStringValue", "", "writeTree", "tree", "Lkotlinx/serialization/json/JsonElement;", "kotlinx-serialization-runtime"})
    public final class JsonOutput
    extends ElementValueOutput {
        private boolean forceStr;
        private final Mode mode;
        private final Composer w;
        private final JsonOutput[] modeReuseCache;

        public final void writeTree(@NotNull JsonElement tree) {
            Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
            this.w.getSb$kotlinx_serialization_runtime().append(tree.toString());
        }

        @Override
        @NotNull
        public KOutput writeBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Mode newMode = JSONKt.access$switchMode(this.mode, desc, typeParams);
            if (newMode.getBegin() != '\u0000') {
                this.w.print(newMode.getBegin());
                this.w.indent();
            }
            if (this.mode == newMode) {
                return this;
            }
            JsonOutput cached = this.modeReuseCache[newMode.ordinal()];
            if (cached != null) {
                return cached;
            }
            return new JsonOutput(newMode, this.w, this.modeReuseCache);
        }

        @Override
        public void writeEnd(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.mode.getEnd() != '\u0000') {
                this.w.unIndent();
                this.w.nextItem();
                this.w.print(this.mode.getEnd());
            }
        }

        @Override
        public boolean writeElement(@NotNull KSerialClassDesc desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            switch (JSON$JsonOutput$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                case 1: 
                case 2: {
                    if (index == 0) {
                        return false;
                    }
                    if (!this.w.getWritingFirst()) {
                        this.w.print(',');
                    }
                    this.w.nextItem();
                    break;
                }
                case 3: 
                case 4: {
                    if (index == 0) {
                        this.forceStr = true;
                    }
                    if (index != 1) break;
                    this.w.print(this.mode == Mode.ENTRY ? (char)':' : ',');
                    this.w.space();
                    this.forceStr = false;
                    break;
                }
                default: {
                    if (!this.w.getWritingFirst()) {
                        this.w.print(',');
                    }
                    this.w.nextItem();
                    this.writeStringValue(desc.getElementName(index));
                    this.w.print(':');
                    this.w.space();
                }
            }
            return true;
        }

        @Override
        public void writeNullValue() {
            this.w.print("null");
        }

        @Override
        public void writeBooleanValue(boolean value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeByteValue(byte value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeShortValue(short value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeIntValue(int value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeLongValue(long value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeFloatValue(float value) {
            float f;
            float f2;
            if (this.forceStr || !(!Float.isInfinite(f2 = (f = value)) && !Float.isNaN(f2 = f))) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeDoubleValue(double value) {
            double d;
            double d2;
            if (this.forceStr || !(!Double.isInfinite(d2 = (d = value)) && !Double.isNaN(d2 = d))) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeCharValue(char value) {
            this.writeStringValue(String.valueOf(value));
        }

        @Override
        public void writeStringValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (JSON.this.unquoted$1 && !JSONKt.access$mustBeQuoted(value)) {
                this.w.print(value);
            } else {
                this.w.printQuoted(value);
            }
        }

        @Override
        public void writeNonSerializableValue(@NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.writeStringValue(value.toString());
        }

        public JsonOutput(@NotNull Mode mode, @NotNull Composer w, JsonOutput[] modeReuseCache) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
            Intrinsics.checkParameterIsNotNull((Object)modeReuseCache, (String)"modeReuseCache");
            this.mode = mode;
            this.w = w;
            this.modeReuseCache = modeReuseCache;
            this.setContext(JSON.this.getContext());
            int i = this.mode.ordinal();
            if (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this) {
                this.modeReuseCache[i] = this;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\u0010\f\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0018J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0019J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001aJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001bJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001cJ\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0016\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lkotlinx/serialization/json/JSON$Composer;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lkotlinx/serialization/json/JSON;Ljava/lang/StringBuilder;)V", "level", "", "getSb$kotlinx_serialization_runtime", "()Ljava/lang/StringBuilder;", "<set-?>", "", "writingFirst", "getWritingFirst", "()Z", "setWritingFirst", "(Z)V", "indent", "", "nextItem", "print", "kotlin.jvm.PlatformType", "v", "", "", "", "", "", "", "", "printQuoted", "value", "space", "unIndent", "kotlinx-serialization-runtime"})
    public final class Composer {
        private int level;
        private boolean writingFirst;
        @NotNull
        private final StringBuilder sb;

        public final boolean getWritingFirst() {
            return this.writingFirst;
        }

        private final void setWritingFirst(boolean bl) {
            this.writingFirst = bl;
        }

        public final void indent() {
            this.writingFirst = true;
            int n = this.level;
            this.level = n + 1;
        }

        public final void unIndent() {
            int n = this.level;
            this.level = n + -1;
        }

        public final void nextItem() {
            this.writingFirst = false;
            if (JSON.this.indented$1) {
                this.print("\n");
                int n = this.level;
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    this.print(JSON.this.indent);
                }
            }
        }

        public final void space() {
            if (JSON.this.indented$1) {
                this.print(' ');
            }
        }

        public final StringBuilder print(char v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(@NotNull String v) {
            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
            return this.sb.append(v);
        }

        public final StringBuilder print(float v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(double v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(byte v) {
            return this.sb.append((Object)v);
        }

        public final StringBuilder print(short v) {
            return this.sb.append((Object)v);
        }

        public final StringBuilder print(int v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(long v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(boolean v) {
            return this.sb.append(v);
        }

        public final void printQuoted(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            StringOpsKt.printQuoted(this.sb, value);
        }

        @NotNull
        public final StringBuilder getSb$kotlinx_serialization_runtime() {
            return this.sb;
        }

        public Composer(StringBuilder sb) {
            Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
            this.sb = sb;
            this.writingFirst = true;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ1\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u001a\u0010\u0014\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015\"\u0006\u0012\u0002\b\u00030\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J+\u0010#\u001a\u0002H$\"\u000e\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0019H\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00065"}, d2={"Lkotlinx/serialization/json/JSON$JsonInput;", "Lkotlinx/serialization/ElementValueInput;", "mode", "Lkotlinx/serialization/json/Mode;", "p", "Lkotlinx/serialization/json/Parser;", "(Lkotlinx/serialization/json/JSON;Lkotlinx/serialization/json/Mode;Lkotlinx/serialization/json/Parser;)V", "curIndex", "", "entryIndex", "updateMode", "Lkotlinx/serialization/UpdateMode;", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "readAsTree", "Lkotlinx/serialization/json/JsonElement;", "readBegin", "Lkotlinx/serialization/KInput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KInput;", "readBooleanValue", "", "readByteValue", "", "readCharValue", "", "readDoubleValue", "", "readElement", "readEnd", "", "readEnumValue", "T", "", "enumClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Enum;", "readFloatValue", "", "readIntValue", "readLongValue", "", "readNotNullMark", "readNullValue", "", "readShortValue", "", "readStringValue", "", "kotlinx-serialization-runtime"})
    public final class JsonInput
    extends ElementValueInput {
        private int curIndex;
        private int entryIndex;
        private final Mode mode;
        private final Parser p;

        @NotNull
        public final JsonElement readAsTree() {
            return new JsonTreeParser(this.p).read();
        }

        @Override
        @NotNull
        public UpdateMode getUpdateMode() {
            return JSON.this.getUpdateMode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public KInput readBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            KInput kInput;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Mode newMode = JSONKt.access$switchMode(this.mode, desc, typeParams);
            if (newMode.getBegin() != '\u0000') {
                void this_$iv;
                Parser parser = this.p;
                byte expected$iv = newMode.getBeginTc();
                if (this_$iv.getTc() != expected$iv) {
                    void pos$iv$iv;
                    int n = this_$iv.getTokenPos();
                    String msg$iv$iv = "Expected '" + newMode.getBegin() + ", kind: " + (Object)((Object)desc.getKind()) + '\'';
                    throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
                }
                this.p.nextToken();
            }
            switch (JSON$JsonInput$WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    kInput = new JsonInput(newMode, this.p);
                    break;
                }
                default: {
                    kInput = this.mode == newMode ? this : new JsonInput(newMode, this.p);
                }
            }
            return kInput;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void readEnd(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.mode.getEnd() != '\u0000') {
                void this_$iv;
                Parser parser = this.p;
                byte expected$iv = this.mode.getEndTc();
                if (this_$iv.getTc() != expected$iv) {
                    void pos$iv$iv;
                    int n = this_$iv.getTokenPos();
                    String msg$iv$iv = "Expected '" + this.mode.getEnd() + '\'';
                    throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
                }
                this.p.nextToken();
            }
        }

        @Override
        public boolean readNotNullMark() {
            return this.p.getTc() != 10;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Void readNullValue() {
            void this_$iv;
            Parser parser = this.p;
            byte expected$iv = 10;
            if (this_$iv.getTc() != expected$iv) {
                void pos$iv$iv;
                int n = this_$iv.getTokenPos();
                String msg$iv$iv = "Expected 'null' literal";
                throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
            }
            this.p.nextToken();
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            while (true) {
                void this_$iv;
                if (this.p.getTc() == 4) {
                    this.p.nextToken();
                }
                switch (JSON$JsonInput$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
                    case 1: 
                    case 2: {
                        int n;
                        if (!this.p.getCanBeginValue()) {
                            n = -1;
                        } else {
                            JsonInput jsonInput = this;
                            n = ++jsonInput.curIndex;
                        }
                        return n;
                    }
                    case 3: {
                        int n;
                        int n2 = this.entryIndex;
                        this.entryIndex = n2 + 1;
                        switch (n2) {
                            case 0: {
                                n = 0;
                                break;
                            }
                            case 1: {
                                n = 1;
                                break;
                            }
                            default: {
                                this.entryIndex = 0;
                                n = -1;
                            }
                        }
                        return n;
                    }
                    case 4: {
                        int n;
                        int n3 = this.entryIndex;
                        this.entryIndex = n3 + 1;
                        switch (n3) {
                            case 0: {
                                n = 0;
                                break;
                            }
                            case 1: {
                                void this_$iv2;
                                Parser parser = this.p;
                                byte expected$iv = 5;
                                if (this_$iv2.getTc() != expected$iv) {
                                    void pos$iv$iv;
                                    int n4 = this_$iv2.getTokenPos();
                                    String msg$iv$iv = "Expected ':'";
                                    throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
                                }
                                this.p.nextToken();
                                n = 1;
                                break;
                            }
                            default: {
                                this.entryIndex = 0;
                                n = -1;
                            }
                        }
                        return n;
                    }
                }
                if (!this.p.getCanBeginValue()) {
                    return -1;
                }
                String key = this.p.takeStr();
                Parser expected$iv = this.p;
                byte expected$iv2 = 5;
                if (this_$iv.getTc() != expected$iv2) {
                    void pos$iv$iv;
                    int $i$a$1$requireTc = this_$iv.getTokenPos();
                    String msg$iv$iv = "Expected ':'";
                    throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
                }
                this.p.nextToken();
                int ind = desc.getElementIndex(key);
                if (ind != -3) {
                    return ind;
                }
                if (!JSON.this.getNonstrict$kotlinx_serialization_runtime()) {
                    throw (Throwable)new SerializationException("Strict JSON encountered unknown key: " + key);
                }
                this.p.skipElement();
            }
        }

        @Override
        public boolean readBooleanValue() {
            String string = this.p.takeStr();
            return Boolean.parseBoolean(string);
        }

        @Override
        public byte readByteValue() {
            String string = this.p.takeStr();
            return Byte.parseByte(string);
        }

        @Override
        public short readShortValue() {
            String string = this.p.takeStr();
            return Short.parseShort(string);
        }

        @Override
        public int readIntValue() {
            String string = this.p.takeStr();
            return Integer.parseInt(string);
        }

        @Override
        public long readLongValue() {
            String string = this.p.takeStr();
            return Long.parseLong(string);
        }

        @Override
        public float readFloatValue() {
            String string = this.p.takeStr();
            return Float.parseFloat(string);
        }

        @Override
        public double readDoubleValue() {
            String string = this.p.takeStr();
            return Double.parseDouble(string);
        }

        @Override
        public char readCharValue() {
            return StringsKt.single((CharSequence)this.p.takeStr());
        }

        @Override
        @NotNull
        public String readStringValue() {
            return this.p.takeStr();
        }

        @Override
        @NotNull
        public <T extends Enum<T>> T readEnumValue(@NotNull KClass<T> enumClass) {
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            return SerializationKt.enumFromName(enumClass, this.p.takeStr());
        }

        public JsonInput(@NotNull Mode mode, Parser p) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
            this.mode = mode;
            this.p = p;
            this.setContext(JSON.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u0011J'\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\u00020\u0010\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0015\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00192\u0006\u0010\u0016\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/json/JSON$Companion;", "", "()V", "indented", "Lkotlinx/serialization/json/JSON;", "getIndented", "()Lkotlinx/serialization/json/JSON;", "nonstrict", "getNonstrict", "plain", "getPlain", "unquoted", "getUnquoted", "parse", "T", "str", "", "(Ljava/lang/String;)Ljava/lang/Object;", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/KSerialLoader;Ljava/lang/String;)Ljava/lang/Object;", "stringify", "obj", "(Ljava/lang/Object;)Ljava/lang/String;", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Lkotlinx/serialization/KSerialSaver;Ljava/lang/Object;)Ljava/lang/String;", "kotlinx-serialization-runtime"})
    public static final class Companion {
        @NotNull
        public final <T> String stringify(@NotNull KSerialSaver<? super T> saver, T obj) {
            Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
            return this.getPlain().stringify(saver, obj);
        }

        private final <T> String stringify(T obj) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this.stringify(SerializationKt.serializer(Reflection.getOrCreateKotlinClass(Object.class)), obj);
        }

        public final <T> T parse(@NotNull KSerialLoader<T> loader, @NotNull String str) {
            Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            return this.getPlain().parse(loader, str);
        }

        private final <T> T parse(String str) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this.parse(SerializationKt.serializer(Reflection.getOrCreateKotlinClass(Object.class)), str);
        }

        @NotNull
        public final JSON getPlain() {
            return plain;
        }

        @NotNull
        public final JSON getUnquoted() {
            return unquoted;
        }

        @NotNull
        public final JSON getIndented() {
            return indented;
        }

        @NotNull
        public final JSON getNonstrict() {
            return nonstrict;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

