/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialContext;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.internal.ArrayListClassDesc;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.ByteSerializer;
import kotlinx.serialization.internal.CharSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.FloatSerializer;
import kotlinx.serialization.internal.HashMapClassDesc;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.HashSetClassDesc;
import kotlinx.serialization.internal.HashSetSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.LinkedHashMapClassDesc;
import kotlinx.serialization.internal.LinkedHashSetClassDesc;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.MapEntryClassDesc;
import kotlinx.serialization.internal.MapEntrySerializer;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.internal.SerialCache;
import kotlinx.serialization.internal.ShortSerializer;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u001a*\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a&\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000f\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\u0006\u0010\u0012\u001a\u00020\u0013\u001a+\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0015\u001a\u0002H\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"mapJavaClassNameToKotlin", "", "s", "registerSerializer", "", "forClassName", "serializer", "Lkotlinx/serialization/KSerializer;", "serializerByClass", "E", "klass", "Lkotlin/reflect/KClass;", "context", "Lkotlinx/serialization/SerialContext;", "serializerBySerialDescClassname", "className", "serializerByTypeToken", "", "type", "Ljava/lang/reflect/Type;", "serializerByValue", "value", "(Ljava/lang/Object;Lkotlinx/serialization/SerialContext;)Lkotlinx/serialization/KSerializer;", "kotlinx-serialization-runtime"})
public final class ResolvingKt {
    public static final void registerSerializer(@NotNull String forClassName, @NotNull KSerializer<?> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)forClassName, (String)"forClassName");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        SerialCache.INSTANCE.getMap$kotlinx_serialization_runtime().put(forClassName, serializer);
    }

    private static final String mapJavaClassNameToKotlin(String s) {
        String string;
        switch (s) {
            case "java.lang.Integer": 
            case "int": {
                string = IntSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                string = BooleanSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.Byte": 
            case "byte": {
                string = ByteSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.Short": 
            case "short": {
                string = ShortSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "long": 
            case "java.lang.Long": {
                string = LongSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.Float": 
            case "float": {
                string = FloatSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.Double": 
            case "double": {
                string = DoubleSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.Character": 
            case "char": {
                string = CharSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.lang.String": {
                string = StringSerializer.INSTANCE.getSerialClassDesc().getName();
                break;
            }
            case "java.util.ArrayList": 
            case "java.util.List": {
                string = ArrayListClassDesc.INSTANCE.getName();
                break;
            }
            case "java.util.LinkedHashSet": 
            case "java.util.Set": {
                string = LinkedHashSetClassDesc.INSTANCE.getName();
                break;
            }
            case "java.util.HashSet": {
                string = HashSetClassDesc.INSTANCE.getName();
                break;
            }
            case "java.util.LinkedHashMap": 
            case "java.util.Map": {
                string = LinkedHashMapClassDesc.INSTANCE.getName();
                break;
            }
            case "java.util.HashMap": {
                string = HashMapClassDesc.INSTANCE.getName();
                break;
            }
            case "java.util.Map$Entry": {
                string = MapEntryClassDesc.INSTANCE.getName();
                break;
            }
            default: {
                string = s;
            }
        }
        return string;
    }

    @NotNull
    public static final <E> KSerializer<E> serializerByValue(E value, @Nullable SerialContext context) {
        E e;
        E e2 = value;
        if (!(e2 instanceof Object)) {
            e2 = e = null;
        }
        if (e2 == null || (e = e.getClass()) == null || (e = JvmClassMappingKt.getKotlinClass(e)) == null) {
            throw (Throwable)new SerializationException("Cannot determine class for value " + value);
        }
        E klass = e;
        return ResolvingKt.serializerByClass(klass, context);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KSerializer serializerByValue$default(Object object, SerialContext serialContext, int n, Object object2) {
        if ((n & 2) != 0) {
            serialContext = null;
        }
        return ResolvingKt.serializerByValue(object, serialContext);
    }

    @NotNull
    public static final <E> KSerializer<E> serializerBySerialDescClassname(@NotNull String className, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return SerialCache.lookupSerializer$kotlinx_serialization_runtime$default(SerialCache.INSTANCE, className, null, context, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KSerializer serializerBySerialDescClassname$default(String string, SerialContext serialContext, int n, Object object) {
        if ((n & 2) != 0) {
            serialContext = null;
        }
        return ResolvingKt.serializerBySerialDescClassname(string, serialContext);
    }

    @NotNull
    public static final <E> KSerializer<E> serializerByClass(@NotNull KClass<?> klass, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getCanonicalName();
        if (string == null) {
            string = "";
        }
        return SerialCache.INSTANCE.lookupSerializer$kotlinx_serialization_runtime(ResolvingKt.mapJavaClassNameToKotlin(string), klass, context);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KSerializer serializerByClass$default(KClass kClass, SerialContext serialContext, int n, Object object) {
        if ((n & 2) != 0) {
            serialContext = null;
        }
        return ResolvingKt.serializerByClass(kClass, serialContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KSerializer<Object> serializerByTypeToken(@NotNull Type type) {
        KSerializer kSerializer;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Type type2 = type;
        if (type2 instanceof Class) {
            if (!((Class)type).isArray()) {
                kSerializer = ResolvingKt.serializerByClass$default(JvmClassMappingKt.getKotlinClass((Class)((Class)type)), null, 2, null);
            } else {
                Class<?> clazz = ((Class)type).getComponentType();
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.componentType");
                Class<?> eType = clazz;
                KSerializer<Object> s = ResolvingKt.serializerByTypeToken(eType);
                KClass kClass = JvmClassMappingKt.getKotlinClass(eType);
                if (kClass == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
                }
                kSerializer = new ReferenceArraySerializer(kClass, s);
            }
        } else if (type2 instanceof ParameterizedType) {
            Type type3 = ((ParameterizedType)type).getRawType();
            if (type3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            Class rootClass = (Class)type3;
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (List.class.isAssignableFrom(rootClass)) {
                Type type4 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"args[0]");
                kSerializer = new ArrayListSerializer<Object>(ResolvingKt.serializerByTypeToken(type4));
            } else if (Set.class.isAssignableFrom(rootClass)) {
                Type type5 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"args[0]");
                kSerializer = new HashSetSerializer<Object>(ResolvingKt.serializerByTypeToken(type5));
            } else if (Map.class.isAssignableFrom(rootClass)) {
                Type type6 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"args[0]");
                KSerializer<Object> kSerializer2 = ResolvingKt.serializerByTypeToken(type6);
                Type type7 = args[1];
                Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"args[1]");
                kSerializer = new HashMapSerializer<Object, Object>(kSerializer2, ResolvingKt.serializerByTypeToken(type7));
            } else if (Map.Entry.class.isAssignableFrom(rootClass)) {
                Type type8 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"args[0]");
                KSerializer<Object> kSerializer3 = ResolvingKt.serializerByTypeToken(type8);
                Type type9 = args[1];
                Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"args[1]");
                kSerializer = new MapEntrySerializer<Object, Object>(kSerializer3, ResolvingKt.serializerByTypeToken(type9));
            } else {
                void $receiver$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
                Object $receiver$iv = args;
                Type[] typeArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((Type[])$receiver$iv).length);
                int n = ((void)$receiver$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_12 = item$iv$iv = $receiver$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    void v12 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                    KSerializer<Object> kSerializer4 = ResolvingKt.serializerByTypeToken((Type)v12);
                    collection.add(kSerializer4);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object thisCollection$iv = $receiver$iv;
                KSerializer[] kSerializerArray = thisCollection$iv.toArray(new KSerializer[0]);
                if (kSerializerArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                KSerializer[] varargs = kSerializerArray;
                KSerializer kSerializer5 = SerializationKt.invokeSerializerGetter(rootClass, Arrays.copyOf(varargs, varargs.length));
                if (!(kSerializer5 instanceof KSerializer)) {
                    kSerializer5 = kSerializer = null;
                }
                if (kSerializer5 == null) {
                    kSerializer = ResolvingKt.serializerByClass$default(JvmClassMappingKt.getKotlinClass((Class)rootClass), null, 2, null);
                }
            }
        } else {
            throw (Throwable)new IllegalArgumentException("type should be instance of Class<?> or ParametrizedType");
        }
        return kSerializer;
    }
}

