/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializerKt;
import kotlinx.serialization.json.JsonInput;
import kotlinx.serialization.json.JsonOutput;
import kotlinx.serialization.json.internal.TreeJsonOutputKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkotlinx/serialization/json/JsonTransformingSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "tSerializer", "transformationName", "", "(Lkotlinx/serialization/KSerializer;Ljava/lang/String;)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/lang/Object;", "readTransform", "Lkotlinx/serialization/json/JsonElement;", "element", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "(Lkotlinx/serialization/Encoder;Ljava/lang/Object;)V", "writeTransform", "kotlinx-serialization-runtime"})
public abstract class JsonTransformingSerializer<T>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final KSerializer<T> tSerializer;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        JsonOutput output = JsonElementSerializerKt.asJsonOutput(encoder2);
        JsonElement element = TreeJsonOutputKt.writeJson(output.getJson(), value, (SerializationStrategy)this.tSerializer);
        element = this.writeTransform(element);
        output.encodeJson(element);
    }

    @Override
    @NotNull
    public final T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        JsonInput input = JsonElementSerializerKt.asJsonInput(decoder);
        JsonElement element = input.decodeJson();
        element = this.readTransform(element);
        return input.getJson().fromJson(this.tSerializer, element);
    }

    @NotNull
    protected JsonElement readTransform(@NotNull JsonElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return element;
    }

    @NotNull
    protected JsonElement writeTransform(@NotNull JsonElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return element;
    }

    public JsonTransformingSerializer(@NotNull KSerializer<T> tSerializer, @NotNull String transformationName) {
        Intrinsics.checkParameterIsNotNull(tSerializer, (String)"tSerializer");
        Intrinsics.checkParameterIsNotNull((Object)transformationName, (String)"transformationName");
        this.tSerializer = tSerializer;
        this.descriptor = SerialDescriptorBuilderKt.SerialDescriptor$default("JsonTransformingSerializer<" + this.tSerializer.getDescriptor().getSerialName() + ">(" + transformationName + ')', this.tSerializer.getDescriptor().getKind(), null, 4, null);
    }

    @Override
    @NotNull
    public T patch(@NotNull Decoder decoder, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return KSerializer.DefaultImpls.patch(this, decoder, old);
    }
}

