/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.ElementValueEncoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonInvalidValueInStrictModeException;
import kotlinx.serialization.json.JsonOutput;
import kotlinx.serialization.json.internal.JsonElementSerializer;
import kotlinx.serialization.json.internal.StreamingJsonOutput$WhenMappings;
import kotlinx.serialization.json.internal.StringOpsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001=B3\b\u0010\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0002\u0010\fB-\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001a\u0010\u0019\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001a0\u000b\"\u0006\u0012\u0002\b\u00030\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020'H\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020'H\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u001dH\u0016J\u0010\u00105\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010<\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006>"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonOutput;", "Lkotlinx/serialization/json/JsonOutput;", "Lkotlinx/serialization/ElementValueEncoder;", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "modeReuseCache", "", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonOutput;)V", "composer", "Lkotlinx/serialization/json/internal/StreamingJsonOutput$Composer;", "(Lkotlinx/serialization/json/internal/StreamingJsonOutput$Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonOutput;)V", "forceQuoting", "", "getJson", "()Lkotlinx/serialization/json/Json;", "[Lkotlinx/serialization/json/JsonOutput;", "beginStructure", "Lkotlinx/serialization/CompositeEncoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeEncoder;", "encodeBoolean", "", "value", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "ordinal", "encodeFloat", "", "encodeInt", "encodeJson", "element", "Lkotlinx/serialization/json/JsonElement;", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "", "encodeValue", "", "endStructure", "shouldEncodeElementDefault", "Composer", "kotlinx-serialization-runtime"})
public final class StreamingJsonOutput
extends ElementValueEncoder
implements JsonOutput {
    private boolean forceQuoting;
    private final Composer composer;
    @NotNull
    private final Json json;
    private final WriteMode mode;
    private final JsonOutput[] modeReuseCache;

    @Override
    public void encodeJson(@NotNull JsonElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.encodeSerializableValue(JsonElementSerializer.INSTANCE, element);
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor desc, int index) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        return this.getJson().getEncodeDefaults();
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
        WriteMode newMode = WriteModeKt.switchMode(desc, typeParams);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if (this.mode == newMode) {
            return this;
        }
        JsonOutput jsonOutput = this.modeReuseCache[newMode.ordinal()];
        return jsonOutput != null ? (CompositeEncoder)jsonOutput : (CompositeEncoder)new StreamingJsonOutput(this.composer, this.getJson(), newMode, this.modeReuseCache);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItem();
            this.composer.print(this.mode.end);
        }
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor desc, int index) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        switch (StreamingJsonOutput$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    if (index % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        break;
                    }
                    this.composer.print(':');
                    this.composer.space();
                    break;
                }
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index == 0) {
                    this.forceQuoting = true;
                }
                if (index != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(desc.getElementName(index));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    @Override
    public void encodeNull() {
        this.composer.print("null");
    }

    @Override
    public void encodeBoolean(boolean value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeByte(byte value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeShort(short value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeInt(int value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeLong(long value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeFloat(float value) {
        float f;
        float f2;
        if (this.getJson().strictMode && !(!Float.isInfinite(f2 = (f = value)) && !Float.isNaN(f2 = f))) {
            throw (Throwable)new JsonInvalidValueInStrictModeException(value);
        }
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeDouble(double value) {
        double d;
        double d2;
        if (this.getJson().strictMode && !(!Double.isInfinite(d2 = (d = value)) && !Double.isNaN(d2 = d))) {
            throw (Throwable)new JsonInvalidValueInStrictModeException(value);
        }
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    @Override
    public void encodeString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.getJson().unquoted && !StringOpsKt.shouldBeQuoted(value)) {
            this.composer.print(value);
        } else {
            this.composer.printQuoted(value);
        }
    }

    @Override
    public void encodeEnum(@NotNull EnumDescriptor enumDescription, int ordinal) {
        Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
        this.encodeString(enumDescription.getElementName(ordinal));
    }

    @Override
    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.getJson().strictMode) {
            super.encodeValue(value);
        } else {
            this.encodeString(value.toString());
        }
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonOutput(@NotNull Composer composer, @NotNull Json json, @NotNull WriteMode mode, @NotNull JsonOutput[] modeReuseCache) {
        Intrinsics.checkParameterIsNotNull((Object)composer, (String)"composer");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)modeReuseCache, (String)"modeReuseCache");
        this.composer = composer;
        this.json = json;
        this.mode = mode;
        this.modeReuseCache = modeReuseCache;
        this.setContext(this.getJson().getContext());
        int i = this.mode.ordinal();
        if (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this) {
            this.modeReuseCache[i] = this;
        }
    }

    public StreamingJsonOutput(@NotNull StringBuilder output, @NotNull Json json, @NotNull WriteMode mode, @NotNull JsonOutput[] modeReuseCache) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)modeReuseCache, (String)"modeReuseCache");
        this(new Composer(output, json), json, mode, modeReuseCache);
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        JsonOutput.DefaultImpls.encodeSerializableValue(this, serializer, value);
    }

    @Override
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        JsonOutput.DefaultImpls.encodeNullableSerializableValue(this, serializer, value);
    }

    @Override
    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor desc, int collectionSize, KSerializer<?> ... typeParams) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
        return JsonOutput.DefaultImpls.beginCollection(this, desc, collectionSize, typeParams);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\u0010\f\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0016J\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0017J\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0018J\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0019J\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u001aJ\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010\u001f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00060\u0003j\u0002`\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonOutput$Composer;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "json", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/json/Json;)V", "level", "", "<set-?>", "", "writingFirst", "getWritingFirst", "()Z", "indent", "", "nextItem", "print", "kotlin.jvm.PlatformType", "v", "", "", "", "", "", "", "", "printQuoted", "value", "space", "unIndent", "kotlinx-serialization-runtime"})
    public static final class Composer {
        private int level;
        private boolean writingFirst;
        @JvmField
        @NotNull
        public final StringBuilder sb;
        private final Json json;

        public final boolean getWritingFirst() {
            return this.writingFirst;
        }

        public final void indent() {
            this.writingFirst = true;
            int n = this.level;
            this.level = n + 1;
        }

        public final void unIndent() {
            int n = this.level;
            this.level = n + -1;
        }

        public final void nextItem() {
            this.writingFirst = false;
            if (this.json.indented) {
                this.print("\n");
                int n = this.level;
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl = false;
                    this.print(this.json.indent);
                }
            }
        }

        public final void space() {
            if (this.json.indented) {
                this.print(' ');
            }
        }

        public final StringBuilder print(char v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(@NotNull String v) {
            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
            return this.sb.append(v);
        }

        public final StringBuilder print(float v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(double v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(byte v) {
            return this.sb.append((Object)v);
        }

        public final StringBuilder print(short v) {
            return this.sb.append((Object)v);
        }

        public final StringBuilder print(int v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(long v) {
            return this.sb.append(v);
        }

        public final StringBuilder print(boolean v) {
            return this.sb.append(v);
        }

        public final void printQuoted(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            StringOpsKt.printQuoted(this.sb, value);
        }

        public Composer(@NotNull StringBuilder sb, @NotNull Json json) {
            Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            this.sb = sb;
            this.json = json;
            this.writingFirst = true;
        }
    }
}

