/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ElementValueDecoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonInput;
import kotlinx.serialization.json.JsonParsingException;
import kotlinx.serialization.json.JsonUnknownKeyException;
import kotlinx.serialization.json.internal.JsonParser;
import kotlinx.serialization.json.internal.JsonReader;
import kotlinx.serialization.json.internal.StreamingJsonInput$WhenMappings;
import kotlinx.serialization.json.internal.StringOpsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ1\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001a\u0010\u0017\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\"\u0006\u0012\u0002\b\u00030\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u001cH\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00067"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonInput;", "Lkotlinx/serialization/json/JsonInput;", "Lkotlinx/serialization/ElementValueDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "reader", "Lkotlinx/serialization/json/internal/JsonReader;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/JsonReader;)V", "currentIndex", "", "entryIndex", "getJson", "()Lkotlinx/serialization/json/Json;", "updateMode", "Lkotlinx/serialization/UpdateMode;", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "beginStructure", "Lkotlinx/serialization/CompositeDecoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeDecoder;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "decodeFloat", "", "decodeInt", "decodeJson", "Lkotlinx/serialization/json/JsonElement;", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "", "endStructure", "", "kotlinx-serialization-runtime"})
public final class StreamingJsonInput
extends ElementValueDecoder
implements JsonInput {
    private int currentIndex;
    private int entryIndex;
    @NotNull
    private final Json json;
    private final WriteMode mode;
    private final JsonReader reader;

    @Override
    @NotNull
    public JsonElement decodeJson() {
        return new JsonParser(this.reader).read();
    }

    @Override
    @NotNull
    public UpdateMode getUpdateMode() {
        return this.getJson().getUpdateMode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
        WriteMode newMode = WriteModeKt.switchMode(desc, typeParams);
        if (newMode.begin != '\u0000') {
            void this_$iv;
            JsonReader jsonReader = this.reader;
            byte expected$iv = newMode.getBeginTc();
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                void pos$iv$iv;
                int n = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv);
                boolean bl = false;
                String msg$iv$iv = "Expected '" + newMode.begin + ", kind: " + desc.getKind() + '\'';
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
            }
            this.reader.nextToken();
        }
        switch (StreamingJsonInput$WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonInput(this.getJson(), newMode, this.reader);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode ? this : new StreamingJsonInput(this.getJson(), newMode, this.reader);
            }
        }
        return compositeDecoder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endStructure(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (this.mode.end != '\u0000') {
            void this_$iv;
            JsonReader jsonReader = this.reader;
            byte expected$iv = this.mode.getEndTc();
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                void pos$iv$iv;
                int n = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv);
                boolean bl = false;
                String msg$iv$iv = "Expected '" + this.mode.end + '\'';
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
            }
            this.reader.nextToken();
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        return this.reader.tokenClass != 10;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Void decodeNull() {
        void this_$iv;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 10;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
        if (this_$iv.tokenClass != expected$iv) {
            void pos$iv$iv;
            int n = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv);
            boolean bl = false;
            String msg$iv$iv = "Expected 'null' literal";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
        }
        this.reader.nextToken();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        while (true) {
            void this_$iv;
            if (this.reader.tokenClass == 4) {
                this.reader.nextToken();
            }
            switch (StreamingJsonInput$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
                case 1: {
                    int n;
                    if (!this.reader.getCanBeginValue()) {
                        n = -1;
                    } else {
                        StreamingJsonInput streamingJsonInput = this;
                        n = ++streamingJsonInput.currentIndex;
                    }
                    return n;
                }
                case 2: {
                    int n;
                    if (this.currentIndex % 2 == 0 && this.reader.tokenClass == 5) {
                        this.reader.nextToken();
                    }
                    if (!this.reader.getCanBeginValue()) {
                        n = -1;
                    } else {
                        StreamingJsonInput streamingJsonInput = this;
                        n = ++streamingJsonInput.currentIndex;
                    }
                    return n;
                }
                case 3: {
                    int n;
                    int n2 = this.entryIndex;
                    this.entryIndex = n2 + 1;
                    switch (n2) {
                        case 0: {
                            n = 0;
                            break;
                        }
                        case 1: {
                            n = 1;
                            break;
                        }
                        default: {
                            this.entryIndex = 0;
                            n = -1;
                        }
                    }
                    return n;
                }
            }
            if (!this.reader.getCanBeginValue()) {
                return -1;
            }
            String key = this.reader.takeString();
            JsonReader jsonReader = this.reader;
            byte expected$iv = 5;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                void pos$iv$iv;
                int n = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv);
                boolean bl = false;
                String msg$iv$iv = "Expected ':'";
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
            }
            this.reader.nextToken();
            int index = desc.getElementIndex(key);
            if (index != -3) {
                return index;
            }
            if (this.getJson().strictMode) {
                throw (Throwable)new JsonUnknownKeyException(key);
            }
            this.reader.skipElement();
        }
    }

    @Override
    public boolean decodeBoolean() {
        boolean bl;
        String string;
        String $receiver = string = this.reader.takeString();
        boolean bl2 = false;
        if (this.getJson().strictMode) {
            bl = StringOpsKt.toBooleanStrict($receiver);
        } else {
            String string2 = $receiver;
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    @Override
    public byte decodeByte() {
        String string = this.reader.takeString();
        return Byte.parseByte(string);
    }

    @Override
    public short decodeShort() {
        String string = this.reader.takeString();
        return Short.parseShort(string);
    }

    @Override
    public int decodeInt() {
        String string = this.reader.takeString();
        return Integer.parseInt(string);
    }

    @Override
    public long decodeLong() {
        String string = this.reader.takeString();
        return Long.parseLong(string);
    }

    @Override
    public float decodeFloat() {
        String string = this.reader.takeString();
        return Float.parseFloat(string);
    }

    @Override
    public double decodeDouble() {
        String string = this.reader.takeString();
        return Double.parseDouble(string);
    }

    @Override
    public char decodeChar() {
        return StringsKt.single((CharSequence)this.reader.takeString());
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.reader.takeString();
    }

    @Override
    public int decodeEnum(@NotNull EnumDescriptor enumDescription) {
        Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
        return enumDescription.getElementIndex(this.reader.takeString());
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonInput(@NotNull Json json, @NotNull WriteMode mode, @NotNull JsonReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.json = json;
        this.mode = mode;
        this.reader = reader;
        this.currentIndex = -1;
        this.setContext(this.getJson().getContext());
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        return JsonInput.DefaultImpls.decodeSerializableValue(this, deserializer);
    }

    @Override
    @Nullable
    public <T> T decodeNullableSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        return JsonInput.DefaultImpls.decodeNullableSerializableValue(this, deserializer);
    }

    @Override
    public <T> T updateSerializableValue(@NotNull DeserializationStrategy<T> deserializer, T old) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        return JsonInput.DefaultImpls.updateSerializableValue(this, deserializer, old);
    }

    @Override
    @Nullable
    public <T> T updateNullableSerializableValue(@NotNull DeserializationStrategy<T> deserializer, @Nullable T old) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        return JsonInput.DefaultImpls.updateNullableSerializableValue(this, deserializer, old);
    }

    @Override
    public int decodeCollectionSize(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        return JsonInput.DefaultImpls.decodeCollectionSize(this, desc);
    }
}

