/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.JsonParsingException;
import kotlinx.serialization.json.internal.JsonReaderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010\u001f\u001a\u00020\u0014J$\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#H\u0080\b\u00a2\u0006\u0002\b$J\u0006\u0010%\u001a\u00020\u0014J\u0006\u0010&\u001a\u00020\u0003J\b\u0010'\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkotlinx/serialization/json/internal/JsonReader;", "", "source", "", "(Ljava/lang/String;)V", "buf", "", "canBeginValue", "", "getCanBeginValue", "()Z", "currentPosition", "", "isDone", "length", "offset", "tokenClass", "", "tokenPosition", "append", "", "ch", "", "appendEsc", "startPos", "appendHex", "appendRange", "fromIndex", "toIndex", "nextLiteral", "nextString", "nextToken", "requireTokenClass", "expected", "lazyErrorMsg", "Lkotlin/Function0;", "requireTokenClass$kotlinx_serialization_runtime", "skipElement", "takeString", "toString", "kotlinx-serialization-runtime"})
public final class JsonReader {
    @JvmField
    public int currentPosition;
    @JvmField
    public byte tokenClass;
    private int tokenPosition;
    private int offset;
    private int length;
    private char[] buf;
    private final String source;

    public final boolean isDone() {
        return this.tokenClass == 12;
    }

    public final boolean getCanBeginValue() {
        boolean bl;
        switch (this.tokenClass) {
            case 0: 
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void requireTokenClass$kotlinx_serialization_runtime(byte expected, @NotNull Function0<String> lazyErrorMsg) {
        int $i$f$requireTokenClass$kotlinx_serialization_runtime = 0;
        Intrinsics.checkParameterIsNotNull(lazyErrorMsg, (String)"lazyErrorMsg");
        if (this.tokenClass != expected) {
            void pos$iv;
            int n = this.tokenPosition;
            String msg$iv = (String)lazyErrorMsg.invoke();
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv, msg$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String takeString() {
        String string;
        int n;
        int n2;
        Object object;
        if (this.tokenClass != 0 && this.tokenClass != 1) {
            void pos$iv;
            int n3 = this.tokenPosition;
            String msg$iv = "Expected string or non-null literal";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv, msg$iv);
        }
        if (this.offset < 0) {
            object = this.buf;
            n2 = 0;
            n = this.length;
            string = new String((char[])object, n2, n);
        } else {
            object = this.source;
            n2 = this.offset;
            n = this.offset + this.length;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object2).substring(n2, n);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String prevStr = string;
        this.nextToken();
        return prevStr;
    }

    private final void append(char ch) {
        if (this.length >= this.buf.length) {
            char[] cArray = this.buf;
            int n = 2 * this.buf.length;
            JsonReader jsonReader = this;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            char[] cArray3 = cArray2;
            jsonReader.buf = cArray3;
        }
        int n = this.length;
        this.length = n + 1;
        this.buf[n] = ch;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendRange(String source, int fromIndex, int toIndex) {
        int n;
        int oldLen = this.length;
        int addLen = toIndex - fromIndex;
        int newLen = oldLen + addLen;
        if (newLen > this.buf.length) {
            char[] cArray = this.buf;
            n = RangesKt.coerceAtLeast((int)newLen, (int)(2 * this.buf.length));
            JsonReader jsonReader = this;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            char[] cArray3 = cArray2;
            jsonReader.buf = cArray3;
        }
        int n2 = 0;
        n = addLen;
        while (n2 < n) {
            void i;
            this.buf[oldLen + i] = source.charAt(fromIndex + i);
            ++i;
        }
        this.length += addLen;
    }

    public final void nextToken() {
        byte tc;
        String source = this.source;
        int curPos = this.currentPosition;
        int maxLen = source.length();
        block5: while (true) {
            if (curPos >= maxLen) {
                this.tokenPosition = curPos;
                this.tokenClass = (byte)12;
                return;
            }
            char ch = source.charAt(curPos);
            tc = JsonReaderKt.charToTokenClass(ch);
            switch (tc) {
                case 3: {
                    ++curPos;
                    continue block5;
                }
                case 0: {
                    this.nextLiteral(source, curPos);
                    return;
                }
                case 1: {
                    this.nextString(source, curPos);
                    return;
                }
            }
            break;
        }
        this.tokenPosition = curPos;
        this.tokenClass = tc;
        this.currentPosition = curPos + 1;
    }

    private final void nextLiteral(String source, int startPos) {
        this.tokenPosition = startPos;
        this.offset = startPos;
        int curPos = startPos;
        int maxLen = source.length();
        while (++curPos < maxLen && JsonReaderKt.charToTokenClass(source.charAt(curPos)) == 0) {
        }
        this.currentPosition = curPos;
        this.length = curPos - this.offset;
        this.tokenClass = (byte)(JsonReaderKt.access$rangeEquals(source, this.offset, this.length, "null") ? 10 : 0);
    }

    private final void nextString(String source, int startPos) {
        int curPos;
        this.tokenPosition = startPos;
        this.length = 0;
        int lastPos = curPos = startPos + 1;
        int maxLen = source.length();
        while (true) {
            if (curPos >= maxLen) {
                String msg$iv = "Unexpected end in string";
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException(curPos, msg$iv);
            }
            if (source.charAt(curPos) == '\"') break;
            if (source.charAt(curPos) == '\\') {
                int newPos;
                this.appendRange(source, lastPos, curPos);
                curPos = newPos = this.appendEsc(source, curPos + 1);
                lastPos = newPos;
                continue;
            }
            ++curPos;
        }
        if (lastPos == startPos + 1) {
            this.offset = lastPos;
            this.length = curPos - lastPos;
        } else {
            this.appendRange(source, lastPos, curPos);
            this.offset = -1;
        }
        this.currentPosition = curPos + 1;
        this.tokenClass = 1;
    }

    private final int appendEsc(String source, int startPos) {
        char curChar;
        int curPos = startPos;
        boolean condition$iv = curPos < source.length();
        boolean $i$f$require = false;
        if (!condition$iv) {
            boolean bl = false;
            String msg$iv$iv = "Unexpected end after escape char";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException(curPos, msg$iv$iv);
        }
        if ((curChar = source.charAt(curPos++)) == 'u') {
            curPos = this.appendHex(source, curPos);
        } else {
            char c = JsonReaderKt.escapeToChar(curChar);
            boolean condition$iv2 = c != '\u0000';
            boolean $i$f$require2 = false;
            if (!condition$iv2) {
                boolean bl = false;
                String msg$iv$iv = "Invalid escaped char '" + curChar + '\'';
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException(curPos, msg$iv$iv);
            }
            this.append(c);
        }
        return curPos;
    }

    private final int appendHex(String source, int startPos) {
        int curPos = startPos;
        this.append((char)((JsonReaderKt.access$fromHexChar(source, curPos++) << 12) + (JsonReaderKt.access$fromHexChar(source, curPos++) << 8) + (JsonReaderKt.access$fromHexChar(source, curPos++) << 4) + JsonReaderKt.access$fromHexChar(source, curPos++)));
        return curPos;
    }

    public final void skipElement() {
        Collection collection;
        if (this.tokenClass != 6 && this.tokenClass != 8) {
            this.nextToken();
            return;
        }
        List tokenStack = new ArrayList();
        do {
            switch (this.tokenClass) {
                case 6: 
                case 8: {
                    tokenStack.add(this.tokenClass);
                    break;
                }
                case 9: {
                    if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 8) {
                        throw (Throwable)new JsonParsingException(this.currentPosition, "found ] instead of }");
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                    break;
                }
                case 7: {
                    if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 6) {
                        throw (Throwable)new JsonParsingException(this.currentPosition, "found } instead of ]");
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                }
            }
            this.nextToken();
        } while (!(collection = (Collection)tokenStack).isEmpty());
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.source + "', currentPosition=" + this.currentPosition + ", tokenClass=" + this.tokenClass + ", tokenPosition=" + this.tokenPosition + ", offset=" + this.offset + ')';
    }

    public JsonReader(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        this.tokenClass = (byte)12;
        this.offset = -1;
        this.buf = new char[16];
        this.nextToken();
    }

    public static final /* synthetic */ void access$setTokenPosition$p(JsonReader $this, int n) {
        $this.tokenPosition = n;
    }
}

