/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonParsingException;
import kotlinx.serialization.json.internal.JsonReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkotlinx/serialization/json/internal/JsonParser;", "", "reader", "Lkotlinx/serialization/json/internal/JsonReader;", "(Lkotlinx/serialization/json/internal/JsonReader;)V", "read", "Lkotlinx/serialization/json/JsonElement;", "readArray", "readObject", "readValue", "isString", "", "kotlinx-serialization-runtime"})
public final class JsonParser {
    private final JsonReader reader;

    /*
     * WARNING - void declaration
     */
    private final JsonElement readObject() {
        void this_$iv;
        void this_$iv2;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 6;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime2 = false;
        if (this_$iv2.tokenClass != expected$iv) {
            void pos$iv$iv;
            int n = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv2);
            boolean bl = false;
            String msg$iv$iv = "Expected start of object";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
        }
        this.reader.nextToken();
        Map result = new LinkedHashMap();
        while (true) {
            void this_$iv3;
            if (this.reader.tokenClass == 4) {
                this.reader.nextToken();
            }
            if (!this.reader.getCanBeginValue()) break;
            String key = this.reader.takeString();
            JsonReader $i$f$requireTokenClass$kotlinx_serialization_runtime2 = this.reader;
            byte expected$iv22 = 5;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime222 = false;
            if (this_$iv3.tokenClass != expected$iv22) {
                void pos$iv$iv;
                int msg$iv$iv = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv3);
                boolean bl = false;
                String msg$iv$iv2 = "Expected ':'";
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv2);
            }
            this.reader.nextToken();
            JsonElement elem = this.read();
            Map expected$iv22 = result;
            JsonElement $i$f$requireTokenClass$kotlinx_serialization_runtime222 = elem;
            expected$iv22.put(key, $i$f$requireTokenClass$kotlinx_serialization_runtime222);
        }
        JsonReader key = this.reader;
        byte expected$iv2 = 7;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime3 = false;
        if (this_$iv.tokenClass != expected$iv2) {
            void pos$iv$iv;
            int $i$f$requireTokenClass$kotlinx_serialization_runtime222 = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv);
            boolean bl = false;
            String msg$iv$iv = "Expected end of object";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
        }
        this.reader.nextToken();
        return new JsonObject(result);
    }

    private final JsonElement readValue(boolean isString) {
        String str = this.reader.takeString();
        return new JsonLiteral(str, isString);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonElement readArray() {
        void this_$iv;
        void this_$iv2;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 8;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
        if (this_$iv2.tokenClass != expected$iv) {
            void pos$iv$iv;
            int n = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv2);
            boolean bl = false;
            String msg$iv$iv = "Expected start of array";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
        }
        this.reader.nextToken();
        List result = new ArrayList();
        while (true) {
            if (this.reader.tokenClass == 4) {
                this.reader.nextToken();
            }
            if (!this.reader.getCanBeginValue()) break;
            JsonElement elem = this.read();
            result.add(elem);
        }
        JsonReader elem = this.reader;
        byte expected$iv2 = 9;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime2 = false;
        if (this_$iv.tokenClass != expected$iv2) {
            void pos$iv$iv;
            int bl = JsonReader.access$getTokenPosition$p((JsonReader)this_$iv);
            boolean bl2 = false;
            String msg$iv$iv = "Expected end of array";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv$iv, msg$iv$iv);
        }
        this.reader.nextToken();
        return new JsonArray(result);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonElement read() {
        JsonElement jsonElement;
        if (!this.reader.getCanBeginValue()) {
            void pos$iv;
            int n = this.reader.currentPosition;
            String msg$iv = "Can't begin reading value from here";
            boolean $i$f$fail = false;
            throw (Throwable)new JsonParsingException((int)pos$iv, msg$iv);
        }
        byte tc = this.reader.tokenClass;
        switch (tc) {
            case 10: {
                JsonNull msg$iv;
                JsonNull it = msg$iv = JsonNull.INSTANCE;
                boolean bl = false;
                this.reader.nextToken();
                jsonElement = msg$iv;
                break;
            }
            case 1: {
                jsonElement = this.readValue(true);
                break;
            }
            case 0: {
                jsonElement = this.readValue(false);
                break;
            }
            case 6: {
                jsonElement = this.readObject();
                break;
            }
            case 8: {
                jsonElement = this.readArray();
                break;
            }
            default: {
                void pos$iv;
                int msg$iv = this.reader.currentPosition;
                String msg$iv2 = "Can't begin reading element";
                boolean $i$f$fail = false;
                throw (Throwable)new JsonParsingException((int)pos$iv, msg$iv2);
            }
        }
        return jsonElement;
    }

    public JsonParser(@NotNull JsonReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.reader = reader;
    }
}

