/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.AbstractSerialFormat;
import kotlinx.serialization.CoreKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ImplicitReflectionSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.context.ContextKt;
import kotlinx.serialization.context.MutableSerialContext;
import kotlinx.serialization.context.SerialContext;
import kotlinx.serialization.context.SerialModule;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonOutput;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonArraySerializer;
import kotlinx.serialization.json.internal.JsonElementSerializer;
import kotlinx.serialization.json.internal.JsonLiteralSerializer;
import kotlinx.serialization.json.internal.JsonNullSerializer;
import kotlinx.serialization.json.internal.JsonObjectSerializer;
import kotlinx.serialization.json.internal.JsonPrimitiveSerializer;
import kotlinx.serialization.json.internal.JsonReader;
import kotlinx.serialization.json.internal.StreamingJsonInput;
import kotlinx.serialization.json.internal.StreamingJsonOutput;
import kotlinx.serialization.json.internal.TreeJsonInputKt;
import kotlinx.serialization.json.internal.TreeJsonOutputKt;
import kotlinx.serialization.json.internal.WriteMode;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(BA\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ'\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0011\u001a\u0002H\u0012\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0087\b\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0007J)\u0010\u001f\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00120!2\u0006\u0010\"\u001a\u0002H\u0012H\u0016\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u00020\u0016\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u00182\u0006\u0010%\u001a\u0002H\u0012H\u0087\b\u00a2\u0006\u0002\u0010&J'\u0010$\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00120!2\u0006\u0010%\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010'R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lkotlinx/serialization/json/Json;", "Lkotlinx/serialization/AbstractSerialFormat;", "Lkotlinx/serialization/StringFormat;", "unquoted", "", "indented", "indent", "", "strictMode", "updateMode", "Lkotlinx/serialization/UpdateMode;", "encodeDefaults", "(ZZLjava/lang/String;ZLkotlinx/serialization/UpdateMode;Z)V", "getEncodeDefaults", "()Z", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "fromJson", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "json", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/DeserializationStrategy;Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Object;", "", "tree", "(Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Object;", "parse", "string", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "parseJson", "stringify", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "toJson", "value", "(Ljava/lang/Object;)Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lkotlinx/serialization/json/JsonElement;", "Companion", "kotlinx-serialization-runtime"})
public final class Json
extends AbstractSerialFormat
implements StringFormat {
    @JvmField
    public final boolean unquoted;
    @JvmField
    public final boolean indented;
    @JvmField
    @NotNull
    public final String indent;
    @JvmField
    public final boolean strictMode;
    @NotNull
    private final UpdateMode updateMode;
    private final boolean encodeDefaults;
    @NotNull
    private static final Json plain;
    @NotNull
    private static final Json unquoted;
    @NotNull
    private static final Json indented;
    @NotNull
    private static final Json nonstrict;
    public static final Companion Companion;

    @Override
    @NotNull
    public <T> String stringify(@NotNull SerializationStrategy<? super T> serializer, T obj) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        StringBuilder result = new StringBuilder();
        StreamingJsonOutput encoder2 = new StreamingJsonOutput(result, this, WriteMode.OBJ, new JsonOutput[WriteMode.values().length]);
        CoreKt.encode(encoder2, serializer, obj);
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final <T> JsonElement toJson(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        return TreeJsonOutputKt.writeJson(this, value, serializer);
    }

    @ImplicitReflectionSerializer
    private final <T> JsonElement toJson(T value) {
        int $i$f$toJson = 0;
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.toJson(ContextKt.getOrDefault(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), value);
    }

    @Override
    public <T> T parse(@NotNull DeserializationStrategy<T> deserializer, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        JsonReader reader = new JsonReader(string);
        StreamingJsonInput input = new StreamingJsonInput(this, WriteMode.OBJ, reader);
        T result = CoreKt.decode(input, deserializer);
        if (!reader.isDone()) {
            String string2 = "Reader has not consumed the whole input: " + reader;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return result;
    }

    @NotNull
    public final JsonElement parseJson(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        return (JsonElement)this.parse(JsonElementSerializer.INSTANCE, string);
    }

    public final <T> T fromJson(@NotNull DeserializationStrategy<T> deserializer, @NotNull JsonElement json) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return TreeJsonInputKt.readJson(this, json, deserializer);
    }

    @ImplicitReflectionSerializer
    private final <T> T fromJson(JsonElement tree) {
        int $i$f$fromJson = 0;
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.fromJson(ContextKt.getOrDefault(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), tree);
    }

    @NotNull
    public final UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public final boolean getEncodeDefaults() {
        return this.encodeDefaults;
    }

    public Json(boolean unquoted, boolean indented, @NotNull String indent, boolean strictMode, @NotNull UpdateMode updateMode, boolean encodeDefaults) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)updateMode), (String)"updateMode");
        this.unquoted = unquoted;
        this.indented = indented;
        this.indent = indent;
        this.strictMode = strictMode;
        this.updateMode = updateMode;
        this.encodeDefaults = encodeDefaults;
        SerialModule module2 = new SerialModule(){

            public void registerIn(@NotNull MutableSerialContext context) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                context.registerSerializer(Reflection.getOrCreateKotlinClass(JsonElement.class), JsonElementSerializer.INSTANCE);
                context.registerSerializer(Reflection.getOrCreateKotlinClass(JsonPrimitive.class), JsonPrimitiveSerializer.INSTANCE);
                context.registerSerializer(Reflection.getOrCreateKotlinClass(JsonLiteral.class), JsonLiteralSerializer.INSTANCE);
                context.registerSerializer(Reflection.getOrCreateKotlinClass(JsonNull.class), JsonNullSerializer.INSTANCE);
                context.registerSerializer(Reflection.getOrCreateKotlinClass(JsonObject.class), JsonObjectSerializer.INSTANCE);
                context.registerSerializer(Reflection.getOrCreateKotlinClass(JsonArray.class), JsonArraySerializer.INSTANCE);
            }
        };
        this.install(module2);
    }

    public /* synthetic */ Json(boolean bl, boolean bl2, String string, boolean bl3, UpdateMode updateMode, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            string = "    ";
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            updateMode = UpdateMode.OVERWRITE;
        }
        if ((n & 0x20) != 0) {
            bl4 = true;
        }
        this(bl, bl2, string, bl3, updateMode, bl4);
    }

    public Json() {
        this(false, false, null, false, null, false, 63, null);
    }

    static {
        Companion = new Companion(null);
        plain = new Json(false, false, null, false, null, false, 63, null);
        unquoted = new Json(true, false, null, false, null, false, 62, null);
        indented = new Json(false, true, null, false, null, false, 61, null);
        nonstrict = new Json(false, false, null, false, null, false, 55, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001e2\u0006\u0010\u001f\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006!"}, d2={"Lkotlinx/serialization/json/Json$Companion;", "Lkotlinx/serialization/StringFormat;", "()V", "context", "Lkotlinx/serialization/context/SerialContext;", "getContext", "()Lkotlinx/serialization/context/SerialContext;", "indented", "Lkotlinx/serialization/json/Json;", "getIndented", "()Lkotlinx/serialization/json/Json;", "nonstrict", "getNonstrict", "plain", "getPlain", "unquoted", "getUnquoted", "install", "", "module", "Lkotlinx/serialization/context/SerialModule;", "parse", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "string", "", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "stringify", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "kotlinx-serialization-runtime"})
    public static final class Companion
    implements StringFormat {
        @NotNull
        public final Json getPlain() {
            return plain;
        }

        @NotNull
        public final Json getUnquoted() {
            return unquoted;
        }

        @NotNull
        public final Json getIndented() {
            return indented;
        }

        @NotNull
        public final Json getNonstrict() {
            return nonstrict;
        }

        @Override
        public void install(@NotNull SerialModule module2) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            this.getPlain().install(module2);
        }

        @Override
        @NotNull
        public SerialContext getContext() {
            return Companion.getPlain().getContext();
        }

        @Override
        @NotNull
        public <T> String stringify(@NotNull SerializationStrategy<? super T> serializer, T obj) {
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            return this.getPlain().stringify(serializer, obj);
        }

        @Override
        public <T> T parse(@NotNull DeserializationStrategy<T> deserializer, @NotNull String string) {
            Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            return this.getPlain().parse(deserializer, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

