/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.ImplicitReflectionSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PlatformUtilsKt;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.context.SerialContext;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.ByteSerializer;
import kotlinx.serialization.internal.CharSerializer;
import kotlinx.serialization.internal.ClassSerialCache;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.FloatSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.internal.ShortSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.internal.UnitSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ImplicitReflectionSerializer
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\n\u001a\u00020\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J=\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0005\"\u0004\b\u0000\u0010\u00102\u0006\u0010\n\u001a\u00020\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0011J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\b\u0016R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/internal/SerialCache;", "", "()V", "allPrimitives", "", "Lkotlinx/serialization/KSerializer;", "serializerCache", "", "", "loadSerializer", "className", "kclass", "Lkotlin/reflect/KClass;", "context", "Lkotlinx/serialization/context/SerialContext;", "lookupSerializer", "E", "lookupSerializer$kotlinx_serialization_runtime", "registerSerializer", "", "classFqn", "serializer", "registerSerializer$kotlinx_serialization_runtime", "kotlinx-serialization-runtime"})
public final class SerialCache {
    private static final Map<String, KSerializer<?>> serializerCache;
    private static final List<KSerializer<?>> allPrimitives;
    public static final SerialCache INSTANCE;

    public final void registerSerializer$kotlinx_serialization_runtime(@NotNull String classFqn, @NotNull KSerializer<?> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)classFqn, (String)"classFqn");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Map<String, KSerializer<?>> map = serializerCache;
        KSerializer<?> kSerializer = serializer;
        map.put(classFqn, kSerializer);
    }

    @NotNull
    public final <E> KSerializer<E> lookupSerializer$kotlinx_serialization_runtime(@NotNull String className, @Nullable KClass<?> kclass, @Nullable SerialContext context) {
        KSerializer<?> kSerializer;
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Map<String, KSerializer<?>> $receiver$iv = serializerCache;
        KSerializer<?> value$iv = $receiver$iv.get(className);
        if (value$iv == null) {
            boolean bl = false;
            KSerializer<?> answer$iv = INSTANCE.loadSerializer(className, kclass, context);
            $receiver$iv.put(className, answer$iv);
            kSerializer = answer$iv;
        } else {
            kSerializer = value$iv;
        }
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<E>");
        }
        return kSerializer;
    }

    @NotNull
    public static /* synthetic */ KSerializer lookupSerializer$kotlinx_serialization_runtime$default(SerialCache serialCache, String string, KClass kClass, SerialContext serialContext, int n, Object object) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        if ((n & 4) != 0) {
            serialContext = null;
        }
        return serialCache.lookupSerializer$kotlinx_serialization_runtime(string, kClass, serialContext);
    }

    private final KSerializer<?> loadSerializer(String className, KClass<?> kclass, SerialContext context) {
        KSerializer<?> answer;
        KSerializer<?> kSerializer;
        KClass actualClass;
        KClass kClass = kclass;
        if (kClass == null) {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(className)");
            kClass = actualClass = JvmClassMappingKt.getKotlinClass(clazz);
        }
        if ((kSerializer = context) == null || (kSerializer = kSerializer.get(actualClass)) == null) {
            kSerializer = answer = ClassSerialCache.INSTANCE.getSubclassSerializer$kotlinx_serialization_runtime(actualClass);
        }
        if (answer != null) {
            return answer;
        }
        KSerializer kSerializer2 = PlatformUtilsKt.serializer(actualClass);
        if (kSerializer2 == null) {
            boolean bl = false;
            String string = "Can't found internal serializer for " + actualClass;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return kSerializer2;
    }

    static /* synthetic */ KSerializer loadSerializer$default(SerialCache serialCache, String string, KClass kClass, SerialContext serialContext, int n, Object object) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        if ((n & 4) != 0) {
            serialContext = null;
        }
        return serialCache.loadSerializer(string, kClass, serialContext);
    }

    private SerialCache() {
    }

    static {
        KSerializer it;
        SerialCache serialCache;
        INSTANCE = serialCache = new SerialCache();
        serializerCache = new ConcurrentHashMap();
        allPrimitives = CollectionsKt.listOf((Object[])new KSerializer[]{UnitSerializer.INSTANCE, BooleanSerializer.INSTANCE, ByteSerializer.INSTANCE, ShortSerializer.INSTANCE, IntSerializer.INSTANCE, LongSerializer.INSTANCE, FloatSerializer.INSTANCE, DoubleSerializer.INSTANCE, CharSerializer.INSTANCE, StringSerializer.INSTANCE});
        Iterable $receiver$iv = allPrimitives;
        for (Object element$iv : $receiver$iv) {
            it = (KSerializer)element$iv;
            boolean bl = false;
            INSTANCE.registerSerializer$kotlinx_serialization_runtime(it.getDescriptor().getName(), it);
        }
        $receiver$iv = CollectionsKt.toList((Iterable)ClassSerialCache.INSTANCE.getMap$kotlinx_serialization_runtime().values());
        for (Object element$iv : $receiver$iv) {
            it = (KSerializer)element$iv;
            boolean bl = false;
            INSTANCE.registerSerializer$kotlinx_serialization_runtime(it.getDescriptor().getName(), it);
        }
        serialCache.registerSerializer$kotlinx_serialization_runtime("kotlin.Array", new ReferenceArraySerializer(Reflection.getOrCreateKotlinClass(Object.class), PolymorphicSerializer.INSTANCE));
    }
}

