/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.ImplicitReflectionSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.ResolvingKt;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.PolymorphicClassDesc;
import org.jetbrains.annotations.NotNull;

@ImplicitReflectionSerializer
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/PolymorphicSerializer;", "Lkotlinx/serialization/KSerializer;", "", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "obj", "kotlinx-serialization-runtime"})
public final class PolymorphicSerializer
implements KSerializer<Object> {
    public static final PolymorphicSerializer INSTANCE;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return PolymorphicClassDesc.INSTANCE;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        KSerializer<Object> serializer = ResolvingKt.serializerByValue(obj, encoder2.getContext());
        CompositeEncoder encoder3 = encoder2.beginStructure(this.getDescriptor(), new KSerializer[0]);
        encoder3.encodeStringElement(this.getDescriptor(), 0, serializer.getDescriptor().getName());
        encoder3.encodeSerializableElement(this.getDescriptor(), 1, (SerializationStrategy)serializer, obj);
        encoder3.endStructure(this.getDescriptor());
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        CompositeDecoder decoder2 = decoder.beginStructure(this.getDescriptor(), new KSerializer[0]);
        String klassName = null;
        Object value = null;
        block6: while (true) {
            switch (decoder2.decodeElementIndex(this.getDescriptor())) {
                case -2: {
                    klassName = decoder2.decodeStringElement(this.getDescriptor(), 0);
                    KSerializer deserializer = ResolvingKt.serializerBySerialDescClassName(klassName, decoder2.getContext());
                    value = decoder2.decodeSerializableElement(this.getDescriptor(), 1, deserializer);
                    break block6;
                }
                case -1: {
                    break block6;
                }
                case 0: {
                    klassName = decoder2.decodeStringElement(this.getDescriptor(), 0);
                    break;
                }
                case 1: {
                    if (klassName == null) {
                        boolean bl = false;
                        String string = "Cannot read polymorphic value before its type token";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    KSerializer deserializer = ResolvingKt.serializerBySerialDescClassName(klassName, decoder2.getContext());
                    value = decoder2.decodeSerializableElement(this.getDescriptor(), 1, deserializer);
                    break;
                }
                default: {
                    throw (Throwable)new SerializationException("Invalid index", null, 2, null);
                }
            }
        }
        decoder2.endStructure(this.getDescriptor());
        if (value == null) {
            boolean bl = false;
            String string = "Polymorphic value have not been read";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return value;
    }

    private PolymorphicSerializer() {
    }

    static {
        PolymorphicSerializer polymorphicSerializer;
        INSTANCE = polymorphicSerializer = new PolymorphicSerializer();
    }

    @Override
    @NotNull
    public Object patch(@NotNull Decoder decoder, @NotNull Object old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return KSerializer.DefaultImpls.patch(this, decoder, old);
    }
}

