/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.swiftexport.standalone.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.sir.SirDeclaration;
import org.jetbrains.kotlin.sir.SirErrorType;
import org.jetbrains.kotlin.sir.SirExistentialType;
import org.jetbrains.kotlin.sir.SirFunctionalType;
import org.jetbrains.kotlin.sir.SirNamedDeclaration;
import org.jetbrains.kotlin.sir.SirNominalType;
import org.jetbrains.kotlin.sir.SirOrigin;
import org.jetbrains.kotlin.sir.SirProtocol;
import org.jetbrains.kotlin.sir.SirType;
import org.jetbrains.kotlin.sir.SirUnsupportedType;
import org.jetbrains.kotlin.sir.bridge.SirTypeNamer;
import org.jetbrains.kotlin.sir.providers.source.KotlinSource;
import org.jetbrains.kotlin.sir.providers.utils.KotlinRuntimeModule;
import org.jetbrains.kotlin.sir.util.SirExtensionsKt;
import org.jetbrains.kotlin.sir.util.SirSwiftModule;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/swiftexport/standalone/utils/StandaloneSirTypeNamer;", "Lorg/jetbrains/kotlin/sir/bridge/SirTypeNamer;", "<init>", "()V", "swiftFqName", "", "type", "Lorg/jetbrains/kotlin/sir/SirType;", "kotlinFqName", "Lorg/jetbrains/kotlin/sir/SirExistentialType;", "Lorg/jetbrains/kotlin/sir/SirNominalType;", "swift-export-standalone"})
@SourceDebugExtension(value={"SMAP\nStandaloneSirTypeNamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandaloneSirTypeNamer.kt\norg/jetbrains/kotlin/swiftexport/standalone/utils/StandaloneSirTypeNamer\n+ 2 KotlinSource.kt\norg/jetbrains/kotlin/sir/providers/source/KotlinSourceKt\n*L\n1#1,65:1\n37#2,3:66\n37#2,3:69\n*S KotlinDebug\n*F\n+ 1 StandaloneSirTypeNamer.kt\norg/jetbrains/kotlin/swiftexport/standalone/utils/StandaloneSirTypeNamer\n*L\n26#1:66,3\n62#1:69,3\n*E\n"})
public final class StandaloneSirTypeNamer
implements SirTypeNamer {
    @NotNull
    public static final StandaloneSirTypeNamer INSTANCE = new StandaloneSirTypeNamer();

    private StandaloneSirTypeNamer() {
    }

    @NotNull
    public String swiftFqName(@NotNull SirType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return SirExtensionsKt.getSwiftName((SirType)type);
    }

    @NotNull
    public String kotlinFqName(@NotNull SirType type) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        SirType sirType = type;
        if (sirType instanceof SirNominalType) {
            string = this.kotlinFqName((SirNominalType)type);
        } else if (sirType instanceof SirExistentialType) {
            string = this.kotlinFqName((SirExistentialType)type);
        } else {
            if (sirType instanceof SirErrorType || sirType instanceof SirFunctionalType || sirType instanceof SirUnsupportedType) {
                throw new IllegalStateException(("Type " + type + " can not be named").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String kotlinFqName(SirExistentialType type) {
        KaSymbol kaSymbol;
        SirProtocol it = (SirProtocol)CollectionsKt.single((List)type.getProtocols());
        boolean bl = false;
        SirDeclaration $this$kaSymbolOrNull$iv = (SirDeclaration)it;
        boolean $i$f$kaSymbolOrNull = false;
        SirOrigin sirOrigin = $this$kaSymbolOrNull$iv.getOrigin();
        KotlinSource kotlinSource = sirOrigin instanceof KotlinSource ? (KotlinSource)sirOrigin : null;
        if (kotlinSource == null) {
            kaSymbol = null;
        } else {
            KotlinSource kotlinOrigin$iv = kotlinSource;
            KaSymbol kaSymbol2 = kotlinOrigin$iv.getSymbol();
            if (!(kaSymbol2 instanceof KaClassLikeSymbol)) {
                kaSymbol2 = null;
            }
            kaSymbol = (KaSymbol)((KaClassLikeSymbol)kaSymbol2);
        }
        Intrinsics.checkNotNull(kaSymbol);
        ClassId classId = ((KaClassLikeSymbol)kaSymbol).getClassId();
        Intrinsics.checkNotNull((Object)classId);
        return classId.asFqNameString();
    }

    private final String kotlinFqName(SirNominalType type) {
        String string;
        SirNamedDeclaration declaration = type.getTypeDeclaration();
        if (Intrinsics.areEqual((Object)declaration, (Object)KotlinRuntimeModule.INSTANCE.getKotlinBase())) {
            string = "kotlin.Any";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getString())) {
            string = "kotlin.String";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getBool())) {
            string = "Boolean";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getInt8())) {
            string = "Byte";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getInt16())) {
            string = "Short";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getInt32())) {
            string = "Int";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getInt64())) {
            string = "Long";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getUint8())) {
            string = "UByte";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getUint16())) {
            string = "UShort";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getUint32())) {
            string = "UInt";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getUint64())) {
            string = "ULong";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getDouble())) {
            string = "Double";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getFloat())) {
            string = "Float";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getUtf16CodeUnit())) {
            string = "Char";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getUnsafeMutableRawPointer())) {
            string = "kotlin.native.internal.NativePtr";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getVoid())) {
            string = "Void";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getNever())) {
            string = "Nothing";
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getArray())) {
            string = "kotlin.collections.List<" + this.kotlinFqName((SirType)CollectionsKt.first((List)type.getTypeArguments())) + '>';
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getSet())) {
            string = "kotlin.collections.Set<" + this.kotlinFqName((SirType)CollectionsKt.first((List)type.getTypeArguments())) + '>';
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getDictionary())) {
            string = "kotlin.collections.Map<" + this.kotlinFqName((SirType)type.getTypeArguments().get(0)) + ", " + this.kotlinFqName((SirType)type.getTypeArguments().get(1)) + '>';
        } else if (Intrinsics.areEqual((Object)declaration, (Object)SirSwiftModule.INSTANCE.getOptional())) {
            string = this.kotlinFqName((SirType)CollectionsKt.first((List)type.getTypeArguments())) + '?';
        } else {
            KaSymbol kaSymbol;
            SirDeclaration $this$kaSymbolOrNull$iv = (SirDeclaration)declaration;
            boolean $i$f$kaSymbolOrNull = false;
            SirOrigin sirOrigin = $this$kaSymbolOrNull$iv.getOrigin();
            KotlinSource kotlinSource = sirOrigin instanceof KotlinSource ? (KotlinSource)sirOrigin : null;
            if (kotlinSource == null) {
                kaSymbol = null;
            } else {
                KotlinSource kotlinOrigin$iv = kotlinSource;
                KaSymbol kaSymbol2 = kotlinOrigin$iv.getSymbol();
                if (!(kaSymbol2 instanceof KaClassLikeSymbol)) {
                    kaSymbol2 = null;
                }
                kaSymbol = (KaSymbol)((KaClassLikeSymbol)kaSymbol2);
            }
            Intrinsics.checkNotNull(kaSymbol);
            ClassId classId = ((KaClassLikeSymbol)kaSymbol).getClassId();
            Intrinsics.checkNotNull((Object)classId);
            string = classId.asFqNameString();
        }
        return string;
    }
}

