/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.projectStructure;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaResolutionScope;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleProvider;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileWithId;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\f\u0010\u0017\u001a\u00020\r*\u00020\u0003H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\rH\u0016J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseResolutionScope;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaResolutionScope;", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "searchScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "analyzableModules", "", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/util/Set;)V", "virtualFileIdCache", "", "contains", "", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "cachedSearchScopeContains", "virtualFile", "isAccessibleDanglingFile", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "isAccessibleFromUseSiteModule", "underlyingSearchScope", "getUnderlyingSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getProject", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "isSearchInModuleContent", "aModule", "Lorg/jetbrains/kotlin/com/intellij/openapi/module/Module;", "isSearchInLibraries", "toString", "", "analysis-api-impl-base"})
public final class KaBaseResolutionScope
extends KaResolutionScope {
    @NotNull
    private final KaModule useSiteModule;
    @NotNull
    private final GlobalSearchScope searchScope;
    @NotNull
    private final Set<KaModule> analyzableModules;
    @NotNull
    private final int[] virtualFileIdCache;

    public KaBaseResolutionScope(@NotNull KaModule useSiteModule, @NotNull GlobalSearchScope searchScope, @NotNull Set<? extends KaModule> analyzableModules) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter(analyzableModules, (String)"analyzableModules");
        this.useSiteModule = useSiteModule;
        this.searchScope = searchScope;
        this.analyzableModules = analyzableModules;
        int n = 0;
        int[] nArray = new int[32];
        KaBaseResolutionScope kaBaseResolutionScope = this;
        while (n < 32) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        kaBaseResolutionScope.virtualFileIdCache = nArray;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.searchScope.contains(file) || this.isAccessibleDanglingFile(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return this.cachedSearchScopeContains(virtualFile);
        }
        PsiFile psiFile = element.getContainingFile();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        if (this.cachedSearchScopeContains(virtualFile2)) return true;
        Intrinsics.checkNotNull((Object)psiFile);
        if (!this.isAccessibleDanglingFile(psiFile)) return false;
        return true;
    }

    private final boolean cachedSearchScopeContains(VirtualFile virtualFile) {
        VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
        if (virtualFileWithId == null) {
            return this.searchScope.contains(virtualFile);
        }
        VirtualFileWithId virtualFileWithId2 = virtualFileWithId;
        int id2 = virtualFileWithId2.getId();
        if (id2 < 0) {
            return this.searchScope.contains(virtualFile);
        }
        int[] cache = this.virtualFileIdCache;
        int index2 = id2 % cache.length;
        if (cache[index2] == id2) {
            return true;
        }
        boolean isContained = this.searchScope.contains(virtualFile);
        if (isContained) {
            cache[index2] = id2;
        }
        return isContained;
    }

    private final boolean isAccessibleDanglingFile(PsiFile psiFile) {
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (!DanglingFilesKt.isDangling(ktFile2)) {
            return false;
        }
        KaModule kaModule = DanglingFilesKt.getContextModule(ktFile2);
        if (kaModule == null) {
            kaModule = KaModuleProvider.Companion.getModule(this.useSiteModule.getProject(), (PsiElement)ktFile2, this.useSiteModule);
        }
        KaModule module = kaModule;
        return this.isAccessibleFromUseSiteModule(module);
    }

    private final boolean isAccessibleDanglingFile(VirtualFile virtualFile) {
        KaModule kaModule = ContextModuleKt.getAnalysisContextModule(virtualFile);
        return kaModule != null ? this.isAccessibleFromUseSiteModule(kaModule) : false;
    }

    private final boolean isAccessibleFromUseSiteModule(KaModule $this$isAccessibleFromUseSiteModule) {
        return this.analyzableModules.contains($this$isAccessibleFromUseSiteModule);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUnderlyingSearchScope() {
        return this.searchScope;
    }

    @Nullable
    public Project getProject() {
        return this.searchScope.getProject();
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return this.searchScope.isSearchInModuleContent(aModule);
    }

    public boolean isSearchInLibraries() {
        return this.searchScope.isSearchInLibraries();
    }

    @NotNull
    public String toString() {
        return "Resolution scope for '" + this.useSiteModule + "'. Underlying search scope: '" + this.searchScope + '\'';
    }
}

