/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.providers.impl.BridgeProvider;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.sir.SirArrayType;
import org.jetbrains.kotlin.sir.SirExistentialType;
import org.jetbrains.kotlin.sir.SirFunctionalType;
import org.jetbrains.kotlin.sir.SirNominalType;
import org.jetbrains.kotlin.sir.SirParameter;
import org.jetbrains.kotlin.sir.SirScopeDefiningDeclaration;
import org.jetbrains.kotlin.sir.SirType;
import org.jetbrains.kotlin.sir.SirTypealias;
import org.jetbrains.kotlin.sir.providers.impl.BridgeProvider.Bridge;
import org.jetbrains.kotlin.sir.providers.impl.BridgeProvider.BridgeParameter;
import org.jetbrains.kotlin.sir.providers.impl.BridgeProvider.CType;
import org.jetbrains.kotlin.sir.providers.impl.BridgeProvider.KotlinType;
import org.jetbrains.kotlin.sir.providers.impl.BridgeProvider.StringUtilsKt;
import org.jetbrains.kotlin.sir.providers.utils.KotlinRuntimeSupportModule;
import org.jetbrains.kotlin.sir.util.SirExtensionsKt;
import org.jetbrains.kotlin.sir.util.SirPlatformModule;
import org.jetbrains.kotlin.sir.util.SirSwiftModule;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a*\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0017H\u0002\"\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0018"}, d2={"bridgeType", "Lorg/jetbrains/kotlin/sir/providers/impl/BridgeProvider/Bridge;", "type", "Lorg/jetbrains/kotlin/sir/SirType;", "bridgeTypeForVariadicParameter", "bridgeExistential", "Lorg/jetbrains/kotlin/sir/SirExistentialType;", "bridgeAsNSCollectionElement", "bridgeNominalType", "Lorg/jetbrains/kotlin/sir/SirNominalType;", "bridgeParameter", "Lorg/jetbrains/kotlin/sir/providers/impl/BridgeProvider/BridgeParameter;", "parameter", "Lorg/jetbrains/kotlin/sir/SirParameter;", "index", "", "isChar", "", "(Lorg/jetbrains/kotlin/sir/SirType;)Z", "mapSwift", "", "temporalName", "transform", "Lkotlin/Function1;", "sir-providers"})
@SourceDebugExtension(value={"SMAP\nTypeBridging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeBridging.kt\norg/jetbrains/kotlin/sir/providers/impl/BridgeProvider/TypeBridgingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,684:1\n1#2:685\n*E\n"})
public final class TypeBridgingKt {
    @NotNull
    public static final Bridge bridgeType(@NotNull SirType type2) {
        Bridge bridge;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        SirType sirType = type2;
        if (sirType instanceof SirNominalType) {
            bridge = TypeBridgingKt.bridgeNominalType((SirNominalType)type2);
        } else if (sirType instanceof SirExistentialType) {
            bridge = TypeBridgingKt.bridgeExistential((SirExistentialType)type2);
        } else if (sirType instanceof SirFunctionalType) {
            bridge = Bridge.AsBlock.Companion.invoke((SirFunctionalType)type2);
        } else {
            throw new IllegalStateException(("Attempt to bridge unbridgeable type: " + type2 + '.').toString());
        }
        return bridge;
    }

    private static final Bridge bridgeTypeForVariadicParameter(SirType type2) {
        return new Bridge.AsNSArrayForVariadic((SirNominalType)new SirArrayType(type2), TypeBridgingKt.bridgeAsNSCollectionElement(type2));
    }

    private static final Bridge bridgeExistential(SirExistentialType type2) {
        if (Intrinsics.areEqual((Object)CollectionsKt.singleOrNull(type2.getProtocols()), (Object)KotlinRuntimeSupportModule.INSTANCE.getKotlinBridgeable())) {
            return Bridge.AsAnyBridgeable.INSTANCE;
        }
        return new Bridge.AsExistential(type2, KotlinType.KotlinObject, (CType)CType.Object.INSTANCE);
    }

    private static final Bridge bridgeAsNSCollectionElement(SirType type2) {
        Bridge bridge;
        Bridge bridge2 = TypeBridgingKt.bridgeType(type2);
        if (bridge2 instanceof Bridge.AsIs) {
            bridge = new Bridge.AsNSNumber(bridge2.getSwiftType());
        } else if (bridge2 instanceof Bridge.AsOptionalWrapper) {
            bridge = new Bridge.AsObjCBridgedOptional(((Bridge.AsOptionalWrapper)bridge2).getWrappedObject().getSwiftType());
        } else if (bridge2 instanceof Bridge.AsOptionalNothing) {
            bridge = new Bridge.AsObjCBridgedOptional(bridge2.getSwiftType());
        } else if (bridge2 instanceof Bridge.AsObject || bridge2 instanceof Bridge.AsExistential || bridge2 instanceof Bridge.AsAnyBridgeable || bridge2 instanceof Bridge.AsOpaqueObject) {
            bridge = new Bridge.AsObjCBridged(bridge2.getSwiftType(), CType.id.INSTANCE);
        } else if (bridge2 instanceof Bridge.AsBlock || bridge2 instanceof Bridge.AsObjCBridged || Intrinsics.areEqual((Object)bridge2, (Object)Bridge.AsOutError.INSTANCE) || Intrinsics.areEqual((Object)bridge2, (Object)Bridge.AsVoid.INSTANCE)) {
            bridge = bridge2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bridge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Bridge bridgeNominalType(SirNominalType type2) {
        Bridge bridge;
        SirScopeDefiningDeclaration subtype = type2.getTypeDeclaration();
        if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getVoid())) {
            bridge = Bridge.AsVoid.INSTANCE;
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getBool())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Boolean, CType.Bool.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getInt8())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Byte, CType.Int8.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getInt16())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Short, CType.Int16.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getInt32())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Int, CType.Int32.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getInt64())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Long, CType.Int64.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getUint8())) {
            bridge = new Bridge.AsIs(type2, KotlinType.UByte, CType.UInt8.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getUint16())) {
            bridge = new Bridge.AsIs(type2, KotlinType.UShort, CType.UInt16.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getUint32())) {
            bridge = new Bridge.AsIs(type2, KotlinType.UInt, CType.UInt32.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getUint64())) {
            bridge = new Bridge.AsIs(type2, KotlinType.ULong, CType.UInt64.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getDouble())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Double, CType.Double.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getFloat())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Float, CType.Float.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getUnsafeMutableRawPointer())) {
            bridge = new Bridge.AsOpaqueObject(type2, KotlinType.KotlinObject, CType.Object.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getNever())) {
            bridge = new Bridge.AsOpaqueObject(type2, KotlinType.KotlinObject, CType.Void.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getString())) {
            bridge = new Bridge.AsObjCBridged(type2, CType.NSString.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getUtf16CodeUnit())) {
            bridge = new Bridge.AsIs(type2, KotlinType.Char, CType.UInt16.INSTANCE);
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getOptional())) {
            Bridge bridge2 = TypeBridgingKt.bridgeType((SirType)CollectionsKt.first(type2.getTypeArguments()));
            if (bridge2 instanceof Bridge.AsObject || bridge2 instanceof Bridge.AsObjCBridged || bridge2 instanceof Bridge.AsExistential || bridge2 instanceof Bridge.AsAnyBridgeable || bridge2 instanceof Bridge.AsBlock) {
                bridge = new Bridge.AsOptionalWrapper(bridge2);
                return bridge;
            } else if (bridge2 instanceof Bridge.AsOpaqueObject) {
                if (!SirExtensionsKt.isNever(bridge2.getSwiftType())) {
                    throw new IllegalStateException("Found Optional wrapping for OpaqueObject. That is impossible".toString());
                }
                bridge = Bridge.AsOptionalNothing.INSTANCE;
                return bridge;
            } else {
                if (!(bridge2 instanceof Bridge.AsIs)) throw new IllegalStateException(("Found Optional wrapping for " + bridge2 + ". That is currently unsupported. See KT-66875").toString());
                bridge = new Bridge.AsOptionalWrapper(TypeBridgingKt.isChar(bridge2.getSwiftType()) ? (Bridge.AsNSNumber)new Bridge.OptionalChar(bridge2.getSwiftType()) : new Bridge.AsNSNumber(bridge2.getSwiftType()));
            }
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getArray())) {
            bridge = new Bridge.AsNSArray(type2, TypeBridgingKt.bridgeAsNSCollectionElement((SirType)CollectionsKt.single(type2.getTypeArguments())));
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getSet())) {
            bridge = new Bridge.AsNSSet(type2, TypeBridgingKt.bridgeAsNSCollectionElement((SirType)CollectionsKt.single(type2.getTypeArguments())));
            return bridge;
        } else if (Intrinsics.areEqual((Object)subtype, (Object)SirSwiftModule.INSTANCE.getDictionary())) {
            List<SirType> list = type2.getTypeArguments();
            SirType key = list.get(0);
            SirType value = list.get(1);
            bridge = new Bridge.AsNSDictionary(type2, TypeBridgingKt.bridgeAsNSCollectionElement(key), TypeBridgingKt.bridgeAsNSCollectionElement(value));
            return bridge;
        } else {
            bridge = subtype instanceof SirTypealias ? TypeBridgingKt.bridgeType(((SirTypealias)subtype).getType()) : (type2.getTypeDeclaration().getParent() instanceof SirPlatformModule ? (Bridge)new Bridge.AsNSObject(type2) : (Bridge)new Bridge.AsObject(type2, KotlinType.KotlinObject, (CType)CType.Object.INSTANCE));
        }
        return bridge;
    }

    @NotNull
    public static final BridgeParameter bridgeParameter(@NotNull SirParameter parameter, int index2) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                string = SirExtensionsKt.getName(parameter);
                if (string == null) break block2;
                String p0 = string;
                boolean bl = false;
                String string2 = StringUtilsKt.createBridgeParameterName(p0);
                string = string2;
                if (string2 != null) break block3;
            }
            string = "" + '_' + index2;
        }
        String bridgeParameterName = string;
        Bridge bridge = parameter.isVariadic() ? TypeBridgingKt.bridgeTypeForVariadicParameter(parameter.getType()) : TypeBridgingKt.bridgeType(parameter.getType());
        return new BridgeParameter(bridgeParameterName, bridge, parameter.getOrigin() != null);
    }

    public static final boolean isChar(@NotNull SirType $this$isChar) {
        Intrinsics.checkNotNullParameter((Object)$this$isChar, (String)"<this>");
        return $this$isChar instanceof SirNominalType && Intrinsics.areEqual((Object)((SirNominalType)$this$isChar).getTypeDeclaration(), (Object)SirSwiftModule.INSTANCE.getUtf16CodeUnit());
    }

    /*
     * WARNING - void declaration
     */
    private static final String mapSwift(String $this$mapSwift, String temporalName, Function1<? super String, String> transform) {
        String string;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                void it;
                Object object = transform.invoke((Object)temporalName);
                String it2 = (String)object;
                boolean $i$a$-takeIf-TypeBridgingKt$mapSwift$adapter$22 = false;
                String adapter = (String)(!Intrinsics.areEqual((Object)it2, (Object)temporalName) ? object : null);
                stringBuilder = new StringBuilder().append($this$mapSwift);
                string = adapter;
                if (string == null) break block2;
                String $i$a$-takeIf-TypeBridgingKt$mapSwift$adapter$22 = string;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string2 = ".map { " + temporalName + " in " + (String)it + " }";
                stringBuilder = stringBuilder2;
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    static /* synthetic */ String mapSwift$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "it";
        }
        return TypeBridgingKt.mapSwift(string, string2, (Function1<? super String, String>)function1);
    }
}

