/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.swiftexport.standalone.config;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.swiftexport.standalone.ErrorTypeStrategy;
import org.jetbrains.kotlin.swiftexport.standalone.InputModule;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportLogger;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportRunnerKt;
import org.jetbrains.kotlin.swiftexport.standalone.config.SwiftModuleConfig;
import org.jetbrains.kotlin.utils.KotlinNativePaths;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u00108\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020)0/2\u0006\u0010:\u001a\u00020;H\u0002J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u0005H\u00c6\u0003J\t\u0010>\u001a\u00020\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\bH\u00c6\u0003J\t\u0010@\u001a\u00020\nH\u00c6\u0003J\t\u0010A\u001a\u00020\fH\u00c6\u0003J\t\u0010B\u001a\u00020\fH\u00c6\u0003J\t\u0010C\u001a\u00020\u000fH\u00c6\u0003JY\u0010D\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0014\u0010E\u001a\u00020\u00052\b\u0010F\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010G\u001a\u00020HH\u00d6\u0081\u0004J\n\u0010I\u001a\u00020!H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u001b\u0010(\u001a\u00020)8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+R!\u0010.\u001a\b\u0012\u0004\u0012\u00020)0/8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010-\u001a\u0004\b0\u00101R\u001b\u00103\u001a\u0002048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010-\u001a\u0004\b5\u00106\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/swiftexport/standalone/config/SwiftExportConfig;", "", "outputPath", "Ljava/nio/file/Path;", "stableDeclarationsOrder", "", "renderDocComments", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "errorTypeStrategy", "Lorg/jetbrains/kotlin/swiftexport/standalone/ErrorTypeStrategy;", "unsupportedTypeStrategy", "logger", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportLogger;", "<init>", "(Ljava/nio/file/Path;ZZLorg/jetbrains/kotlin/konan/target/Distribution;Lorg/jetbrains/kotlin/konan/target/KonanTarget;Lorg/jetbrains/kotlin/swiftexport/standalone/ErrorTypeStrategy;Lorg/jetbrains/kotlin/swiftexport/standalone/ErrorTypeStrategy;Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportLogger;)V", "getOutputPath", "()Ljava/nio/file/Path;", "getStableDeclarationsOrder", "()Z", "getRenderDocComments", "getDistribution", "()Lorg/jetbrains/kotlin/konan/target/Distribution;", "getKonanTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getErrorTypeStrategy", "()Lorg/jetbrains/kotlin/swiftexport/standalone/ErrorTypeStrategy;", "getUnsupportedTypeStrategy", "getLogger", "()Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportLogger;", "moduleForPackagesName", "", "getModuleForPackagesName", "()Ljava/lang/String;", "runtimeSupportModuleName", "getRuntimeSupportModuleName", "runtimeModuleName", "getRuntimeModuleName", "stdlibInputModule", "Lorg/jetbrains/kotlin/swiftexport/standalone/InputModule;", "getStdlibInputModule", "()Lorg/jetbrains/kotlin/swiftexport/standalone/InputModule;", "stdlibInputModule$delegate", "Lkotlin/Lazy;", "platformLibsInputModule", "", "getPlatformLibsInputModule", "()Ljava/util/Set;", "platformLibsInputModule$delegate", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "targetPlatform$delegate", "createInputModuleForStdlib", "createInputModuleForPlatformLibs", "platformLibsRootFile", "Ljava/io/File;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "swift-export-standalone"})
@SourceDebugExtension(value={"SMAP\nSwiftExportConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftExportConfig.kt\norg/jetbrains/kotlin/swiftexport/standalone/config/SwiftExportConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,56:1\n11704#2:57\n12051#2,3:58\n*S KotlinDebug\n*F\n+ 1 SwiftExportConfig.kt\norg/jetbrains/kotlin/swiftexport/standalone/config/SwiftExportConfig\n*L\n48#1:57\n48#1:58,3\n*E\n"})
public final class SwiftExportConfig {
    @NotNull
    private final Path outputPath;
    private final boolean stableDeclarationsOrder;
    private final boolean renderDocComments;
    @NotNull
    private final Distribution distribution;
    @NotNull
    private final KonanTarget konanTarget;
    @NotNull
    private final ErrorTypeStrategy errorTypeStrategy;
    @NotNull
    private final ErrorTypeStrategy unsupportedTypeStrategy;
    @NotNull
    private final SwiftExportLogger logger;
    @NotNull
    private final String moduleForPackagesName;
    @NotNull
    private final String runtimeSupportModuleName;
    @NotNull
    private final String runtimeModuleName;
    @NotNull
    private final Lazy stdlibInputModule$delegate;
    @NotNull
    private final Lazy platformLibsInputModule$delegate;
    @NotNull
    private final Lazy targetPlatform$delegate;

    public SwiftExportConfig(@NotNull Path outputPath, boolean stableDeclarationsOrder, boolean renderDocComments, @NotNull Distribution distribution, @NotNull KonanTarget konanTarget, @NotNull ErrorTypeStrategy errorTypeStrategy, @NotNull ErrorTypeStrategy unsupportedTypeStrategy, @NotNull SwiftExportLogger logger) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeStrategy), (String)"errorTypeStrategy");
        Intrinsics.checkNotNullParameter((Object)((Object)unsupportedTypeStrategy), (String)"unsupportedTypeStrategy");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.outputPath = outputPath;
        this.stableDeclarationsOrder = stableDeclarationsOrder;
        this.renderDocComments = renderDocComments;
        this.distribution = distribution;
        this.konanTarget = konanTarget;
        this.errorTypeStrategy = errorTypeStrategy;
        this.unsupportedTypeStrategy = unsupportedTypeStrategy;
        this.logger = logger;
        this.moduleForPackagesName = "ExportedKotlinPackages";
        this.runtimeSupportModuleName = "KotlinRuntimeSupport";
        this.runtimeModuleName = "KotlinRuntime";
        this.stdlibInputModule$delegate = LazyKt.lazy(() -> SwiftExportConfig.stdlibInputModule_delegate$lambda$0(this));
        this.platformLibsInputModule$delegate = LazyKt.lazy(() -> SwiftExportConfig.platformLibsInputModule_delegate$lambda$0(this));
        this.targetPlatform$delegate = LazyKt.lazy(() -> SwiftExportConfig.targetPlatform_delegate$lambda$0(this));
    }

    public /* synthetic */ SwiftExportConfig(Path path, boolean bl, boolean bl2, Distribution distribution, KonanTarget konanTarget, ErrorTypeStrategy errorTypeStrategy, ErrorTypeStrategy errorTypeStrategy2, SwiftExportLogger swiftExportLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            String string = KotlinNativePaths.INSTANCE.getHomePath().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            distribution = new Distribution(string, false, null, null, null, 30, null);
        }
        if ((n & 0x20) != 0) {
            errorTypeStrategy = ErrorTypeStrategy.Fail;
        }
        if ((n & 0x40) != 0) {
            errorTypeStrategy2 = ErrorTypeStrategy.SpecialType;
        }
        if ((n & 0x80) != 0) {
            swiftExportLogger = SwiftExportRunnerKt.createDummyLogger();
        }
        this(path, bl, bl2, distribution, konanTarget, errorTypeStrategy, errorTypeStrategy2, swiftExportLogger);
    }

    @NotNull
    public final Path getOutputPath() {
        return this.outputPath;
    }

    public final boolean getStableDeclarationsOrder() {
        return this.stableDeclarationsOrder;
    }

    public final boolean getRenderDocComments() {
        return this.renderDocComments;
    }

    @NotNull
    public final Distribution getDistribution() {
        return this.distribution;
    }

    @NotNull
    public final KonanTarget getKonanTarget() {
        return this.konanTarget;
    }

    @NotNull
    public final ErrorTypeStrategy getErrorTypeStrategy() {
        return this.errorTypeStrategy;
    }

    @NotNull
    public final ErrorTypeStrategy getUnsupportedTypeStrategy() {
        return this.unsupportedTypeStrategy;
    }

    @NotNull
    public final SwiftExportLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getModuleForPackagesName() {
        return this.moduleForPackagesName;
    }

    @NotNull
    public final String getRuntimeSupportModuleName() {
        return this.runtimeSupportModuleName;
    }

    @NotNull
    public final String getRuntimeModuleName() {
        return this.runtimeModuleName;
    }

    @NotNull
    public final InputModule getStdlibInputModule() {
        Lazy lazy = this.stdlibInputModule$delegate;
        return (InputModule)lazy.getValue();
    }

    @NotNull
    public final Set<InputModule> getPlatformLibsInputModule() {
        Lazy lazy = this.platformLibsInputModule$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final TargetPlatform getTargetPlatform() {
        Lazy lazy = this.targetPlatform$delegate;
        return (TargetPlatform)lazy.getValue();
    }

    private final InputModule createInputModuleForStdlib(Distribution distribution) {
        Path path = Paths.get(distribution.getStdlib(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return new InputModule("KotlinStdlib", path, new SwiftModuleConfig(null, null, null, null, false, 15, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<InputModule> createInputModuleForPlatformLibs(File platformLibsRootFile) {
        void $this$mapTo$iv$iv;
        String[] stringArray = platformLibsRootFile.list();
        Intrinsics.checkNotNull((Object)stringArray);
        String[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        String[] stringArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String[] stringArray3 = new String[]{"."};
            String string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray3, (boolean)false, (int)0, (int)6, null));
            Path path = FilesKt.resolve((File)platformLibsRootFile, (String)it).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            collection.add(new InputModule(string, path, new SwiftModuleConfig(null, null, null, null, false, 15, null)));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Path component1() {
        return this.outputPath;
    }

    public final boolean component2() {
        return this.stableDeclarationsOrder;
    }

    public final boolean component3() {
        return this.renderDocComments;
    }

    @NotNull
    public final Distribution component4() {
        return this.distribution;
    }

    @NotNull
    public final KonanTarget component5() {
        return this.konanTarget;
    }

    @NotNull
    public final ErrorTypeStrategy component6() {
        return this.errorTypeStrategy;
    }

    @NotNull
    public final ErrorTypeStrategy component7() {
        return this.unsupportedTypeStrategy;
    }

    @NotNull
    public final SwiftExportLogger component8() {
        return this.logger;
    }

    @NotNull
    public final SwiftExportConfig copy(@NotNull Path outputPath, boolean stableDeclarationsOrder, boolean renderDocComments, @NotNull Distribution distribution, @NotNull KonanTarget konanTarget, @NotNull ErrorTypeStrategy errorTypeStrategy, @NotNull ErrorTypeStrategy unsupportedTypeStrategy, @NotNull SwiftExportLogger logger) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeStrategy), (String)"errorTypeStrategy");
        Intrinsics.checkNotNullParameter((Object)((Object)unsupportedTypeStrategy), (String)"unsupportedTypeStrategy");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        return new SwiftExportConfig(outputPath, stableDeclarationsOrder, renderDocComments, distribution, konanTarget, errorTypeStrategy, unsupportedTypeStrategy, logger);
    }

    public static /* synthetic */ SwiftExportConfig copy$default(SwiftExportConfig swiftExportConfig, Path path, boolean bl, boolean bl2, Distribution distribution, KonanTarget konanTarget, ErrorTypeStrategy errorTypeStrategy, ErrorTypeStrategy errorTypeStrategy2, SwiftExportLogger swiftExportLogger, int n, Object object) {
        if ((n & 1) != 0) {
            path = swiftExportConfig.outputPath;
        }
        if ((n & 2) != 0) {
            bl = swiftExportConfig.stableDeclarationsOrder;
        }
        if ((n & 4) != 0) {
            bl2 = swiftExportConfig.renderDocComments;
        }
        if ((n & 8) != 0) {
            distribution = swiftExportConfig.distribution;
        }
        if ((n & 0x10) != 0) {
            konanTarget = swiftExportConfig.konanTarget;
        }
        if ((n & 0x20) != 0) {
            errorTypeStrategy = swiftExportConfig.errorTypeStrategy;
        }
        if ((n & 0x40) != 0) {
            errorTypeStrategy2 = swiftExportConfig.unsupportedTypeStrategy;
        }
        if ((n & 0x80) != 0) {
            swiftExportLogger = swiftExportConfig.logger;
        }
        return swiftExportConfig.copy(path, bl, bl2, distribution, konanTarget, errorTypeStrategy, errorTypeStrategy2, swiftExportLogger);
    }

    @NotNull
    public String toString() {
        return "SwiftExportConfig(outputPath=" + this.outputPath + ", stableDeclarationsOrder=" + this.stableDeclarationsOrder + ", renderDocComments=" + this.renderDocComments + ", distribution=" + this.distribution + ", konanTarget=" + this.konanTarget + ", errorTypeStrategy=" + (Object)((Object)this.errorTypeStrategy) + ", unsupportedTypeStrategy=" + (Object)((Object)this.unsupportedTypeStrategy) + ", logger=" + this.logger + ')';
    }

    public int hashCode() {
        int result = ((Object)this.outputPath).hashCode();
        result = result * 31 + Boolean.hashCode(this.stableDeclarationsOrder);
        result = result * 31 + Boolean.hashCode(this.renderDocComments);
        result = result * 31 + this.distribution.hashCode();
        result = result * 31 + this.konanTarget.hashCode();
        result = result * 31 + this.errorTypeStrategy.hashCode();
        result = result * 31 + this.unsupportedTypeStrategy.hashCode();
        result = result * 31 + this.logger.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwiftExportConfig)) {
            return false;
        }
        SwiftExportConfig swiftExportConfig = (SwiftExportConfig)other;
        if (!Intrinsics.areEqual((Object)this.outputPath, (Object)swiftExportConfig.outputPath)) {
            return false;
        }
        if (this.stableDeclarationsOrder != swiftExportConfig.stableDeclarationsOrder) {
            return false;
        }
        if (this.renderDocComments != swiftExportConfig.renderDocComments) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.distribution, (Object)swiftExportConfig.distribution)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.konanTarget, (Object)swiftExportConfig.konanTarget)) {
            return false;
        }
        if (this.errorTypeStrategy != swiftExportConfig.errorTypeStrategy) {
            return false;
        }
        if (this.unsupportedTypeStrategy != swiftExportConfig.unsupportedTypeStrategy) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.logger, (Object)swiftExportConfig.logger);
    }

    private static final InputModule stdlibInputModule_delegate$lambda$0(SwiftExportConfig this$0) {
        return this$0.createInputModuleForStdlib(this$0.distribution);
    }

    private static final Set platformLibsInputModule_delegate$lambda$0(SwiftExportConfig this$0) {
        Path path = Paths.get(this$0.distribution.platformLibs(this$0.konanTarget), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this$0.createInputModuleForPlatformLibs(file);
    }

    private static final TargetPlatform targetPlatform_delegate$lambda$0(SwiftExportConfig this$0) {
        return NativePlatforms.INSTANCE.nativePlatformBySingleTarget(this$0.konanTarget);
    }
}

