/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0010J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00062\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0010R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\n\u001a-\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneIndexCache;", "", "<init>", "()V", "stubs", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "roots", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneIndexCache$SharedIndexableDecompiledFile;", "getOrBuildStub", "compiledFile", "stubBuilder", "Lkotlin/Function1;", "getOrProcessBinaryRoot", "binaryRoot", "processRoot", "SharedIndexableDecompiledFile", "analysis-api-standalone-base"})
public final class KotlinStandaloneIndexCache {
    @NotNull
    private final ConcurrentMap<VirtualFile, KotlinFileStubImpl> stubs;
    @NotNull
    private final ConcurrentMap<VirtualFile, Set<SharedIndexableDecompiledFile>> roots;

    public KotlinStandaloneIndexCache() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakKeySoftValueMap(...)");
        this.stubs = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakKeySoftValueMap(...)");
        this.roots = concurrentMap2;
    }

    @NotNull
    public final KotlinFileStubImpl getOrBuildStub(@NotNull VirtualFile compiledFile, @NotNull Function1<? super VirtualFile, KotlinFileStubImpl> stubBuilder) {
        Intrinsics.checkNotNullParameter((Object)compiledFile, (String)"compiledFile");
        Intrinsics.checkNotNullParameter(stubBuilder, (String)"stubBuilder");
        KotlinFileStubImpl kotlinFileStubImpl = this.stubs.computeIfAbsent(compiledFile, arg_0 -> KotlinStandaloneIndexCache.getOrBuildStub$lambda$0(stubBuilder, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileStubImpl, (String)"computeIfAbsent(...)");
        return kotlinFileStubImpl;
    }

    @NotNull
    public final Set<SharedIndexableDecompiledFile> getOrProcessBinaryRoot(@NotNull VirtualFile binaryRoot, @NotNull Function1<? super VirtualFile, ? extends Set<SharedIndexableDecompiledFile>> processRoot) {
        Intrinsics.checkNotNullParameter((Object)binaryRoot, (String)"binaryRoot");
        Intrinsics.checkNotNullParameter(processRoot, (String)"processRoot");
        Set set = this.roots.computeIfAbsent(binaryRoot, arg_0 -> KotlinStandaloneIndexCache.getOrProcessBinaryRoot$lambda$1(arg_0 -> KotlinStandaloneIndexCache.getOrProcessBinaryRoot$lambda$0(processRoot, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        return set;
    }

    private static final KotlinFileStubImpl getOrBuildStub$lambda$0(Function1 $tmp0, Object p0) {
        return (KotlinFileStubImpl)$tmp0.invoke(p0);
    }

    private static final Set getOrProcessBinaryRoot$lambda$0(Function1 $processRoot, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return (Set)$processRoot.invoke((Object)it);
    }

    private static final Set getOrProcessBinaryRoot$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneIndexCache$SharedIndexableDecompiledFile;", "", "virtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "kotlinDecompiler", "Lorg/jetbrains/kotlin/com/intellij/psi/compiled/ClassFileDecompilers$Full;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKotlinDecompiler", "()Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "equals", "", "other", "hashCode", "", "toString", "", "analysis-api-standalone-base"})
    public static final class SharedIndexableDecompiledFile {
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final ClassFileDecompilers.Full kotlinDecompiler;

        public SharedIndexableDecompiledFile(@NotNull VirtualFile virtualFile, @NotNull ClassFileDecompilers.Full kotlinDecompiler) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)kotlinDecompiler, (String)"kotlinDecompiler");
            this.virtualFile = virtualFile;
            this.kotlinDecompiler = kotlinDecompiler;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final ClassFileDecompilers.Full getKotlinDecompiler() {
            return this.kotlinDecompiler;
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof SharedIndexableDecompiledFile && Intrinsics.areEqual((Object)this.virtualFile, (Object)((SharedIndexableDecompiledFile)other).virtualFile);
        }

        public int hashCode() {
            return this.virtualFile.hashCode();
        }

        @NotNull
        public String toString() {
            return this.virtualFile + " (" + Reflection.getOrCreateKotlinClass(this.kotlinDecompiler.getClass()).getSimpleName() + ')';
        }
    }
}

