/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactoryKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionKt;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/FirSyntheticFunctionInterfaceSourceProvider;", "", "<init>", "()V", "findPsi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "fir", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "provideSourceForInvokeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "provideSourceForFunctionClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "classByClassId", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "ktModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "classIdMapping", "", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirSyntheticFunctionInterfaceSourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSyntheticFunctionInterfaceSourceProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/FirSyntheticFunctionInterfaceSourceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n295#2,2:58\n1204#2,2:60\n1281#2,4:62\n*S KotlinDebug\n*F\n+ 1 FirSyntheticFunctionInterfaceSourceProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/FirSyntheticFunctionInterfaceSourceProvider\n*L\n50#1:58,2\n53#1:60,2\n53#1:62,4\n*E\n"})
public final class FirSyntheticFunctionInterfaceSourceProvider {
    @NotNull
    public static final FirSyntheticFunctionInterfaceSourceProvider INSTANCE;
    @NotNull
    private static final Map<ClassId, ClassId> classIdMapping;

    private FirSyntheticFunctionInterfaceSourceProvider() {
    }

    @Nullable
    public final PsiElement findPsi(@NotNull FirDeclaration fir, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        FirDeclaration firDeclaration = fir;
        return firDeclaration instanceof FirSimpleFunction ? this.provideSourceForInvokeFunction((FirSimpleFunction)fir, scope) : (firDeclaration instanceof FirClass ? this.provideSourceForFunctionClass((FirClass)fir, scope) : null);
    }

    private final PsiElement provideSourceForInvokeFunction(FirSimpleFunction function, GlobalSearchScope scope) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)((FirCallableDeclaration)function));
        if (coneClassLikeLookupTag == null || (coneClassLikeLookupTag = coneClassLikeLookupTag.getClassId()) == null) {
            return null;
        }
        ConeClassLikeLookupTag classId = coneClassLikeLookupTag;
        KtClassOrObject ktClassOrObject = this.classByClassId((ClassId)classId, scope, LLFirSessionKt.getLlFirSession((FirElementWithResolveState)function).getKtModule());
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return (PsiElement)CollectionsKt.singleOrNull((List)classOrObject.getDeclarations());
    }

    private final PsiElement provideSourceForFunctionClass(FirClass klass, GlobalSearchScope scope) {
        return (PsiElement)this.classByClassId(klass.getSymbol().getClassId(), scope, LLFirSessionKt.getLlFirSession((FirElementWithResolveState)klass).getKtModule());
    }

    /*
     * WARNING - void declaration
     */
    private final KtClassOrObject classByClassId(ClassId classId, GlobalSearchScope scope, KaModule ktModule) {
        Object v1;
        block3: {
            void $this$firstOrNull$iv;
            Project project = ktModule.getProject();
            ClassId classId2 = classIdMapping.get(classId);
            if (classId2 == null) {
                return null;
            }
            ClassId correctedClassId = classId2;
            if (!(ktModule instanceof KaBuiltinsModule)) {
                boolean $i$a$-require-FirSyntheticFunctionInterfaceSourceProvider$classByClassId$22 = false;
                String $i$a$-require-FirSyntheticFunctionInterfaceSourceProvider$classByClassId$22 = "Expected builtin module but found " + ktModule;
                throw new IllegalArgumentException($i$a$-require-FirSyntheticFunctionInterfaceSourceProvider$classByClassId$22.toString());
            }
            Iterable iterable = KotlinDeclarationProviderFactoryKt.createDeclarationProvider(project, scope, ktModule).getAllClassesByClassId(correctedClassId);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl = false;
                if (!it.getContainingKtFile().isCompiled()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        INSTANCE = new FirSyntheticFunctionInterfaceSourceProvider();
        Iterable $this$associate$iv = (Iterable)new IntRange(0, 23);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator).nextInt();
            Map map = destination$iv$iv;
            int i2 = element$iv$iv;
            boolean bl = false;
            ClassId classId = StandardClassIds.INSTANCE.FunctionN(i2);
            FqName fqName = new FqName("kotlin.jvm.functions");
            Name name = Name.identifier((String)("Function" + i2));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            Pair pair = TuplesKt.to((Object)classId, (Object)new ClassId(fqName, name));
            map.put(pair.getFirst(), pair.getSecond());
        }
        classIdMapping = destination$iv$iv;
    }
}

