/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.packages;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProvider;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProviderBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProvider;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "searchScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "doesPackageExist", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "doesPlatformSpecificPackageExist", "getSubpackageNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getPlatformSpecificSubpackageNames", "analysis-api-platform-interface"})
@SourceDebugExtension(value={"SMAP\nKotlinPackageProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProviderBase\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/api/platform/utils/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n12#2,7:73\n12#2,5:80\n18#2:86\n1#3:85\n*S KotlinDebug\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProviderBase\n*L\n28#1:73,7\n57#1:80,5\n57#1:86\n*E\n"})
public abstract class KotlinPackageProviderBase
implements KotlinPackageProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public KotlinPackageProviderBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        this.project = project;
        this.searchScope = searchScope;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Override
    public boolean doesPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return this.doesPlatformSpecificPackageExist(packageFqName, platform) || this.doesKotlinOnlyPackageExist(packageFqName);
    }

    @Override
    public boolean doesPlatformSpecificPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (JvmPlatformKt.isJvm((TargetPlatform)platform)) {
            String fqNameString = packageFqName.asString();
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint((AreaInstance)project$iv).getExtensionList()) {
                if (Intrinsics.areEqual((Object)finder$iv.getClass().getName(), (Object)"org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull((Object)finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl = false;
                PsiPackage psiPackage = finder.findPackage(fqNameString);
                if (psiPackage == null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<Name> getSubpackageNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Set $this$getSubpackageNames_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getSubpackageNames_u24lambda_u240.addAll((Collection)this.getKotlinOnlySubpackageNames(packageFqName));
        $this$getSubpackageNames_u24lambda_u240.addAll((Collection)this.getPlatformSpecificSubpackageNames(packageFqName, platform));
        return SetsKt.build((Set)set);
    }

    @Override
    @NotNull
    public Set<Name> getPlatformSpecificSubpackageNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (JvmPlatformKt.isJvm((TargetPlatform)platform)) {
            Set set2;
            String fqNameString = packageFqName.asString();
            Set $this$getPlatformSpecificSubpackageNames_u24lambda_u240 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint((AreaInstance)project$iv).getExtensionList()) {
                PsiPackage[] psiPackageArray;
                PsiPackage psiPackage;
                if (Intrinsics.areEqual((Object)finder$iv.getClass().getName(), (Object)"org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull((Object)finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl2 = false;
                if (finder.findPackage(fqNameString) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)finder.getSubPackages(psiPackage, this.searchScope), (String)"getSubPackages(...)");
                for (PsiPackage subPackage : psiPackageArray) {
                    String string = subPackage.getName();
                    if (string == null) continue;
                    String p0 = string;
                    boolean bl3 = false;
                    Name name = Name.identifierIfValid((String)p0);
                    string = name;
                    if (name == null) {
                        continue;
                    }
                    String name2 = string;
                    $this$getPlatformSpecificSubpackageNames_u24lambda_u240.add(name2);
                }
            }
            set = SetsKt.build((Set)set2);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }
}

