/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.swiftexport.standalone;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.sir.SirModule;
import org.jetbrains.kotlin.sir.builder.SirModuleBuilder;
import org.jetbrains.kotlin.sir.providers.impl.SirEnumGeneratorImpl;
import org.jetbrains.kotlin.swiftexport.standalone.InputModule;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportFiles;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportLogger;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportModule;
import org.jetbrains.kotlin.swiftexport.standalone.builders.SwiftExportDependencies;
import org.jetbrains.kotlin.swiftexport.standalone.config.SwiftExportConfig;
import org.jetbrains.kotlin.swiftexport.standalone.translation.ModuleTranslationKt;
import org.jetbrains.kotlin.swiftexport.standalone.translation.TranslationResult;
import org.jetbrains.kotlin.swiftexport.standalone.utils.LogConfigIssuesKt;
import org.jetbrains.kotlin.swiftexport.standalone.writer.DumpResultToFilesKt;
import org.jetbrains.sir.printer.SirAsSwiftSourcesPrinter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a-\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"createDummyLogger", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportLogger;", "runSwiftExport", "Lkotlin/Result;", "", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportModule;", "input", "Lorg/jetbrains/kotlin/swiftexport/standalone/InputModule;", "config", "Lorg/jetbrains/kotlin/swiftexport/standalone/config/SwiftExportConfig;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/swiftexport/standalone/config/SwiftExportConfig;)Ljava/lang/Object;", "createModuleForPackages", "Lorg/jetbrains/kotlin/sir/SirModule;", "", "Lorg/jetbrains/kotlin/swiftexport/standalone/translation/TranslationResult;", "writeKotlinPackagesModule", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportModule$SwiftOnly;", "sirModule", "outputPath", "Ljava/nio/file/Path;", "writeRuntimeSupportModule", "writeModule", "swift-export-standalone"})
@SourceDebugExtension(value={"SMAP\nSwiftExportRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftExportRunner.kt\norg/jetbrains/kotlin/swiftexport/standalone/SwiftExportRunnerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 SirModuleBuilder.kt\norg/jetbrains/kotlin/sir/builder/SirModuleBuilderKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1563#2:228\n1634#2,3:229\n1374#2:232\n1460#2,5:233\n1563#2:239\n1634#2,3:240\n1374#2:244\n1460#2,5:245\n1869#2:250\n1870#2:252\n1563#2:253\n1634#2,3:254\n193#3:238\n40#4:243\n1#5:251\n*S KotlinDebug\n*F\n+ 1 SwiftExportRunner.kt\norg/jetbrains/kotlin/swiftexport/standalone/SwiftExportRunnerKt\n*L\n132#1:228\n132#1:229,3\n150#1:232\n150#1:233,5\n162#1:239\n162#1:240,3\n169#1:244\n169#1:245,5\n170#1:250\n170#1:252\n211#1:253\n211#1:254,3\n150#1:238\n165#1:243\n*E\n"})
public final class SwiftExportRunnerKt {
    @NotNull
    public static final SwiftExportLogger createDummyLogger() {
        return new SwiftExportLogger(){

            public void report(SwiftExportLogger.Severity severity, String message) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                System.out.println((Object)((Object)((Object)severity) + ": " + message));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Object runSwiftExport(@NotNull Set<InputModule> input, @NotNull SwiftExportConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TranslationResult translationResult;
            Iterable $this$runSwiftExport_u24lambda_u244_u24lambda_u242;
            void $this$ifNotEmpty$iv;
            void $this$flatMapTo$iv$iv;
            Collection collection;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            boolean bl = false;
            LogConfigIssuesKt.logConfigIssues(input, config.getLogger());
            InputModule stdlibInputModule = config.getStdlibInputModule();
            Set<InputModule> platformLibsInputModule = config.getPlatformLibsInputModule();
            Iterable $this$map$iv2 = input;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void rootModule;
                InputModule inputModule = (InputModule)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Set dependencies = SetsKt.minus(input, (Object)rootModule);
                collection.add(ModuleTranslationKt.translateModulePublicApi((InputModule)rootModule, new SwiftExportDependencies<InputModule>(dependencies, stdlibInputModule, platformLibsInputModule), config));
            }
            List translationResults = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = translationResults;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TranslationResult it = (TranslationResult)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = it.getReferencedStdlibTypes();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                $this$runSwiftExport_u24lambda_u244_u24lambda_u242 = (List)$this$ifNotEmpty$iv;
                boolean bl4 = false;
                translationResult = ModuleTranslationKt.translateModuleTransitiveClosure(stdlibInputModule, config, CollectionsKt.toSet((Iterable)$this$runSwiftExport_u24lambda_u244_u24lambda_u242));
            } else {
                translationResult = null;
            }
            TranslationResult stdlibTranslationResult = translationResult;
            List allModules = CollectionsKt.plus((Collection)translationResults, (Iterable)CollectionsKt.listOfNotNull(stdlibTranslationResult));
            SirModule sirModule = SwiftExportRunnerKt.createModuleForPackages(allModules, config);
            Path path = config.getOutputPath().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            $this$runSwiftExport_u24lambda_u244_u24lambda_u242 = path;
            Path path2 = $this$runSwiftExport_u24lambda_u244_u24lambda_u242.resolve(config.getModuleForPackagesName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            $this$runSwiftExport_u24lambda_u244_u24lambda_u242 = path2;
            Path path3 = $this$runSwiftExport_u24lambda_u244_u24lambda_u242.resolve(config.getModuleForPackagesName() + ".swift");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            SwiftExportModule.SwiftOnly packagesModule = SwiftExportRunnerKt.writeKotlinPackagesModule(sirModule, path3);
            Object[] objectArray = config.getOutputPath().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParent(...)");
            Object bl4 = objectArray;
            Path path4 = bl4.resolve(config.getRuntimeSupportModuleName());
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            bl4 = path4;
            Path path5 = bl4.resolve(config.getRuntimeSupportModuleName() + ".swift");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            SwiftExportModule.SwiftOnly runtimeSupportModule = SwiftExportRunnerKt.writeRuntimeSupportModule(config, path5);
            bl4 = new SwiftExportModule.SwiftOnly[]{packagesModule, runtimeSupportModule};
            Set set = SetsKt.setOf((Object[])bl4);
            bl4 = allModules;
            collection = set;
            boolean $i$f$map2 = false;
            item$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it;
                TranslationResult translationResult2 = (TranslationResult)item$iv$iv3;
                Collection collection2 = destination$iv$iv3;
                boolean bl5 = false;
                collection2.add(SwiftExportRunnerKt.writeModule((TranslationResult)it, config));
            }
            object = Result.constructor-impl((Object)SetsKt.plus((Set)collection, (Iterable)((List)destination$iv$iv3)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final SirModule createModuleForPackages(Collection<TranslationResult> $this$createModuleForPackages, SwiftExportConfig config) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        SirModule sirModule;
        SirModuleBuilder sirModuleBuilder;
        boolean $i$f$buildModule = false;
        SirModuleBuilder $this$createModuleForPackages_u24lambda_u245 = sirModuleBuilder = new SirModuleBuilder();
        boolean bl = false;
        $this$createModuleForPackages_u24lambda_u245.setName(config.getModuleForPackagesName());
        SirModule $this$createModuleForPackages_u24lambda_u249 = sirModule = sirModuleBuilder.build();
        boolean bl2 = false;
        SirEnumGeneratorImpl enumGenerator = new SirEnumGeneratorImpl($this$createModuleForPackages_u24lambda_u249);
        Iterable $this$flatMap$iv = $this$createModuleForPackages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TranslationResult it = (TranslationResult)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getPackages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl4 = false;
            SirEnumGeneratorImpl $this$createModuleForPackages_u24lambda_u249_u24lambda_u248_u24lambda_u247 = enumGenerator;
            boolean bl5 = false;
            $this$createModuleForPackages_u24lambda_u249_u24lambda_u248_u24lambda_u247.sirPackageEnum(it);
        }
        return sirModule;
    }

    private static final SwiftExportModule.SwiftOnly writeKotlinPackagesModule(SirModule sirModule, Path outputPath) {
        Object object = new String[]{SirAsSwiftSourcesPrinter.Companion.print$default(SirAsSwiftSourcesPrinter.Companion, sirModule, true, false, null, 8, null)};
        Sequence swiftSources = SequencesKt.sequenceOf((Object[])object);
        File file = outputPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        DumpResultToFilesKt.dumpTextAtFile((Sequence<String>)swiftSources, file);
        object = sirModule.getName();
        SwiftExportModule.SwiftOnly.Kind kind = SwiftExportModule.SwiftOnly.Kind.KotlinPackages;
        return new SwiftExportModule.SwiftOnly(outputPath, kind, (String)object);
    }

    private static final SwiftExportModule.SwiftOnly writeRuntimeSupportModule(SwiftExportConfig config, Path outputPath) {
        URL uRL = config.getClass().getResource("/swift/KotlinRuntimeSupport.swift");
        if (uRL == null) {
            throw new IllegalStateException("Can't find runtime support module".toString());
        }
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String runtimeSupportContent = new String(byArray, charset);
        Object object = new String[]{runtimeSupportContent};
        Sequence sequence = SequencesKt.sequenceOf((Object[])object);
        File file = outputPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        DumpResultToFilesKt.dumpTextAtFile((Sequence<String>)sequence, file);
        object = config.getRuntimeSupportModuleName();
        SwiftExportModule.SwiftOnly.Kind kind = SwiftExportModule.SwiftOnly.Kind.KotlinRuntimeSupport;
        return new SwiftExportModule.SwiftOnly(outputPath, kind, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    private static final SwiftExportModule writeModule(TranslationResult $this$writeModule, SwiftExportConfig config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new String[]{$this$writeModule.getSwiftModuleSources()};
        Sequence sequence = SequencesKt.sequenceOf((Object[])object);
        object = $this$writeModule.getModuleConfig().getUnsupportedDeclarationReporter().getMessages();
        Sequence sequence2 = sequence;
        boolean $i$f$map = false;
        String string = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("// " + (String)it);
        }
        Sequence swiftSources = SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv));
        Path path = config.getOutputPath().resolve($this$writeModule.getSwiftModuleName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path modulePath = path;
        Path path2 = modulePath.resolve($this$writeModule.getSwiftModuleName() + ".swift");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = modulePath.resolve($this$writeModule.getSwiftModuleName() + ".kt");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path path4 = modulePath.resolve($this$writeModule.getSwiftModuleName() + ".h");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        SwiftExportFiles outputFiles = new SwiftExportFiles(path2, path3, path4);
        DumpResultToFilesKt.dumpTextAtPath((Sequence<String>)swiftSources, $this$writeModule.getBridgeSources(), outputFiles);
        string = $this$writeModule.getSwiftModuleName();
        List<SwiftExportModule.Reference> list = $this$writeModule.getReferencedSwiftModules();
        String string3 = $this$writeModule.getBridgesModuleName();
        return new SwiftExportModule.BridgesToKotlin(outputFiles, string3, string, list);
    }
}

