/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.bridge.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertyGetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.sir.SirCallable;
import org.jetbrains.kotlin.sir.SirDeclaration;
import org.jetbrains.kotlin.sir.SirFunction;
import org.jetbrains.kotlin.sir.SirFunctionBody;
import org.jetbrains.kotlin.sir.SirGetter;
import org.jetbrains.kotlin.sir.SirInit;
import org.jetbrains.kotlin.sir.SirNominalType;
import org.jetbrains.kotlin.sir.SirOrigin;
import org.jetbrains.kotlin.sir.SirSetter;
import org.jetbrains.kotlin.sir.bridge.BridgeGenerator;
import org.jetbrains.kotlin.sir.bridge.BridgeRequest;
import org.jetbrains.kotlin.sir.bridge.FunctionBridge;
import org.jetbrains.kotlin.sir.bridge.FunctionBridgeRequest;
import org.jetbrains.kotlin.sir.bridge.GeneratedBridge;
import org.jetbrains.kotlin.sir.bridge.SirTypeNamer;
import org.jetbrains.kotlin.sir.bridge.TypeBindingBridge;
import org.jetbrains.kotlin.sir.bridge.TypeBindingBridgeRequest;
import org.jetbrains.kotlin.sir.bridge.impl.BridgeFunctionDescriptor;
import org.jetbrains.kotlin.sir.bridge.impl.BridgeGeneratorImplKt;
import org.jetbrains.kotlin.sir.bridge.impl.BridgeParameter;
import org.jetbrains.kotlin.sir.mangler.ManglerKt;
import org.jetbrains.kotlin.sir.providers.source.InnerInitSource;
import org.jetbrains.kotlin.sir.providers.source.KotlinSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/BridgeGeneratorImpl;", "Lorg/jetbrains/kotlin/sir/bridge/BridgeGenerator;", "typeNamer", "Lorg/jetbrains/kotlin/sir/bridge/SirTypeNamer;", "<init>", "(Lorg/jetbrains/kotlin/sir/bridge/SirTypeNamer;)V", "generateBridges", "", "Lorg/jetbrains/kotlin/sir/bridge/GeneratedBridge;", "request", "Lorg/jetbrains/kotlin/sir/bridge/BridgeRequest;", "generateFunctionBridges", "Lorg/jetbrains/kotlin/sir/bridge/FunctionBridge;", "Lorg/jetbrains/kotlin/sir/bridge/FunctionBridgeRequest;", "generateSirFunctionBody", "Lorg/jetbrains/kotlin/sir/SirFunctionBody;", "generateTypeBindingBridge", "Lorg/jetbrains/kotlin/sir/bridge/TypeBindingBridge;", "Lorg/jetbrains/kotlin/sir/bridge/TypeBindingBridgeRequest;", "sir-compiler-bridge"})
@SourceDebugExtension(value={"SMAP\nBridgeGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeGeneratorImpl.kt\norg/jetbrains/kotlin/sir/bridge/impl/BridgeGeneratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KotlinSource.kt\norg/jetbrains/kotlin/sir/providers/source/KotlinSourceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1045:1\n1563#2:1046\n1634#2,3:1047\n37#3,3:1050\n1#4:1053\n*S KotlinDebug\n*F\n+ 1 BridgeGeneratorImpl.kt\norg/jetbrains/kotlin/sir/bridge/impl/BridgeGeneratorImpl\n*L\n50#1:1046\n50#1:1047,3\n57#1:1050,3\n*E\n"})
public final class BridgeGeneratorImpl
implements BridgeGenerator {
    @NotNull
    private final SirTypeNamer typeNamer;

    public BridgeGeneratorImpl(@NotNull SirTypeNamer typeNamer) {
        Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
        this.typeNamer = typeNamer;
    }

    @Override
    @NotNull
    public List<GeneratedBridge> generateBridges(@NotNull BridgeRequest request) {
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BridgeRequest bridgeRequest = request;
        if (bridgeRequest instanceof FunctionBridgeRequest) {
            list = this.generateFunctionBridges((FunctionBridgeRequest)request);
        } else if (bridgeRequest instanceof TypeBindingBridgeRequest) {
            list = CollectionsKt.listOf((Object)this.generateTypeBindingBridge((TypeBindingBridgeRequest)request));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<FunctionBridge> generateFunctionBridges(FunctionBridgeRequest request) {
        boolean bl;
        List list;
        List $this$generateFunctionBridges_u24lambda_u2413 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        SirCallable sirCallable = request.getCallable();
        if (sirCallable instanceof SirFunction) {
            bl = $this$generateFunctionBridges_u24lambda_u2413.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer), arg_0 -> BridgeGeneratorImpl.generateFunctionBridges$lambda$13$lambda$3(request, arg_0)));
        } else if (sirCallable instanceof SirGetter) {
            bl = $this$generateFunctionBridges_u24lambda_u2413.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$13$lambda$5));
        } else if (sirCallable instanceof SirSetter) {
            bl = $this$generateFunctionBridges_u24lambda_u2413.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$13$lambda$7));
        } else if (sirCallable instanceof SirInit) {
            $this$generateFunctionBridges_u24lambda_u2413.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$allocationDescriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$13$lambda$8));
            bl = ((SirInit)request.getCallable()).getOrigin() instanceof InnerInitSource ? $this$generateFunctionBridges_u24lambda_u2413.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$initializationDescriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$13$lambda$11)) : $this$generateFunctionBridges_u24lambda_u2413.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$initializationDescriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$13$lambda$12));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public SirFunctionBody generateSirFunctionBody(@NotNull FunctionBridgeRequest request) {
        boolean bl;
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List $this$generateSirFunctionBody_u24lambda_u2414 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        SirCallable sirCallable = request.getCallable();
        if (sirCallable instanceof SirFunction || sirCallable instanceof SirGetter || sirCallable instanceof SirSetter) {
            BridgeFunctionDescriptor descriptor = BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer);
            BridgeParameter errorParameter = descriptor.getErrorParameter();
            if (errorParameter != null) {
                $this$generateSirFunctionBody_u24lambda_u2414.add("var " + errorParameter.getName() + ": UInt = 0");
                $this$generateSirFunctionBody_u24lambda_u2414.add("let _result = " + BridgeGeneratorImplKt.access$swiftInvoke(descriptor, this.typeNamer));
                String error = errorParameter.getBridge().getInSwiftSources().kotlinToSwift(this.typeNamer, errorParameter.getName());
                $this$generateSirFunctionBody_u24lambda_u2414.add("guard " + errorParameter.getName() + " == 0 else { throw KotlinError(wrapped: " + error + ") }");
                bl = $this$generateSirFunctionBody_u24lambda_u2414.add("return " + descriptor.getReturnType().getInSwiftSources().kotlinToSwift(this.typeNamer, "_result"));
            } else {
                bl = $this$generateSirFunctionBody_u24lambda_u2414.add("return " + BridgeGeneratorImplKt.access$swiftCall(descriptor, this.typeNamer));
            }
        } else if (sirCallable instanceof SirInit) {
            BridgeFunctionDescriptor initDescriptor = BridgeGeneratorImplKt.access$initializationDescriptor(request, this.typeNamer);
            BridgeParameter errorParameter = initDescriptor.getErrorParameter();
            $this$generateSirFunctionBody_u24lambda_u2414.add("let " + BridgeGeneratorImplKt.access$getObj$p().getName() + " = " + BridgeGeneratorImplKt.access$swiftCall(BridgeGeneratorImplKt.access$allocationDescriptor(request, this.typeNamer), this.typeNamer));
            $this$generateSirFunctionBody_u24lambda_u2414.add("super.init(__externalRCRef: " + BridgeGeneratorImplKt.access$getObj$p().getName() + ')');
            if (errorParameter != null) {
                $this$generateSirFunctionBody_u24lambda_u2414.add("var " + errorParameter.getName() + ": UInt = 0");
                $this$generateSirFunctionBody_u24lambda_u2414.add(BridgeGeneratorImplKt.access$swiftCall(initDescriptor, this.typeNamer));
                String error = errorParameter.getBridge().getInSwiftSources().kotlinToSwift(this.typeNamer, errorParameter.getName());
                bl = $this$generateSirFunctionBody_u24lambda_u2414.add("guard " + errorParameter.getName() + " == 0 else { throw KotlinError(wrapped: " + error + ") }");
            } else {
                bl = $this$generateSirFunctionBody_u24lambda_u2414.add(BridgeGeneratorImplKt.access$swiftCall(initDescriptor, this.typeNamer));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List list2 = CollectionsKt.build((List)list);
        return new SirFunctionBody(list2);
    }

    private final TypeBindingBridge generateTypeBindingBridge(TypeBindingBridgeRequest request) {
        String annotationName = "kotlin.native.internal.objc.BindClassToObjCName";
        String kotlinType = this.typeNamer.kotlinFqName(new SirNominalType(request.getSirClass(), null, null, null, 14, null));
        String swiftName = ManglerKt.getMangledNameOrNull(request.getSirClass());
        if (swiftName == null) {
            boolean bl = false;
            String string = "Cannot mangle name for Swift class exported from `" + kotlinType + '`';
            throw new IllegalArgumentException(string.toString());
        }
        return new TypeBindingBridge(annotationName + '(' + kotlinType + "::class, \"" + swiftName + "\")");
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> generateFunctionBridges$lambda$13$argNames(BridgeFunctionDescriptor descriptor) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = descriptor.getParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BridgeParameter bridgeParameter = (BridgeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BridgeGeneratorImplKt.access$getKotlinIdentifier("__" + it.getName()));
        }
        return (List)destination$iv$iv;
    }

    private static final String generateFunctionBridges$lambda$13$lambda$3(FunctionBridgeRequest $request, BridgeFunctionDescriptor $this$createFunctionBridge) {
        String string;
        KaSymbol kaSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        List args = BridgeGeneratorImpl.generateFunctionBridges$lambda$13$argNames($this$createFunctionBridge);
        SirDeclaration $this$kaSymbolOrNull$iv = $request.getCallable();
        boolean $i$f$kaSymbolOrNull = false;
        SirOrigin sirOrigin = $this$kaSymbolOrNull$iv.getOrigin();
        KotlinSource kotlinSource = sirOrigin instanceof KotlinSource ? (KotlinSource)sirOrigin : null;
        if (kotlinSource == null) {
            kaSymbol = null;
        } else {
            KotlinSource kotlinOrigin$iv = kotlinSource;
            KaSymbol kaSymbol2 = kotlinOrigin$iv.getSymbol();
            if (!(kaSymbol2 instanceof KaFunctionSymbol)) {
                kaSymbol2 = null;
            }
            kaSymbol = (KaFunctionSymbol)kaSymbol2;
        }
        KaFunctionSymbol kaSymbol3 = (KaFunctionSymbol)kaSymbol;
        if (kaSymbol3 instanceof KaPropertyGetterSymbol) {
            int expectedParameters = $this$createFunctionBridge.getExtensionReceiverParameter() != null ? 1 : 0;
            if (!(args.size() == expectedParameters)) {
                boolean $i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$1$32 = false;
                String $i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$1$32 = "Received an extension getter " + $this$createFunctionBridge.getName() + " with " + args.size() + " parameters instead of a " + expectedParameters + ", aborting";
                throw new IllegalArgumentException($i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$1$32.toString());
            }
            string = $this$createFunctionBridge.buildCall("");
        } else if (kaSymbol3 instanceof KaPropertySetterSymbol) {
            int expectedParameters = $this$createFunctionBridge.getExtensionReceiverParameter() != null ? 2 : 1;
            if (!(args.size() == expectedParameters)) {
                boolean bl = false;
                String string2 = "Received an extension getter " + $this$createFunctionBridge.getName() + " with " + args.size() + " parameters instead of a " + expectedParameters + ", aborting";
                throw new IllegalArgumentException(string2.toString());
            }
            string = $this$createFunctionBridge.buildCall(" = " + (String)CollectionsKt.last((List)args));
        } else if (kaSymbol3 instanceof KaNamedFunctionSymbol) {
            List actualArgs = $this$createFunctionBridge.getExtensionReceiverParameter() != null ? CollectionsKt.drop((Iterable)args, (int)1) : args;
            string = $this$createFunctionBridge.buildCall('(' + CollectionsKt.joinToString$default((Iterable)actualArgs, null, null, null, (int)0, null, null, (int)63, null) + ')');
        } else {
            throw new IllegalStateException(("Unexpected Kotlin symbol: " + kaSymbol3).toString());
        }
        return string;
    }

    private static final String generateFunctionBridges$lambda$13$lambda$5(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        List<String> args = BridgeGeneratorImpl.generateFunctionBridges$lambda$13$argNames($this$createFunctionBridge);
        if (!args.isEmpty()) {
            boolean bl = false;
            String string = "Received a getter " + $this$createFunctionBridge.getName() + " with " + args.size() + " parameters instead of no parameters, aborting";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$createFunctionBridge.buildCall("");
    }

    private static final String generateFunctionBridges$lambda$13$lambda$7(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        List<String> args = BridgeGeneratorImpl.generateFunctionBridges$lambda$13$argNames($this$createFunctionBridge);
        if (!(args.size() == 1)) {
            boolean bl = false;
            String string = "Received a setter " + $this$createFunctionBridge.getName() + " with " + args.size() + " parameters instead of a single one, aborting";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$createFunctionBridge.buildCall(" = " + (String)CollectionsKt.single(args));
    }

    private static final String generateFunctionBridges$lambda$13$lambda$8(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        List<String> args = BridgeGeneratorImpl.generateFunctionBridges$lambda$13$argNames($this$createFunctionBridge);
        return "kotlin.native.internal.createUninitializedInstance<" + $this$createFunctionBridge.getName() + ">(" + CollectionsKt.joinToString$default((Iterable)args, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    private static final String generateFunctionBridges$lambda$13$lambda$11(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        List<String> args = BridgeGeneratorImpl.generateFunctionBridges$lambda$13$argNames($this$createFunctionBridge);
        if (!($this$createFunctionBridge.getKotlinFqName().size() >= 2)) {
            boolean $i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$5$32 = false;
            String $i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$5$32 = "Expected >=2 kotlinFqName.size, but were " + $this$createFunctionBridge.getKotlinFqName().size() + ": " + CollectionsKt.joinToString$default((Iterable)$this$createFunctionBridge.getKotlinFqName(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException($i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$5$32.toString());
        }
        if (!(args.size() >= 2)) {
            boolean $i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$5$42 = false;
            String $i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$5$42 = "Expected >=2 inner constructor arguments, but were " + args.size() + ": " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException($i$a$-require-BridgeGeneratorImpl$generateFunctionBridges$1$5$42.toString());
        }
        String outerClassName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast($this$createFunctionBridge.getKotlinFqName(), (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        String innerClassName = (String)CollectionsKt.last($this$createFunctionBridge.getKotlinFqName());
        String innerConstructorArgs = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)args, (int)1), (int)1), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String innerConstructorCall = '(' + (String)CollectionsKt.last(args) + " as " + outerClassName + ")." + innerClassName + '(' + innerConstructorArgs + ')';
        return "kotlin.native.internal.initInstance(" + (String)CollectionsKt.first(args) + ", " + innerConstructorCall + ')';
    }

    private static final String generateFunctionBridges$lambda$13$lambda$12(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        List<String> args = BridgeGeneratorImpl.generateFunctionBridges$lambda$13$argNames($this$createFunctionBridge);
        return "kotlin.native.internal.initInstance(" + (String)CollectionsKt.first(args) + ", " + $this$createFunctionBridge.getName() + '(' + CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)args, (int)1), null, null, null, (int)0, null, null, (int)63, null) + "))";
    }
}

