/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.projectStructure;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaResolutionScope;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DependenciesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleProvider;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0011\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\f\u0010\u0016\u001a\u00020\u000b*\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseResolutionScope;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaResolutionScope;", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "resolutionScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "isSearchInModuleContent", "", "aModule", "Lorg/jetbrains/kotlin/com/intellij/openapi/module/Module;", "isSearchInLibraries", "contains", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isFromGeneratedModule", "virtualFile", "isAccessibleFromUseSiteModule", "toString", "", "analysis-api-impl-base"})
public final class KaBaseResolutionScope
extends KaResolutionScope {
    @NotNull
    private final KaModule useSiteModule;
    @NotNull
    private final GlobalSearchScope resolutionScope;

    public KaBaseResolutionScope(@NotNull KaModule useSiteModule, @NotNull GlobalSearchScope resolutionScope) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        Intrinsics.checkNotNullParameter((Object)resolutionScope, (String)"resolutionScope");
        this.useSiteModule = useSiteModule;
        this.resolutionScope = resolutionScope;
    }

    @Nullable
    public Project getProject() {
        return this.resolutionScope.getProject();
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return this.resolutionScope.isSearchInModuleContent(aModule);
    }

    public boolean isSearchInLibraries() {
        return this.resolutionScope.isSearchInLibraries();
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.resolutionScope.contains(file) || this.isFromGeneratedModule(file);
    }

    @Override
    public boolean contains(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PsiUtilsKt.contains((SearchScope)((SearchScope)this.resolutionScope), (PsiElement)element) || this.isFromGeneratedModule(element);
    }

    private final boolean isFromGeneratedModule(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (DanglingFilesKt.isDangling(ktFile2)) {
            KaModule module = KaModuleProvider.Companion.getModule(this.useSiteModule.getProject(), (PsiElement)ktFile2, this.useSiteModule);
            return this.isAccessibleFromUseSiteModule(module);
        }
        VirtualFile virtualFile = ktFile2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return this.isFromGeneratedModule(virtualFile2);
    }

    private final boolean isFromGeneratedModule(VirtualFile virtualFile) {
        KaModule kaModule = ContextModuleKt.getAnalysisContextModule(virtualFile);
        if (kaModule == null) {
            return false;
        }
        KaModule analysisContextModule = kaModule;
        return this.isAccessibleFromUseSiteModule(analysisContextModule);
    }

    private final boolean isAccessibleFromUseSiteModule(KaModule $this$isAccessibleFromUseSiteModule) {
        return Intrinsics.areEqual((Object)$this$isAccessibleFromUseSiteModule, (Object)this.useSiteModule) || SequencesKt.contains(DependenciesKt.allDirectDependencies(this.useSiteModule), (Object)$this$isAccessibleFromUseSiteModule);
    }

    @NotNull
    public String toString() {
        return "Analysis scope for " + this.useSiteModule + ". Resolution scope: " + this.resolutionScope;
    }
}

