/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.native.analysis.api;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializationUtilsKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.native.analysis.api.KlibClassAddress;
import org.jetbrains.kotlin.native.analysis.api.KlibDeclarationAddress;
import org.jetbrains.kotlin.native.analysis.api.KlibFunctionAddress;
import org.jetbrains.kotlin.native.analysis.api.KlibPropertyAddress;
import org.jetbrains.kotlin.native.analysis.api.KlibTypeAliasAddress;
import org.jetbrains.kotlin.native.analysis.api.PackageFragmentReadingContext;
import org.jetbrains.kotlin.native.analysis.api.PackageFragmentReadingContextKt;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.util.DummyLogger;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u0003\u001a\"\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001*\u00020\rH\u0000R\u00020\f\u00a2\u0006\u0002\u0010\u000e\u001a\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001*\u00020\rH\u0000R\u00020\f\u00a2\u0006\u0002\u0010\u000e\u001a\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001*\u00020\rH\u0000R\u00020\f\u00a2\u0006\u0002\u0010\u000e\u001a\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\rH\u0000R\u00020\f\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0015"}, d2={"readKlibDeclarationAddresses", "", "Lorg/jetbrains/kotlin/native/analysis/api/KlibDeclarationAddress;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "path", "Ljava/nio/file/Path;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "readKlibClassAddresses", "Lorg/jetbrains/kotlin/native/analysis/api/KlibClassAddress;", "Lorg/jetbrains/kotlin/native/analysis/api/PackageFragmentReadingContext;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "(Lorg/jetbrains/kotlin/native/analysis/api/PackageFragmentReadingContext;Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;)Ljava/util/Set;", "readKlibTypeAliasAddresses", "Lorg/jetbrains/kotlin/native/analysis/api/KlibTypeAliasAddress;", "readKlibPropertyAddresses", "Lorg/jetbrains/kotlin/native/analysis/api/KlibPropertyAddress;", "readKlibFunctionAddresses", "Lorg/jetbrains/kotlin/native/analysis/api/KlibFunctionAddress;", "analysis-api-klib-reader"})
@SourceDebugExtension(value={"SMAP\nreadKlibDeclarationAddresses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 readKlibDeclarationAddresses.kt\norg/jetbrains/kotlin/native/analysis/api/ReadKlibDeclarationAddressesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1611#2,9:145\n1863#2:154\n1864#2:156\n1620#2:157\n1557#2:158\n1628#2,3:159\n1557#2:162\n1628#2,3:163\n1557#2:166\n1628#2,3:167\n1#3:155\n*S KotlinDebug\n*F\n+ 1 readKlibDeclarationAddresses.kt\norg/jetbrains/kotlin/native/analysis/api/ReadKlibDeclarationAddressesKt\n*L\n88#1:145,9\n88#1:154\n88#1:156\n88#1:157\n105#1:158\n105#1:159,3\n118#1:162\n118#1:163,3\n133#1:166\n133#1:167,3\n88#1:155\n*E\n"})
public final class ReadKlibDeclarationAddressesKt {
    @Nullable
    public static final Set<KlibDeclarationAddress> readKlibDeclarationAddresses(@NotNull KaLibraryModule $this$readKlibDeclarationAddresses) {
        Intrinsics.checkNotNullParameter((Object)$this$readKlibDeclarationAddresses, (String)"<this>");
        Path path = (Path)CollectionsKt.singleOrNull((Iterable)$this$readKlibDeclarationAddresses.getBinaryRoots());
        if (path == null) {
            return null;
        }
        Path binary = path;
        if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)binary), (Object)"klib")) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(binary, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
        }
        return ReadKlibDeclarationAddressesKt.readKlibDeclarationAddresses$default(binary, null, 2, null);
    }

    @Nullable
    public static final Set<KlibDeclarationAddress> readKlibDeclarationAddresses(@NotNull Path path, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        KotlinLibrary kotlinLibrary = ToolingSingleFileKlibResolveStrategy.INSTANCE.tryResolve(new File(path), logger);
        if (kotlinLibrary == null) {
            return null;
        }
        KotlinLibrary library = kotlinLibrary;
        return ReadKlibDeclarationAddressesKt.readKlibDeclarationAddresses(library);
    }

    public static /* synthetic */ Set readKlibDeclarationAddresses$default(Path path, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = (Logger)DummyLogger.INSTANCE;
        }
        return ReadKlibDeclarationAddressesKt.readKlibDeclarationAddresses(path, logger);
    }

    @NotNull
    public static final Set<KlibDeclarationAddress> readKlibDeclarationAddresses(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        KlibMetadataProtoBuf.Header headerProto = KlibMetadataDeserializationUtilsKt.parseModuleHeader((byte[])library.getModuleHeaderData());
        ProtocolStringList protocolStringList = headerProto.getPackageFragmentNameList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getPackageFragmentNameList(...)");
        Sequence packageMetadataSequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)protocolStringList)), arg_0 -> ReadKlibDeclarationAddressesKt.readKlibDeclarationAddresses$lambda$1(library, arg_0));
        return SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)packageMetadataSequence, arg_0 -> ReadKlibDeclarationAddressesKt.readKlibDeclarationAddresses$lambda$3(library, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KlibClassAddress> readKlibClassAddresses(@NotNull PackageFragmentReadingContext $context_receiver_0, @NotNull ProtoBuf.PackageFragment $this$readKlibClassAddresses) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readKlibClassAddresses, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        List list = $this$readKlibClassAddresses.getClass_List();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClass_List(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KlibClassAddress klibClassAddress;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv$iv;
            boolean bl2 = false;
            ClassId classId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)$context_receiver_0.getNameResolver().getQualifiedClassName(classProto.getFqName()), (boolean)false, (int)2, null);
            if (classId.isNestedClass()) {
                klibClassAddress = null;
            } else {
                String string;
                Path path = $context_receiver_0.getLibraryPath();
                FqName fqName = $context_receiver_0.getPackageFqName();
                Intrinsics.checkNotNull((Object)classProto);
                GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)classProto;
                GeneratedMessageLite.GeneratedExtension generatedExtension = KlibMetadataProtoBuf.classFile;
                Intrinsics.checkNotNullExpressionValue((Object)generatedExtension, (String)"classFile");
                Integer n = (Integer)ProtoBufUtilKt.getExtensionOrNull((GeneratedMessageLite.ExtendableMessage)extendableMessage, (GeneratedMessageLite.GeneratedExtension)generatedExtension);
                if (n != null) {
                    int fileNameId = ((Number)n).intValue();
                    boolean bl3 = false;
                    string = $context_receiver_0.getNameResolver().getStrings().getString(fileNameId);
                } else {
                    string = null;
                }
                String string2 = string;
                klibClassAddress = new KlibClassAddress(path, string2, fqName, classId);
            }
            if (klibClassAddress == null) continue;
            KlibClassAddress it$iv$iv = klibClassAddress;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KlibTypeAliasAddress> readKlibTypeAliasAddresses(@NotNull PackageFragmentReadingContext $context_receiver_0, @NotNull ProtoBuf.PackageFragment $this$readKlibTypeAliasAddresses) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readKlibTypeAliasAddresses, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        List list = $this$readKlibTypeAliasAddresses.getPackage().getTypeAliasList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeAliasList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Name name;
            void typeAliasProto;
            ProtoBuf.TypeAlias typeAlias = (ProtoBuf.TypeAlias)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Name.identifier((String)$context_receiver_0.getNameResolver().getString(typeAliasProto.getName())), (String)"identifier(...)");
            collection.add(new KlibTypeAliasAddress($context_receiver_0.getLibraryPath(), $context_receiver_0.getPackageFqName(), new ClassId($context_receiver_0.getPackageFqName(), name)));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KlibPropertyAddress> readKlibPropertyAddresses(@NotNull PackageFragmentReadingContext $context_receiver_0, @NotNull ProtoBuf.PackageFragment $this$readKlibPropertyAddresses) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readKlibPropertyAddresses, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        List list = $this$readKlibPropertyAddresses.getPackage().getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Name name;
            String string;
            void propertyProto;
            ProtoBuf.Property property = (ProtoBuf.Property)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = $context_receiver_0.getLibraryPath();
            Intrinsics.checkNotNull((Object)propertyProto);
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)propertyProto;
            GeneratedMessageLite.GeneratedExtension generatedExtension = KlibMetadataProtoBuf.propertyFile;
            Intrinsics.checkNotNullExpressionValue((Object)generatedExtension, (String)"propertyFile");
            Integer n = (Integer)ProtoBufUtilKt.getExtensionOrNull((GeneratedMessageLite.ExtendableMessage)extendableMessage, (GeneratedMessageLite.GeneratedExtension)generatedExtension);
            if (n != null) {
                void fileNameId;
                int n2 = ((Number)n).intValue();
                Path path2 = path;
                boolean bl2 = false;
                string = $context_receiver_0.getNameResolver().getStrings().getString((int)fileNameId);
                path = path2;
            } else {
                string = null;
            }
            FqName fqName = $context_receiver_0.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)Name.identifier((String)$context_receiver_0.getNameResolver().getString(propertyProto.getName())), (String)"identifier(...)");
            FqName fqName2 = fqName;
            String string2 = string;
            Path path3 = path;
            collection.add(new KlibPropertyAddress(path3, string2, fqName2, name));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KlibFunctionAddress> readKlibFunctionAddresses(@NotNull PackageFragmentReadingContext $context_receiver_0, @NotNull ProtoBuf.PackageFragment $this$readKlibFunctionAddresses) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readKlibFunctionAddresses, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        List list = $this$readKlibFunctionAddresses.getPackage().getFunctionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFunctionList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Name name;
            String string;
            void functionProto;
            ProtoBuf.Function function = (ProtoBuf.Function)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = $context_receiver_0.getLibraryPath();
            Intrinsics.checkNotNull((Object)functionProto);
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)functionProto;
            GeneratedMessageLite.GeneratedExtension generatedExtension = KlibMetadataProtoBuf.functionFile;
            Intrinsics.checkNotNullExpressionValue((Object)generatedExtension, (String)"functionFile");
            Integer n = (Integer)ProtoBufUtilKt.getExtensionOrNull((GeneratedMessageLite.ExtendableMessage)extendableMessage, (GeneratedMessageLite.GeneratedExtension)generatedExtension);
            if (n != null) {
                void fileNameId;
                int n2 = ((Number)n).intValue();
                Path path2 = path;
                boolean bl2 = false;
                string = $context_receiver_0.getNameResolver().getString((int)fileNameId);
                path = path2;
            } else {
                string = null;
            }
            FqName fqName = $context_receiver_0.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)Name.identifier((String)$context_receiver_0.getNameResolver().getString(functionProto.getName())), (String)"identifier(...)");
            FqName fqName2 = fqName;
            String string2 = string;
            Path path3 = path;
            collection.add(new KlibFunctionAddress(path3, string2, fqName2, name));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final byte[] readKlibDeclarationAddresses$lambda$1$lambda$0(KotlinLibrary $library, String $packageFragmentName, String packageMetadataPart) {
        Intrinsics.checkNotNullParameter((Object)packageMetadataPart, (String)"packageMetadataPart");
        Intrinsics.checkNotNull((Object)$packageFragmentName);
        return $library.packageMetadata($packageFragmentName, packageMetadataPart);
    }

    private static final Sequence readKlibDeclarationAddresses$lambda$1(KotlinLibrary $library, String packageFragmentName) {
        Intrinsics.checkNotNull((Object)packageFragmentName);
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$library.packageMetadataParts(packageFragmentName)), arg_0 -> ReadKlibDeclarationAddressesKt.readKlibDeclarationAddresses$lambda$1$lambda$0($library, packageFragmentName, arg_0));
    }

    private static final Iterable readKlibDeclarationAddresses$lambda$3(KotlinLibrary $library, byte[] packageMetadata) {
        Intrinsics.checkNotNullParameter((Object)packageMetadata, (String)"packageMetadata");
        ProtoBuf.PackageFragment packageFragmentProto = KlibMetadataDeserializationUtilsKt.parsePackageFragment((byte[])packageMetadata);
        PackageFragmentReadingContext packageFragmentReadingContext = PackageFragmentReadingContextKt.PackageFragmentReadingContext($library, packageFragmentProto);
        if (packageFragmentReadingContext == null) {
            return SetsKt.emptySet();
        }
        PackageFragmentReadingContext $this$readKlibDeclarationAddresses_u24lambda_u243_u24lambda_u242 = packageFragmentReadingContext;
        boolean bl = false;
        return SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus(ReadKlibDeclarationAddressesKt.readKlibClassAddresses($this$readKlibDeclarationAddresses_u24lambda_u243_u24lambda_u242, packageFragmentProto), (Iterable)ReadKlibDeclarationAddressesKt.readKlibTypeAliasAddresses($this$readKlibDeclarationAddresses_u24lambda_u243_u24lambda_u242, packageFragmentProto)), (Iterable)ReadKlibDeclarationAddressesKt.readKlibPropertyAddresses($this$readKlibDeclarationAddresses_u24lambda_u243_u24lambda_u242, packageFragmentProto)), (Iterable)ReadKlibDeclarationAddressesKt.readKlibFunctionAddresses($this$readKlibDeclarationAddresses_u24lambda_u243_u24lambda_u242, packageFragmentProto));
    }
}

