/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.bridge.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.sir.SirType;
import org.jetbrains.kotlin.sir.bridge.SirTypeNamer;
import org.jetbrains.kotlin.sir.bridge.impl.CType;
import org.jetbrains.kotlin.sir.bridge.impl.IdentityValueConversion;
import org.jetbrains.kotlin.sir.bridge.impl.KotlinType;
import org.jetbrains.kotlin.sir.bridge.impl.ValueConversion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u0082\u0001\u0004\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge;", "", "swiftType", "Lorg/jetbrains/kotlin/sir/SirType;", "kotlinType", "Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;", "cType", "Lorg/jetbrains/kotlin/sir/bridge/impl/CType;", "<init>", "(Lorg/jetbrains/kotlin/sir/SirType;Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;Lorg/jetbrains/kotlin/sir/bridge/impl/CType;)V", "getSwiftType", "()Lorg/jetbrains/kotlin/sir/SirType;", "getKotlinType", "()Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;", "getCType", "()Lorg/jetbrains/kotlin/sir/bridge/impl/CType;", "inKotlinSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "getInKotlinSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "inSwiftSources", "getInSwiftSources", "AsIs", "AsObject", "AsOpaqueObject", "AsObjCBridged", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsIs;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsObjCBridged;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsObject;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsOpaqueObject;", "sir-compiler-bridge"})
abstract class Bridge {
    @NotNull
    private final SirType swiftType;
    @NotNull
    private final KotlinType kotlinType;
    @NotNull
    private final CType cType;

    private Bridge(SirType swiftType, KotlinType kotlinType, CType cType) {
        this.swiftType = swiftType;
        this.kotlinType = kotlinType;
        this.cType = cType;
    }

    @NotNull
    public final SirType getSwiftType() {
        return this.swiftType;
    }

    @NotNull
    public final KotlinType getKotlinType() {
        return this.kotlinType;
    }

    @NotNull
    public final CType getCType() {
        return this.cType;
    }

    @NotNull
    public abstract ValueConversion getInKotlinSources();

    @NotNull
    public abstract ValueConversion getInSwiftSources();

    public /* synthetic */ Bridge(SirType swiftType, KotlinType kotlinType, CType cType, DefaultConstructorMarker $constructor_marker) {
        this(swiftType, kotlinType, cType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsIs;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge;", "swiftType", "Lorg/jetbrains/kotlin/sir/SirType;", "kotlinType", "Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;", "cType", "Lorg/jetbrains/kotlin/sir/bridge/impl/CType;", "<init>", "(Lorg/jetbrains/kotlin/sir/SirType;Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;Lorg/jetbrains/kotlin/sir/bridge/impl/CType;)V", "inKotlinSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/IdentityValueConversion;", "getInKotlinSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/IdentityValueConversion;", "inSwiftSources", "getInSwiftSources", "sir-compiler-bridge"})
    public static final class AsIs
    extends Bridge {
        @NotNull
        private final IdentityValueConversion inKotlinSources;
        @NotNull
        private final IdentityValueConversion inSwiftSources;

        public AsIs(@NotNull SirType swiftType, @NotNull KotlinType kotlinType, @NotNull CType cType) {
            Intrinsics.checkNotNullParameter((Object)swiftType, (String)"swiftType");
            Intrinsics.checkNotNullParameter((Object)((Object)kotlinType), (String)"kotlinType");
            Intrinsics.checkNotNullParameter((Object)((Object)cType), (String)"cType");
            super(swiftType, kotlinType, cType, null);
            this.inKotlinSources = IdentityValueConversion.INSTANCE;
            this.inSwiftSources = IdentityValueConversion.INSTANCE;
        }

        @Override
        @NotNull
        public IdentityValueConversion getInKotlinSources() {
            return this.inKotlinSources;
        }

        @Override
        @NotNull
        public IdentityValueConversion getInSwiftSources() {
            return this.inSwiftSources;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsObjCBridged;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge;", "swiftType", "Lorg/jetbrains/kotlin/sir/SirType;", "localKotlinType", "Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;", "cType", "Lorg/jetbrains/kotlin/sir/bridge/impl/CType;", "<init>", "(Lorg/jetbrains/kotlin/sir/SirType;Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;Lorg/jetbrains/kotlin/sir/bridge/impl/CType;)V", "inKotlinSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "getInKotlinSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "inSwiftSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/IdentityValueConversion;", "getInSwiftSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/IdentityValueConversion;", "sir-compiler-bridge"})
    public static final class AsObjCBridged
    extends Bridge {
        @NotNull
        private final ValueConversion inKotlinSources;
        @NotNull
        private final IdentityValueConversion inSwiftSources;

        public AsObjCBridged(@NotNull SirType swiftType, @NotNull KotlinType localKotlinType, @NotNull CType cType) {
            Intrinsics.checkNotNullParameter((Object)swiftType, (String)"swiftType");
            Intrinsics.checkNotNullParameter((Object)((Object)localKotlinType), (String)"localKotlinType");
            Intrinsics.checkNotNullParameter((Object)((Object)cType), (String)"cType");
            super(swiftType, KotlinType.ObjCObjectUnretained, cType, null);
            this.inKotlinSources = new ValueConversion(localKotlinType){
                final /* synthetic */ KotlinType $localKotlinType;
                {
                    this.$localKotlinType = $localKotlinType;
                }

                public String swiftToKotlin(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return "interpretObjCPointer<" + this.$localKotlinType.getRepr() + ">(" + valueExpression + ')';
                }

                public String kotlinToSwift(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return valueExpression + ".objcPtr()";
                }
            };
            this.inSwiftSources = IdentityValueConversion.INSTANCE;
        }

        @Override
        @NotNull
        public ValueConversion getInKotlinSources() {
            return this.inKotlinSources;
        }

        @Override
        @NotNull
        public IdentityValueConversion getInSwiftSources() {
            return this.inSwiftSources;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsObject;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge;", "swiftType", "Lorg/jetbrains/kotlin/sir/SirType;", "kotlinType", "Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;", "cType", "Lorg/jetbrains/kotlin/sir/bridge/impl/CType;", "<init>", "(Lorg/jetbrains/kotlin/sir/SirType;Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;Lorg/jetbrains/kotlin/sir/bridge/impl/CType;)V", "inKotlinSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "getInKotlinSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "inSwiftSources", "getInSwiftSources", "sir-compiler-bridge"})
    public static final class AsObject
    extends Bridge {
        @NotNull
        private final ValueConversion inKotlinSources;
        @NotNull
        private final ValueConversion inSwiftSources;

        public AsObject(@NotNull SirType swiftType, @NotNull KotlinType kotlinType, @NotNull CType cType) {
            Intrinsics.checkNotNullParameter((Object)swiftType, (String)"swiftType");
            Intrinsics.checkNotNullParameter((Object)((Object)kotlinType), (String)"kotlinType");
            Intrinsics.checkNotNullParameter((Object)((Object)cType), (String)"cType");
            super(swiftType, kotlinType, cType, null);
            this.inKotlinSources = new ValueConversion(swiftType){
                final /* synthetic */ SirType $swiftType;
                {
                    this.$swiftType = $swiftType;
                }

                public String swiftToKotlin(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return "kotlin.native.internal.ref.dereferenceExternalRCRef(" + valueExpression + ") as " + typeNamer.kotlinFqName(this.$swiftType);
                }

                public String kotlinToSwift(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return "kotlin.native.internal.ref.createRetainedExternalRCRef(" + valueExpression + ')';
                }
            };
            this.inSwiftSources = new ValueConversion(swiftType){
                final /* synthetic */ SirType $swiftType;
                {
                    this.$swiftType = $swiftType;
                }

                public String swiftToKotlin(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return valueExpression + ".__externalRCRef()";
                }

                public String kotlinToSwift(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return typeNamer.swiftFqName(this.$swiftType) + "(__externalRCRef: " + valueExpression + ')';
                }
            };
        }

        @Override
        @NotNull
        public ValueConversion getInKotlinSources() {
            return this.inKotlinSources;
        }

        @Override
        @NotNull
        public ValueConversion getInSwiftSources() {
            return this.inSwiftSources;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge$AsOpaqueObject;", "Lorg/jetbrains/kotlin/sir/bridge/impl/Bridge;", "swiftType", "Lorg/jetbrains/kotlin/sir/SirType;", "kotlinType", "Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;", "cType", "Lorg/jetbrains/kotlin/sir/bridge/impl/CType;", "<init>", "(Lorg/jetbrains/kotlin/sir/SirType;Lorg/jetbrains/kotlin/sir/bridge/impl/KotlinType;Lorg/jetbrains/kotlin/sir/bridge/impl/CType;)V", "inKotlinSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "getInKotlinSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/ValueConversion;", "inSwiftSources", "Lorg/jetbrains/kotlin/sir/bridge/impl/IdentityValueConversion;", "getInSwiftSources", "()Lorg/jetbrains/kotlin/sir/bridge/impl/IdentityValueConversion;", "sir-compiler-bridge"})
    public static final class AsOpaqueObject
    extends Bridge {
        @NotNull
        private final ValueConversion inKotlinSources;
        @NotNull
        private final IdentityValueConversion inSwiftSources;

        public AsOpaqueObject(@NotNull SirType swiftType, @NotNull KotlinType kotlinType, @NotNull CType cType) {
            Intrinsics.checkNotNullParameter((Object)swiftType, (String)"swiftType");
            Intrinsics.checkNotNullParameter((Object)((Object)kotlinType), (String)"kotlinType");
            Intrinsics.checkNotNullParameter((Object)((Object)cType), (String)"cType");
            super(swiftType, kotlinType, cType, null);
            this.inKotlinSources = new ValueConversion(){

                public String swiftToKotlin(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return "kotlin.native.internal.ref.dereferenceExternalRCRef(" + valueExpression + ')';
                }

                public String kotlinToSwift(SirTypeNamer typeNamer, String valueExpression) {
                    Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
                    Intrinsics.checkNotNullParameter((Object)valueExpression, (String)"valueExpression");
                    return "kotlin.native.internal.ref.createRetainedExternalRCRef(" + valueExpression + ')';
                }
            };
            this.inSwiftSources = IdentityValueConversion.INSTANCE;
        }

        @Override
        @NotNull
        public ValueConversion getInKotlinSources() {
            return this.inKotlinSources;
        }

        @Override
        @NotNull
        public IdentityValueConversion getInSwiftSources() {
            return this.inSwiftSources;
        }
    }
}

