/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// Auto-generated file. DO NOT EDIT!
// Generated by: org.jetbrains.kotlin.generators.builtins.contextParameters.GenerateContextFunctions

@file:kotlin.jvm.JvmName("ContextParametersKt")
@file:kotlin.jvm.JvmMultifileClass
package kotlin


/**
 * Runs the specified [block] with the given value in context scope.
 *
 * As opposed to [with], [context] only makes the value available for
 * context parameter resolution, but not as implicit receiver.
 *
 * @sample samples.misc.ContextParameters.useContext
 */
@kotlin.internal.InlineOnly
@SinceKotlin("2.2")
public inline fun <T, R> context(with: T, block: context(T) () -> R): R {
    kotlin.contracts.contract {
        callsInPlace(block, kotlin.contracts.InvocationKind.EXACTLY_ONCE)
    }
    return block(with)
}


/**
 * Runs the specified [block] with the given values in context scope.
 *
 * As opposed to [with], [context] only makes the values available for
 * context parameter resolution, but not as implicit receivers.
 *
 * @sample samples.misc.ContextParameters.useContext
 */
@kotlin.internal.InlineOnly
@SinceKotlin("2.2")
public inline fun <A, B, R> context(a: A, b: B, block: context(A, B) () -> R): R {
    kotlin.contracts.contract {
        callsInPlace(block, kotlin.contracts.InvocationKind.EXACTLY_ONCE)
    }
    return block(a, b)
}


/**
 * Runs the specified [block] with the given values in context scope.
 *
 * As opposed to [with], [context] only makes the values available for
 * context parameter resolution, but not as implicit receivers.
 *
 * @sample samples.misc.ContextParameters.useContext
 */
@kotlin.internal.InlineOnly
@SinceKotlin("2.2")
public inline fun <A, B, C, R> context(a: A, b: B, c: C, block: context(A, B, C) () -> R): R {
    kotlin.contracts.contract {
        callsInPlace(block, kotlin.contracts.InvocationKind.EXACTLY_ONCE)
    }
    return block(a, b, c)
}


/**
 * Runs the specified [block] with the given values in context scope.
 *
 * As opposed to [with], [context] only makes the values available for
 * context parameter resolution, but not as implicit receivers.
 *
 * @sample samples.misc.ContextParameters.useContext
 */
@kotlin.internal.InlineOnly
@SinceKotlin("2.2")
public inline fun <A, B, C, D, R> context(a: A, b: B, c: C, d: D, block: context(A, B, C, D) () -> R): R {
    kotlin.contracts.contract {
        callsInPlace(block, kotlin.contracts.InvocationKind.EXACTLY_ONCE)
    }
    return block(a, b, c, d)
}


/**
 * Runs the specified [block] with the given values in context scope.
 *
 * As opposed to [with], [context] only makes the values available for
 * context parameter resolution, but not as implicit receivers.
 *
 * @sample samples.misc.ContextParameters.useContext
 */
@kotlin.internal.InlineOnly
@SinceKotlin("2.2")
public inline fun <A, B, C, D, E, R> context(a: A, b: B, c: C, d: D, e: E, block: context(A, B, C, D, E) () -> R): R {
    kotlin.contracts.contract {
        callsInPlace(block, kotlin.contracts.InvocationKind.EXACTLY_ONCE)
    }
    return block(a, b, c, d, e)
}


/**
 * Runs the specified [block] with the given values in context scope.
 *
 * As opposed to [with], [context] only makes the values available for
 * context parameter resolution, but not as implicit receivers.
 *
 * @sample samples.misc.ContextParameters.useContext
 */
@kotlin.internal.InlineOnly
@SinceKotlin("2.2")
public inline fun <A, B, C, D, E, F, R> context(a: A, b: B, c: C, d: D, e: E, f: F, block: context(A, B, C, D, E, F) () -> R): R {
    kotlin.contracts.contract {
        callsInPlace(block, kotlin.contracts.InvocationKind.EXACTLY_ONCE)
    }
    return block(a, b, c, d, e, f)
}

