package kotlin

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import java.util.*

/**
 * Returns 1st *element* from the collection.
 */
public inline fun <T> Array<out T>.component1(): T {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun BooleanArray.component1(): Boolean {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun ByteArray.component1(): Byte {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun CharArray.component1(): Char {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun DoubleArray.component1(): Double {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun FloatArray.component1(): Float {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun IntArray.component1(): Int {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun LongArray.component1(): Long {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun ShortArray.component1(): Short {
    return get(0)
}

/**
 * Returns 1st *element* from the collection.
 */
public inline fun <T> List<T>.component1(): T {
    return get(0)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun <T> Array<out T>.component2(): T {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun BooleanArray.component2(): Boolean {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun ByteArray.component2(): Byte {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun CharArray.component2(): Char {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun DoubleArray.component2(): Double {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun FloatArray.component2(): Float {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun IntArray.component2(): Int {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun LongArray.component2(): Long {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun ShortArray.component2(): Short {
    return get(1)
}

/**
 * Returns 2nd *element* from the collection.
 */
public inline fun <T> List<T>.component2(): T {
    return get(1)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun <T> Array<out T>.component3(): T {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun BooleanArray.component3(): Boolean {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun ByteArray.component3(): Byte {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun CharArray.component3(): Char {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun DoubleArray.component3(): Double {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun FloatArray.component3(): Float {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun IntArray.component3(): Int {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun LongArray.component3(): Long {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun ShortArray.component3(): Short {
    return get(2)
}

/**
 * Returns 3rd *element* from the collection.
 */
public inline fun <T> List<T>.component3(): T {
    return get(2)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun <T> Array<out T>.component4(): T {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun BooleanArray.component4(): Boolean {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun ByteArray.component4(): Byte {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun CharArray.component4(): Char {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun DoubleArray.component4(): Double {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun FloatArray.component4(): Float {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun IntArray.component4(): Int {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun LongArray.component4(): Long {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun ShortArray.component4(): Short {
    return get(3)
}

/**
 * Returns 4th *element* from the collection.
 */
public inline fun <T> List<T>.component4(): T {
    return get(3)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun <T> Array<out T>.component5(): T {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun BooleanArray.component5(): Boolean {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun ByteArray.component5(): Byte {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun CharArray.component5(): Char {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun DoubleArray.component5(): Double {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun FloatArray.component5(): Float {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun IntArray.component5(): Int {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun LongArray.component5(): Long {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun ShortArray.component5(): Short {
    return get(4)
}

/**
 * Returns 5th *element* from the collection.
 */
public inline fun <T> List<T>.component5(): T {
    return get(4)
}

/**
 * Returns true if *element* is found in the collection
 */
public fun <T> Array<out T>.contains(element: T): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun BooleanArray.contains(element: Boolean): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun ByteArray.contains(element: Byte): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun CharArray.contains(element: Char): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun DoubleArray.contains(element: Double): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun FloatArray.contains(element: Float): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun IntArray.contains(element: Int): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun LongArray.contains(element: Long): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun ShortArray.contains(element: Short): Boolean {
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun <T> Iterable<T>.contains(element: T): Boolean {
    if (this is Collection<*>)
        return contains(element)
    return indexOf(element) >= 0
}

/**
 * Returns true if *element* is found in the collection
 */
public fun <T> Stream<T>.contains(element: T): Boolean {
    if (this is Collection<*>)
        return contains(element)
    return indexOf(element) >= 0
}

/**
 * Returns element at given *index*
 */
public fun <T> Array<out T>.elementAt(index: Int): T {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun BooleanArray.elementAt(index: Int): Boolean {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun ByteArray.elementAt(index: Int): Byte {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun CharArray.elementAt(index: Int): Char {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun DoubleArray.elementAt(index: Int): Double {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun FloatArray.elementAt(index: Int): Float {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun IntArray.elementAt(index: Int): Int {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun LongArray.elementAt(index: Int): Long {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun ShortArray.elementAt(index: Int): Short {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun <T> Iterable<T>.elementAt(index: Int): T {
    if (this is List<*>)
        return get(index) as T
    val iterator = iterator()
    var count = 0
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (index == count++)
            return element
    }
    throw IndexOutOfBoundsException("Collection doesn't contain element at index")
}

/**
 * Returns element at given *index*
 */
public fun <T> List<T>.elementAt(index: Int): T {
    return get(index)
}

/**
 * Returns element at given *index*
 */
public fun <T> Stream<T>.elementAt(index: Int): T {
    val iterator = iterator()
    var count = 0
    while (iterator.hasNext()) {
        val element = iterator.next()
        if (index == count++)
            return element
    }
    throw IndexOutOfBoundsException("Collection doesn't contain element at index")
}

/**
 * Returns element at given *index*
 */
public fun String.elementAt(index: Int): Char {
    return get(index)
}

/**
 * Returns first element
 */
public fun <T> Array<out T>.first(): T {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun BooleanArray.first(): Boolean {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun ByteArray.first(): Byte {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun CharArray.first(): Char {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun DoubleArray.first(): Double {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun FloatArray.first(): Float {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun IntArray.first(): Int {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun LongArray.first(): Long {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun ShortArray.first(): Short {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun <T> Iterable<T>.first(): T {
    when (this) {
        is List<*> -> {
            if (size == 0)
                throw NoSuchElementException("Collection is empty")
            else
                return this[0] as T
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw NoSuchElementException("Collection is empty")
            return iterator.next()
        }
    }
}

/**
 * Returns first element
 */
public fun <T> List<T>.first(): T {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element
 */
public fun <T> Stream<T>.first(): T {
    when (this) {
        is List<*> -> {
            if (size == 0)
                throw NoSuchElementException("Collection is empty")
            else
                return this[0] as T
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw NoSuchElementException("Collection is empty")
            return iterator.next()
        }
    }
}

/**
 * Returns first element
 */
public fun String.first(): Char {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[0]
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun <T> Array<out T>.first(predicate: (T) -> Boolean): T {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun BooleanArray.first(predicate: (Boolean) -> Boolean): Boolean {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun ByteArray.first(predicate: (Byte) -> Boolean): Byte {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun CharArray.first(predicate: (Char) -> Boolean): Char {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun DoubleArray.first(predicate: (Double) -> Boolean): Double {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun FloatArray.first(predicate: (Float) -> Boolean): Float {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun IntArray.first(predicate: (Int) -> Boolean): Int {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun LongArray.first(predicate: (Long) -> Boolean): Long {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun ShortArray.first(predicate: (Short) -> Boolean): Short {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun <T> Iterable<T>.first(predicate: (T) -> Boolean): T {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun <T> Stream<T>.first(predicate: (T) -> Boolean): T {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element matching the given *predicate*
 */
public inline fun String.first(predicate: (Char) -> Boolean): Char {
    for (element in this) if (predicate(element)) return element
    throw NoSuchElementException("No element matching predicate was found")
}

/**
 * Returns first element, or null if collection is empty
 */
public fun <T> Array<out T>.firstOrNull(): T? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun BooleanArray.firstOrNull(): Boolean? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun ByteArray.firstOrNull(): Byte? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun CharArray.firstOrNull(): Char? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun DoubleArray.firstOrNull(): Double? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun FloatArray.firstOrNull(): Float? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun IntArray.firstOrNull(): Int? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun LongArray.firstOrNull(): Long? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun ShortArray.firstOrNull(): Short? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun <T> Iterable<T>.firstOrNull(): T? {
    when (this) {
        is List<*> -> {
            if (size == 0)
                return null
            else
                return this[0] as T
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            return iterator.next()
        }
    }
}

/**
 * Returns first element, or null if collection is empty
 */
public fun <T> List<T>.firstOrNull(): T? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element, or null if collection is empty
 */
public fun <T> Stream<T>.firstOrNull(): T? {
    when (this) {
        is List<*> -> {
            if (size == 0)
                return null
            else
                return this[0] as T
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            return iterator.next()
        }
    }
}

/**
 * Returns first element, or null if collection is empty
 */
public fun String.firstOrNull(): Char? {
    return if (size > 0) this[0] else null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun <T> Array<out T>.firstOrNull(predicate: (T) -> Boolean): T? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun BooleanArray.firstOrNull(predicate: (Boolean) -> Boolean): Boolean? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun ByteArray.firstOrNull(predicate: (Byte) -> Boolean): Byte? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun CharArray.firstOrNull(predicate: (Char) -> Boolean): Char? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun DoubleArray.firstOrNull(predicate: (Double) -> Boolean): Double? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun FloatArray.firstOrNull(predicate: (Float) -> Boolean): Float? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun IntArray.firstOrNull(predicate: (Int) -> Boolean): Int? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun LongArray.firstOrNull(predicate: (Long) -> Boolean): Long? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun ShortArray.firstOrNull(predicate: (Short) -> Boolean): Short? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun <T> Iterable<T>.firstOrNull(predicate: (T) -> Boolean): T? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun <T> Stream<T>.firstOrNull(predicate: (T) -> Boolean): T? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first element matching the given *predicate*, or *null* if element was not found
 */
public inline fun String.firstOrNull(predicate: (Char) -> Boolean): Char? {
    for (element in this) if (predicate(element)) return element
    return null
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Array<out T>.indexOf(element: T): Int {
    if (element == null) {
        for (index in indices) {
            if (this[index] == null) {
                return index
            }
        }
    } else {
        for (index in indices) {
            if (element == this[index]) {
                return index
            }
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun BooleanArray.indexOf(element: Boolean): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun ByteArray.indexOf(element: Byte): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun CharArray.indexOf(element: Char): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun DoubleArray.indexOf(element: Double): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun FloatArray.indexOf(element: Float): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun IntArray.indexOf(element: Int): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun LongArray.indexOf(element: Long): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun ShortArray.indexOf(element: Short): Int {
    for (index in indices) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Iterable<T>.indexOf(element: T): Int {
    var index = 0
    for (item in this) {
        if (element == item)
            return index
        index++
    }
    return -1
}

/**
 * Returns first index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Stream<T>.indexOf(element: T): Int {
    var index = 0
    for (item in this) {
        if (element == item)
            return index
        index++
    }
    return -1
}

/**
 * Returns last element
 */
public fun <T> Array<out T>.last(): T {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun BooleanArray.last(): Boolean {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun ByteArray.last(): Byte {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun CharArray.last(): Char {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun DoubleArray.last(): Double {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun FloatArray.last(): Float {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun IntArray.last(): Int {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun LongArray.last(): Long {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun ShortArray.last(): Short {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun <T> Iterable<T>.last(): T {
    when (this) {
        is List<*> -> {
            if (size == 0)
                throw NoSuchElementException("Collection is empty")
            else
                return this[size - 1] as T
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw NoSuchElementException("Collection is empty")
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
}

/**
 * Returns last element
 */
public fun <T> List<T>.last(): T {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element
 */
public fun <T> Stream<T>.last(): T {
    when (this) {
        is List<*> -> {
            if (size == 0)
                throw NoSuchElementException("Collection is empty")
            else
                return this[size - 1] as T
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw NoSuchElementException("Collection is empty")
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
}

/**
 * Returns last element
 */
public fun String.last(): Char {
    if (size == 0)
        throw NoSuchElementException("Collection is empty")
    return this[size - 1]
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun <T> Array<out T>.last(predicate: (T) -> Boolean): T {
    var last: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as T
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun BooleanArray.last(predicate: (Boolean) -> Boolean): Boolean {
    var last: Boolean? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Boolean
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun ByteArray.last(predicate: (Byte) -> Boolean): Byte {
    var last: Byte? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Byte
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun CharArray.last(predicate: (Char) -> Boolean): Char {
    var last: Char? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Char
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun DoubleArray.last(predicate: (Double) -> Boolean): Double {
    var last: Double? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Double
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun FloatArray.last(predicate: (Float) -> Boolean): Float {
    var last: Float? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Float
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun IntArray.last(predicate: (Int) -> Boolean): Int {
    var last: Int? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Int
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun LongArray.last(predicate: (Long) -> Boolean): Long {
    var last: Long? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Long
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun ShortArray.last(predicate: (Short) -> Boolean): Short {
    var last: Short? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Short
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun <T> Iterable<T>.last(predicate: (T) -> Boolean): T {
    var last: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as T
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun <T> Stream<T>.last(predicate: (T) -> Boolean): T {
    var last: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as T
}

/**
 * Returns last element matching the given *predicate*
 */
public inline fun String.last(predicate: (Char) -> Boolean): Char {
    var last: Char? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            last = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return last as Char
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Array<out T>.lastIndexOf(element: T): Int {
    if (element == null) {
        for (index in indices.reverse()) {
            if (this[index] == null) {
                return index
            }
        }
    } else {
        for (index in indices.reverse()) {
            if (element == this[index]) {
                return index
            }
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun BooleanArray.lastIndexOf(element: Boolean): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun ByteArray.lastIndexOf(element: Byte): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun CharArray.lastIndexOf(element: Char): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun DoubleArray.lastIndexOf(element: Double): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun FloatArray.lastIndexOf(element: Float): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun IntArray.lastIndexOf(element: Int): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun LongArray.lastIndexOf(element: Long): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun ShortArray.lastIndexOf(element: Short): Int {
    for (index in indices.reverse()) {
        if (element == this[index]) {
            return index
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Iterable<T>.lastIndexOf(element: T): Int {
    var lastIndex = -1
    var index = 0
    for (item in this) {
        if (element == item)
            lastIndex = index
        index++
    }
    return lastIndex
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> List<T>.lastIndexOf(element: T): Int {
    if (element == null) {
        for (index in indices.reverse()) {
            if (this[index] == null) {
                return index
            }
        }
    } else {
        for (index in indices.reverse()) {
            if (element == this[index]) {
                return index
            }
        }
    }
    return -1
}

/**
 * Returns last index of *element*, or -1 if the collection does not contain element
 */
public fun <T> Stream<T>.lastIndexOf(element: T): Int {
    var lastIndex = -1
    var index = 0
    for (item in this) {
        if (element == item)
            lastIndex = index
        index++
    }
    return lastIndex
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> Array<out T>.lastOrNull(): T? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun BooleanArray.lastOrNull(): Boolean? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun ByteArray.lastOrNull(): Byte? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun CharArray.lastOrNull(): Char? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun DoubleArray.lastOrNull(): Double? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun FloatArray.lastOrNull(): Float? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun IntArray.lastOrNull(): Int? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun LongArray.lastOrNull(): Long? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun ShortArray.lastOrNull(): Short? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> Iterable<T>.lastOrNull(): T? {
    when (this) {
        is List<*> -> return if (size > 0) this[size - 1] as T else null
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> List<T>.lastOrNull(): T? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element, or null if collection is empty
 */
public fun <T> Stream<T>.lastOrNull(): T? {
    when (this) {
        is List<*> -> return if (size > 0) this[size - 1] as T else null
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var last = iterator.next()
            while (iterator.hasNext())
                last = iterator.next()
            return last
        }
    }
}

/**
 * Returns last element, or null if collection is empty
 */
public fun String.lastOrNull(): Char? {
    return if (size > 0) this[size - 1] else null
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun <T> Array<out T>.lastOrNull(predicate: (T) -> Boolean): T? {
    var last: T? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun BooleanArray.lastOrNull(predicate: (Boolean) -> Boolean): Boolean? {
    var last: Boolean? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun ByteArray.lastOrNull(predicate: (Byte) -> Boolean): Byte? {
    var last: Byte? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun CharArray.lastOrNull(predicate: (Char) -> Boolean): Char? {
    var last: Char? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun DoubleArray.lastOrNull(predicate: (Double) -> Boolean): Double? {
    var last: Double? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun FloatArray.lastOrNull(predicate: (Float) -> Boolean): Float? {
    var last: Float? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun IntArray.lastOrNull(predicate: (Int) -> Boolean): Int? {
    var last: Int? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun LongArray.lastOrNull(predicate: (Long) -> Boolean): Long? {
    var last: Long? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun ShortArray.lastOrNull(predicate: (Short) -> Boolean): Short? {
    var last: Short? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun <T> Iterable<T>.lastOrNull(predicate: (T) -> Boolean): T? {
    var last: T? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun <T> Stream<T>.lastOrNull(predicate: (T) -> Boolean): T? {
    var last: T? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns last element matching the given *predicate*, or null if element was not found
 */
public inline fun String.lastOrNull(predicate: (Char) -> Boolean): Char? {
    var last: Char? = null
    for (element in this) {
        if (predicate(element)) {
            last = element
        }
    }
    return last
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> Array<out T>.single(): T {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun BooleanArray.single(): Boolean {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun ByteArray.single(): Byte {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun CharArray.single(): Char {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun DoubleArray.single(): Double {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun FloatArray.single(): Float {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun IntArray.single(): Int {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun LongArray.single(): Long {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun ShortArray.single(): Short {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> Iterable<T>.single(): T {
    when (this) {
        is List<*> -> return when (size) {
            0 -> throw NoSuchElementException("Collection is empty")
            1 -> this[0] as T
            else -> throw IllegalArgumentException("Collection has more than one element")
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw NoSuchElementException("Collection is empty")
            var single = iterator.next()
            if (iterator.hasNext())
                throw IllegalArgumentException("Collection has more than one element")
            return single
        }
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> List<T>.single(): T {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun <T> Stream<T>.single(): T {
    when (this) {
        is List<*> -> return when (size) {
            0 -> throw NoSuchElementException("Collection is empty")
            1 -> this[0] as T
            else -> throw IllegalArgumentException("Collection has more than one element")
        }
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                throw NoSuchElementException("Collection is empty")
            var single = iterator.next()
            if (iterator.hasNext())
                throw IllegalArgumentException("Collection has more than one element")
            return single
        }
    }
}

/**
 * Returns single element, or throws exception if there is no or more than one element
 */
public fun String.single(): Char {
    return when (size) {
        0 -> throw NoSuchElementException("Collection is empty")
        1 -> this[0]
        else -> throw IllegalArgumentException("Collection has more than one element")
    }
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun <T> Array<out T>.single(predicate: (T) -> Boolean): T {
    var single: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as T
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun BooleanArray.single(predicate: (Boolean) -> Boolean): Boolean {
    var single: Boolean? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Boolean
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun ByteArray.single(predicate: (Byte) -> Boolean): Byte {
    var single: Byte? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Byte
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun CharArray.single(predicate: (Char) -> Boolean): Char {
    var single: Char? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Char
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun DoubleArray.single(predicate: (Double) -> Boolean): Double {
    var single: Double? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Double
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun FloatArray.single(predicate: (Float) -> Boolean): Float {
    var single: Float? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Float
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun IntArray.single(predicate: (Int) -> Boolean): Int {
    var single: Int? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Int
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun LongArray.single(predicate: (Long) -> Boolean): Long {
    var single: Long? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Long
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun ShortArray.single(predicate: (Short) -> Boolean): Short {
    var single: Short? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Short
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun <T> Iterable<T>.single(predicate: (T) -> Boolean): T {
    var single: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as T
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun <T> Stream<T>.single(predicate: (T) -> Boolean): T {
    var single: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as T
}

/**
 * Returns single element matching the given *predicate*, or throws exception if there is no or more than one element
 */
public inline fun String.single(predicate: (Char) -> Boolean): Char {
    var single: Char? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) throw IllegalArgumentException("Collection contains more than one matching element")
            single = element
            found = true
        }
    }
    if (!found) throw NoSuchElementException("Collection doesn't contain any element matching predicate")
    return single as Char
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> Array<out T>.singleOrNull(): T? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun BooleanArray.singleOrNull(): Boolean? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun ByteArray.singleOrNull(): Byte? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun CharArray.singleOrNull(): Char? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun DoubleArray.singleOrNull(): Double? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun FloatArray.singleOrNull(): Float? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun IntArray.singleOrNull(): Int? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun LongArray.singleOrNull(): Long? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun ShortArray.singleOrNull(): Short? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> Iterable<T>.singleOrNull(): T? {
    when (this) {
        is List<*> -> return if (size == 1) this[0] as T else null
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var single = iterator.next()
            if (iterator.hasNext())
                return null
            return single
        }
    }
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> List<T>.singleOrNull(): T? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun <T> Stream<T>.singleOrNull(): T? {
    when (this) {
        is List<*> -> return if (size == 1) this[0] as T else null
        else -> {
            val iterator = iterator()
            if (!iterator.hasNext())
                return null
            var single = iterator.next()
            if (iterator.hasNext())
                return null
            return single
        }
    }
}

/**
 * Returns single element, or null if collection is empty, or throws exception if there is more than one element
 */
public fun String.singleOrNull(): Char? {
    return if (size == 1) this[0] else null
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun <T> Array<out T>.singleOrNull(predicate: (T) -> Boolean): T? {
    var single: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun BooleanArray.singleOrNull(predicate: (Boolean) -> Boolean): Boolean? {
    var single: Boolean? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun ByteArray.singleOrNull(predicate: (Byte) -> Boolean): Byte? {
    var single: Byte? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun CharArray.singleOrNull(predicate: (Char) -> Boolean): Char? {
    var single: Char? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun DoubleArray.singleOrNull(predicate: (Double) -> Boolean): Double? {
    var single: Double? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun FloatArray.singleOrNull(predicate: (Float) -> Boolean): Float? {
    var single: Float? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun IntArray.singleOrNull(predicate: (Int) -> Boolean): Int? {
    var single: Int? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun LongArray.singleOrNull(predicate: (Long) -> Boolean): Long? {
    var single: Long? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun ShortArray.singleOrNull(predicate: (Short) -> Boolean): Short? {
    var single: Short? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun <T> Iterable<T>.singleOrNull(predicate: (T) -> Boolean): T? {
    var single: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun <T> Stream<T>.singleOrNull(predicate: (T) -> Boolean): T? {
    var single: T? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

/**
 * Returns single element matching the given *predicate*, or null if element was not found or more than one elements were found
 */
public inline fun String.singleOrNull(predicate: (Char) -> Boolean): Char? {
    var single: Char? = null
    var found = false
    for (element in this) {
        if (predicate(element)) {
            if (found) return null
            single = element
            found = true
        }
    }
    if (!found) return null
    return single
}

