/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.PlatformRandomKt;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0018H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lkotlin/random/Random;", "", "()V", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "bound", "origin", "nextFloat", "", "nextInt", "range", "Lkotlin/ranges/IntRange;", "nextLong", "", "Lkotlin/ranges/LongRange;", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
public abstract class Random {
    private static final Random defaultRandom;
    public static final Companion Companion;

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    public int nextInt(int bound) {
        return this.nextInt(0, bound);
    }

    public int nextInt(int origin, int bound) {
        int rnd;
        int n;
        RandomKt.checkRangeBounds(origin, bound);
        int n2 = bound - origin;
        if (n2 > 0 || n2 == Integer.MIN_VALUE) {
            int n3;
            if ((n2 & -n2) == n2) {
                int bitCount = PlatformRandomKt.fastLog2(n2);
                n3 = this.nextBits(bitCount);
            } else {
                int v;
                int bits;
                while ((bits = this.nextInt() >>> 1) - (v = bits % n2) + (n2 - 1) < 0) {
                }
                n3 = v;
            }
            int rnd2 = n3;
            return origin + rnd2;
        }
        while (origin > (n = (rnd = this.nextInt())) || bound <= n) {
        }
        return rnd;
    }

    public int nextInt(@NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull(range, "range");
        if (range.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Cannot get random in empty range: " + range);
        }
        return range.getLast() < Integer.MAX_VALUE ? this.nextInt(range.getFirst(), range.getLast() + 1) : (range.getFirst() > Integer.MIN_VALUE ? this.nextInt(range.getFirst() - 1, range.getLast()) + 1 : this.nextInt());
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public long nextLong(long bound) {
        return this.nextLong(0L, bound);
    }

    public long nextLong(long origin, long bound) {
        long rnd;
        long l;
        RandomKt.checkRangeBounds(origin, bound);
        long n = bound - origin;
        if (n > 0L) {
            long rnd2;
            if ((n & -n) == n) {
                long l2;
                int bitCount;
                int nLow = (int)n;
                int nHigh = (int)(n >>> 32);
                if (nLow != 0) {
                    bitCount = PlatformRandomKt.fastLog2(nLow);
                    l2 = (long)this.nextBits(bitCount) & 0xFFFFFFFFL;
                } else if (nHigh == 1) {
                    l2 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    bitCount = PlatformRandomKt.fastLog2(nHigh);
                    l2 = ((long)this.nextBits(bitCount) << 32) + (long)this.nextInt();
                }
                rnd2 = l2;
            } else {
                long v;
                long bits;
                while ((bits = this.nextLong() >>> 1) - (v = bits % n) + (n - 1L) < 0L) {
                }
                rnd2 = v;
            }
            return origin + rnd2;
        }
        while (origin > (l = (rnd = this.nextLong())) || bound <= l) {
        }
        return rnd;
    }

    public long nextLong(@NotNull LongRange range) {
        Intrinsics.checkParameterIsNotNull(range, "range");
        if (range.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Cannot get random in empty range: " + range);
        }
        return range.getLast() < Long.MAX_VALUE ? this.nextLong(range.getStart(), range.getEndInclusive() + 1L) : (range.getStart() > Long.MIN_VALUE ? this.nextLong(range.getStart() - 1L, range.getEndInclusive()) + 1L : this.nextLong());
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    public double nextDouble(double bound) {
        return this.nextDouble(0.0, bound);
    }

    public double nextDouble(double origin, double bound) {
        double d;
        double r;
        double d2;
        double d3;
        double size;
        RandomKt.checkRangeBounds(origin, bound);
        double d4 = size = bound - origin;
        if (Double.isInfinite(d4) && !Double.isInfinite(d3 = (d4 = origin)) && !Double.isNaN(d3 = d4) && !Double.isInfinite(d3 = (d4 = bound)) && !Double.isNaN(d3 = d4)) {
            double r1 = this.nextDouble() * (bound / (double)2 - origin / (double)2);
            d2 = origin + r1 + r1;
        } else {
            d2 = r = origin + this.nextDouble() * size;
        }
        if (r >= bound) {
            d4 = bound;
            d = Math.nextAfter(d4, DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
        } else {
            d = r;
        }
        return d;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / (float)0x1000000;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
        int it;
        Intrinsics.checkParameterIsNotNull(array, "array");
        int n = fromIndex;
        int n2 = n = 0 <= n && array.length >= n && 0 <= (n = toIndex) && array.length >= n ? 1 : 0;
        if (n == 0) {
            String string = "fromIndex (" + fromIndex + ") or toIndex (" + toIndex + ") are out of range: 0.." + array.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n3 = n = fromIndex <= toIndex ? 1 : 0;
        if (n == 0) {
            String string = "fromIndex (" + fromIndex + ") must be not greater than toIndex (" + toIndex + ").";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int steps = (toIndex - fromIndex) / 4;
        int position = fromIndex;
        int n4 = 0;
        int n5 = steps;
        while (n4 < n5) {
            it = n4++;
            int v = this.nextInt();
            array[position] = (byte)v;
            array[position + 1] = (byte)(v >>> 8);
            array[position + 2] = (byte)(v >>> 16);
            array[position + 3] = (byte)(v >>> 24);
            position += 4;
        }
        int remainder = toIndex - position;
        int vr = this.nextBits(remainder * 8);
        it = 0;
        int n6 = remainder;
        while (it < n6) {
            void i;
            array[position + i] = (byte)(vr >>> i * 8);
            ++i;
        }
        return array;
    }

    @NotNull
    public static /* synthetic */ byte[] nextBytes$default(Random random, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return random.nextBytes(byArray, n, n2);
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] array) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        return this.nextBytes(array, 0, array.length);
    }

    @NotNull
    public byte[] nextBytes(int size) {
        return this.nextBytes(new byte[size]);
    }

    static {
        Companion = new Companion(null);
        defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlin/random/Random$Companion;", "Lkotlin/random/Random;", "()V", "defaultRandom", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "bound", "origin", "nextFloat", "", "nextInt", "range", "Lkotlin/ranges/IntRange;", "nextLong", "", "Lkotlin/ranges/LongRange;", "kotlin-stdlib"})
    public static final class Companion
    extends Random {
        @Override
        public int nextBits(int bitCount) {
            return defaultRandom.nextBits(bitCount);
        }

        @Override
        public int nextInt() {
            return defaultRandom.nextInt();
        }

        @Override
        public int nextInt(int bound) {
            return defaultRandom.nextInt(bound);
        }

        @Override
        public int nextInt(int origin, int bound) {
            return defaultRandom.nextInt(origin, bound);
        }

        @Override
        public int nextInt(@NotNull IntRange range) {
            Intrinsics.checkParameterIsNotNull(range, "range");
            return defaultRandom.nextInt(range);
        }

        @Override
        public long nextLong() {
            return defaultRandom.nextLong();
        }

        @Override
        public long nextLong(long bound) {
            return defaultRandom.nextLong(bound);
        }

        @Override
        public long nextLong(long origin, long bound) {
            return defaultRandom.nextLong(origin, bound);
        }

        @Override
        public long nextLong(@NotNull LongRange range) {
            Intrinsics.checkParameterIsNotNull(range, "range");
            return defaultRandom.nextLong(range);
        }

        @Override
        public boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public double nextDouble() {
            return defaultRandom.nextDouble();
        }

        @Override
        public double nextDouble(double bound) {
            return defaultRandom.nextDouble(bound);
        }

        @Override
        public double nextDouble(double origin, double bound) {
            return defaultRandom.nextDouble(origin, bound);
        }

        @Override
        public float nextFloat() {
            return defaultRandom.nextFloat();
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] array) {
            Intrinsics.checkParameterIsNotNull(array, "array");
            return defaultRandom.nextBytes(array);
        }

        @Override
        @NotNull
        public byte[] nextBytes(int size) {
            return defaultRandom.nextBytes(size);
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
            Intrinsics.checkParameterIsNotNull(array, "array");
            return defaultRandom.nextBytes(array, fromIndex, toIndex);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

