/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.Function0;
import jet.Function1;
import jet.Function2;
import jet.Unit;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$8;
import kotlin.KotlinPackage$sortBy$sortBy$8;
import kotlin.KotlinPackage$src$IterablesSpecial$2aa30a87;
import kotlin.KotlinPackage$src$Maps$d342c8;
import kotlin.KotlinPackage$src$OrderingJVM$625d3d22;
import kotlin.Pair;

public final class KotlinPackage$src$_Iterables$4b9c149f {
    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Z")
    public static final <T> boolean all(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Z")
    public static final <T> boolean any(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="I")
    public static final <T> int count(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        for (T element : $receiver) {
            Object object2;
            if (((Boolean)predicate.invoke(element)).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @JetMethod(typeParameters="<erased T:Ljava/lang/Object;>", returnType="?TT;")
    public static final <T> T find(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TT;>;>", returnType="TC;")
    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = (Boolean)predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TT;>;>", returnType="TC;")
    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = (Boolean)predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:Ljava/lang/Object;erased C::Ljet/MutableCollection<-TT;>;>", returnType="TC;")
    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<?TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result) {
        for (T element : $receiver) {
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Lkotlin/Pair<Ljet/List<TT;>;Ljet/List<TT;>;>;")
    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        for (T element : $receiver) {
            boolean bl = (Boolean)predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<TT;TR;>;") Function1<? super T, ? extends R> transform) {
        for (T item : $receiver) {
            result.add((Object)transform.invoke(item));
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<TT;Ljet/Iterable<TR;>;>;") Function1<? super T, ? extends Iterable<? extends R>> transform) {
        for (T element : $receiver) {
            Iterable list2 = (Iterable)transform.invoke(element);
            for (Object r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="V")
    public static final <T> void forEach(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="operation", type="Ljet/Function1<TT;Ljet/Unit;>;") Function1<? super T, ? extends Unit> operation) {
        for (T element : $receiver) {
            operation.invoke(element);
        }
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <T, R> R fold(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<TR;TT;TR;>;") Function2<? super R, ? super T, ? extends R> operation) {
        Object answer = initial;
        for (T element : $receiver) {
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T reduce(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<TT;TT;TT;>;") Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        Object result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/List<TT;>;>;")
    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="toKey", type="Ljet/Function1<TT;TK;>;") Function1<? super T, ? extends K> toKey) {
        return KotlinPackage$src$_Iterables$4b9c149f.groupByTo($receiver, new HashMap(), toKey);
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/MutableList<TT;>;>;")
    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="Ljet/MutableMap<TK;Ljet/MutableList<TT;>;>;") Map<K, List<T>> result, @JetValueParameter(name="toKey", type="Ljet/Function1<TT;TK;>;") Function1<? super T, ? extends K> toKey) {
        for (T element : $receiver) {
            Object key = toKey.invoke(element);
            List<T> list2 = KotlinPackage$src$Maps$d342c8.getOrPut(result, key, (Function0)KotlinPackage$groupByTo$list$8.instance$);
            list2.add(element);
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljet/List<TT;>;")
    public static final <T> List<T> drop(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_Iterables$4b9c149f.dropWhile($receiver, KotlinPackage$src$IterablesSpecial$2aa30a87.countTo(n));
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljet/List<TT;>;")
    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_Iterables$4b9c149f.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased L::Ljet/MutableList<-TT;>;>", returnType="TL;")
    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TL;") L result, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        for (T element : $receiver) {
            Object object2;
            if (!(start != 0 ? (Boolean)predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TT;>;>", returnType="TC;")
    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!((Boolean)predicate.invoke(element)).booleanValue()) break;
            result.add(element);
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TT;>;>", returnType="TC;")
    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="result", type="TC;") C result) {
        for (T element : $receiver) {
            result.add(element);
        }
        return result;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljet/List<TT;>;")
    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage$src$_Iterables$4b9c149f.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljava/util/LinkedList<TT;>;")
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver) {
        return (LinkedList)KotlinPackage$src$_Iterables$4b9c149f.toCollection($receiver, (Collection)new LinkedList());
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljet/List<TT;>;")
    public static final <T> List<T> toList(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver) {
        return (ArrayList)KotlinPackage$src$_Iterables$4b9c149f.toCollection($receiver, (Collection)new ArrayList());
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljet/Set<TT;>;")
    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver) {
        return (LinkedHashSet)KotlinPackage$src$_Iterables$4b9c149f.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljava/util/SortedSet<TT;>;")
    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver) {
        return (TreeSet)KotlinPackage$src$_Iterables$4b9c149f.toCollection($receiver, (Collection)new TreeSet());
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljet/Iterator<Lkotlin/Pair<Ljava/lang/Integer;TT;>;>;")
    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver) {
        return new IndexIterator<T>($receiver.iterator());
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;erased R::Ljava/lang/Comparable<TR;>;>", returnType="Ljet/List<TT;>;")
    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="f", type="Ljet/Function1<TT;TR;>;") Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage$src$_Iterables$4b9c149f.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage$src$OrderingJVM$625d3d22.comparator((Function2)new KotlinPackage$sortBy$sortBy$8(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="V")
    public static final <T> void appendString(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="buffer", type="Ljava/lang/Appendable;") Appendable buffer, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (T element : $receiver) {
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(Iterable iterable, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage$src$_Iterables$4b9c149f.appendString(iterable, appendable, string, string2, string3, n, string4);
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="Ljava/lang/String;")
    public static final <T> String makeString(@JetValueParameter(name="$receiver", receiver=true, type="Ljet/Iterable<TT;>;") Iterable<? extends T> $receiver, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage$src$_Iterables$4b9c149f.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(Iterable iterable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage$src$_Iterables$4b9c149f.makeString(iterable, string, string2, string3, n, string4);
    }
}

