package kotlin

/**
 * Defines names for Unicode symbols used in proper Typography
 */
public object Typography {
    public val quote: Char = '\u0022'
    public val amp: Char = '\u0026'
    public val less: Char = '\u003C'
    public val greater: Char = '\u003E'
    public val nbsp: Char = '\u00A0'
    public val times: Char = '\u00D7'
    public val cent: Char = '\u00A2'
    public val pound: Char = '\u00A3'
    public val section: Char = '\u00A7'
    public val copyright: Char = '\u00A9'
    public val leftGuillemete: Char = '\u00AB'
    public val rightGuillemete: Char = '\u00BB'
    public val registered: Char = '\u00AE'
    public val degree: Char = '\u00B0'
    public val plusMinus: Char = '\u00B1'
    public val paragraph: Char = '\u00B6'
    public val middleDot: Char = '\u00B7'
    public val half: Char = '\u00BD'
    public val ndash: Char = '\u2013'
    public val mdash: Char = '\u2014'
    public val leftSingleQuote: Char = '\u2018'
    public val rightSingleQuote: Char = '\u2019'
    public val lowSingleQuote: Char = '\u201A'
    public val leftDoubleQuote: Char = '\u201C'
    public val rightDoubleQuote: Char = '\u201D'
    public val lowDoubleQuote: Char = '\u201D'
    public val dagger: Char = '\u2020'
    public val doubleDagger: Char = '\u2021'
    public val bullet: Char = '\u2022'
    public val ellipsis: Char = '\u2026'
    public val prime: Char = '\u2032'
    public val doublePrime: Char = '\u2033'
    public val euro: Char = '\u20AC'
    public val tm: Char = '\u2122'
    public val almostEqual: Char = '\u2248'
    public val notEqual: Char = '\u2260'
    public val lessOrEqual: Char = '\u2264'
    public val greaterOrEqual: Char = '\u2265'
}