/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.ByteIterator;
import jet.Function0;
import jet.Function1;
import jet.Function2;
import jet.Unit;
import jet.runtime.ArrayIterator;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$3;
import kotlin.KotlinPackage$sortBy$sortBy$3;
import kotlin.KotlinPackage$src$IterablesSpecial$2c690166;
import kotlin.KotlinPackage$src$Maps$83a55027;
import kotlin.KotlinPackage$src$OrderingJVM$6b2236e3;
import kotlin.Pair;

public final class KotlinPackage$src$_ByteArrays$c9435dcb {
    @JetMethod(returnType="Z")
    public static final boolean all(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            if (((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @JetMethod(returnType="Z")
    public static final boolean any(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            if (!((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @JetMethod(returnType="I")
    public static final int count(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            byte element = $receiver[i];
            if (((Boolean)predicate.invoke((Object)element)).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @JetMethod(returnType="?Ljava/lang/Byte;")
    public static final Byte find(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            if (!((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> filter(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Byte;>;>", returnType="TC;")
    public static final <C extends Collection<? super Byte>> C filterTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            Object object2 = (Boolean)predicate.invoke((Object)element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> filterNot(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Byte;>;>", returnType="TC;")
    public static final <C extends Collection<? super Byte>> C filterNotTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            Object object2 = (Boolean)predicate.invoke((Object)element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Lkotlin/Pair<Ljet/List<Ljava/lang/Byte;>;Ljet/List<Ljava/lang/Byte;>;>;")
    public static final Pair<List<? extends Byte>, List<? extends Byte>> partition(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        ArrayList<Byte> first = new ArrayList<Byte>();
        ArrayList<Byte> second = new ArrayList<Byte>();
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            boolean bl = (Boolean)predicate.invoke((Object)element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends Byte>, List<? extends Byte>>(first, second);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="Ljet/List<TR;>;")
    public static final <R> List<R> map(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Byte;TR;>;") Function1<? super Byte, ? extends R> transform) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Byte;TR;>;") Function1<? super Byte, ? extends R> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte item = $receiver[i];
            result.add((Object)transform.invoke((Object)item));
        }
        return result;
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="Ljet/List<TR;>;")
    public static final <R> List<R> flatMap(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Byte;Ljet/Iterable<TR;>;>;") Function1<? super Byte, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;erased C::Ljet/MutableCollection<-TR;>;>", returnType="TC;")
    public static final <R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="transform", type="Ljet/Function1<Ljava/lang/Byte;Ljet/Iterable<TR;>;>;") Function1<? super Byte, ? extends Iterable<? extends R>> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            Iterable list2 = (Iterable)transform.invoke((Object)element);
            for (Object r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @JetMethod(returnType="V")
    public static final void forEach(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function1<Ljava/lang/Byte;Ljet/Unit;>;") Function1<? super Byte, ? extends Unit> operation) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            operation.invoke((Object)element);
        }
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <R> R fold(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<TR;Ljava/lang/Byte;TR;>;") Function2<? super R, ? super Byte, ? extends R> operation) {
        Object answer = initial;
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            answer = operation.invoke(answer, (Object)element);
        }
        return answer;
    }

    @JetMethod(typeParameters="<erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <R> R foldRight(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="initial", type="TR;") R initial, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Byte;TR;TR;>;") Function2<? super Byte, ? super R, ? extends R> operation) {
        Object r = initial;
        int index = $receiver.length - 1;
        while (index >= 0) {
            r = operation.invoke((Object)$receiver[index--], r);
        }
        return r;
    }

    @JetMethod(returnType="B")
    public static final byte reduce(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Byte;Ljava/lang/Byte;Ljava/lang/Byte;>;") Function2<? super Byte, ? super Byte, ? extends Byte> operation) {
        ByteIterator iterator2 = ArrayIterator.iterator((byte[])$receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        byte result = iterator2.nextByte();
        while (iterator2.hasNext()) {
            result = ((Number)operation.invoke((Object)result, (Object)iterator2.nextByte())).byteValue();
        }
        return result;
    }

    @JetMethod(returnType="B")
    public static final byte reduceRight(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="operation", type="Ljet/Function2<Ljava/lang/Byte;Ljava/lang/Byte;Ljava/lang/Byte;>;") Function2<? super Byte, ? super Byte, ? extends Byte> operation) {
        int index = $receiver.length - 1;
        if (index < 0) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        byte r = $receiver[index--];
        while (index >= 0) {
            r = ((Number)operation.invoke((Object)$receiver[index--], (Object)r)).byteValue();
        }
        return r;
    }

    @JetMethod(typeParameters="<erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/List<Ljava/lang/Byte;>;>;")
    public static final <K> Map<K, List<? extends Byte>> groupBy(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="toKey", type="Ljet/Function1<Ljava/lang/Byte;TK;>;") Function1<? super Byte, ? extends K> toKey) {
        return KotlinPackage$src$_ByteArrays$c9435dcb.groupByTo($receiver, new HashMap(), toKey);
    }

    @JetMethod(typeParameters="<erased K:?Ljava/lang/Object;>", returnType="Ljet/Map<TK;Ljet/MutableList<Ljava/lang/Byte;>;>;")
    public static final <K> Map<K, List<Byte>> groupByTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="Ljet/MutableMap<TK;Ljet/MutableList<Ljava/lang/Byte;>;>;") Map<K, List<Byte>> result, @JetValueParameter(name="toKey", type="Ljet/Function1<Ljava/lang/Byte;TK;>;") Function1<? super Byte, ? extends K> toKey) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            Object key = toKey.invoke((Object)element);
            List<Byte> list2 = KotlinPackage$src$Maps$83a55027.getOrPut(result, key, (Function0)KotlinPackage$groupByTo$list$3.instance$);
            list2.add(element);
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> drop(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_ByteArrays$c9435dcb.dropWhile($receiver, KotlinPackage$src$IterablesSpecial$2c690166.countTo(n));
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> dropWhile(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased L::Ljet/MutableList<-Ljava/lang/Byte;>;>", returnType="TL;")
    public static final <L extends List<? super Byte>> L dropWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TL;") L result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        int start = 1;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            byte element = $receiver[i];
            if (!(start != 0 ? (Boolean)predicate.invoke((Object)element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> take(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="n", type="I") int n) {
        return KotlinPackage$src$_ByteArrays$c9435dcb.takeWhile($receiver, KotlinPackage$src$IterablesSpecial$2c690166.countTo(n));
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> takeWhile(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Byte;>;>", returnType="TC;")
    public static final <C extends Collection<? super Byte>> C takeWhileTo(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TC;") C result, @JetValueParameter(name="predicate", type="Ljet/Function1<Ljava/lang/Byte;Ljava/lang/Boolean;>;") Function1<? super Byte, ? extends Boolean> predicate) {
        byte element;
        for (int i = 0; i < $receiver.length && ((Boolean)predicate.invoke((Object)(element = $receiver[i]))).booleanValue(); ++i) {
            result.add(element);
        }
        return result;
    }

    @JetMethod(typeParameters="<erased C::Ljet/MutableCollection<-Ljava/lang/Byte;>;>", returnType="TC;")
    public static final <C extends Collection<? super Byte>> C toCollection(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="result", type="TC;") C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            result.add(element);
        }
        return result;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> reverse(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @JetMethod(returnType="Ljava/util/LinkedList<Ljava/lang/Byte;>;")
    public static final LinkedList<Byte> toLinkedList(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver) {
        return (LinkedList)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)new LinkedList());
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> toList(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver) {
        return (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)new ArrayList());
    }

    @JetMethod(returnType="Ljet/Set<Ljava/lang/Byte;>;")
    public static final Set<Byte> toSet(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver) {
        return (LinkedHashSet)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @JetMethod(returnType="Ljava/util/SortedSet<Ljava/lang/Byte;>;")
    public static final SortedSet<Byte> toSortedSet(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver) {
        return (TreeSet)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)new TreeSet());
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> plus(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="element", type="B") byte element) {
        ArrayList<Byte> answer = new ArrayList<Byte>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)answer);
        answer.add(element);
        return answer;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> plus(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="iterator", type="Ljet/Iterator<Ljava/lang/Byte;>;") Iterator<? extends Byte> iterator2) {
        ArrayList<Byte> answer = new ArrayList<Byte>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)answer);
        Iterator<? extends Byte> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            byte element = ((Number)iterator3.next()).byteValue();
            answer.add(element);
        }
        return answer;
    }

    @JetMethod(returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final List<Byte> plus(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="collection", type="Ljet/Iterable<Ljava/lang/Byte;>;") Iterable<? extends Byte> collection) {
        return KotlinPackage$src$_ByteArrays$c9435dcb.plus($receiver, collection.iterator());
    }

    @JetMethod(returnType="Ljet/Iterator<Lkotlin/Pair<Ljava/lang/Integer;Ljava/lang/Byte;>;>;")
    public static final Iterator<Pair<? extends Integer, ? extends Byte>> withIndices(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver) {
        return new IndexIterator((Iterator)ArrayIterator.iterator((byte[])$receiver));
    }

    @JetMethod(typeParameters="<erased R::Ljava/lang/Comparable<TR;>;>", returnType="Ljet/List<Ljava/lang/Byte;>;")
    public static final <R extends Comparable<? super R>> List<Byte> sortBy(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="f", type="Ljet/Function1<Ljava/lang/Byte;TR;>;") Function1<? super Byte, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage$src$_ByteArrays$c9435dcb.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage$src$OrderingJVM$6b2236e3.comparator((Function2)new KotlinPackage$sortBy$sortBy$3(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @JetMethod(returnType="V")
    public static final void appendString(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="buffer", type="Ljava/lang/Appendable;") Appendable buffer, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            byte element = $receiver[i];
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (Byte.valueOf(element) != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(byte[] byArray, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage$src$_ByteArrays$c9435dcb.appendString(byArray, appendable, string, string2, string3, n, string4);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String makeString(@JetValueParameter(name="$receiver", receiver=true, type="[B") byte[] $receiver, @JetValueParameter(name="separator", hasDefaultValue=true, type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix, @JetValueParameter(name="limit", hasDefaultValue=true, type="I") int limit, @JetValueParameter(name="truncated", hasDefaultValue=true, type="Ljava/lang/String;") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage$src$_ByteArrays$c9435dcb.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(byte[] byArray, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage$src$_ByteArrays$c9435dcb.makeString(byArray, string, string2, string3, n, string4);
    }
}

