/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sourceSections;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.sourceSections.FilteredSectionsVirtualFileKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/sourceSections/FilteredSectionsVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "delegate", "sectionIds", "", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Collection;)V", "getDelegate", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getSectionIds", "()Ljava/util/Collection;", "contentsToByteArray", "", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getInputStream", "Ljava/io/InputStream;", "getLength", "", "getName", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getTimeStamp", "isDirectory", "", "isValid", "isWritable", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "kotlin-source-sections-compiler-plugin"})
public final class FilteredSectionsVirtualFile
extends VirtualFile {
    @NotNull
    private final VirtualFile delegate;
    @NotNull
    private final Collection<String> sectionIds;

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.delegate.refresh(asynchronous, recursive, postRunnable);
    }

    public long getLength() {
        return this.delegate.getLength();
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.delegate.getFileSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"delegate.fileSystem");
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.delegate.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.path");
        return string;
    }

    public boolean isDirectory() {
        return this.delegate.isDirectory();
    }

    public long getTimeStamp() {
        return this.delegate.getTimeStamp();
    }

    @NotNull
    public String getName() {
        String string = this.delegate.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.name");
        return string;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.delegate.contentsToByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"delegate.contentsToByteArray()");
        Charset charset = this.delegate.getCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"delegate.charset");
        return FilteredSectionsVirtualFileKt.access$filterByteContents(this.sectionIds, byArray, charset);
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.contentsToByteArray());
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile = this.delegate.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"delegate.parent");
        return virtualFile;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        VirtualFile[] virtualFileArray = this.delegate.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"delegate.children");
        return virtualFileArray;
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        OutputStream outputStream = this.delegate.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"delegate.getOutputStream\u2026ationStamp, newTimeStamp)");
        return outputStream;
    }

    @NotNull
    public final VirtualFile getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final Collection<String> getSectionIds() {
        return this.sectionIds;
    }

    public FilteredSectionsVirtualFile(@NotNull VirtualFile delegate, @NotNull Collection<String> sectionIds) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull(sectionIds, (String)"sectionIds");
        this.delegate = delegate;
        this.sectionIds = sectionIds;
    }
}

