/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.common;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerialTypeInfo;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt$anonymousInitializers$;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt$bodyPropertiesDescriptorsMap$;
import org.jetbrains.kotlinx.serialization.compiler.backend.jvm.JVMCodegenUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationPackages;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f\u001a\u001e\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a2\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001e\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 0\u000e*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010!\u001a\u00020\"*\u00020\u0005\u00a8\u0006#"}, d2={"findEnumTypeSerializer", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "kType", "Lorg/jetbrains/kotlin/types/KotlinType;", "findPolymorphicSerializer", "findStandardKotlinTypeSerializer", "findTypeSerializer", "anonymousInitializers", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "bodyPropertiesDescriptorsMap", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findAddOnSerializer", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "propertyType", "findTypeSerializerOrContext", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "sourceElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getSerialTypeInfo", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerialTypeInfo;", "property", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "primaryPropertiesDescriptorsMap", "Lorg/jetbrains/kotlin/psi/KtParameter;", "requiresPolymorphism", "", "kotlinx-serialization-compiler-plugin"})
public final class TypeUtilKt {
    @Nullable
    public static final ClassDescriptor findAddOnSerializer(@NotNull AbstractSerialGenerator $receiver, @NotNull KotlinType propertyType, @NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)propertyType, (String)"propertyType");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ClassDescriptor classDescriptor = $receiver.getAdditionalSerializersInScopeOfCurrentFile().get(propertyType);
        if (classDescriptor != null) {
            ClassDescriptor classDescriptor2;
            ClassDescriptor it = classDescriptor2 = classDescriptor;
            return it;
        }
        if ($receiver.getContextualKClassListInCurrentFile().contains(propertyType)) {
            return KSerializationUtilKt.getClassFromSerializationPackage(module, "ContextSerializer");
        }
        if (propertyType.isMarkedNullable()) {
            return TypeUtilKt.findAddOnSerializer($receiver, TypeUtilsKt.makeNotNullable((KotlinType)propertyType), module);
        }
        return null;
    }

    @NotNull
    public static final SerialTypeInfo getSerialTypeInfo(@NotNull AbstractSerialGenerator $receiver, @NotNull SerializableProperty property) {
        SerialTypeInfo serialTypeInfo;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Function1<ClassDescriptor, SerialTypeInfo> SerializableInfo$ = new Function1<ClassDescriptor, SerialTypeInfo>(property){
            final /* synthetic */ SerializableProperty $property;

            @NotNull
            public final SerialTypeInfo invoke(@Nullable ClassDescriptor serializer) {
                return new SerialTypeInfo(this.$property, this.$property.getType().isMarkedNullable() ? "Nullable" : "", serializer, false, 8, null);
            }
            {
                this.$property = serializableProperty;
                super(1);
            }
        };
        KotlinType T = property.getType();
        KotlinType kotlinType = property.getSerializableWith();
        if (kotlinType != null && (kotlinType = KSerializationUtilKt.toClassDescriptor(kotlinType)) != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            return SerializableInfo$.invoke((ClassDescriptor)it);
        }
        ClassDescriptor classDescriptor = TypeUtilKt.findAddOnSerializer($receiver, T, property.getModule());
        if (classDescriptor != null) {
            ClassDescriptor classDescriptor2;
            ClassDescriptor it = classDescriptor2 = classDescriptor;
            return SerializableInfo$.invoke(it);
        }
        KotlinType kotlinType3 = KSerializationUtilKt.getOverridenSerializer(T);
        if (kotlinType3 != null && (kotlinType3 = KSerializationUtilKt.toClassDescriptor(kotlinType3)) != null) {
            KotlinType kotlinType4;
            KotlinType it = kotlinType4 = kotlinType3;
            return SerializableInfo$.invoke((ClassDescriptor)it);
        }
        if (TypeUtilsKt.isTypeParameter((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, property.getType().isMarkedNullable() ? "Nullable" : "", null, false, 8, null);
        } else if (TypeUtilsKt.isPrimitiveNumberType((KotlinType)T) | TypeUtilsKt.isBoolean((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, StringsKt.removePrefix((String)org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getJetTypeFqName((KotlinType)T, (boolean)false), (CharSequence)"kotlin."), null, false, 12, null);
        } else if (KotlinBuiltIns.isString((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, "String", null, false, 12, null);
        } else if (KotlinBuiltIns.isUnit((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, "Unit", null, true, 4, null);
        } else {
            if (KotlinBuiltIns.isPrimitiveArray((KotlinType)T)) {
                String string = "primitive arrays are not supported yet";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            ClassDescriptor classDescriptor3 = KSerializationUtilKt.toClassDescriptor(T);
            if (classDescriptor3 == null) {
                Intrinsics.throwNpe();
            }
            if (KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)classDescriptor3)) {
                KotlinType kotlinType5 = property.getSerializableWith();
                if (kotlinType5 == null || (kotlinType5 = KSerializationUtilKt.toClassDescriptor(kotlinType5)) == null) {
                    kotlinType5 = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)property.getModule(), (ClassId)JVMCodegenUtilKt.getReferenceArraySerializerId());
                }
                KotlinType serializer = kotlinType5;
                serialTypeInfo = SerializableInfo$.invoke((ClassDescriptor)serializer);
            } else {
                ClassDescriptor classDescriptor4 = KSerializationUtilKt.toClassDescriptor(T);
                if ((classDescriptor4 != null ? classDescriptor4.getKind() : null) == ClassKind.ENUM_CLASS) {
                    ClassDescriptor serializer = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)property.getModule(), (ClassId)JVMCodegenUtilKt.getEnumSerializerId());
                    serialTypeInfo = SerializableInfo$.invoke(serializer);
                } else {
                    ClassDescriptor serializer = TypeUtilKt.findTypeSerializerOrContext($receiver, property.getModule(), property.getType(), property.getDescriptor().getAnnotations(), SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)property.getDescriptor())));
                    serialTypeInfo = SerializableInfo$.invoke(serializer);
                }
            }
        }
        return serialTypeInfo;
    }

    @Nullable
    public static final ClassDescriptor findTypeSerializerOrContext(@NotNull AbstractSerialGenerator $receiver, @NotNull ModuleDescriptor module, @NotNull KotlinType kType, @NotNull Annotations annotations, @Nullable PsiElement sourceElement) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        Intrinsics.checkParameterIsNotNull((Object)annotations, (String)"annotations");
        if (TypeUtilsKt.isTypeParameter((KotlinType)kType)) {
            return null;
        }
        if (kType.isMarkedNullable()) {
            return TypeUtilKt.findTypeSerializerOrContext($receiver, module, TypeUtilsKt.makeNotNullable((KotlinType)kType), annotations, sourceElement);
        }
        ClassDescriptor classDescriptor = $receiver.getAdditionalSerializersInScopeOfCurrentFile().get(kType);
        if (classDescriptor != null) {
            ClassDescriptor classDescriptor2;
            ClassDescriptor it = classDescriptor2 = classDescriptor;
            return it;
        }
        Function0<ClassDescriptor> getContextualSerializer$ = new Function0<ClassDescriptor>($receiver, annotations, kType, module){
            final /* synthetic */ AbstractSerialGenerator $this_findTypeSerializerOrContext;
            final /* synthetic */ Annotations $annotations;
            final /* synthetic */ KotlinType $kType;
            final /* synthetic */ ModuleDescriptor $module;

            @Nullable
            public final ClassDescriptor invoke() {
                return this.$annotations.hasAnnotation(SerializationAnnotations.INSTANCE.getContextualFqName$kotlinx_serialization_compiler_plugin()) || this.$this_findTypeSerializerOrContext.getContextualKClassListInCurrentFile().contains(this.$kType) ? KSerializationUtilKt.getClassFromSerializationPackage(this.$module, "ContextSerializer") : null;
            }
            {
                this.$this_findTypeSerializerOrContext = abstractSerialGenerator;
                this.$annotations = annotations;
                this.$kType = kotlinType;
                this.$module = moduleDescriptor;
                super(0);
            }
        };
        ClassDescriptor classDescriptor3 = getContextualSerializer$.invoke();
        if (classDescriptor3 == null) {
            classDescriptor3 = TypeUtilKt.findTypeSerializer(module, kType);
        }
        if (classDescriptor3 == null) {
            throw (Throwable)new CompilationException("Serializer for element of type " + kType + " has not been found.\n" + "To use context serializer as fallback, explicitly annotate element with @ContextualSerialization", null, sourceElement);
        }
        return classDescriptor3;
    }

    @Nullable
    public static /* synthetic */ ClassDescriptor findTypeSerializerOrContext$default(AbstractSerialGenerator abstractSerialGenerator, ModuleDescriptor moduleDescriptor, KotlinType kotlinType, Annotations annotations, PsiElement psiElement, int n, Object object) {
        if ((n & 4) != 0) {
            annotations = kotlinType.getAnnotations();
        }
        if ((n & 8) != 0) {
            psiElement = null;
        }
        return TypeUtilKt.findTypeSerializerOrContext(abstractSerialGenerator, moduleDescriptor, kotlinType, annotations, psiElement);
    }

    @Nullable
    public static final ClassDescriptor findTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        KotlinType userOverride = KSerializationUtilKt.getOverridenSerializer(kType);
        if (userOverride != null) {
            return KSerializationUtilKt.toClassDescriptor(userOverride);
        }
        if (TypeUtilKt.requiresPolymorphism(kType)) {
            return TypeUtilKt.findPolymorphicSerializer(module);
        }
        if (TypeUtilsKt.isTypeParameter((KotlinType)kType)) {
            return null;
        }
        if (KotlinBuiltIns.isArray((KotlinType)kType)) {
            return KSerializationUtilKt.getClassFromInternalSerializationPackage(module, "ReferenceArraySerializer");
        }
        ClassDescriptor classDescriptor2 = KSerializationUtilKt.toClassDescriptor(KSerializationUtilKt.getTypeSerializer(kType));
        if (classDescriptor2 == null) {
            classDescriptor2 = classDescriptor = TypeUtilKt.findStandardKotlinTypeSerializer(module, kType);
        }
        if (classDescriptor2 == null) {
            classDescriptor = TypeUtilKt.findEnumTypeSerializer(module, kType);
        }
        return classDescriptor;
    }

    @Nullable
    public static final ClassDescriptor findStandardKotlinTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        switch (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getJetTypeFqName((KotlinType)kType, (boolean)false)) {
            case "kotlin.Unit": {
                string = "UnitSerializer";
                break;
            }
            case "kotlin.Boolean": 
            case "Z": {
                string = "BooleanSerializer";
                break;
            }
            case "B": 
            case "kotlin.Byte": {
                string = "ByteSerializer";
                break;
            }
            case "kotlin.Short": 
            case "S": {
                string = "ShortSerializer";
                break;
            }
            case "kotlin.Int": 
            case "I": {
                string = "IntSerializer";
                break;
            }
            case "J": 
            case "kotlin.Long": {
                string = "LongSerializer";
                break;
            }
            case "F": 
            case "kotlin.Float": {
                string = "FloatSerializer";
                break;
            }
            case "kotlin.Double": 
            case "D": {
                string = "DoubleSerializer";
                break;
            }
            case "C": 
            case "kotlin.Char": {
                string = "CharSerializer";
                break;
            }
            case "kotlin.String": {
                string = "StringSerializer";
                break;
            }
            case "kotlin.Pair": {
                string = "PairSerializer";
                break;
            }
            case "kotlin.Triple": {
                string = "TripleSerializer";
                break;
            }
            case "kotlin.collections.Collection": 
            case "kotlin.collections.MutableList": 
            case "kotlin.collections.ArrayList": 
            case "kotlin.collections.List": {
                string = "ArrayListSerializer";
                break;
            }
            case "kotlin.collections.LinkedHashSet": 
            case "kotlin.collections.MutableSet": 
            case "kotlin.collections.Set": {
                string = "LinkedHashSetSerializer";
                break;
            }
            case "kotlin.collections.HashSet": {
                string = "HashSetSerializer";
                break;
            }
            case "kotlin.collections.LinkedHashMap": 
            case "kotlin.collections.MutableMap": 
            case "kotlin.collections.Map": {
                string = "LinkedHashMapSerializer";
                break;
            }
            case "kotlin.collections.HashMap": {
                string = "HashMapSerializer";
                break;
            }
            case "kotlin.collections.Map.Entry": {
                string = "MapEntrySerializer";
                break;
            }
            case "java.lang.Boolean": {
                string = "BooleanSerializer";
                break;
            }
            case "java.lang.Byte": {
                string = "ByteSerializer";
                break;
            }
            case "java.lang.Short": {
                string = "ShortSerializer";
                break;
            }
            case "java.lang.Integer": {
                string = "IntSerializer";
                break;
            }
            case "java.lang.Long": {
                string = "LongSerializer";
                break;
            }
            case "java.lang.Float": {
                string = "FloatSerializer";
                break;
            }
            case "java.lang.Double": {
                string = "DoubleSerializer";
                break;
            }
            case "java.lang.Character": {
                string = "CharSerializer";
                break;
            }
            case "java.lang.String": {
                string = "StringSerializer";
                break;
            }
            case "java.util.Collection": 
            case "java.util.List": 
            case "java.util.ArrayList": {
                string = "ArrayListSerializer";
                break;
            }
            case "java.util.Set": 
            case "java.util.LinkedHashSet": {
                string = "LinkedHashSetSerializer";
                break;
            }
            case "java.util.HashSet": {
                string = "HashSetSerializer";
                break;
            }
            case "java.util.Map": 
            case "java.util.LinkedHashMap": {
                string = "LinkedHashMapSerializer";
                break;
            }
            case "java.util.HashMap": {
                string = "HashMapSerializer";
                break;
            }
            case "java.util.Map.Entry": {
                string = "MapEntrySerializer";
                break;
            }
            default: {
                return null;
            }
        }
        String name = string;
        return FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)new ClassId(SerializationPackages.INSTANCE.getInternalPackageFqName$kotlinx_serialization_compiler_plugin(), Name.identifier((String)name)));
    }

    @Nullable
    public static final ClassDescriptor findEnumTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(kType);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return classDescriptor2.getKind() == ClassKind.ENUM_CLASS ? FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)JVMCodegenUtilKt.getEnumSerializerId()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean requiresPolymorphism(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor($receiver);
        if (classDescriptor != null && (classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)classDescriptor)) != null) {
            if (KSerializationUtilKt.isInternalSerializable(classDescriptor)) return true;
        }
        ClassDescriptor classDescriptor2 = KSerializationUtilKt.toClassDescriptor($receiver);
        if ((classDescriptor2 != null ? classDescriptor2.getModality() : null) != Modality.FINAL) {
            ClassDescriptor classDescriptor3 = KSerializationUtilKt.toClassDescriptor($receiver);
            if ((classDescriptor3 != null ? classDescriptor3.getUnsubstitutedPrimaryConstructor() : null) != null) return true;
        }
        if (!TypeUtilsKt.containsTypeProjectionsInTopLevelArguments((KotlinType)$receiver)) return false;
        return true;
    }

    @NotNull
    public static final ClassDescriptor findPolymorphicSerializer(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)JVMCodegenUtilKt.getPolymorphicSerializerId());
        if (classDescriptor == null) {
            String string = "Can't locate polymorphic serializer definition";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PropertyDescriptor, KtProperty> bodyPropertiesDescriptorsMap(@NotNull KtPureClassOrObject $receiver, @NotNull BindingContext bindingContext) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        List list = $receiver.getDeclarations();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"declarations");
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)list);
        Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)bodyPropertiesDescriptorsMap$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $receiver$iv = SequencesKt.filter((Sequence)sequence, (Function1)bodyPropertiesDescriptorsMap.1.INSTANCE);
        Sequence $i$f$filterIsInstance = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PropertyDescriptor propertyDescriptor;
            void it;
            KtProperty ktProperty = (KtProperty)element$iv$iv;
            Map map = destination$iv$iv;
            Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)it);
            if (!(object instanceof PropertyDescriptor)) {
                object = null;
            }
            if ((PropertyDescriptor)object == null) {
                Intrinsics.throwNpe();
            }
            map.put(propertyDescriptor, element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PropertyDescriptor, KtParameter> primaryPropertiesDescriptorsMap(@NotNull KtPureClassOrObject $receiver, @NotNull BindingContext bindingContext) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        List list = $receiver.getPrimaryConstructorParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"primaryConstructorParameters");
        Sequence $receiver$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)primaryPropertiesDescriptorsMap.1.INSTANCE);
        Sequence sequence = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)element$iv$iv;
            Map map = destination$iv$iv;
            Object object = bindingContext.get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)it);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
            map.put(propertyDescriptor, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final List<KtExpression> anonymousInitializers(@NotNull KtPureClassOrObject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List list = $receiver.getDeclarations();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"declarations");
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)list);
        Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)anonymousInitializers$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)anonymousInitializers.1.INSTANCE));
    }
}

