/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.js;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlinx.serialization.compiler.backend.js.JsBlockBuilder;
import org.jetbrains.kotlinx.serialization.compiler.backend.js.SerializerJsTranslator;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/js/SerializerForEnumsTranslator;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/js/SerializerJsTranslator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "translator", "Lorg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "generateSave", "", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateLoad", "instantiateNewDescriptor", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "correctThis", "baseSerialDescImplClass", "addElementsContentToDescriptor", "serialDescriptorInThis", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "addElementFunction", "pushAnnotationFunction", "kotlinx-serialization-compiler-plugin.backend"})
public final class SerializerForEnumsTranslator
extends SerializerJsTranslator {
    public SerializerForEnumsTranslator(@NotNull ClassDescriptor descriptor, @NotNull DeclarationBodyVisitor translator, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(descriptor, translator, context, null);
    }

    @Override
    protected void generateSave(@NotNull FunctionDescriptor function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.generateFunction$kotlinx_serialization_compiler_plugin_backend(function, (Function3<? super JsBlockBuilder, ? super JsFunction, ? super TranslationContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> SerializerForEnumsTranslator.generateSave$lambda$0(this, arg_0, arg_1, arg_2)));
    }

    @Override
    protected void generateLoad(@NotNull FunctionDescriptor function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.generateFunction$kotlinx_serialization_compiler_plugin_backend(function, (Function3<? super JsBlockBuilder, ? super JsFunction, ? super TranslationContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> SerializerForEnumsTranslator.generateLoad$lambda$1(this, arg_0, arg_1, arg_2)));
    }

    @Override
    @NotNull
    protected JsExpression instantiateNewDescriptor(@NotNull TranslationContext context, @NotNull JsExpression correctThis, @NotNull ClassDescriptor baseSerialDescImplClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)correctThis, (String)"correctThis");
        Intrinsics.checkNotNullParameter((Object)baseSerialDescImplClass, (String)"baseSerialDescImplClass");
        ClassDescriptor serialDescForEnums = SearchUtilsKt.getClassFromInternalSerializationPackage(this.getSerializerDescriptor(), "EnumDescriptor");
        ClassConstructorDescriptor classConstructorDescriptor = serialDescForEnums.getUnsubstitutedPrimaryConstructor();
        Intrinsics.checkNotNull((Object)classConstructorDescriptor);
        ClassConstructorDescriptor ctor = classConstructorDescriptor;
        Object[] objectArray = new JsLiteral.JsValueLiteral[]{new JsStringLiteral(this.getSerialName()), new JsIntLiteral(KSerializationUtilKt.enumEntries(this.getSerializableDescriptor()).size())};
        return (JsExpression)new JsNew(context.getInnerReference((DeclarationDescriptor)ctor), CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    protected void addElementsContentToDescriptor(@NotNull TranslationContext context, @NotNull JsNameRef serialDescriptorInThis, @NotNull FunctionDescriptor addElementFunction, @NotNull FunctionDescriptor pushAnnotationFunction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serialDescriptorInThis, (String)"serialDescriptorInThis");
        Intrinsics.checkNotNullParameter((Object)addElementFunction, (String)"addElementFunction");
        Intrinsics.checkNotNullParameter((Object)pushAnnotationFunction, (String)"pushAnnotationFunction");
        List<ClassDescriptor> enumEntries = KSerializationUtilKt.enumEntries(this.getSerializableDescriptor());
        for (ClassDescriptor entry : enumEntries) {
            String string = KSerializationUtilKt.getSerialNameValue(entry.getAnnotations());
            if (string == null) {
                String string2 = entry.getName().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            String serialName = string;
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsStringLiteral(serialName)};
            JsInvocation call = new JsInvocation((JsExpression)new JsNameRef(context.getNameForDescriptor((DeclarationDescriptor)addElementFunction), (JsExpression)serialDescriptorInThis), jsExpressionArray);
            DeclarationBodyVisitor declarationBodyVisitor = this.getTranslator();
            JsStatement jsStatement = call.makeStmt();
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
            declarationBodyVisitor.addInitializerStatement(jsStatement);
            this.pushAnnotationsInto((Annotated)entry, (DeclarationDescriptor)pushAnnotationFunction, serialDescriptorInThis);
        }
    }

    private static final Unit generateSave$lambda$0(SerializerForEnumsTranslator this$0, JsBlockBuilder $this$generateFunction, JsFunction jsFun, TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$generateFunction, (String)"$this$generateFunction");
        Intrinsics.checkNotNullParameter((Object)jsFun, (String)"jsFun");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ClassDescriptor encoderClass = SearchUtilsKt.getClassFromSerializationPackage(this$0.getSerializerDescriptor(), "Encoder");
        TranslationContext translationContext = this$0.getContext();
        PropertyDescriptor propertyDescriptor = this$0.getAnySerialDescProperty();
        Intrinsics.checkNotNull((Object)propertyDescriptor);
        JsNameRef serialClassDescRef = new JsNameRef(translationContext.getNameForDescriptor((DeclarationDescriptor)propertyDescriptor), (JsExpression)new JsThisRef());
        MemberScope memberScope = this$0.getSerializableDescriptor().getUnsubstitutedMemberScope();
        Name name = Name.identifier((String)"ordinal");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        PropertyDescriptor ordinalProp = (PropertyDescriptor)CollectionsKt.single((Iterable)memberScope.getContributedVariables(name, (LookupLocation)NoLookupLocation.FROM_BACKEND));
        JsNameRef ordinalRef = new JsNameRef(this$0.getContext().getNameForDescriptor((DeclarationDescriptor)ordinalProp), (JsExpression)new JsNameRef(((JsParameter)jsFun.getParameters().get(1)).getName()));
        JsName jsName = ctx.getNameForDescriptor((DeclarationDescriptor)SequencesKt.single(this$0.getFuncDesc(encoderClass, "encodeEnum")));
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        JsName encodeEnumF = jsName;
        JsExpression[] jsExpressionArray = new JsExpression[]{serialClassDescRef, ordinalRef};
        JsInvocation call = new JsInvocation((JsExpression)new JsNameRef(encodeEnumF, (JsExpression)new JsNameRef(((JsParameter)jsFun.getParameters().get(0)).getName())), jsExpressionArray);
        JsStatement jsStatement = call.makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        $this$generateFunction.unaryPlus(jsStatement);
        return Unit.INSTANCE;
    }

    private static final Unit generateLoad$lambda$1(SerializerForEnumsTranslator this$0, JsBlockBuilder $this$generateFunction, JsFunction jsFun, TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$generateFunction, (String)"$this$generateFunction");
        Intrinsics.checkNotNullParameter((Object)jsFun, (String)"jsFun");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ClassDescriptor decoderClass = SearchUtilsKt.getClassFromSerializationPackage(this$0.getSerializerDescriptor(), "Decoder");
        TranslationContext translationContext = this$0.getContext();
        PropertyDescriptor propertyDescriptor = this$0.getAnySerialDescProperty();
        Intrinsics.checkNotNull((Object)propertyDescriptor);
        JsNameRef serialClassDescRef = new JsNameRef(translationContext.getNameForDescriptor((DeclarationDescriptor)propertyDescriptor), (JsExpression)new JsThisRef());
        JsName jsName = ctx.getNameForDescriptor((DeclarationDescriptor)SequencesKt.single(this$0.getFuncDesc(decoderClass, "decodeEnum")));
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        JsName decodeEnumF = jsName;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName((MemberScope)this$0.getSerializableDescriptor().getStaticScope(), (Name)StandardNames.ENUM_VALUES);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionByName(...)");
        FunctionDescriptor valuesFunc = functionDescriptor;
        JsExpression[] jsExpressionArray = new JsExpression[]{serialClassDescRef};
        JsInvocation decodeEnumCall = new JsInvocation((JsExpression)new JsNameRef(decodeEnumF, (JsExpression)new JsNameRef(((JsParameter)jsFun.getParameters().get(0)).getName())), jsExpressionArray);
        JsArrayAccess resultCall = new JsArrayAccess((JsExpression)new JsInvocation((JsExpression)ctx.getInnerNameForDescriptor((DeclarationDescriptor)valuesFunc).makeRef(), new JsExpression[0]), (JsExpression)decodeEnumCall);
        $this$generateFunction.unaryPlus((JsStatement)new JsReturn((JsExpression)resultCall));
        return Unit.INSTANCE;
    }
}

